package com.example.newgen2xplay;

import android.os.AsyncTask;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;

import androidx.lifecycle.MutableLiveData;

import com.example.newgen2xplay.ui.Inventory.TagDataViewModel;
import com.zebra.rfid.api3.ACCESS_OPERATION_CODE;
import com.zebra.rfid.api3.ACCESS_OPERATION_STATUS;
import com.zebra.rfid.api3.AccessFilter;
import com.zebra.rfid.api3.AntennaInfo;
import com.zebra.rfid.api3.Antennas;
import com.zebra.rfid.api3.CableLossCompensation;
import com.zebra.rfid.api3.ENUM_OPERATING_MODE;
import com.zebra.rfid.api3.ENUM_TRANSPORT;
import com.zebra.rfid.api3.ENUM_TRIGGER_MODE;
import com.zebra.rfid.api3.FILTER_ACTION;
import com.zebra.rfid.api3.FILTER_MATCH_PATTERN;
import com.zebra.rfid.api3.GPITrigger;
import com.zebra.rfid.api3.HANDHELD_TRIGGER_EVENT_TYPE;
import com.zebra.rfid.api3.INVENTORY_STATE;
import com.zebra.rfid.api3.IRFIDLogger;
import com.zebra.rfid.api3.ImpinjExtensions;
import com.zebra.rfid.api3.InvalidUsageException;
import com.zebra.rfid.api3.LOCK_DATA_FIELD;
import com.zebra.rfid.api3.LOCK_PRIVILEGE;
import com.zebra.rfid.api3.MEMORY_BANK;
import com.zebra.rfid.api3.MultiLocateParams;
import com.zebra.rfid.api3.OperationFailureException;
import com.zebra.rfid.api3.PreFilters;
import com.zebra.rfid.api3.READER_POWER_STATE;
import com.zebra.rfid.api3.RFIDReader;
import com.zebra.rfid.api3.RFIDResults;
import com.zebra.rfid.api3.ReaderDevice;
import com.zebra.rfid.api3.Readers;
import com.zebra.rfid.api3.RfidEventsListener;
import com.zebra.rfid.api3.RfidReadEvents;
import com.zebra.rfid.api3.RfidStatusEvents;
import com.zebra.rfid.api3.SESSION;
import com.zebra.rfid.api3.SL_FLAG;
import com.zebra.rfid.api3.START_TRIGGER_TYPE;
import com.zebra.rfid.api3.STATE_AWARE_ACTION;
import com.zebra.rfid.api3.STATUS_EVENT_TYPE;
import com.zebra.rfid.api3.STOP_TRIGGER_TYPE;
import com.zebra.rfid.api3.StartTrigger;
import com.zebra.rfid.api3.StopTrigger;
import com.zebra.rfid.api3.TARGET;
import com.zebra.rfid.api3.TagAccess;
import com.zebra.rfid.api3.TagData;
import com.zebra.rfid.api3.TagPatternBase;
import com.zebra.rfid.api3.TriggerInfo;
import com.zebra.scannercontrol.DCSScannerInfo;
import com.zebra.scannercontrol.FirmwareUpdateEvent;
import com.zebra.scannercontrol.IDcsSdkApiDelegate;
import com.zebra.scannercontrol.SDKHandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RFIDHandler implements IDcsSdkApiDelegate, Readers.RFIDReaderEventHandler{

    public final static String TAG = "RFID_SAMPLE";
    public static Readers readers;
    public static ArrayList<ReaderDevice> availableRFIDReaderList;
    private static ReaderDevice readerDevice;
    public static RFIDReader mConnectedRfidReader;
    TextView textView;
    private static EventHandler eventHandler;
    private MainActivity context;
    String readername = "RFD40+_212735201D0086";
    private SDKHandler sdkHandler;

    public static boolean isInventoryRunning = false;

    public static TagDataViewModel tagDataViewModel;

    public static ImpinjExtensions impinjExtensions;
//    public static FWUpdateDataViewModel fwUpdateDataViewModel;
//    public static MenuViewModel menuViewModel;

    public static String hostName = "";
    public static String ProtocolType;
    public static int ZIOTCport = 443;
    public static int LLRPport = 5084;
    public static int timeoutMilliSeconds = 2000;
    public static ArrayList<String> tagIDs = new ArrayList<>();


    public final MutableLiveData<Boolean> connectionStatus = new MutableLiveData<>();
    public final MutableLiveData<Boolean> isInitialized = new MutableLiveData<>(false);
    // LiveData to notify trigger press/release events
    public final MutableLiveData<Boolean> triggerPressedLiveData = new MutableLiveData<>();

    void onCreate(MainActivity activity) {
        context = activity;
        InitSDK();
    }

    private void InitSDK() {
        Log.d(TAG, "InitSDK");
        IRFIDLogger.getLogger("RFIDHandler").EnableDebugLogs(true);
        if (readers == null) {
            setTransportType();
        }
        if (eventHandler == null)
            eventHandler = new EventHandler();
//        if(!isReaderConnected()){
//            String connectStatus = connect();
//        }
    }

    private void setTransportType() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            Log.d(TAG, "CreateInstanceTask");
//            try {
                readers = new Readers(context, ENUM_TRANSPORT.ALL);
                readers.setTransport(ENUM_TRANSPORT.ALL);
                //tryGetAvailableReaders();

                /*if (availableRFIDReaderList != null && !availableRFIDReaderList.isEmpty()) {
                    readers.attach(this);
                   // selectReaderDevice(availableRFIDReaderList);
                } else {
                    Log.d(TAG, "No readers found");
                }*/

                // Mark as initialized
                isInitialized.postValue(true);
//            } catch (InvalidUsageException e) {
//                e.printStackTrace();
//                Log.d(TAG, "InvalidUsageException " + e.getVendorMessage());
//            }
        });
    }

    public static void tryGetAvailableReaders() throws InvalidUsageException {
        //readers.setTransport(transport);
        availableRFIDReaderList =  readers.GetAvailableRFIDReaderList();
    }

    public void selectReaderDevice(ArrayList<ReaderDevice> readerList) {
        if (readerList.size() == 1) {
                  readerDevice = readerList.get(0);
                  mConnectedRfidReader = readerDevice.getRFIDReader();
        }else{
            for (ReaderDevice device : readerList) {
                Log.d(TAG,"device: "+device.getName());
                if (device.getName().startsWith(readername)) {
                    readerDevice = device;
                    mConnectedRfidReader = readerDevice.getRFIDReader();
                    break;
                }
            }
        }
    }

    // Public method to select a single reader
    public void selectReader(ReaderDevice device) {
        ArrayList<ReaderDevice> list = new ArrayList<>();
        list.add(device);
        selectReaderDevice(list);
    }

    private boolean isReaderConnected() {
        if (mConnectedRfidReader != null && mConnectedRfidReader.isConnected())
            return true;
        else {
            Log.d(TAG, "reader is not connected");
            return false;
        }
    }


  /*  private synchronized String connect() {
        if (mReader != null) {
            Log.d(TAG, "connect " + mReader.getHostName());
            try {
                if (!mReader.isConnected()) {
                    // Establish connection to the RFID Reader
                    mReader.connect();
                    ConfigureReader();

                    if(mReader.isConnected()){
                        return "Connected: " + mReader.getHostName();
                    }

                }
            } catch (InvalidUsageException e) {
                e.printStackTrace();
                return "Connection failed" + e.getVendorMessage() ;
            } catch (OperationFailureException e) {
                e.printStackTrace();
                Log.d(TAG, "OperationFailureException " + e.getVendorMessage());
                String des = e.getResults().toString();
                return "Connection failed" + e.getVendorMessage() + " " + des;
            }
        }
        return "reader null";
    }*/

//    public void setupScannerSDK(){
//        if (sdkHandler == null)
//        {
//            sdkHandler = new SDKHandler(context);
//            //For cdc device
//            DCSSDKDefs.DCSSDK_RESULT result = sdkHandler.dcssdkSetOperationalMode(DCSSDKDefs.DCSSDK_MODE.DCSSDK_OPMODE_USB_CDC);
//
//            //For bluetooth device
//            DCSSDKDefs.DCSSDK_RESULT btResult = sdkHandler.dcssdkSetOperationalMode(DCSSDKDefs.DCSSDK_MODE.DCSSDK_OPMODE_BT_LE);
//            DCSSDKDefs.DCSSDK_RESULT btNormalResult = sdkHandler.dcssdkSetOperationalMode(DCSSDKDefs.DCSSDK_MODE.DCSSDK_OPMODE_BT_NORMAL);
//
//            Log.d(TAG,btNormalResult+ " results "+ btResult);
//            sdkHandler.dcssdkSetDelegate(this);
//
//            int notifications_mask = 0;
//            // We would like to subscribe to all scanner available/not-available events
//            notifications_mask |= DCSSDKDefs.DCSSDK_EVENT.DCSSDK_EVENT_SCANNER_APPEARANCE.value | DCSSDKDefs.DCSSDK_EVENT.DCSSDK_EVENT_SCANNER_DISAPPEARANCE.value;
//
//            // We would like to subscribe to all scanner connection events
//            notifications_mask |= DCSSDKDefs.DCSSDK_EVENT.DCSSDK_EVENT_BARCODE.value | DCSSDKDefs.DCSSDK_EVENT.DCSSDK_EVENT_SESSION_ESTABLISHMENT.value | DCSSDKDefs.DCSSDK_EVENT.DCSSDK_EVENT_SESSION_TERMINATION.value;
//
//
//            // We would like to subscribe to all barcode events
//            // subscribe to events set in notification mask
//            sdkHandler.dcssdkSubsribeForEvents(notifications_mask);
//        }
//        if (sdkHandler != null)
//        {
//            ArrayList<DCSScannerInfo> availableScanners = new ArrayList<>();
//            availableScanners  = (ArrayList<DCSScannerInfo>) sdkHandler.dcssdkGetAvailableScannersList();
//
//            scannerList.clear();
//            if (availableScanners != null)
//            {
//                for (DCSScannerInfo scanner : availableScanners)
//                {
//
//                    scannerList.add(scanner);
//                }
//            }
//            else
//                Log.d(TAG,"Available scanners null");
//
//        }
//        if (reader != null )
//        {
//            for (DCSScannerInfo device : scannerList)
//            {
//                if (device.getScannerName().contains(reader.getHostName()))
//                {
//                    try
//                    {
//                        sdkHandler.dcssdkEstablishCommunicationSession(device.getScannerID());
//                        scannerID= device.getScannerID();
//                    }
//                    catch (Exception e) {
//                        e.printStackTrace();
//                    }
//                }
//            }
//        }
//    }

    public void Test() {
        // call use case
        //Test1();
    }

    public void MultiTag() {

        //Ability to search up to 4 tags simultaneously
        TagPatternBase[] tagpatterns = new TagPatternBase[3];
        tagpatterns[0] = new TagPatternBase();
        tagpatterns[0].setTagPattern("10000179F2E24166066F6894A9706ACD");
        tagpatterns[0].setBitOffset(32);
        tagpatterns[0].setMemoryBank(MEMORY_BANK.MEMORY_BANK_EPC);


        tagpatterns[1] = new TagPatternBase();
        tagpatterns[1].setTagPattern("100001791F0E1B5BCF856BF09B02F868");
        tagpatterns[1].setBitOffset(32);
        tagpatterns[1].setMemoryBank(MEMORY_BANK.MEMORY_BANK_EPC);




        tagpatterns[2] = new TagPatternBase();
        tagpatterns[2].setTagPattern("10000179F3FB785478D184F26A790DE1");
        tagpatterns[2].setBitOffset(32);
        tagpatterns[2].setMemoryBank(MEMORY_BANK.MEMORY_BANK_EPC);

        //tagpatterns[3] = new TagPatternBase();
        //tagpatterns[3].setTagPattern("1000016DA1F0DB102465E72738AEFC52");
        //tagpatterns[3].setBitOffset(32);
        //tagpatterns[3].setMemoryBank(MEMORY_BANK.MEMORY_BANK_TID);

        try {

            // run locate with default params
            mConnectedRfidReader.Actions.TagLocationing.PerformMultiLocate(tagpatterns, null, null);
            Thread.sleep(3000);
            mConnectedRfidReader.Actions.TagLocationing.Stop();

            // with customized locate parameters
            MultiLocateParams multi_params = new MultiLocateParams();
            // set thresholds
            multi_params.lock_on = 50;
            multi_params.lock_off = 10;
            multi_params.lock_off_time = 1;

            multi_params.getDetectionProfile().setTime(250);
            multi_params.getDetectionProfile().setLevel(20);

            multi_params.getLowProfile().setTime(150);
            multi_params.getLowProfile().setLevel(45);
            multi_params.getLowProfile().setLevel(1);

            multi_params.getMediumProfile().setTime(80);
            multi_params.getMediumProfile().setLevel(65);
            multi_params.getMediumProfile().setLevel(2);

            multi_params.getHighProfile().setTime(50);
            multi_params.getHighProfile().setLevel(80);
            multi_params.getHighProfile().setLevel(2);

            multi_params.getMaxProfile().setTime(90);
            multi_params.getMaxProfile().setLevel(3);

            mConnectedRfidReader.Actions.TagLocationing.PerformMultiLocate(tagpatterns, multi_params, null);
            Thread.sleep(3000);
            mConnectedRfidReader.Actions.TagLocationing.Stop();
        } catch (InvalidUsageException e) {
            //e.printStackTrace();
        } catch (OperationFailureException e) {
            //e.printStackTrace();
        } catch (InterruptedException e) {
            //e.printStackTrace();
        }
    }
    public void powerState(){

        for (READER_POWER_STATE powerstate : READER_POWER_STATE.values()) {
            try {
                //READER_POWER_STATE powerstate = reader.Config.getReaderPowerState();
                if (powerstate != READER_POWER_STATE.POWER_STATE_OFF)
                    mConnectedRfidReader.Config.setReaderPowerState(powerstate);
                powerstate = mConnectedRfidReader.Config.getReaderPowerState();
                Log.d(TAG,"Current power state " + powerstate);
            } catch (InvalidUsageException e) {
                //e.printStackTrace();
            } catch (OperationFailureException e) {
                //e.printStackTrace();
            }
        }
        try {
            READER_POWER_STATE powerstate = READER_POWER_STATE.POWER_STATE_STANDBY;
            mConnectedRfidReader.Config.setReaderPowerState(powerstate);
            powerstate = mConnectedRfidReader.Config.getReaderPowerState();
            Log.d(TAG,"Last power state " + powerstate);
        }
        catch (InvalidUsageException e) {
            //e.printStackTrace();
        } catch (OperationFailureException e) {
            //e.printStackTrace();
        }

    }

    public void UserFeedback() {
        //User can control LED and Beeper based on canned profiles.
      /*  for (int i = 0; i < 10; i++)*/{
            try {

                mConnectedRfidReader.Config.setUserFeedback(0);
                Thread.sleep(5000);
            } catch (InvalidUsageException e) {
                //e.printStackTrace();
            } catch (OperationFailureException e) {
                //e.printStackTrace();
            } catch (InterruptedException e) {
                //e.printStackTrace();
            }
        }
    }
    public void batteryHealth(){
        int bH = 0;
        try {

            bH = mConnectedRfidReader.Config.getBatteryHealth();

        } catch (InvalidUsageException e) {
            //e.printStackTrace();
        } catch (OperationFailureException e) {
            //e.printStackTrace();
        }
        Log.d(TAG,"Battery Health "+bH);
    }

    public void enableInfoEvent(){
        /*
        RFID antenna power level is limited to 24dbm when reader is in cradle, setting the antenna power level to value higher than 24db when sled is in cradle will get “Value Not Allowed” error
“Antenna Power Level Adjusted” information event is sent to host if antenna power level is higher than 24dbm when reader is placed in cradle

        * */
       // reader.Events.setInfoEvent(true);
        //reader.Events.setCradleEvent(true);
        try {

            mConnectedRfidReader.Config.getDeviceStatus(false,false,false,true);
        } catch (InvalidUsageException e) {
            //e.printStackTrace();
        } catch (OperationFailureException e) {
            //e.printStackTrace();
        }
    }

    public void setSingulationControl(){
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {
                Antennas.SingulationControl singulationControl;
                try {
                    singulationControl = mConnectedRfidReader.Config.Antennas.getSingulationControl(3);
                    singulationControl.setSession(SESSION.GetSession(1));
                    singulationControl.setTagPopulation((short) 22);
                    singulationControl.Action.setInventoryState(INVENTORY_STATE.GetInventoryState(2));

                    switch (2) {
                        case 0:
                            singulationControl.Action.setSLFlag(SL_FLAG.SL_ALL);
                            break;
                        case 1:
                            singulationControl.Action.setSLFlag(SL_FLAG.SL_FLAG_DEASSERTED);
                            break;
                        case 2:
                            singulationControl.Action.setSLFlag(SL_FLAG.SL_FLAG_ASSERTED);
                            break;
                    }
                    mConnectedRfidReader.Config.Antennas.setSingulationControl(1, singulationControl);
                } catch (InvalidUsageException e) {
                    if (e != null && e.getStackTrace().length > 0) {
                        Log.e(TAG, e.getStackTrace()[0].toString());
                    }
                } catch (OperationFailureException e) {
                    if (e != null && e.getStackTrace().length > 0) {
                        Log.e(TAG, e.getStackTrace()[0].toString());
                    }
                }
                return null;
            }
        }.execute();
    }

    public void triggerSettings(){
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {
                try {
                    StartTrigger startTrigger = mConnectedRfidReader.Config.getStartTrigger();
                    StopTrigger stopTrigger = mConnectedRfidReader.Config.getStopTrigger();
                    mConnectedRfidReader.Config.setStartTrigger(startTrigger);
                    mConnectedRfidReader.Config.setStopTrigger(stopTrigger);

                } catch (InvalidUsageException | OperationFailureException e) {
                    if (e.getStackTrace().length > 0) {
                        Log.e(TAG, e.getStackTrace()[0].toString());
                    }
                }
                return null;
            }


        }.execute();
    }

    public void addPrefilter() {

        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {
                String tag = "11112222";
                PreFilters filters = new PreFilters();
                PreFilters.PreFilter filter = filters.new PreFilter();
                filter.setAntennaID((short) 1);// Set this filter for Antenna ID 1
                filter.setTagPattern(tag);// Tags which starts with passed pattern
                filter.setTagPatternBitCount(32);
                filter.setBitOffset(32); // skip PC bits (always it should be in bit length)
                filter.setMemoryBank(MEMORY_BANK.MEMORY_BANK_EPC);
                filter.setFilterAction(FILTER_ACTION.FILTER_ACTION_STATE_AWARE); // use state aware singulation
                filter.StateAwareAction.setTarget(TARGET.TARGET_SL); // inventoried flag of session S1 of matching tags to B
                filter.StateAwareAction.setStateAwareAction(STATE_AWARE_ACTION.STATE_AWARE_ACTION_ASRT_SL_NOT_DSRT_SL);
                // not to select tags that match the criteria
                try {
                    mConnectedRfidReader.Actions.PreFilters.add(filter);
                } catch (InvalidUsageException e) {
                   // e.printStackTrace();
                } catch (OperationFailureException e) {
                  //  e.printStackTrace();
                }
                return null;
            }
        }.execute();

    }

    public void doRead() {
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {

// read operation
                try {
                    CableLossCompensation cableLoss =  mConnectedRfidReader.Config.getCableLossCompensation(1);
                    //reader.Actions.TagAccess.readEvent( readAccessParams, null, null);
                    Log.d("test", "test");
                } catch (InvalidUsageException e) {
                    //throw new RuntimeException(e);
                    showMessage("get cable loss failed ");
                    return null;
                } catch (OperationFailureException e) {
                    //throw new RuntimeException(e);
                    showMessage("get cable loss failed "  );
                    return null;

                }
                showMessage("get cable loss  success ");
                return null;
            }

        }.execute();

    }

    public void doWrite() {
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {

// read operation
                try {
                    CableLossCompensation[] cableLossCompensationInfo = new CableLossCompensation[3];
                    cableLossCompensationInfo[0] = new CableLossCompensation();
                    cableLossCompensationInfo[0].setAntennaID(1);
                    cableLossCompensationInfo[0].setCableLossPer100Feet(5);
                    cableLossCompensationInfo[0].setCableLengthInFeet(5);
                    cableLossCompensationInfo[1] = new CableLossCompensation();
                    cableLossCompensationInfo[1].setAntennaID(2);
                    cableLossCompensationInfo[1].setCableLossPer100Feet(10);
                    cableLossCompensationInfo[1].setCableLengthInFeet(10);
                    cableLossCompensationInfo[2] = new CableLossCompensation();
                    cableLossCompensationInfo[2].setAntennaID(3);
                    cableLossCompensationInfo[2].setCableLossPer100Feet(20);
                    cableLossCompensationInfo[2].setCableLengthInFeet(20);

                    RFIDResults result = mConnectedRfidReader.Config.setCableLossCompensation(cableLossCompensationInfo);
                    //reader.Actions.TagAccess.readEvent( readAccessParams, null, null);
                    Log.d("test", "test");
                } catch (InvalidUsageException e) {
                    //throw new RuntimeException(e);
                    showMessage("get cable loss failed ");
                    return null;
                } catch (OperationFailureException e) {
                    //throw new RuntimeException(e);
                    showMessage("get cable loss failed "  );
                    return null;

                }
                showMessage("get cable loss  success ");
                return null;
            }

        }.execute();

    }

    private void showMessage(String message) {
        context.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
            }
        });
    }

    public void doLock() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            TagData tagData = null;
            String tagId = "e28011700000020d2a411a23";
            //String tagId = "11112222000000021f0b8976";
            TagAccess tagAccess = new TagAccess();
            TagAccess.LockAccessParams lockAccessParams = tagAccess.new LockAccessParams();
            lockAccessParams.setAccessPassword(11112222);
            LOCK_PRIVILEGE lockPrivilege = LOCK_PRIVILEGE.LOCK_PRIVILEGE_READ_WRITE;
            lockAccessParams.setLockPrivilege(LOCK_DATA_FIELD.LOCK_EPC_MEMORY, lockPrivilege);
// data length in words
            try {
                mConnectedRfidReader.Actions.TagAccess.lockWait(tagId, lockAccessParams, null, false);
            } catch (InvalidUsageException e) {
                //throw new RuntimeException(e);
                showMessage("lock failed ");
                return  ;
            } catch (OperationFailureException e) {
                //throw new RuntimeException(e);
                showMessage("lock failed ");
                return ;
            }
            showMessage("lock success ");
            return ;

        });
    }

    public void deleteSelects() {
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {
                try {
                    mConnectedRfidReader.Actions.PreFilters.deleteAll();
                } catch (InvalidUsageException e) {
                    //throw new RuntimeException(e);
                    showMessage("delete all failed ");
                    return null ;
                } catch (OperationFailureException e) {
                    //throw new RuntimeException(e);
                    showMessage("delete all failed ");
                    return null;
                }
                showMessage("delete all success ");
                return null;
            }

        }.execute();
    }

    public void getcapablities() {
    }


//    private class GetReaderListTask extends AsyncTask<Void, Void, String> {
//        @Override
//        protected String doInBackground(Void... voids) {
//            /*
//            if (readers != null) {
//                Log.d(TAG, "GetReaderListTask");
//                availableRFIDReaderList = readers.GetAvailableRFIDReaderList();
//                if (availableRFIDReaderList != null) {
//                    if (availableRFIDReaderList.size() != 0) {
//                        // search reader specified by name
//                        for (ReaderDevice device : availableRFIDReaderList) {
//                            if (device.getName().equals(readername)) {
//                                readerDevice = device;
//                                reader = readerDevice.getRFIDReader();
//                                return connect();
//                            }
//                        }
//                    }
//                }
//            }
//            */
//            return connect();
//        }
//
//        @Override
//        protected void onPostExecute(String result) {
//            super.onPostExecute(result);
//            Toast.makeText(context, result, Toast.LENGTH_SHORT).show();
//            textView.setText(result);
//
//        }
//    }
//
//    void onDestroy() {
//        dispose();
//    }
//
//    String onResume() {
//        return connect();
//    }
//
//    void onPause() {
//        disconnect();
//    }
//
//    private synchronized String connect() {
//        Log.d(TAG, "connect");
//        if (mReader != null) {
//            try {
//                if (!mReader.isConnected()) {
//                    // Establish connection to the RFID Reader
//                    mReader.setPassword("Zebra@123");
//                    //reader.setAdminPassword("admin");
//                    mReader.connect();
//                    ConfigureReader();
//                    return "Connected";
//                }
//            } catch (InvalidUsageException e) {
//                //e.printStackTrace();
//            } catch (OperationFailureException e) {
//                //e.printStackTrace();
//                Log.d(TAG, "OperationFailureException " + e.getVendorMessage());
//                return "Connection failed" + e.getVendorMessage() + " " + e.getStatusDescription();
//            }
//        }
//        return "";
//    }

    public static void ConfigureReader() {
        if (mConnectedRfidReader.isConnected()) {
            TriggerInfo triggerInfo = new TriggerInfo();
            triggerInfo.StartTrigger.setTriggerType(START_TRIGGER_TYPE.START_TRIGGER_TYPE_IMMEDIATE);
            triggerInfo.StopTrigger.setTriggerType(STOP_TRIGGER_TYPE.STOP_TRIGGER_TYPE_IMMEDIATE);
            try {

                // receive events from reader
                mConnectedRfidReader.Events.addEventsListener(eventHandler);
                // HH event
                mConnectedRfidReader.Events.setHandheldEvent(true);
                // tag event with tag data
                mConnectedRfidReader.Events.setTagReadEvent(true);
                mConnectedRfidReader.Events.setAttachTagDataWithReadEvent(false);
                mConnectedRfidReader.Events.setReaderDisconnectEvent(true);
                mConnectedRfidReader.Events.setCradleEvent(true);
                mConnectedRfidReader.Events.setBatteryEvent(true);
                mConnectedRfidReader.Events.setFirmwareUpdateEvent(true);

                Antennas.SingulationControl s1_singulationControl = new Antennas.SingulationControl();
                s1_singulationControl.setSession(SESSION.SESSION_S0);
                s1_singulationControl.setTagPopulation((short) 200);
                s1_singulationControl.Action.setInventoryState(INVENTORY_STATE.INVENTORY_STATE_AB_FLIP);
                s1_singulationControl.Action.setSLFlag(SL_FLAG.SL_ALL);
                mConnectedRfidReader.Config.Antennas.setSingulationControl(1, s1_singulationControl);
                // set trigger mode as rfid so scanner beam will not come
                mConnectedRfidReader.Config.setTriggerMode(ENUM_TRIGGER_MODE.RFID_MODE, false);
                // set start and stop triggers
                mConnectedRfidReader.Config.setStartTrigger(triggerInfo.StartTrigger);
                mConnectedRfidReader.Config.setStopTrigger(triggerInfo.StopTrigger);
                mConnectedRfidReader.Actions.PreFilters.deleteAll();

                // set antenna configurations
                /*Antennas.AntennaRfConfig config = mReader.Config.Antennas.getAntennaRfConfig(1);
                config.setTransmitPowerIndex(27);
                config.setrfModeTableIndex(0);
                config.setTari(0);
                mReader.Config.Antennas.setAntennaRfConfig(1, config);
                // Set the singulation control

                // delete any prefilters
                */
                //
            } catch (InvalidUsageException | OperationFailureException e) {
                //e.printStackTrace();
            }
        }
    }

    public  synchronized void disconnect() {
        Log.d(TAG, "Disconnect");
        try {
            if (mConnectedRfidReader != null) {
                if (eventHandler != null)
                    mConnectedRfidReader.Events.removeEventsListener(eventHandler);
                connectionStatus.postValue(false);
                mConnectedRfidReader.disconnect();
            }
        } catch (InvalidUsageException e) {
            //e.printStackTrace();
        } catch (OperationFailureException e) {
            //e.printStackTrace();
        } catch (Exception e) {
            //e.printStackTrace();
        }
    }

    public synchronized void dispose() {
        disconnect();
        try {
            if (mConnectedRfidReader != null) {
                //Toast.makeText(getApplicationContext(), "Disconnecting reader", Toast.LENGTH_LONG).show();
                mConnectedRfidReader = null;
                readers.Dispose();
                readers = null;
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }
    }

    public void doKill() {

        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable() {
            @Override
            public void run() {
                StopTrigger stopTrigger;
                try {

                    TagData tagData = null;
                    String tagId = "e280689400005001b043b044";
                    //String tagId = "11112222000000021f0b8976";
                    TagAccess tagAccess = new TagAccess();
                    TagAccess.KillAccessParams killAccessParams = tagAccess.new KillAccessParams();
                    killAccessParams.setKillPassword(0);
                    AntennaInfo antennaInfo = new AntennaInfo();
                    mConnectedRfidReader.Actions.TagAccess.killWait(tagId,killAccessParams,null);
                } catch (InvalidUsageException e) {
                    return;
                } catch (OperationFailureException e) {
                    return;
                }
            }
        });
    }

    public void dosequence() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable() {
            @Override
            public void run() {

                AccessFilter accessFilter = new AccessFilter();
                byte[] tagMask = new byte[]{(byte) 0xff, (byte) 0xff
                };

                // Tag Pattern A
                accessFilter.TagPatternA.setMemoryBank(MEMORY_BANK.MEMORY_BANK_EPC);
                accessFilter.TagPatternA.setTagPattern(new byte[]
                        {
                                // 0x2f, 0x22
                                0x22, 0x44
                                // (byte)0x83, (byte)0x91
                        });
                accessFilter.TagPatternA.setTagPatternBitCount(16);
                accessFilter.TagPatternA.setBitOffset(32);
                accessFilter.TagPatternA.setTagMask(tagMask);
                accessFilter.TagPatternA.setTagMaskBitCount(tagMask.length * 8);
                accessFilter.setAccessFilterMatchPattern(FILTER_MATCH_PATTERN.A);
                int accessOpcount = 0;
                TagAccess tagAccess = new TagAccess();
                TagAccess.Sequence opSequence = tagAccess.new Sequence(tagAccess);

                TagAccess.Sequence.Operation op1 = opSequence.new Operation();
                op1.setAccessOperationCode(ACCESS_OPERATION_CODE.ACCESS_OPERATION_READ);
                op1.ReadAccessParams.setMemoryBank(MEMORY_BANK.MEMORY_BANK_EPC);
                op1.ReadAccessParams.setAccessPassword(0);
                op1.ReadAccessParams.setByteOffset(2);
                // op2.WriteAccessParams.setWriteData(new byte[]{(byte) 0xBB, (byte) 0xBB, (byte) 0xBB, (byte) 0xBB});
                //op2.WriteAccessParams.setWriteDataLength(4);
                try {
                    mConnectedRfidReader.Actions.TagAccess.OperationSequence.add(op1);

                    accessOpcount++;

                    TagAccess.Sequence.Operation op2 = opSequence.new Operation();
                    op2.setAccessOperationCode(ACCESS_OPERATION_CODE.ACCESS_OPERATION_READ);
                    op2.ReadAccessParams.setMemoryBank(MEMORY_BANK.MEMORY_BANK_USER);
                    op2.ReadAccessParams.setAccessPassword(0);
                    op2.ReadAccessParams.setByteOffset(2);
                    // op1.WriteAccessParams.setWriteData(new byte[]{(byte) 0x55, (byte) 0x66, (byte) 0x77, (byte) 0x88});
                    // op1.WriteAccessParams.setWriteDataLength(4);
                    mConnectedRfidReader.Actions.TagAccess.OperationSequence.add(op2);
                    accessOpcount++;
                    // add Write Access operation - Write to Reserved memory bank
                    TagAccess.Sequence.Operation op3 = opSequence.new Operation();
                    op3.setAccessOperationCode(ACCESS_OPERATION_CODE.ACCESS_OPERATION_READ);
                    op3.ReadAccessParams.setMemoryBank(MEMORY_BANK.MEMORY_BANK_RESERVED);
                    op3.ReadAccessParams.setAccessPassword(0);
                    op3.ReadAccessParams.setByteOffset(2);
                    // op2.WriteAccessParams.setWriteData(new byte[]{(byte) 0xBB, (byte) 0xBB, (byte) 0xBB, (byte) 0xBB});
                    //op2.WriteAccessParams.setWriteDataLength(4);
                    mConnectedRfidReader.Actions.TagAccess.OperationSequence.add(op3);
                    accessOpcount++;
                    TagAccess.Sequence.Operation op4 = opSequence.new Operation();
                    op4.setAccessOperationCode(ACCESS_OPERATION_CODE.ACCESS_OPERATION_READ);
                    op4.ReadAccessParams.setMemoryBank(MEMORY_BANK.MEMORY_BANK_TID);
                    op4.ReadAccessParams.setAccessPassword(0);
                    op4.ReadAccessParams.setByteOffset(2);
                    // op2.WriteAccessParams.setWriteData(new byte[]{(byte) 0xBB, (byte) 0xBB, (byte) 0xBB, (byte) 0xBB});
                    //op2.WriteAccessParams.setWriteDataLength(4);
                    mConnectedRfidReader.Actions.TagAccess.OperationSequence.add(op4);
                    accessOpcount++;

                    TriggerInfo triggerInfo = new TriggerInfo();
                    // perform access sequence
                    mConnectedRfidReader.Actions.TagAccess.OperationSequence.performSequence(accessFilter, triggerInfo, null);
                } catch (InvalidUsageException e) {
                    throw new RuntimeException(e);
                } catch (OperationFailureException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void RFIDReaderAppeared(ReaderDevice readerDevice) {

    }

    @Override
    public void RFIDReaderDisappeared(ReaderDevice readerDevice) {
        Log.d(TAG, "RFIDReaderDisappeared " + readerDevice.getName());

        if(mConnectedRfidReader != null && mConnectedRfidReader.isConnected()){
            if (readerDevice.getName().equals(mConnectedRfidReader.getHostName()))
                disconnect();
        }

    }

    @Override
    public void dcssdkEventScannerAppeared(DCSScannerInfo dcsScannerInfo) {

    }

    @Override
    public void dcssdkEventScannerDisappeared(int i) {

    }

    @Override
    public void dcssdkEventCommunicationSessionEstablished(DCSScannerInfo dcsScannerInfo) {

    }

    @Override
    public void dcssdkEventCommunicationSessionTerminated(int i) {

    }

    @Override
    public void dcssdkEventBarcode(byte[] bytes, int i, int i1) {

    }

    @Override
    public void dcssdkEventImage(byte[] bytes, int i) {

    }

    @Override
    public void dcssdkEventVideo(byte[] bytes, int i) {

    }

    @Override
    public void dcssdkEventBinaryData(byte[] bytes, int i) {

    }

    @Override
    public void dcssdkEventFirmwareUpdate(FirmwareUpdateEvent firmwareUpdateEvent) {

    }

    @Override
    public void dcssdkEventAuxScannerAppeared(DCSScannerInfo dcsScannerInfo, DCSScannerInfo dcsScannerInfo1) {

    }

    // Read/Status Notify handler
    // Implement the RfidEventsLister class to receive event notifications
    public  class EventHandler implements RfidEventsListener {
        // Read Event Notification
        public void eventReadNotify(RfidReadEvents e) {
            // Recommended to use new method getReadTagsEx for better performance in case of large tag population

            TagData[] myTags = mConnectedRfidReader.Actions.getReadTags(100);
            if (myTags != null) {
                for (int index = 0; index < myTags.length; index++) {
                   // Log.d(TAG, "Tag ID " + myTags[index].getTagID() + " Count "+ myTags[index].getTagSeenCount());

                    if (myTags[index].getOpCode() == ACCESS_OPERATION_CODE.ACCESS_OPERATION_READ &&
                            myTags[index].getOpStatus() == ACCESS_OPERATION_STATUS.ACCESS_SUCCESS) {
                        if (myTags[index].getMemoryBankData().length() > 0) {
                            Log.d(TAG, " Mem Bank Data " + myTags[index].getMemoryBankData());
                        }
                    }
                    if (myTags[index].isContainsLocationInfo()) {
                        short dist = myTags[index].LocationInfo.getRelativeDistance();
                        short num = myTags[index].LocationInfo.getTagNumber();
                        Log.d(TAG, "Tag relative distance " + dist + " # " + num);
                    }
                }
              //  Log.d(TAG," Total Tags Read: " + myTags);
                context.runOnUiThread(() -> tagDataViewModel.setTagItems(myTags));
//                if(myTags != null )
//                    new AsyncDataUpdate().execute(myTags);

            }

        }

        // Status Event Notification
        public void eventStatusNotify(RfidStatusEvents rfidStatusEvents) {
            Log.d(TAG, "Status Notification: " + rfidStatusEvents.StatusEventData.getStatusEventType());
            if (rfidStatusEvents.StatusEventData.getStatusEventType() == STATUS_EVENT_TYPE.HANDHELD_TRIGGER_EVENT) {
                if (rfidStatusEvents.StatusEventData.HandheldTriggerEventData.getHandheldEvent() == HANDHELD_TRIGGER_EVENT_TYPE.HANDHELD_TRIGGER_PRESSED) {
                    Log.d(TAG, "Status trigger: trigger pressed");
                    triggerPressedLiveData.postValue(true);
                    //performInventory();
                }
                if (rfidStatusEvents.StatusEventData.HandheldTriggerEventData.getHandheldEvent() == HANDHELD_TRIGGER_EVENT_TYPE.HANDHELD_TRIGGER_RELEASED) {
                    Log.d(TAG, "Status trigger: trigger release");
                    triggerPressedLiveData.postValue(false);
                    //stopInventory();
                }
            }
            if (rfidStatusEvents.StatusEventData.getStatusEventType() == STATUS_EVENT_TYPE.DISCONNECTION_EVENT) {
                new AsyncTask<Void, Void, Void>() {
                    @Override
                    protected Void doInBackground(Void... voids) {

                        disconnect();
                        return null;
                    }
                }.execute();
            }
            if(rfidStatusEvents.StatusEventData.getStatusEventType() == STATUS_EVENT_TYPE.BATTERY_EVENT){
                int data = rfidStatusEvents.StatusEventData.BatteryData.getLevel();
                //  = rfidStatusEvents.StatusEventData.InfoData.getCause();
                Log.d(TAG,"Battery level : "+data );
            }

            if(rfidStatusEvents.StatusEventData.getStatusEventType() == STATUS_EVENT_TYPE.CRADLE_EVENT){
                boolean data = rfidStatusEvents.StatusEventData.cradleData.isOnCradle();
                //  = rfidStatusEvents.StatusEventData.InfoData.getCause();
                Log.d(TAG,"Cradle data : "+data );
            }
            if(rfidStatusEvents.StatusEventData.getStatusEventType() == STATUS_EVENT_TYPE.INFO_EVENT){
                rfidStatusEvents.StatusEventData.cradleData.getCause();
                String data = rfidStatusEvents.StatusEventData.InfoData.getCause();
                Log.d(TAG,"InfoData : "+data );
            }
            if(rfidStatusEvents.StatusEventData.getStatusEventType() == STATUS_EVENT_TYPE.FIRMWARE_UPDATE_EVENT){
                String status = rfidStatusEvents.StatusEventData.FWEventData.getStatus();
                int imageDownloadProgress = rfidStatusEvents.StatusEventData.FWEventData.getImageDownloadProgress();
                int overallUpdateProgress = rfidStatusEvents.StatusEventData.FWEventData.getOverallUpdateProgress();
                Log.d(TAG,"FW status: "+status+", idp: "+imageDownloadProgress+", ovp: "+overallUpdateProgress );
             //   context.runOnUiThread(() -> fwUpdateDataViewModel.setStatus(new String[]{status, String.valueOf(imageDownloadProgress), String.valueOf(overallUpdateProgress)}));
            }
            if(rfidStatusEvents.StatusEventData.getStatusEventType() == STATUS_EVENT_TYPE.GPI_EVENT){

                Log.d(TAG,"GPI_EVENT " );
            }
        }
    }

//    private class AsyncDataUpdate extends AsyncTask<TagData[], Void, Void> {
//        @Override
//        protected Void doInBackground(TagData[]... params) {
//            context.handleTagdata(params[0]);
//
//            return null;
//        }
//    }

    interface ResponseHandlerInterface {
        void handleTagdata(TagData[] tagData);

        void handleTriggerPress(boolean pressed);
        //void handleStatusEvents(Events.StatusEventData eventData);
    }

    public void connect(String readerName) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            if (mConnectedRfidReader != null) {
                Log.d(TAG, "connect " + mConnectedRfidReader.getHostName());
                try {
                    if (!mConnectedRfidReader.isConnected()) {
                        mConnectedRfidReader.connect();
                        ConfigureReader();
                        if (mConnectedRfidReader.isConnected()) {
                            impinjExtensions = new ImpinjExtensions(mConnectedRfidReader);
                            Log.d(TAG, "Connection successful: " + mConnectedRfidReader.getHostName());
                            connectionStatus.postValue(true);
                        }
                    }
                } catch (InvalidUsageException | OperationFailureException e) {
                    e.printStackTrace();
                    connectionStatus.postValue(false);
                }
            }
        });
    }

    public static STATE_AWARE_ACTION getStateAwareActionFromString(String strAction) {
        STATE_AWARE_ACTION action = null;
        if (strAction.equalsIgnoreCase("INV A NOT INV B OR ASRT SL NOT DSRT SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_INV_A_NOT_INV_B;
        if (strAction.equalsIgnoreCase("INV A OR ASRT SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_INV_A;
        if (strAction.equalsIgnoreCase("NOT INV B OR NOT DSRT SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_NOT_INV_B;
        if (strAction.equalsIgnoreCase("INV A2BB2A NOT INV A OR NEG SL NOT ASRT SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_INV_A2BB2A_NOT_INV_A;
        if (strAction.equalsIgnoreCase("INV B NOT INV A OR DSRT SL NOT ASRT SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_INV_B_NOT_INV_A;
        if (strAction.equalsIgnoreCase("INV B OR DSRT SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_INV_B;
        if (strAction.equalsIgnoreCase("NOT INV A OR NOT ASRT SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_NOT_INV_A;
        if (strAction.equalsIgnoreCase("NOT INV A2BB2A OR NOT NEG SL"))
            action = STATE_AWARE_ACTION.STATE_AWARE_ACTION_NOT_INV_A2BB2A;
        return action;
    }
}
