/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class CommandLineParser {
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_NO_ARGUMENTS = -1;
    public static final int ERROR_REQUIRED_MISSING = -2;
    public static final int ERROR_INVALID_COMMAND = -3;
    ArrayList<Option> Options = new ArrayList();
    String command;

    public void addOption(String name, String alternateName, Boolean required, String description, Boolean hidden) {
        Option o = new Option();
        o.name = name;
        o.alternateName = alternateName;
        o.required = required;
        o.description = description;
        o.hidden = hidden;
        this.Options.add(o);
    }

    public int parse(String[] args) {
        int result = 0;
        Option o = new Option();
        if (args.length > 0) {
            if (args[0].startsWith("-")) {
                result = -3;
            } else {
                this.command = args[0];
                for (String a : args) {
                    if (a.startsWith("-")) {
                        a = a.substring(1, a.length());
                        for (Option op : this.Options) {
                            if (!op.name.equalsIgnoreCase(a)) continue;
                            o = op;
                        }
                        continue;
                    }
                    if (o == null) continue;
                    if (o.value.length() > 0) {
                        o.value = o.value + ",";
                    }
                    o.value = o.value + a.toUpperCase();
                }
            }
            for (Option op : this.Options) {
                if (!o.required.booleanValue() || !o.value.equals("")) continue;
                result = -2;
            }
        } else {
            result = -1;
        }
        return result;
    }

    public String getCommand() {
        return this.command;
    }

    public String getOptionValue(String o) {
        for (Option op : this.Options) {
            if (!op.name.equalsIgnoreCase(o)) continue;
            return op.value;
        }
        return "";
    }
}

