/*
 * Decompiled with CFR 0.152.
 */
public class MainClass {
    private static final String APPNAME = "SigTools";
    private static final String GETCERT_COMMAND = "GETCERT";
    private static final String GETVERSION_COMMAND = "VERSION";
    private static final String versionNumber = "1.3";
    private static final int MAX_CERTIFICATES = 10;
    private static String TAB1 = "    ";
    private static String TAB2 = "        ";
    private static String TAB3 = "            ";
    private static String TAB4 = "                ";
    private static String USAGE = "NAME\n" + TAB2 + "SigTools - Converts a certificate (either a direct DER formated file or from an APK) into\n" + TAB2 + "a byte array.  The output is formatted as a java class, string of bytes or a DER file\n" + TAB2 + "and is copied to the clipboard.  The output can also be written to a file (for JAVA or DER OUTFORM)\n\nSYNOPSIS\n" + TAB2 + "java -jar SigTools COMMAND -INFORM [DER|APK] -OUTFORM [BASE64|HEX|JAVA|DER] [-OUTFILE filename] -IN FILENAME [FILENAME]...[ARGUMENTS]\n\nDESCRIPTION\n" + TAB2 + "Commands:\n" + TAB3 + "GETCERT" + TAB1 + "Read the certificate\n" + TAB3 + "VERSION" + TAB1 + "Get the version of this JAR\n\n" + TAB2 + "Arguments:\n" + TAB3 + "INFORM" + TAB1 + "(REQUIRED) Format of the input file.  Either APK or DER\n" + TAB3 + "OUTFORM" + TAB1 + "(REQUIRED) Format of the output.\n" + TAB4 + "BASE64 - a Base64 string representing the bytes in the certificate\n" + TAB4 + "JAVA - a Java class with public byte array member(s) initialized with the certificate bytes\n" + TAB4 + "HEX - a HEX string representing the bytes in the certificate\n" + TAB4 + "DER - the certificate itself.  Most important if extracting from APK file\n" + TAB3 + "IN" + TAB1 + "(REQUIRED) A space separated list of file names (NOTE be sure to surround with quote if there is a space in the name\n" + TAB3 + "OUTFILE" + TAB1 + "(Optional) If JAVA is used as the OUTFORM the output file name";

    private static void initializeCommandLineParser(CommandLineParser clp) {
        clp.addOption("INFORM", "", true, "Form of the input file", false);
        clp.addOption("OUTFORM", "", true, "Format of the output", false);
        clp.addOption("IN", "", true, "Input file(s)", false);
        clp.addOption("OUTFILE", "", false, "Output file name", false);
        clp.addOption("LOG", "L", false, "Turn Logging On", true);
    }

    public static void main(String[] args) {
        CommandLineParser commandLineParser = new CommandLineParser();
        MainClass.initializeCommandLineParser(commandLineParser);
        switch (commandLineParser.parse(args)) {
            case 0: {
                MainClass.processCommand(commandLineParser);
                break;
            }
            case -1: {
                System.out.println("ERROR - No arguments found\n\n" + USAGE);
                break;
            }
            case -2: {
                System.out.println("ERROR - Required argument missing\n\n" + USAGE);
                break;
            }
            case -3: {
                System.out.println("ERROR - No command found\n\n" + USAGE);
                break;
            }
        }
    }

    private static void processCommand(CommandLineParser c) {
        switch (c.getCommand().toUpperCase()) {
            case "GETCERT": {
                MainClass.processGETCERT(c);
                break;
            }
            case "VERSION": {
                System.out.println("SigTools : version 1.3");
                break;
            }
            default: {
                System.out.println("ERROR - Invalid command found\n\n" + USAGE);
            }
        }
    }

    private static void processGETCERT(CommandLineParser c) {
        byte[][] certificates = new byte[10][];
        Output outPut = new Output();
        switch (c.getOptionValue("INFORM")) {
            case "APK": {
                ReadBytesFromAPKFile readbytesfromapkfile = new ReadBytesFromAPKFile();
                readbytesfromapkfile.ReadBytesFromAPKFile(c.getOptionValue("IN").split(","), certificates, 10, c.getOptionValue("log").equalsIgnoreCase("TRUE"));
                outPut.writeOutput(certificates, c.getOptionValue("OUTFORM"), c.getOptionValue("OUTFILE"), c.getOptionValue("log").equalsIgnoreCase("TRUE"));
                break;
            }
            case "DER": {
                ReadBytesFromDERFile readbytesfromderfile = new ReadBytesFromDERFile();
                readbytesfromderfile.ReadBytesFromDERFile(c.getOptionValue("IN").split(","), certificates, 10);
                outPut.writeOutput(certificates, c.getOptionValue("OUTFORM"), c.getOptionValue("OUTFILE"), c.getOptionValue("log").equalsIgnoreCase("TRUE"));
                break;
            }
            default: {
                System.out.println("ERROR - Invalid INFORM argument found\n\n" + USAGE);
            }
        }
    }
}

