/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Base64;

public class Output {
    private static String TAB1 = "    ";
    private static String TAB2 = "        ";
    private static String TAB3 = "            ";

    public boolean writeOutput(byte[][] certificates, String outForm, String outFile, Boolean logging) {
        boolean result = true;
        switch (outForm) {
            case "JAVA": {
                this.writeJAVA(certificates, outFile, logging);
                break;
            }
            case "BASE64": {
                this.writeBase64(certificates, outFile, logging);
                break;
            }
            case "DER": {
                this.writeDER(certificates, outFile, logging);
                break;
            }
            case "HEX": {
                this.writeHEX(certificates, outFile, logging);
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private void writeJAVA(byte[][] certificates, String outFile, Boolean logging) {
        block8: {
            String finalstring = new String();
            int certificatenumber = 0;
            finalstring = "package <your package name here>\n\npublic class AllowedSigningCertificates {\n" + TAB1 + "public byte [][] AllowedCertByteArrays = new byte[][] {\n" + TAB2 + "{\n";
            for (byte[] c : certificates) {
                if (c == null) continue;
                if (certificatenumber > 0) {
                    finalstring = finalstring + ",\n" + TAB2 + "{\n";
                }
                finalstring = finalstring + TAB3 + "// Certificate #" + certificatenumber++ + "\n" + TAB3;
                int j = 0;
                for (int i = 0; i < c.length - 1; ++i) {
                    finalstring = finalstring + "(byte) " + String.format("0x%02X", c[i]) + ", ";
                    if (j == 9) {
                        finalstring = finalstring + "\n" + TAB3;
                        j = 0;
                        continue;
                    }
                    ++j;
                }
                finalstring = finalstring + "(byte) " + String.format("0x%02X", c[c.length - 1]) + "\n" + TAB2 + "}";
            }
            finalstring = finalstring + "\n" + TAB1 + "};\n}";
            Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipBoard.setContents(new StringSelection(finalstring), null);
            if (logging.booleanValue()) {
                System.out.println(finalstring);
            }
            if (outFile != null && !outFile.isEmpty()) {
                try {
                    File certFile = new File(outFile);
                    FileOutputStream FO = new FileOutputStream(certFile);
                    FO.write(finalstring.getBytes());
                    FO.close();
                }
                catch (IOException e) {
                    if (!logging.booleanValue()) break block8;
                    System.out.println("IOException writing output file");
                }
            }
        }
    }

    private void writeBase64(byte[][] certificates, String outFile, Boolean logging) {
        String finalstring = "";
        if (outFile != null && !outFile.isEmpty()) {
            for (int counter = 0; counter < certificates.length; ++counter) {
                block6: {
                    try {
                        if (certificates[counter] != null) {
                            finalstring = Base64.getEncoder().encodeToString(certificates[counter]);
                            if (logging.booleanValue()) {
                                System.out.println("Base64 of Certificate #" + counter + ": " + finalstring);
                            }
                            File certFile = new File(this.formatFileNameWithNumber(outFile, counter));
                            FileOutputStream FO = new FileOutputStream(certFile);
                            FO.write(finalstring.getBytes());
                            FO.close();
                        }
                    }
                    catch (IOException e) {
                        if (!logging.booleanValue()) break block6;
                        System.out.println("IOException writing output file");
                    }
                }
                if (counter != 0) continue;
                Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipBoard.setContents(new StringSelection(finalstring), null);
            }
        }
    }

    private void writeDER(byte[][] certificates, String outFile, Boolean logging) {
        if (outFile != null && !outFile.isEmpty()) {
            for (int counter = 0; counter < certificates.length; ++counter) {
                try {
                    if (certificates[counter] == null) continue;
                    File certFile = new File(this.formatFileNameWithNumber(outFile, counter));
                    FileOutputStream FO = new FileOutputStream(certFile);
                    FO.write(certificates[counter]);
                    FO.close();
                    continue;
                }
                catch (IOException e) {
                    if (!logging.booleanValue()) continue;
                    System.out.println("IOException writing output file");
                }
            }
        } else if (logging.booleanValue()) {
            System.out.println("No Output File Specified");
        }
    }

    private void writeHEX(byte[][] certificates, String outFile, Boolean logging) {
        String finalstring = "";
        if (outFile != null && !outFile.isEmpty()) {
            for (int counter = 0; counter < certificates.length; ++counter) {
                block9: {
                    try {
                        if (certificates[counter] != null) {
                            finalstring = "";
                            for (int i = 0; i < certificates[counter].length - 1; ++i) {
                                finalstring = finalstring + String.format("%02X", certificates[counter][i]);
                            }
                            if (logging.booleanValue()) {
                                System.out.println("Hex of Certificate #" + counter + ": " + finalstring);
                            }
                            File certFile = new File(this.formatFileNameWithNumber(outFile, counter));
                            FileOutputStream FO = new FileOutputStream(certFile);
                            FO.write(finalstring.getBytes());
                            FO.close();
                        }
                    }
                    catch (IOException e) {
                        if (!logging.booleanValue()) break block9;
                        System.out.println("IOException writing output file");
                    }
                }
                if (counter != 0) continue;
                Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipBoard.setContents(new StringSelection(finalstring), null);
            }
        } else if (logging.booleanValue()) {
            System.out.println("No Output File Specified");
        }
    }

    private String formatFileNameWithNumber(String fileName, int number) {
        if (number != 0) {
            String prefix = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            return prefix + "_" + number + suffix;
        }
        return fileName;
    }
}

