/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ReadBytesFromAPKFile {
    private static int BUFFER_SIZE = 10000;
    private static String TAB2 = "        ";
    private static String TAB3 = "            ";

    private static long uINT64(byte[] b) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value += (long)((b[i] & 0xFF) << 8 * i);
        }
        return value;
    }

    private static int uINT32(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value += (b[i] & 0xFF) << 8 * i;
        }
        return value;
    }

    public byte[][] ReadBytesFromAPKFile(String[] args, byte[][] certificates, int maxcertificates, Boolean logging) {
        if (!this.SignatureSchemeV1(args, certificates, maxcertificates, logging)) {
            this.SignatureSchemeV2(args, certificates, maxcertificates, logging);
        }
        return certificates;
    }

    private boolean SignatureSchemeV1(String[] args, byte[][] certificates, int maxcertificates, Boolean logging) {
        boolean result = false;
        String APKFilename = args[0];
        try {
            ZipFile file = new ZipFile(APKFilename);
            Enumeration<? extends ZipEntry> entries = file.entries();
            int certificatenumber = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.isDirectory() && entry.getName().endsWith(".RSA")) {
                    int bytes;
                    if (logging.booleanValue()) {
                        System.out.println("Signature Scheme V1 - Certificate File Found");
                    }
                    result = true;
                    byte[] tempbuffer = new byte[BUFFER_SIZE];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    InputStream is = file.getInputStream(entry);
                    while ((bytes = is.read(tempbuffer)) != -1) {
                        out.write(tempbuffer, 0, bytes);
                    }
                    out.flush();
                    byte[] byteArray = out.toByteArray();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> c = certificateFactory.generateCertificates(new ByteArrayInputStream(byteArray));
                    for (Certificate certificate : c) {
                        byte[] b = certificate.getEncoded();
                        if (certificatenumber >= maxcertificates) continue;
                        certificates[certificatenumber] = Arrays.copyOfRange(b, 0, b.length);
                    }
                    ++certificatenumber;
                }
                file.getInputStream(entry);
            }
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void SignatureSchemeV2(String[] args, byte[][] certificates, int maxcertificates, Boolean logging) {
        int APKSigningBlockID = 1896449818;
        String APKSigningBlockMagic = "APK Sig Block 42";
        String APKFilename = args[0];
        File file = new File(APKFilename);
        try {
            int index;
            FileInputStream F = new FileInputStream(file);
            int filelength = (int)file.length();
            byte[] fileContent = new byte[filelength];
            F.read(fileContent);
            F.close();
            for (index = 0; index < filelength; ++index) {
                byte[] b = new byte[4];
                b = Arrays.copyOfRange(fileContent, index, index + 4);
                int value = ReadBytesFromAPKFile.uINT32(b);
                if (value == APKSigningBlockID) break;
            }
            if (index == filelength) {
                if (logging.booleanValue()) {
                    System.out.println("No APK Signing Block ID found");
                }
            } else {
                if (logging.booleanValue()) {
                    System.out.println("APK Signing Block ID Found in " + APKFilename + "at offset: " + index);
                }
                long StartingAPKSigningBlockLength = ReadBytesFromAPKFile.uINT64(Arrays.copyOfRange(fileContent, (index -= 8) - 8, index));
                if (logging.booleanValue()) {
                    System.out.println("APK Signing Block Length = " + StartingAPKSigningBlockLength);
                }
                if ((long)index + StartingAPKSigningBlockLength > (long)filelength) {
                    if (logging.booleanValue()) {
                        System.out.println("Incorrect APK Signing Block Length");
                    }
                } else {
                    byte[] APKSigningBlock = new byte[(int)StartingAPKSigningBlockLength];
                    APKSigningBlock = Arrays.copyOfRange(fileContent, index, index + (int)StartingAPKSigningBlockLength);
                    long EndingAPKSigningBlockLength = ReadBytesFromAPKFile.uINT64(Arrays.copyOfRange(fileContent, index = (int)((long)index + (StartingAPKSigningBlockLength - (long)APKSigningBlockMagic.length() - 8L)), index += 8));
                    if (logging.booleanValue()) {
                        System.out.println("APK Signing Block Length #2 = " + EndingAPKSigningBlockLength);
                    }
                    if (StartingAPKSigningBlockLength != EndingAPKSigningBlockLength) {
                        if (logging.booleanValue()) {
                            System.out.println("The length at the start of the block does not equal the length at the end");
                        }
                    } else {
                        byte[] MagicString = new byte[16];
                        MagicString = Arrays.copyOfRange(fileContent, index, index + 16);
                        String tempString = new String(MagicString);
                        if (!tempString.equals(APKSigningBlockMagic)) {
                            if (logging.booleanValue()) {
                                System.out.println("APK Signing Block Not Found - Magic is missing");
                            }
                        } else {
                            if (logging.booleanValue()) {
                                System.out.println("APK Signing Block Magic String Found at offset: " + index);
                            }
                            if (ReadBytesFromAPKFile.uINT32(Arrays.copyOfRange(APKSigningBlock, index = 8, index + 4)) != APKSigningBlockID) {
                                if (logging.booleanValue()) {
                                    System.out.println("APK Signing Block Got Lost");
                                }
                            } else {
                                int SignerSequenceLength = ReadBytesFromAPKFile.uINT32(Arrays.copyOfRange(APKSigningBlock, index += 4, index += 4));
                                if (logging.booleanValue()) {
                                    System.out.println("Signer Sequence Length = " + SignerSequenceLength);
                                }
                                int FirstSignerLength = ReadBytesFromAPKFile.uINT32(Arrays.copyOfRange(APKSigningBlock, index, index += 4));
                                if (logging.booleanValue()) {
                                    System.out.println("First Signer Length = " + FirstSignerLength);
                                }
                                int SignedDataLength = ReadBytesFromAPKFile.uINT32(Arrays.copyOfRange(APKSigningBlock, index, index += 4));
                                if (logging.booleanValue()) {
                                    System.out.println("First Signer Signed Data Length = " + SignedDataLength);
                                }
                                int DigestSequenceLength = ReadBytesFromAPKFile.uINT32(Arrays.copyOfRange(APKSigningBlock, index, index += 4));
                                if (logging.booleanValue()) {
                                    System.out.println("First Signer Digest Sequence Length = " + DigestSequenceLength);
                                }
                                int certificateSequenceLength = ReadBytesFromAPKFile.uINT32(Arrays.copyOfRange(APKSigningBlock, index += DigestSequenceLength, index += 4));
                                if (logging.booleanValue()) {
                                    System.out.println("First Signer Certificate Sequence Length = " + certificateSequenceLength);
                                }
                                int certificateLength = ReadBytesFromAPKFile.uINT32(Arrays.copyOfRange(APKSigningBlock, index, index += 4));
                                if (logging.booleanValue()) {
                                    System.out.println("First Signer First Certificate Found at Signing Block Offset: " + index);
                                }
                                if (logging.booleanValue()) {
                                    System.out.println("First Signer First Certificate Length = " + certificateLength);
                                }
                                byte[] certificate = new byte[certificateLength];
                                certificate = Arrays.copyOfRange(APKSigningBlock, index, index + certificateLength);
                                certificates[0] = certificate;
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

