package com.zebra.usingptt;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;

public class MainActivity extends AppCompatActivity {

    private static BroadcastReceiver keyReceivers;
    private TextView consoleView;
    private boolean errorDisplayed = false;
    private static int keyAction = -1;
    private final static String symbolKeyString = "com.symbol.button." ;
    private static final String TAG = "BRTester";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        this.consoleView = findViewById(R.id.consoleTextView);
        createButtonReceiver();
    }

    private void clearConsole() {
        this.consoleView.setText("");
        this.consoleView.setTextColor(getResources().getColor(R.color.colorPrimaryDark));
    }

    public void outputTextToConsole(String message) {
        if(errorDisplayed) {
            clearConsole();
            errorDisplayed = false;
        }

        this.consoleView.append(message);

        ScrollView scrollView = ((ScrollView) this.consoleView.getParent());
        scrollView.fullScroll(ScrollView.FOCUS_DOWN);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (keyReceivers != null) {
            getApplicationContext().unregisterReceiver(keyReceivers);
            keyReceivers = null;
        }
    }

    public void createButtonReceiver() {
        final IntentFilter requestFilter = new IntentFilter();
        requestFilter.addAction(symbolKeyString + "L2");
        requestFilter.addAction(symbolKeyString + "R2");
        if (keyReceivers != null) {
            getApplicationContext().unregisterReceiver(keyReceivers);
            keyReceivers = null;
        }
        if (keyReceivers == null) {
            keyReceivers = new BroadcastReceiver() {
                @Override
                public synchronized void onReceive(Context context, final Intent intent) {

                    try {
                        if (intent == null || intent.getAction() == null)
                            return;
                        KeyEvent event = intent
                                .getParcelableExtra(Intent.EXTRA_KEY_EVENT);
                        if (event == null)
                            return;

                        keyAction = event.getAction();

                        if (event.getRepeatCount() != 0)
                            return;

                        String message = "Receiving key intent: " + intent.getAction() + " : "
                                + (keyAction == KeyEvent.ACTION_DOWN ? "DOWN" : "UP");
                        Log.v(TAG, message);
                        outputTextToConsole(message+"\n");
                    } catch (Exception e) {
                        Log.e(TAG, e.getMessage());
                        e.printStackTrace();
                    }
                }
            };
            getApplicationContext().registerReceiver(keyReceivers, requestFilter);
        }
    }
}
