/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.profilegprsmgrsample1;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Xml;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.ProfileManager;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener {
    private String profileName = "GPRSProfile-1";
    private ProfileManager profileManager = null;
    private EMDKManager emdkManager = null;
    private TextView statusTextView = null;
    private String APN = "";
    private String AccessPoint = "";
    private String UserName = "";
    private String Password = "";
    private int ReplaceExisting = 0;
    private int MakeDefault = 0;
    private String errorType = "";
    private String parmName = "";
    private String errorDescription = "";
    private String errorString = "";
    private Action action = Action.ADD_REPLACE;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903040);
        this.statusTextView = (TextView)this.findViewById(2130837522);
        this.addSetButtonListener();
        this.addsetOnCheckedChangeListener();
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode == EMDKResults.STATUS_CODE.SUCCESS) {
            // empty if block
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.profileManager != null) {
            this.profileManager = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2130968576, menu2);
        return true;
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
        this.statusTextView.setText((CharSequence)"Status: EMDK closed unexpectedly! Please close and restart the application.");
    }

    public void onOpened(EMDKManager emdkManager) {
        this.statusTextView.setText((CharSequence)"EMDK open success.");
        this.emdkManager = emdkManager;
        this.profileManager = (ProfileManager)emdkManager.getInstance(EMDKManager.FEATURE_TYPE.PROFILE);
    }

    private void addSetButtonListener() {
        Button setButton = (Button)this.findViewById(2130837510);
        setButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (MainActivity.this.readValues()) {
                    MainActivity.this.modifyProfile_XMLString();
                } else {
                    MainActivity.this.statusTextView.setText((CharSequence)"The APN Name and Access Point (applicable to Add/Replace only) fields cannot be empty.");
                }
            }
        });
    }

    private void addsetOnCheckedChangeListener() {
        RadioGroup radioGroup = (RadioGroup)this.findViewById(2130837517);
        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                EditText ap = (EditText)MainActivity.this.findViewById(2130837504);
                EditText user = (EditText)MainActivity.this.findViewById(2130837506);
                EditText pass = (EditText)MainActivity.this.findViewById(2130837505);
                CheckBox replace = (CheckBox)MainActivity.this.findViewById(2130837512);
                CheckBox make_default = (CheckBox)MainActivity.this.findViewById(2130837511);
                TextView apText = (TextView)MainActivity.this.findViewById(2130837521);
                TextView userText = (TextView)MainActivity.this.findViewById(2130837508);
                TextView passText = (TextView)MainActivity.this.findViewById(2130837507);
                if (2130837515 == checkedId) {
                    ap.setEnabled(true);
                    user.setEnabled(true);
                    pass.setEnabled(true);
                    replace.setEnabled(true);
                    make_default.setEnabled(true);
                    apText.setEnabled(true);
                    userText.setEnabled(true);
                    passText.setEnabled(true);
                } else {
                    ap.setEnabled(false);
                    user.setEnabled(false);
                    pass.setEnabled(false);
                    replace.setEnabled(false);
                    make_default.setEnabled(false);
                    apText.setEnabled(false);
                    userText.setEnabled(false);
                    passText.setEnabled(false);
                }
            }
        });
    }

    private boolean readValues() {
        EditText APNEditText = (EditText)this.findViewById(2130837513);
        this.APN = APNEditText.getText().toString().trim();
        if (this.APN == null || this.APN.length() == 0) {
            return false;
        }
        RadioGroup radiogroup = (RadioGroup)this.findViewById(2130837517);
        if (2130837515 == radiogroup.getCheckedRadioButtonId()) {
            this.action = Action.ADD_REPLACE;
            EditText APEditText = (EditText)this.findViewById(2130837504);
            this.AccessPoint = APEditText.getText().toString().trim();
            if (this.AccessPoint == null || this.AccessPoint.length() == 0) {
                return false;
            }
            EditText UserEditText = (EditText)this.findViewById(2130837506);
            this.UserName = UserEditText.getText().toString().trim();
            EditText PassEditText = (EditText)this.findViewById(2130837505);
            this.Password = PassEditText.getText().toString().trim();
            CheckBox cb = (CheckBox)this.findViewById(2130837512);
            this.ReplaceExisting = cb.isChecked() ? 1 : 0;
            cb = (CheckBox)this.findViewById(2130837511);
            this.MakeDefault = cb.isChecked() ? 1 : 0;
        } else {
            this.action = Action.REMOVE;
        }
        return true;
    }

    private void modifyProfile_XMLString() {
        this.statusTextView.setText((CharSequence)"");
        this.errorType = "";
        this.parmName = "";
        this.errorDescription = "";
        this.errorString = "";
        String[] modifyData = new String[]{"<?xml version=\"1.0\" encoding=\"utf-8\"?><characteristic type=\"Profile\"><parm name=\"ProfileName\" value=\"GPRSProfile-1\"/><characteristic type=\"GprsMgr\" version=\"0.2\"><parm name=\"GprsAction\" value=\"" + this.action.getValue() + "\"/>"};
        modifyData[0] = this.action == Action.ADD_REPLACE ? modifyData[0] + "<parm name=\"GprsCarrier\" value=\"0\"/><characteristic type=\"gprs-details\"><parm name=\"ApnName\" value=\"" + this.APN + "\"/><parm name=\"ReplaceIfExisting\" value=\"" + this.ReplaceExisting + "\"/><parm name=\"MakeDefault\" value=\"" + this.MakeDefault + "\"/></characteristic><characteristic type=\"custom-details\"><parm name=\"CustomAccessPoint\" value=\"" + this.AccessPoint + "\"/><parm name=\"CustomUserName\" value=\"" + this.UserName + "\"/><parm name=\"CustomPassword\" value=\"" + this.Password + "\"/></characteristic>" : modifyData[0] + "<characteristic type=\"gprs-details\"><parm name=\"ApnName\" value=\"" + this.APN + "\"/></characteristic>";
        modifyData[0] = modifyData[0] + "</characteristic></characteristic>";
        new ProcessProfileTask().execute(new String[]{modifyData[0]});
    }

    public void parseXML(XmlPullParser myParser) {
        try {
            int event = myParser.getEventType();
            while (event != 1) {
                String name = myParser.getName();
                switch (event) {
                    case 2: {
                        if (name.equals("parm-error")) {
                            this.parmName = myParser.getAttributeValue(null, "name");
                            this.errorDescription = myParser.getAttributeValue(null, "desc");
                            this.errorString = " (Name: " + this.parmName + ", Error Description: " + this.errorDescription + ")";
                            return;
                        }
                        if (!name.equals("characteristic-error")) break;
                        this.errorType = myParser.getAttributeValue(null, "type");
                        this.errorDescription = myParser.getAttributeValue(null, "desc");
                        this.errorString = " (Type: " + this.errorType + ", Error Description: " + this.errorDescription + ")";
                        return;
                    }
                }
                event = myParser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum Action {
        ADD_REPLACE(1),
        REMOVE(2);

        private int value;

        private Action(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    private class ProcessProfileTask
    extends AsyncTask<String, Void, EMDKResults> {
        private ProcessProfileTask() {
        }

        protected EMDKResults doInBackground(String ... params) {
            EMDKResults results = MainActivity.this.profileManager.processProfile(MainActivity.this.profileName, ProfileManager.PROFILE_FLAG.SET, params);
            return results;
        }

        protected void onPostExecute(EMDKResults results) {
            super.onPostExecute((Object)results);
            String resultString = "";
            if (results.statusCode == EMDKResults.STATUS_CODE.CHECK_XML) {
                String statusXMLResponse = results.getStatusString();
                try {
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput((Reader)new StringReader(statusXMLResponse));
                    MainActivity.this.parseXML(parser);
                    resultString = TextUtils.isEmpty((CharSequence)MainActivity.this.parmName) && TextUtils.isEmpty((CharSequence)MainActivity.this.errorType) && TextUtils.isEmpty((CharSequence)MainActivity.this.errorDescription) ? "Profile update success." : "Profile update failed." + MainActivity.this.errorString;
                }
                catch (XmlPullParserException e) {
                    resultString = e.getMessage();
                }
            }
            MainActivity.this.statusTextView.setText((CharSequence)resultString);
        }
    }
}

