/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.serialcommsample1;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.serialcomm.SerialComm;
import com.symbol.emdk.serialcomm.SerialCommException;
import com.symbol.emdk.serialcomm.SerialCommManager;
import com.symbol.emdk.serialcomm.SerialCommResults;
import com.symbol.emdk.serialcomm.SerialPortInfo;
import java.util.HashMap;
import java.util.List;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener {
    private String TAG = MainActivity.class.getSimpleName();
    private EMDKManager emdkManager = null;
    private SerialComm serialCommPort = null;
    private SerialCommManager serialCommManager = null;
    private EditText txtDataToSend = null;
    private TextView txtStatus = null;
    private Button btnRead = null;
    private Button btnWrite = null;
    private Spinner spinnerPorts = null;
    public HashMap<String, SerialPortInfo> supportedPorts = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903040);
        this.txtDataToSend = (EditText)this.findViewById(2130837515);
        this.txtDataToSend.setText((CharSequence)"Serial Communication Write Data Testing.");
        this.spinnerPorts = (Spinner)this.findViewById(2130837514);
        this.btnWrite = (Button)this.findViewById(2130837507);
        this.btnRead = (Button)this.findViewById(2130837506);
        this.txtStatus = (TextView)this.findViewById(2130837517);
        this.txtStatus.setText((CharSequence)"");
        this.txtStatus.requestFocus();
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) {
            new AsyncStatusUpdate().execute(new String[]{"EMDKManager object request failed!"});
        }
        new AsyncUiControlUpdate().execute(new Boolean[]{false});
    }

    public void onOpened(EMDKManager emdkManager) {
        this.emdkManager = emdkManager;
        Log.d((String)this.TAG, (String)"EMDK opened");
        try {
            this.serialCommManager = (SerialCommManager)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.SERIALCOMM_EX);
            if (this.serialCommManager != null) {
                this.populatePorts();
            } else {
                new AsyncStatusUpdate().execute(new String[]{EMDKManager.FEATURE_TYPE.SERIALCOMM_EX.toString() + " Feature not supported."});
            }
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)e.getMessage());
            new AsyncStatusUpdate().execute(new String[]{e.getMessage()});
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2130968576, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 2130837504) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.deinitSerialComm();
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    protected void onPause() {
        super.onPause();
        this.deinitSerialComm();
        this.serialCommManager = null;
        this.supportedPorts = null;
        if (this.emdkManager != null) {
            this.emdkManager.release(EMDKManager.FEATURE_TYPE.SERIALCOMM_EX);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.emdkManager != null) {
            this.serialCommManager = (SerialCommManager)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.SERIALCOMM_EX);
            if (this.serialCommManager != null) {
                this.populatePorts();
                if (this.supportedPorts != null) {
                    this.initSerialComm();
                }
            }
        }
    }

    void populatePorts() {
        try {
            if (this.serialCommManager != null) {
                List serialPorts = this.serialCommManager.getSupportedPorts();
                if (serialPorts.size() > 0) {
                    this.supportedPorts = new HashMap();
                    Object[] ports = new String[serialPorts.size()];
                    int count = 0;
                    for (SerialPortInfo info : serialPorts) {
                        this.supportedPorts.put(info.getFriendlyName(), info);
                        ports[count] = info.getFriendlyName();
                        ++count;
                    }
                    this.spinnerPorts.setAdapter((SpinnerAdapter)new ArrayAdapter((Context)this, 0x1090009, ports));
                    this.spinnerPorts.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                        public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                            MainActivity.this.deinitSerialComm();
                            MainActivity.this.initSerialComm();
                        }

                        public void onNothingSelected(AdapterView<?> adapterView) {
                        }
                    });
                } else {
                    new AsyncStatusUpdate().execute(new String[]{"Failed to get available ports"});
                    Toast.makeText((Context)this, (CharSequence)"Failed to get available ports, serial communication may not be supported.", (int)1).show();
                    this.finish();
                }
            } else {
                new AsyncStatusUpdate().execute(new String[]{"SerialCommManager is null"});
            }
        }
        catch (Exception ex) {
            Log.d((String)this.TAG, (String)ex.getMessage());
            new AsyncStatusUpdate().execute(new String[]{ex.getMessage()});
        }
    }

    void initSerialComm() {
        new AsyncEnableSerialComm().execute(new SerialPortInfo[]{this.supportedPorts.get(this.spinnerPorts.getSelectedItem())});
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
        }
        new AsyncStatusUpdate().execute(new String[]{"EMDK closed unexpectedly! Please close and restart the application."});
    }

    public void btnReadOnClick(View arg) {
        new AsyncReadData().execute(new Void[0]);
    }

    public void btnWriteOnClick(View arg) {
        new AsyncUiControlUpdate().execute(new Boolean[]{false});
        try {
            String writeData = this.txtDataToSend.getText().toString();
            int bytesWritten = this.serialCommPort.write(writeData.getBytes(), writeData.getBytes().length);
            new AsyncStatusUpdate().execute(new String[]{"Bytes written: " + bytesWritten});
        }
        catch (SerialCommException e) {
            new AsyncStatusUpdate().execute(new String[]{"write: " + e.getResult().getDescription()});
        }
        catch (Exception e) {
            new AsyncStatusUpdate().execute(new String[]{"write: " + e.getMessage() + "\n"});
        }
        new AsyncUiControlUpdate().execute(new Boolean[]{true});
    }

    void deinitSerialComm() {
        if (this.serialCommPort != null) {
            try {
                this.serialCommPort.disable();
                this.serialCommPort = null;
            }
            catch (Exception ex) {
                Log.d((String)this.TAG, (String)("deinitSerialComm disable Exception: " + ex.getMessage()));
            }
        }
    }

    private class AsyncStatusUpdate
    extends AsyncTask<String, Void, String> {
        private AsyncStatusUpdate() {
        }

        protected String doInBackground(String ... params) {
            return params[0];
        }

        protected void onPostExecute(String result) {
            MainActivity.this.txtStatus.setText((CharSequence)result);
        }
    }

    private class AsyncUiControlUpdate
    extends AsyncTask<Boolean, Void, Boolean> {
        private AsyncUiControlUpdate() {
        }

        protected Boolean doInBackground(Boolean ... arg0) {
            return arg0[0];
        }

        protected void onPostExecute(Boolean bEnable) {
            MainActivity.this.btnRead.setEnabled(bEnable.booleanValue());
            MainActivity.this.btnWrite.setEnabled(bEnable.booleanValue());
            MainActivity.this.txtDataToSend.setEnabled(bEnable.booleanValue());
            MainActivity.this.spinnerPorts.setEnabled(bEnable.booleanValue());
        }
    }

    private class AsyncEnableSerialComm
    extends AsyncTask<SerialPortInfo, Void, SerialCommResults> {
        private AsyncEnableSerialComm() {
        }

        protected SerialCommResults doInBackground(SerialPortInfo ... params) {
            SerialCommResults returnvar = SerialCommResults.FAILURE;
            try {
                MainActivity.this.serialCommPort = MainActivity.this.serialCommManager.getPort(params[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (MainActivity.this.serialCommPort != null) {
                try {
                    MainActivity.this.serialCommPort.enable();
                    returnvar = SerialCommResults.SUCCESS;
                }
                catch (SerialCommException e) {
                    Log.d((String)MainActivity.this.TAG, (String)e.getMessage());
                    e.printStackTrace();
                    returnvar = e.getResult();
                }
            }
            return returnvar;
        }

        protected void onPostExecute(SerialCommResults result) {
            super.onPostExecute((Object)result);
            if (result == SerialCommResults.SUCCESS) {
                new AsyncStatusUpdate().execute(new String[]{"Serial comm channel enabled: (" + MainActivity.this.spinnerPorts.getSelectedItem().toString() + ")"});
                MainActivity.this.txtDataToSend.setText((CharSequence)("Serial Communication Write Data Testing " + MainActivity.this.spinnerPorts.getSelectedItem().toString() + "."));
                new AsyncUiControlUpdate().execute(new Boolean[]{true});
            } else {
                new AsyncStatusUpdate().execute(new String[]{result.getDescription()});
                new AsyncUiControlUpdate().execute(new Boolean[]{false});
            }
        }
    }

    private class AsyncReadData
    extends AsyncTask<Void, Void, String> {
        private AsyncReadData() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            new AsyncUiControlUpdate().execute(new Boolean[]{false});
            new AsyncStatusUpdate().execute(new String[]{"Reading.."});
        }

        protected String doInBackground(Void ... params) {
            String statusText = "";
            try {
                byte[] readBuffer = MainActivity.this.serialCommPort.read(10000);
                if (readBuffer != null) {
                    String tempString = new String(readBuffer);
                    statusText = "Data Read:\n" + tempString;
                } else {
                    statusText = "No Data Available";
                }
            }
            catch (SerialCommException e) {
                statusText = "read:" + e.getResult().getDescription();
            }
            catch (Exception e) {
                statusText = "read:" + e.getMessage();
            }
            return statusText;
        }

        protected void onPostExecute(String statusText) {
            super.onPostExecute((Object)statusText);
            new AsyncUiControlUpdate().execute(new Boolean[]{true});
            new AsyncStatusUpdate().execute(new String[]{statusText});
        }
    }
}

