/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.barcodesample1;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.Html;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.ScanDataCollection;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.ScannerException;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.barcode.StatusData;
import java.util.ArrayList;
import java.util.List;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener,
Scanner.DataListener,
Scanner.StatusListener,
BarcodeManager.ScannerConnectionListener,
CompoundButton.OnCheckedChangeListener {
    private EMDKManager emdkManager = null;
    private BarcodeManager barcodeManager = null;
    private Scanner scanner = null;
    private List<ScannerInfo> scannerInfoList = null;
    private TextView textViewData = null;
    private TextView textViewStatus = null;
    private CheckBox checkBoxEAN8 = null;
    private CheckBox checkBoxEAN13 = null;
    private CheckBox checkBoxCode39 = null;
    private CheckBox checkBoxCode128 = null;
    private Spinner spinnerScannerDevices = null;
    private int scannerIndex = 0;
    private int defaultIndex = 0;
    private int dataLength = 0;
    private String statusString = "";
    private boolean applyScannerConfiguration = false;
    private boolean scanButtonPressed = false;
    private boolean extScannerDisconnected = false;
    private final Object lock = new Object();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.scannerInfoList = new ArrayList<ScannerInfo>();
        this.setRequestedOrientation(5);
        this.setDefaultOrientation();
        this.textViewData = (TextView)this.findViewById(2130903068);
        this.textViewStatus = (TextView)this.findViewById(2130903072);
        this.checkBoxEAN8 = (CheckBox)this.findViewById(2130903048);
        this.checkBoxEAN13 = (CheckBox)this.findViewById(2130903047);
        this.checkBoxCode39 = (CheckBox)this.findViewById(2130903046);
        this.checkBoxCode128 = (CheckBox)this.findViewById(2130903045);
        this.spinnerScannerDevices = (Spinner)this.findViewById(2130903062);
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) {
            this.updateStatus("EMDKManager object request failed!");
            return;
        }
        this.updateStatus("EMDKManager object initialization is in progress.......");
        this.checkBoxEAN8.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.checkBoxEAN13.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.checkBoxCode39.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.checkBoxCode128.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.addSpinnerScannerDevicesListener();
        this.textViewData.setSelected(true);
        this.textViewData.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
    }

    public void onOpened(EMDKManager emdkManager) {
        this.updateStatus("EMDK open success!");
        this.emdkManager = emdkManager;
        this.initBarcodeManager();
        this.enumerateScannerDevices();
        this.spinnerScannerDevices.setSelection(this.defaultIndex);
    }

    protected void onResume() {
        super.onResume();
        if (this.emdkManager != null) {
            this.initBarcodeManager();
            this.enumerateScannerDevices();
            this.spinnerScannerDevices.setSelection(this.scannerIndex);
            this.initScanner();
        }
    }

    protected void onPause() {
        super.onPause();
        this.deInitScanner();
        this.deInitBarcodeManager();
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
        this.updateStatus("EMDK closed unexpectedly! Please close and restart the application.");
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public void onData(ScanDataCollection scanDataCollection) {
        if (scanDataCollection != null && scanDataCollection.getResult() == ScannerResults.SUCCESS) {
            ArrayList scanData = scanDataCollection.getScanData();
            for (ScanDataCollection.ScanData data : scanData) {
                this.updateData("<font color='gray'>" + data.getLabelType() + "</font> : " + data.getData());
            }
        }
    }

    public void onStatus(StatusData statusData) {
        StatusData.ScannerStates state = statusData.getState();
        switch (state) {
            case IDLE: {
                this.statusString = statusData.getFriendlyName() + " is enabled and idle...";
                this.updateStatus(this.statusString);
                if (this.scanButtonPressed) {
                    this.scanner.triggerType = Scanner.TriggerType.SOFT_ONCE;
                    this.scanButtonPressed = false;
                } else {
                    this.scanner.triggerType = Scanner.TriggerType.HARD;
                }
                if (this.applyScannerConfiguration) {
                    this.setDecoders();
                    this.applyScannerConfiguration = false;
                }
                if (this.scanner.isReadPending() || this.extScannerDisconnected) break;
                try {
                    this.scanner.read();
                }
                catch (ScannerException e) {
                    this.updateStatus(e.getMessage());
                }
                break;
            }
            case WAITING: {
                this.statusString = "Scanner is waiting for trigger press...";
                this.updateStatus(this.statusString);
                break;
            }
            case SCANNING: {
                this.statusString = "Scanning...";
                this.updateStatus(this.statusString);
                break;
            }
            case DISABLED: {
                this.statusString = statusData.getFriendlyName() + " is disabled.";
                this.updateStatus(this.statusString);
                break;
            }
            case ERROR: {
                this.statusString = "An error has occurred.";
                this.updateStatus(this.statusString);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionChange(ScannerInfo scannerInfo, BarcodeManager.ConnectionState connectionState) {
        String scannerName = "";
        String statusExtScanner = connectionState.toString();
        String scannerNameExtScanner = scannerInfo.getFriendlyName();
        if (this.scannerInfoList.size() != 0) {
            scannerName = this.scannerInfoList.get(this.scannerIndex).getFriendlyName();
        }
        if (scannerName.equalsIgnoreCase(scannerNameExtScanner)) {
            switch (connectionState) {
                case CONNECTED: {
                    this.scanButtonPressed = false;
                    Object object = this.lock;
                    synchronized (object) {
                        this.initScanner();
                        this.extScannerDisconnected = false;
                        break;
                    }
                }
                case DISCONNECTED: {
                    this.extScannerDisconnected = true;
                    Object object = this.lock;
                    synchronized (object) {
                        this.deInitScanner();
                        break;
                    }
                }
            }
            String status = scannerNameExtScanner + ":" + statusExtScanner;
            this.updateStatus(status);
        } else {
            this.extScannerDisconnected = false;
            String status = this.statusString + " " + scannerNameExtScanner + ":" + statusExtScanner;
            this.updateStatus(status);
        }
    }

    private void initScanner() {
        if (this.scanner == null) {
            if (this.scannerInfoList != null && this.scannerInfoList.size() != 0) {
                if (this.barcodeManager != null) {
                    this.scanner = this.barcodeManager.getDevice(this.scannerInfoList.get(this.scannerIndex));
                }
            } else {
                this.updateStatus("Failed to get the specified scanner device! Please close and restart the application.");
                return;
            }
            if (this.scanner != null) {
                this.scanner.addDataListener((Scanner.DataListener)this);
                this.scanner.addStatusListener((Scanner.StatusListener)this);
                try {
                    this.applyScannerConfiguration = true;
                    this.scanner.enable();
                }
                catch (ScannerException e) {
                    this.applyScannerConfiguration = false;
                    this.updateStatus(e.getMessage());
                    this.deInitScanner();
                }
            } else {
                this.updateStatus("Failed to initialize the scanner device.");
            }
        }
    }

    private void deInitScanner() {
        if (this.scanner != null) {
            try {
                this.scanner.release();
            }
            catch (Exception e) {
                this.updateStatus(e.getMessage());
            }
            this.scanner = null;
        }
    }

    private void initBarcodeManager() {
        this.barcodeManager = (BarcodeManager)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.BARCODE);
        if (this.barcodeManager != null) {
            this.barcodeManager.addConnectionListener((BarcodeManager.ScannerConnectionListener)this);
        } else {
            Toast.makeText((Context)this, (CharSequence)"Barcode scanning is not supported.", (int)1).show();
            this.finish();
        }
    }

    private void deInitBarcodeManager() {
        if (this.emdkManager != null) {
            this.emdkManager.release(EMDKManager.FEATURE_TYPE.BARCODE);
        }
    }

    private void addSpinnerScannerDevicesListener() {
        this.spinnerScannerDevices.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View arg1, int position, long arg3) {
                if (MainActivity.this.scannerIndex != position || MainActivity.this.scanner == null) {
                    MainActivity.this.scannerIndex = position;
                    MainActivity.this.scanButtonPressed = false;
                    MainActivity.this.extScannerDisconnected = false;
                    MainActivity.this.deInitScanner();
                    MainActivity.this.initScanner();
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void enumerateScannerDevices() {
        if (this.barcodeManager != null) {
            ArrayList<String> friendlyNameList = new ArrayList<String>();
            int spinnerIndex = 0;
            this.scannerInfoList = this.barcodeManager.getSupportedDevicesInfo();
            if (this.scannerInfoList != null && this.scannerInfoList.size() != 0) {
                for (ScannerInfo scnInfo : this.scannerInfoList) {
                    friendlyNameList.add(scnInfo.getFriendlyName());
                    if (scnInfo.isDefaultScanner()) {
                        this.defaultIndex = spinnerIndex;
                    }
                    ++spinnerIndex;
                }
            } else {
                this.updateStatus("Failed to get the list of supported scanner devices! Please close and restart the application.");
            }
            ArrayAdapter spinnerAdapter = new ArrayAdapter((Context)this, 17367048, friendlyNameList);
            spinnerAdapter.setDropDownViewResource(0x1090009);
            this.spinnerScannerDevices.setAdapter((SpinnerAdapter)spinnerAdapter);
        }
    }

    private void setDecoders() {
        if (this.scanner != null) {
            try {
                Bundle requiredParams = new Bundle();
                requiredParams.putString("decoder_ean8", "");
                requiredParams.putString("decoder_ean13", "");
                requiredParams.putString("decoder_code39", "");
                requiredParams.putString("decoder_code128", "");
                Bundle params = this.scanner.getParams(requiredParams);
                if (params.containsKey("decoder_ean8")) {
                    params.putString("decoder_ean8", String.valueOf(this.checkBoxEAN8.isChecked()));
                }
                if (params.containsKey("decoder_ean13")) {
                    params.putString("decoder_ean13", String.valueOf(this.checkBoxEAN13.isChecked()));
                }
                if (params.containsKey("decoder_code39")) {
                    params.putString("decoder_code39", String.valueOf(this.checkBoxCode39.isChecked()));
                }
                if (params.containsKey("decoder_code128")) {
                    params.putString("decoder_code128", String.valueOf(this.checkBoxCode128.isChecked()));
                }
                this.scanner.setParams(params);
            }
            catch (ScannerException e) {
                this.updateStatus(e.getMessage());
            }
        }
    }

    public void softScan(View view) {
        this.scanButtonPressed = true;
        this.cancelRead();
    }

    private void cancelRead() {
        if (this.scanner != null && this.scanner.isReadPending()) {
            try {
                this.scanner.cancelRead();
            }
            catch (ScannerException e) {
                this.updateStatus(e.getMessage());
            }
        }
    }

    private void updateStatus(final String status) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.textViewStatus.setText((CharSequence)("" + status));
            }
        });
    }

    private void updateData(final String result) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (result != null) {
                    if (MainActivity.this.dataLength++ > 100) {
                        MainActivity.this.textViewData.setText((CharSequence)"");
                        MainActivity.this.dataLength = 0;
                    }
                    MainActivity.this.textViewData.append((CharSequence)Html.fromHtml((String)result));
                    MainActivity.this.textViewData.append((CharSequence)"\n");
                    MainActivity.this.findViewById(2130903061).post(new Runnable(){

                        @Override
                        public void run() {
                            ((ScrollView)MainActivity.this.findViewById(2130903061)).fullScroll(130);
                        }
                    });
                }
            }
        });
    }

    private void setDefaultOrientation() {
        DisplayMetrics dm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if (width > height) {
            this.setContentView(2130968577);
        } else {
            this.setContentView(2130968576);
        }
    }

    public void onCheckedChanged(CompoundButton arg0, boolean arg1) {
        this.applyScannerConfiguration = true;
        this.cancelRead();
    }
}

