/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.multibarcodesample1;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.ScanDataCollection;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.ScannerConfig;
import com.symbol.emdk.barcode.ScannerException;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.barcode.StatusData;
import java.util.ArrayList;
import java.util.List;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener,
Scanner.DataListener,
Scanner.StatusListener,
BarcodeManager.ScannerConnectionListener,
CompoundButton.OnCheckedChangeListener {
    private EMDKManager emdkManager = null;
    private BarcodeManager barcodeManager = null;
    private Scanner scanner = null;
    private TextView textViewStatus = null;
    private Spinner spinnerScannerDevices = null;
    private Spinner spinnerTriggers = null;
    private EditText barcodeCount = null;
    private CheckBox instantReporting = null;
    private TextView resultTitle = null;
    private TableLayout tableLayout = null;
    private List<ScannerInfo> deviceList = new ArrayList<ScannerInfo>();
    private String statusString = "";
    private int scannerIndex = 0;
    private int defaultIndex = 0;
    private int triggerIndex = 1;
    private boolean headerRowAdded = false;
    TextView keyText;
    TextView valueText;
    TableRow.LayoutParams llp = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131034112);
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) {
            this.textViewStatus.setText((CharSequence)"Status: EMDKManager object request failed!");
        }
        this.textViewStatus = (TextView)this.findViewById(2130968589);
        this.spinnerScannerDevices = (Spinner)this.findViewById(2130968581);
        this.spinnerTriggers = (Spinner)this.findViewById(2130968582);
        this.barcodeCount = (EditText)this.findViewById(2130968577);
        this.instantReporting = (CheckBox)this.findViewById(2130968579);
        this.resultTitle = (TextView)this.findViewById(2130968590);
        this.tableLayout = (TableLayout)this.findViewById(2130968583);
        this.addSpinnerScannerDevicesListener();
        this.addSpinnerTriggersListener();
        this.addBarcodeCountListener();
        this.addStartScanButtonListener();
        this.instantReporting.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.deInitScanner();
        if (this.barcodeManager != null) {
            this.barcodeManager.removeConnectionListener((BarcodeManager.ScannerConnectionListener)this);
            this.barcodeManager = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131099648, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 2130968576) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onOpened(EMDKManager emdkManager) {
        this.textViewStatus.setText((CharSequence)"Status: EMDK open success!");
        this.emdkManager = emdkManager;
        this.barcodeManager = (BarcodeManager)emdkManager.getInstance(EMDKManager.FEATURE_TYPE.BARCODE);
        if (this.barcodeManager != null) {
            this.barcodeManager.addConnectionListener((BarcodeManager.ScannerConnectionListener)this);
        }
        this.enumerateScannerDevices();
        this.spinnerScannerDevices.setSelection(this.defaultIndex);
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            if (this.barcodeManager != null) {
                this.barcodeManager.removeConnectionListener((BarcodeManager.ScannerConnectionListener)this);
                this.barcodeManager = null;
            }
            this.emdkManager.release();
            this.emdkManager = null;
        }
        this.textViewStatus.setText((CharSequence)"Status: EMDK closed unexpectedly! Please close and restart the application.");
    }

    public void onData(ScanDataCollection scanDataCollection) {
        String outString = "\nMultiBarcode Data: \n";
        ArrayList<TableRow> rows = null;
        if (scanDataCollection != null && scanDataCollection.getResult() == ScannerResults.SUCCESS && scanDataCollection.getScanData() != null) {
            rows = new ArrayList<TableRow>();
            if (!this.headerRowAdded) {
                TableRow headerRow = new TableRow((Context)this);
                headerRow.setBackgroundColor(-16777216);
                headerRow.setPadding(1, 1, 1, 1);
                this.llp = new TableRow.LayoutParams(-1, -1);
                this.llp.setMargins(0, 0, 2, 0);
                this.keyText = new TextView((Context)this);
                this.keyText.setPadding(5, 5, 5, 5);
                this.keyText.setLayoutParams((ViewGroup.LayoutParams)this.llp);
                this.keyText.setBackgroundColor(-1);
                this.keyText.setText((CharSequence)"Type");
                headerRow.addView((View)this.keyText);
                this.valueText = new TextView((Context)this);
                this.valueText.setPadding(5, 5, 5, 5);
                this.valueText.setBackgroundColor(-1);
                this.valueText.setText((CharSequence)"Value");
                headerRow.addView((View)this.valueText);
                rows.add(headerRow);
                this.headerRowAdded = true;
            }
            for (ScanDataCollection.ScanData data : scanDataCollection.getScanData()) {
                TableRow valueRow = new TableRow((Context)this);
                valueRow.setBackgroundColor(-16777216);
                valueRow.setPadding(1, 1, 1, 1);
                String mKey = data.getLabelType().toString();
                String mValue = data.getData();
                this.keyText = new TextView((Context)this);
                this.keyText.setPadding(5, 5, 5, 5);
                this.keyText.setLayoutParams((ViewGroup.LayoutParams)this.llp);
                this.keyText.setBackgroundColor(-1);
                this.keyText.setText((CharSequence)mKey);
                valueRow.addView((View)this.keyText);
                this.valueText = new TextView((Context)this);
                this.valueText.setPadding(5, 5, 5, 5);
                this.valueText.setBackgroundColor(-1);
                this.valueText.setLayoutParams((ViewGroup.LayoutParams)this.llp);
                this.valueText.setText((CharSequence)mValue);
                valueRow.addView((View)this.valueText);
                rows.add(valueRow);
            }
            new AsyncMultiDataUpdate(rows).execute(new String[]{"MultiBarcode Scanning result"});
        }
    }

    public void onStatus(StatusData statusData) {
        StatusData.ScannerStates state = statusData.getState();
        new AsyncStatusUpdate().execute(new String[]{state.toString()});
    }

    private void addSpinnerScannerDevicesListener() {
        this.spinnerScannerDevices.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View arg1, int position, long arg3) {
                if (MainActivity.this.scannerIndex != position || MainActivity.this.scanner == null) {
                    MainActivity.this.scannerIndex = position;
                    MainActivity.this.deInitScanner();
                    MainActivity.this.initScanner();
                    MainActivity.this.setTrigger();
                    MainActivity.this.setConfig();
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void addSpinnerTriggersListener() {
        this.spinnerTriggers.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> arg0, View arg1, int position, long arg3) {
                MainActivity.this.triggerIndex = position;
                MainActivity.this.setTrigger();
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void addStartScanButtonListener() {
        Button btnStartScan = (Button)this.findViewById(2130968578);
        btnStartScan.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                MainActivity.this.startScan();
            }
        });
    }

    private void addBarcodeCountListener() {
        this.barcodeCount.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int aft) {
            }

            public void afterTextChanged(Editable s) {
                MainActivity.this.setConfig();
            }
        });
    }

    private void enumerateScannerDevices() {
        if (this.barcodeManager != null) {
            ArrayList<String> friendlyNameList = new ArrayList<String>();
            int spinnerIndex = 0;
            this.deviceList = this.barcodeManager.getSupportedDevicesInfo();
            if (this.deviceList != null && this.deviceList.size() != 0) {
                for (ScannerInfo scnInfo : this.deviceList) {
                    friendlyNameList.add(scnInfo.getFriendlyName());
                    if (scnInfo.isDefaultScanner()) {
                        this.defaultIndex = spinnerIndex;
                    }
                    ++spinnerIndex;
                }
            } else {
                this.textViewStatus.setText((CharSequence)"Status: Failed to get the list of supported scanner devices! Please close and restart the application.");
            }
            ArrayAdapter spinnerAdapter = new ArrayAdapter((Context)this, 17367048, friendlyNameList);
            spinnerAdapter.setDropDownViewResource(0x1090009);
            this.spinnerScannerDevices.setAdapter((SpinnerAdapter)spinnerAdapter);
        }
    }

    private void setTrigger() {
        if (this.scanner == null) {
            this.initScanner();
        }
        if (this.scanner != null) {
            switch (this.triggerIndex) {
                case 0: {
                    this.scanner.triggerType = Scanner.TriggerType.HARD;
                    break;
                }
                case 1: {
                    this.scanner.triggerType = Scanner.TriggerType.SOFT_ALWAYS;
                }
            }
        }
    }

    private void setConfig() {
        if (this.scanner == null) {
            this.initScanner();
        }
        if (this.scanner != null && this.scanner.isEnabled()) {
            try {
                ScannerConfig config = this.scanner.getConfig();
                config.readerParams.readerSpecific.imagerSpecific.scanMode = ScannerConfig.ScanMode.MULTI_BARCODE;
                config.readerParams.readerSpecific.cameraSpecific.scanMode = ScannerConfig.ScanMode.MULTI_BARCODE;
                if (config.isParamSupported("config.multiBarcodeParams.instantReporting")) {
                    config.multiBarcodeParams.instantReporting = this.instantReporting.isChecked();
                }
                if (this.barcodeCount.getText().toString().length() > 0) {
                    config.multiBarcodeParams.barcodeCount = Integer.parseInt(this.barcodeCount.getText().toString());
                }
                this.scanner.setConfig(config);
                this.textViewStatus.setText((CharSequence)"Status: Configuration changed!");
            }
            catch (ScannerException e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        }
    }

    private void startScan() {
        if (this.scanner == null) {
            this.initScanner();
        }
        if (this.scanner != null) {
            try {
                if (this.scanner.isEnabled()) {
                    this.scanner.read();
                } else {
                    this.textViewStatus.setText((CharSequence)"Status: Scanner is not enabled");
                }
            }
            catch (ScannerException e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        }
    }

    private void initScanner() {
        if (this.scanner == null) {
            if (this.deviceList == null || this.deviceList.size() == 0) {
                this.textViewStatus.setText((CharSequence)"Status: Failed to get the specified scanner device! Please close and restart the application.");
                return;
            }
            this.scanner = this.barcodeManager.getDevice(this.deviceList.get(this.scannerIndex));
            if (this.scanner != null) {
                this.scanner.addDataListener((Scanner.DataListener)this);
                this.scanner.addStatusListener((Scanner.StatusListener)this);
                try {
                    this.scanner.enable();
                    this.checkMultiBarcodeSupport();
                }
                catch (ScannerException e) {
                    this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
                }
            } else {
                this.textViewStatus.setText((CharSequence)"Status: Failed to initialize the scanner device.");
            }
        }
    }

    private void checkMultiBarcodeSupport() {
        if (this.scanner != null) {
            try {
                ScannerConfig config = this.scanner.getConfig();
                if (!config.isParamSupported("config.multiBarcodeParams.barcodeCount")) {
                    new AsyncMultiDataUpdate(new ArrayList<TableRow>()).execute(new String[]{"NOTE: Multibarcode feature is unsupported in the selected scanner"});
                } else {
                    new AsyncMultiDataUpdate(new ArrayList<TableRow>()).execute(new String[]{""});
                }
            }
            catch (Exception e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        }
    }

    private void deInitScanner() {
        if (this.scanner != null) {
            try {
                this.scanner.cancelRead();
                this.scanner.disable();
            }
            catch (Exception e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            try {
                this.scanner.removeDataListener((Scanner.DataListener)this);
                this.scanner.removeStatusListener((Scanner.StatusListener)this);
            }
            catch (Exception e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            try {
                this.scanner.release();
            }
            catch (Exception e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            this.scanner = null;
        }
    }

    private void cancelRead() {
        if (this.scanner != null && this.scanner.isReadPending()) {
            try {
                this.scanner.cancelRead();
            }
            catch (ScannerException e) {
                this.textViewStatus.setText((CharSequence)("Status " + e.getMessage()));
            }
        }
    }

    public void onCheckedChanged(CompoundButton arg0, boolean isChecked) {
        this.cancelRead();
        this.setConfig();
    }

    public void onConnectionChange(ScannerInfo scannerInfo, BarcodeManager.ConnectionState connectionState) {
        String scannerName = "";
        String statusExtScanner = connectionState.toString();
        String scannerNameExtScanner = scannerInfo.getFriendlyName();
        if (this.deviceList.size() != 0) {
            scannerName = this.deviceList.get(this.scannerIndex).getFriendlyName();
        }
        if (scannerName.equalsIgnoreCase(scannerNameExtScanner)) {
            switch (connectionState) {
                case CONNECTED: {
                    this.deInitScanner();
                    this.initScanner();
                    this.setTrigger();
                    this.setConfig();
                    break;
                }
                case DISCONNECTED: {
                    this.deInitScanner();
                }
            }
            String status = scannerNameExtScanner + ":" + statusExtScanner;
            new AsyncStatusUpdate().execute(new String[]{status});
        } else {
            String status = this.statusString + " " + scannerNameExtScanner + ":" + statusExtScanner;
            new AsyncStatusUpdate().execute(new String[]{status});
        }
    }

    private class AsyncMultiDataUpdate
    extends AsyncTask<String, Void, String> {
        private ArrayList<TableRow> rows;

        AsyncMultiDataUpdate(ArrayList<TableRow> rows) {
            this.rows = rows;
        }

        protected String doInBackground(String ... params) {
            return params[0];
        }

        protected void onPostExecute(String decodeType) {
            MainActivity.this.resultTitle.setText((CharSequence)decodeType);
            for (TableRow row : this.rows) {
                MainActivity.this.tableLayout.addView((View)row);
            }
        }
    }

    private class AsyncStatusUpdate
    extends AsyncTask<String, Void, String> {
        private AsyncStatusUpdate() {
        }

        protected String doInBackground(String ... params) {
            return params[0];
        }

        protected void onPostExecute(String result) {
            MainActivity.this.textViewStatus.setText((CharSequence)("Status: " + result));
        }
    }
}

