/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.personalshoppersample1;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.os.Bundle;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.Scroller;
import android.widget.TextView;
import android.widget.Toast;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.personalshopper.CradleException;
import com.symbol.emdk.personalshopper.CradleInfo;
import com.symbol.emdk.personalshopper.CradleLedFlashInfo;
import com.symbol.emdk.personalshopper.CradleResults;
import com.symbol.emdk.personalshopper.DiagnosticConfig;
import com.symbol.emdk.personalshopper.DiagnosticData;
import com.symbol.emdk.personalshopper.DiagnosticException;
import com.symbol.emdk.personalshopper.DiagnosticParamId;
import com.symbol.emdk.personalshopper.PersonalShopper;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener {
    private EMDKManager emdkManager = null;
    private PersonalShopper PsObject = null;
    boolean mLedsmooth = false;
    private TextView textViewStatus = null;
    private CheckBox mFCState = null;
    private CheckBox mFCSmooth = null;
    private Button btnCrdInfo = null;
    private Button btnSetCfgLeds = null;
    private Button btnUnlock = null;
    private Button btnFlashLeds = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130968576);
        this.textViewStatus = (TextView)this.findViewById(2130903044);
        this.mFCState = (CheckBox)this.findViewById(2130903040);
        this.mFCSmooth = (CheckBox)this.findViewById(2130903050);
        this.btnCrdInfo = (Button)this.findViewById(2130903041);
        this.btnSetCfgLeds = (Button)this.findViewById(2130903042);
        this.btnUnlock = (Button)this.findViewById(2130903045);
        this.btnFlashLeds = (Button)this.findViewById(2130903043);
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) {
            this.textViewStatus.setText((CharSequence)("Status: Failed in getEMDKManager::" + results.statusCode));
        } else {
            this.textViewStatus.setText((CharSequence)"Status: getEMDKManager Success");
        }
        this.addCrdInfoButtonListener();
        this.addbtnUnlockButtonListener();
        this.addFlashLedsButtonListener();
        this.addFCCheckboxListener();
        this.addDiagnosticButtonListener();
    }

    private void addDiagnosticButtonListener() {
        this.btnSetCfgLeds.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                MainActivity.this.getDiagnosticData();
            }
        });
    }

    private void getDiagnosticData() {
        DiagnosticData diagnosticData = null;
        DiagnosticParamId diagnosticparamID = new DiagnosticParamId();
        int paramId = 255;
        DiagnosticConfig diagnosticconfig = new DiagnosticConfig(200, 60);
        if (null != this.PsObject.diagnostic) {
            try {
                diagnosticData = this.PsObject.diagnostic.getDiagnosticData(paramId, diagnosticconfig);
            }
            catch (DiagnosticException e) {
                e.printStackTrace();
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            if (diagnosticData != null) {
                this.showMessageInDialog("Battery Capacity in Per : " + diagnosticData.batteryStateOfCharge + "\nBattery Capacity in mins: " + diagnosticData.batteryTimeToEmpty + "\nBattery SOH in Per: " + diagnosticData.batteryStateOfHealth + "\nBattery Charging Time Required mins: " + diagnosticData.batteryChargingTime + "\nBattery Replacement in days: " + diagnosticData.timeSinceBatteryReplaced + "\nTime since Last reboot  mins: " + diagnosticData.timeSinceReboot + "\nBattery Charging Time Elapsed mins: " + diagnosticData.batteryChargingTimeElapsed + "\nManufacturing Date: " + diagnosticData.batteryDateOfManufacture, "Diagnostic Info");
            }
        }
    }

    private void addSmoothCheckboxListener() throws CradleException {
        if (null != this.PsObject.cradle) {
            this.mLedsmooth = this.mFCSmooth.isChecked();
        }
    }

    private void addFCCheckboxListener() {
        this.mFCState.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (null != ((MainActivity)MainActivity.this).PsObject.cradle) {
                    try {
                        if (MainActivity.this.mFCState.isChecked()) {
                            ((MainActivity)MainActivity.this).PsObject.cradle.config.setFastChargingState(true);
                            if (((MainActivity)MainActivity.this).PsObject.cradle.config.getFastChargingState()) {
                                MainActivity.this.textViewStatus.setText((CharSequence)"Status: fast charge enabled");
                            } else {
                                MainActivity.this.textViewStatus.setText((CharSequence)"Status: fast charge enabling failed");
                            }
                        } else {
                            ((MainActivity)MainActivity.this).PsObject.cradle.config.setFastChargingState(false);
                            if (!((MainActivity)MainActivity.this).PsObject.cradle.config.getFastChargingState()) {
                                MainActivity.this.textViewStatus.setText((CharSequence)"Status: fast charge disabled");
                            } else {
                                MainActivity.this.textViewStatus.setText((CharSequence)"Status: fast charge disabling failed");
                            }
                        }
                    }
                    catch (CradleException e) {
                        e.printStackTrace();
                        MainActivity.this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
                    }
                }
            }
        });
    }

    public void showMessageInDialog(String txtStatus, String titleText) {
        View customDialogView = this.getLayoutInflater().inflate(2130968577, null);
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setCancelable(true).setNegativeButton((CharSequence)"Cancel", null).setView(customDialogView).create();
        TextView titleInfoText = (TextView)customDialogView.findViewById(2130903057);
        titleInfoText.setText((CharSequence)titleText);
        TextView infoStatusText = (TextView)customDialogView.findViewById(2130903056);
        infoStatusText.setScroller(new Scroller((Context)this));
        infoStatusText.setVerticalScrollBarEnabled(true);
        infoStatusText.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        infoStatusText.setText((CharSequence)txtStatus);
        alertDialog.show();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.PsObject != null) {
            this.disable();
            this.PsObject = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    void addFlashLedsButtonListener() {
        this.btnFlashLeds.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                MainActivity.this.flashLeds();
            }
        });
    }

    protected void flashLeds() {
        if (null != this.PsObject.cradle) {
            int onDuration = 2000;
            int offDuration = 1000;
            int flashCount = 5;
            try {
                this.addSmoothCheckboxListener();
                CradleLedFlashInfo ledFlashInfo = new CradleLedFlashInfo(onDuration, offDuration, this.mLedsmooth);
                CradleResults result = this.PsObject.cradle.flashLed(flashCount, ledFlashInfo);
                if (result == CradleResults.SUCCESS) {
                    this.textViewStatus.setText((CharSequence)"Status: Flashed LEDs ");
                } else {
                    this.textViewStatus.setText((CharSequence)("Status: Failed error " + result.getDescription()));
                }
            }
            catch (CradleException e) {
                e.printStackTrace();
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        }
    }

    private void addbtnUnlockButtonListener() {
        this.btnUnlock.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                MainActivity.this.unlock();
            }
        });
    }

    protected void unlock() {
        if (null != this.PsObject.cradle) {
            int onDuration = 500;
            int offDuration = 500;
            int unlockDuration = 15;
            try {
                this.addSmoothCheckboxListener();
                CradleLedFlashInfo ledFlashInfo = new CradleLedFlashInfo(onDuration, offDuration, this.mLedsmooth);
                CradleResults result = this.PsObject.cradle.unlock(unlockDuration, ledFlashInfo);
                if (result == CradleResults.SUCCESS) {
                    this.textViewStatus.setText((CharSequence)"Status: Unlocked");
                } else {
                    this.textViewStatus.setText((CharSequence)("Status: Failed error " + result.getDescription()));
                }
            }
            catch (CradleException e) {
                e.printStackTrace();
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        }
    }

    private void addCrdInfoButtonListener() {
        this.btnCrdInfo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                MainActivity.this.getCradleInfo();
            }
        });
    }

    protected void getCradleInfo() {
        CradleInfo cradleInfo = null;
        if (null != this.PsObject.cradle) {
            try {
                cradleInfo = this.PsObject.cradle.getCradleInfo();
            }
            catch (CradleException e) {
                e.printStackTrace();
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            if (cradleInfo != null) {
                Log.d((String)"PartNo", (String)("part No=" + cradleInfo.getPartNumber()));
                this.showMessageInDialog("FirmwareVersion: " + cradleInfo.getFirmwareVersion() + "\nDateOfManufacturing: " + cradleInfo.getDateOfManufacture() + "\nHardwareID: " + cradleInfo.getHardwareID() + "\nPartnumber: " + cradleInfo.getPartNumber() + "\nSerialNumber: " + cradleInfo.getSerialNumber(), "Cradle Info");
            }
        }
    }

    protected void disable() {
        try {
            if (null != this.PsObject.cradle) {
                this.PsObject.cradle.disable();
            }
        }
        catch (CradleException e) {
            e.printStackTrace();
            this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
        }
    }

    protected void enable() {
        try {
            if (null != this.PsObject.cradle) {
                this.PsObject.cradle.enable();
            }
        }
        catch (CradleException e) {
            e.printStackTrace();
            this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
        }
    }

    public void onOpened(EMDKManager emdkManager) {
        this.textViewStatus.setText((CharSequence)"Status: EMDK open success");
        this.emdkManager = emdkManager;
        try {
            this.PsObject = (PersonalShopper)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.PERSONALSHOPPER);
        }
        catch (Exception e) {
            this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
        }
        if (this.PsObject == null) {
            Toast.makeText((Context)this, (CharSequence)"PersonalShopper feature is NOT supported", (int)1).show();
            this.finish();
        } else {
            this.enable();
        }
    }

    private void disableUI() {
        this.mFCState.setEnabled(false);
        this.mFCSmooth.setEnabled(false);
        this.btnCrdInfo.setEnabled(false);
        this.btnSetCfgLeds.setEnabled(false);
        this.btnUnlock.setEnabled(false);
        this.btnFlashLeds.setEnabled(false);
    }
}

