/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.samsample1;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.Ndef;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcF;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.sam.SAM;
import com.symbol.emdk.sam.SAMException;
import com.symbol.emdk.sam.SAMManager;
import com.symbol.emdk.sam.SAMResults;
import com.symbol.emdk.sam.SAMType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MainActivity
extends AppCompatActivity
implements EMDKManager.EMDKListener {
    private static final String TAG = MainActivity.class.getCanonicalName();
    private EMDKManager emdkManager = null;
    private SAMManager samManager = null;
    boolean tagOperationInProgress = false;
    private Button btnGetSAMInfo = null;
    private HashMap<Integer, SAM> presetSAMList = new HashMap();
    private PendingIntent nfcIntent = null;
    private NfcAdapter nfcAdapter = null;
    private TextView txtStatus = null;
    private HashMap<SAMType, byte[]> getVersionAPDUs = new HashMap();
    private String detectedTag = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(5);
        this.setContentView(2131296284);
        this.txtStatus = (TextView)this.findViewById(2131165327);
        this.btnGetSAMInfo = (Button)this.findViewById(2131165218);
        this.getVersionAPDUs.put(SAMType.MIFARE, new byte[]{-128, 96, 0, 0, 0});
        this.getVersionAPDUs.put(SAMType.FELICA, new byte[]{-96, 0, 0, 0, 5, 0, 0, 0, -26, 0, 0});
        this.nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        if (this.nfcAdapter == null) {
            Toast.makeText((Context)this, (CharSequence)this.getString(2131427372), (int)0).show();
            this.finish();
            return;
        }
        this.nfcIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, ((Object)((Object)this)).getClass()).addFlags(0x20000000), (int)0);
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode == EMDKResults.STATUS_CODE.SUCCESS) {
            // empty if block
        }
    }

    public void onOpened(EMDKManager emdkManager) {
        this.emdkManager = emdkManager;
        this.initSAMManager();
        this.enumerateSAMsAndGetInfo();
    }

    void enableDisableUIComponents(final boolean enabled) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.btnGetSAMInfo.setEnabled(enabled);
            }
        });
    }

    private void enumerateSAMsAndGetInfo() {
        if (this.samManager != null) {
            this.txtStatus.setText((CharSequence)"");
            List samList = null;
            this.presetSAMList.clear();
            try {
                samList = this.samManager.enumerateSAMs();
            }
            catch (SAMException ex) {
                this.updateStatus(this.getString(2131427374) + " " + SAMResults.getErrorDescription((SAMResults)ex.getResult()));
                return;
            }
            if (samList != null && samList.size() != 0) {
                Iterator it = samList.iterator();
                int i = 0;
                while (it.hasNext()) {
                    SAM sam = (SAM)it.next();
                    this.presetSAMList.put(sam.getSamIndex(), sam);
                    this.getSAMInfo(sam);
                    ++i;
                }
            } else {
                this.enableDisableUIComponents(false);
                this.updateStatus(this.getString(2131427371));
            }
        }
    }

    public void onClickGetSAMInfo(View view) {
        this.enumerateSAMsAndGetInfo();
    }

    void updateStatus(String s) {
        String text = this.txtStatus.getText().toString();
        text = s + "\n\n" + text;
        if (text.length() > 1000) {
            text = s;
        }
        this.txtStatus.setText((CharSequence)text);
    }

    private static String getHexString(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (byte b : buf) {
            sb.append(String.format("0x%02x", b));
        }
        return sb.toString();
    }

    private void getSAMInfo(SAM sam) {
        String text = "";
        if (sam != null) {
            long tick = System.currentTimeMillis();
            try {
                if (!sam.isConnected()) {
                    sam.connect();
                    text = text + this.getString(2131427373) + " " + sam.getSamType() + "(Slot " + sam.getSamIndex() + ")\n";
                }
            }
            catch (SAMException ex) {
                this.updateStatus(this.getString(2131427369) + " " + SAMResults.getErrorDescription((SAMResults)ex.getResult()));
                return;
            }
            byte[] getVersionAPDU = this.getVersionAPDUs.get(sam.getSamType());
            byte[] response = null;
            try {
                text = text + this.getString(2131427378) + "\n";
                response = sam.transceive(getVersionAPDU, (short)0, false);
                text = response != null ? text + this.getString(2131427384) + " " + MainActivity.getHexString(response) + "\n" : text + this.getString(2131427385) + "\n";
            }
            catch (SAMException ex) {
                text = text + this.getString(2131427379) + " " + SAMResults.getErrorDescription((SAMResults)ex.getResult()) + "\n";
            }
            if (sam.isConnected()) {
                sam.disconnect();
                text = text + this.getString(2131427370) + " " + sam.getSamType() + "(" + sam.getSamIndex() + ")\n";
            }
            long timetook = System.currentTimeMillis() - tick;
            text = text + "Time taken to get version: " + timetook + "ms";
            this.updateStatus(text);
        }
    }

    void initSAMManager() {
        if (this.emdkManager != null) {
            this.samManager = (SAMManager)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.SAM);
        }
    }

    private void deinitSAMManager() {
        if (this.samManager != null) {
            this.emdkManager.release(EMDKManager.FEATURE_TYPE.SAM);
            this.samManager = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.deinitSAMManager();
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    protected void onResume() {
        super.onResume();
        this.initSAMManager();
        if (this.tagOperationInProgress) {
            this.tagOperationInProgress = false;
        }
        if (this.nfcAdapter != null) {
            this.nfcAdapter.enableForegroundDispatch((Activity)this, this.nfcIntent, null, null);
        }
    }

    protected void onPause() {
        super.onPause();
        this.deinitSAMManager();
        if (this.nfcAdapter != null) {
            this.nfcAdapter.disableForegroundDispatch((Activity)this);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.tagDetection(intent);
    }

    private void tagDetection(Intent intent) {
        this.tagOperationInProgress = true;
        if (this.samManager == null) {
            this.initSAMManager();
        }
        if ("android.nfc.action.NDEF_DISCOVERED".equals(intent.getAction()) || "android.nfc.action.TAG_DISCOVERED".equals(intent.getAction()) || "android.nfc.action.TECH_DISCOVERED".equals(intent.getAction())) {
            Tag lTag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
            SAM sam = null;
            SAMType samTypeForTag = null;
            samTypeForTag = this.findCompatibleSAM(lTag);
            String text = this.detectedTag + " " + this.getString(2131427376) + "\n";
            String compatibeSAMText = "";
            for (Map.Entry<Integer, SAM> entry : this.presetSAMList.entrySet()) {
                if (entry.getValue().getSamType() != samTypeForTag) continue;
                sam = entry.getValue();
                compatibeSAMText = compatibeSAMText + "\n\t" + sam.getSamType() + "(Slot " + sam.getSamIndex() + ")";
            }
            if (!this.presetSAMList.isEmpty()) {
                text = !compatibeSAMText.isEmpty() ? text + this.getString(2131427375) + " " + compatibeSAMText : text + this.getString(2131427377);
            }
            this.updateStatus(text);
        }
    }

    private SAMType findCompatibleSAM(Tag aTag) {
        SAMType lType = SAMType.UNKNOWN;
        this.detectedTag = "UNKNOWN";
        if (this.isNDEFTag(aTag)) {
            this.detectedTag = "NDEF";
        } else if (this.isFelicaTag(aTag)) {
            lType = SAMType.FELICA;
            this.detectedTag = "FELICA";
        } else if (this.isMIFAREClassicTag(aTag)) {
            lType = SAMType.MIFARE;
            this.detectedTag = "MIFARE_CLASSIC";
        } else if (this.isMIFARETag(aTag)) {
            lType = SAMType.MIFARE;
        }
        return lType;
    }

    private boolean isNDEFTag(Tag tag) {
        boolean returnVar = false;
        Ndef lNdefTag = Ndef.get((Tag)tag);
        if (lNdefTag != null) {
            returnVar = true;
        }
        return returnVar;
    }

    private boolean isFelicaTag(Tag tag) {
        boolean returnVar = false;
        NfcF mNfcF = NfcF.get((Tag)tag);
        if (mNfcF != null) {
            byte[] mPMm = mNfcF.getManufacturer();
            if (mPMm[0] == 1 && mPMm[1] == 32) {
                returnVar = true;
            } else if (mPMm[0] == 3 && mPMm[1] == 50) {
                returnVar = true;
            }
        }
        return returnVar;
    }

    private boolean isMIFAREClassicTag(Tag tag) {
        boolean returnVar = false;
        MifareClassic mifareClassic = MifareClassic.get((Tag)tag);
        if (mifareClassic != null) {
            returnVar = true;
        }
        return returnVar;
    }

    private boolean isMIFARETag(Tag tag) {
        boolean returnVar = false;
        if (Arrays.asList(tag.getTechList()).contains("android.nfc.tech.NfcA")) {
            NfcA nfc_A = NfcA.get((Tag)tag);
            byte[] atqa = nfc_A.getAtqa();
            Integer Sak = Integer.valueOf("" + nfc_A.getSak());
            switch (atqa[1]) {
                case 0: {
                    if (atqa[0] != 68 && atqa[0] != 66 && atqa[0] != 2 && atqa[0] != 4) break;
                    if (Sak == 32) {
                        returnVar = true;
                        this.detectedTag = "MIFARE_PLUS_SL3";
                        break;
                    }
                    if (Sak != 16) break;
                    returnVar = true;
                    this.detectedTag = "MIFARE_PLUS_SL2";
                    break;
                }
                case 3: {
                    if (atqa[0] != 68 && atqa[0] != 4) break;
                    returnVar = true;
                    this.detectedTag = "MIFARE_DESFIRE";
                }
            }
        }
        return returnVar;
    }
}

