/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.notificationsample1;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.notification.DeviceInfo;
import com.symbol.emdk.notification.DeviceType;
import com.symbol.emdk.notification.Notification;
import com.symbol.emdk.notification.NotificationDevice;
import com.symbol.emdk.notification.NotificationException;
import com.symbol.emdk.notification.NotificationManager;
import java.util.ArrayList;
import java.util.List;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener {
    private Spinner spnLEDPattern = null;
    private Spinner spnBeepPattern = null;
    private Spinner spnVibratePattern = null;
    private Spinner spnNotificationDevice = null;
    private Spinner spnLEDColor = null;
    private EMDKManager emdkManager = null;
    private NotificationManager notificationManager = null;
    private NotificationDevice notificationDevice = null;
    private DeviceInfo deviceInfo = null;
    private TextView txtStatus = null;
    private Button btnReConnenct = null;
    private List<DeviceInfo> deviceInfoList = null;
    private int deviceIndex = 0;
    private int defaultIndex = 0;
    static final String PATTERN1 = "4 Short";
    static final String PATTERN2 = "2 Long";
    static final String PATTERN3 = "1 Short";
    static final String PATTERN_NONE = "None";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(5);
        this.setDefaultOrientation();
        this.spnLEDPattern = (Spinner)this.findViewById(2130837523);
        this.spnBeepPattern = (Spinner)this.findViewById(2130837521);
        this.spnVibratePattern = (Spinner)this.findViewById(2130837525);
        this.spnNotificationDevice = (Spinner)this.findViewById(2130837524);
        this.spnLEDColor = (Spinner)this.findViewById(2130837522);
        this.txtStatus = (TextView)this.findViewById(2130837535);
        this.btnReConnenct = (Button)this.findViewById(2130837519);
        this.addSpinnerDevicesListener();
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) {
            this.txtStatus.setText((CharSequence)"Status: EMDKManager object request failed!");
        }
    }

    public void onOpened(EMDKManager emdkManager) {
        this.txtStatus.setText((CharSequence)"Status:  EMDK open success!");
        this.emdkManager = emdkManager;
        try {
            this.notificationManager = (NotificationManager)emdkManager.getInstance(EMDKManager.FEATURE_TYPE.NOTIFICATION);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.notificationManager != null) {
            this.enumerateNotificationDevices();
            this.spnNotificationDevice.setSelection(this.defaultIndex);
            this.initDevice();
            this.populateNotificationSpinners();
        }
    }

    private void setDefaultOrientation() {
        WindowManager windowManager = (WindowManager)this.getSystemService("window");
        int rotation = windowManager.getDefaultDisplay().getRotation();
        DisplayMetrics dm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = 0;
        int height = 0;
        switch (rotation) {
            case 0: 
            case 2: {
                width = dm.widthPixels;
                height = dm.heightPixels;
                break;
            }
            case 1: 
            case 3: {
                width = dm.heightPixels;
                height = dm.widthPixels;
                break;
            }
        }
        if (width > height) {
            this.setContentView(2130903041);
        } else {
            this.setContentView(2130903040);
        }
    }

    void populateNotificationSpinners() {
        ArrayList<String> lstBeepPattern = new ArrayList<String>();
        lstBeepPattern.add(PATTERN1);
        lstBeepPattern.add(PATTERN2);
        lstBeepPattern.add(PATTERN3);
        lstBeepPattern.add(PATTERN_NONE);
        ArrayAdapter beepAdapter = new ArrayAdapter((Context)this, 17367048, lstBeepPattern);
        beepAdapter.setDropDownViewResource(0x1090009);
        this.spnBeepPattern.setAdapter((SpinnerAdapter)beepAdapter);
        ArrayList<String> lstVibratePattern = new ArrayList<String>();
        if (this.deviceInfo.getDeviceType() == DeviceType.IMAGER) {
            lstVibratePattern.add(PATTERN1);
            lstVibratePattern.add(PATTERN2);
            this.btnReConnenct.setEnabled(true);
        } else {
            this.btnReConnenct.setEnabled(false);
        }
        lstVibratePattern.add(PATTERN3);
        lstVibratePattern.add(PATTERN_NONE);
        ArrayAdapter vibrateAdapter = new ArrayAdapter((Context)this, 17367048, lstVibratePattern);
        vibrateAdapter.setDropDownViewResource(0x1090009);
        this.spnVibratePattern.setAdapter((SpinnerAdapter)vibrateAdapter);
        ArrayList<String> lstColorPattern = new ArrayList<String>();
        lstColorPattern.add(PATTERN1);
        lstColorPattern.add(PATTERN2);
        lstColorPattern.add(PATTERN3);
        lstColorPattern.add(PATTERN_NONE);
        ArrayAdapter colorPatternAdapter = new ArrayAdapter((Context)this, 17367048, lstColorPattern);
        colorPatternAdapter.setDropDownViewResource(0x1090009);
        this.spnLEDPattern.setAdapter((SpinnerAdapter)colorPatternAdapter);
        ArrayList<String> lstLedColor = new ArrayList<String>();
        for (LedColor capType : LedColor.values()) {
            lstLedColor.add(capType.name());
        }
        ArrayAdapter colorAdapter = new ArrayAdapter((Context)this, 17367048, lstLedColor);
        colorAdapter.setDropDownViewResource(0x1090009);
        this.spnLEDColor.setAdapter((SpinnerAdapter)colorAdapter);
        if (this.deviceInfo.isLEDSupported()) {
            this.spnLEDPattern.setEnabled(true);
            this.spnLEDColor.setEnabled(true);
        } else {
            this.spnLEDPattern.setEnabled(false);
            this.spnLEDColor.setEnabled(false);
        }
        if (this.deviceInfo.isBeepSupported()) {
            this.spnBeepPattern.setEnabled(true);
        } else {
            this.spnBeepPattern.setEnabled(false);
        }
    }

    private void enumerateNotificationDevices() {
        if (this.notificationManager != null) {
            this.deviceInfoList = this.notificationManager.getSupportedDevicesInfo();
            ArrayList<String> friendlyNameList = new ArrayList<String>();
            int spinnerIndex = 0;
            if (this.deviceInfoList != null && this.deviceInfoList.size() != 0) {
                for (DeviceInfo devInfo : this.deviceInfoList) {
                    friendlyNameList.add(devInfo.getFriendlyName());
                    if (devInfo.isDefaultDevice()) {
                        this.defaultIndex = spinnerIndex;
                    }
                    ++spinnerIndex;
                }
            }
            ArrayAdapter spinnerAdapter = new ArrayAdapter((Context)this, 17367048, friendlyNameList);
            spinnerAdapter.setDropDownViewResource(0x1090009);
            this.spnNotificationDevice.setAdapter((SpinnerAdapter)spinnerAdapter);
        }
    }

    private void addSpinnerDevicesListener() {
        this.spnNotificationDevice.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View arg1, int position, long arg3) {
                if (MainActivity.this.deviceIndex != position) {
                    MainActivity.this.deviceIndex = position;
                    MainActivity.this.deInitDevice();
                    MainActivity.this.initDevice();
                    MainActivity.this.populateNotificationSpinners();
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
        this.txtStatus.setText((CharSequence)"Status: EMDK closed unexpectedly! Please close and restart the application.");
    }

    public void onClickDeviceInfo(View arg0) {
        this.deviceInfo = this.notificationDevice.getDeviceInfo();
        String info = "FriendlyName = " + this.deviceInfo.getFriendlyName() + "\r\nModelNumber = " + this.deviceInfo.getModelNumber() + "\r\nDeviceType = " + this.deviceInfo.getDeviceType().toString() + "\r\nConnectionType = " + this.deviceInfo.getConnectionType().toString() + "\r\nisConnected = " + this.notificationDevice.isConnected() + "\r\nisDefaultDevice = " + this.deviceInfo.isDefaultDevice() + "\r\nisLEDSupported = " + this.deviceInfo.isLEDSupported() + "\r\nisBeepSupported = " + this.deviceInfo.isBeepSupported() + "\r\nisVibrateSupported = " + this.deviceInfo.isVibrateSupported();
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        alertDialog.setTitle((CharSequence)"Notification Device Info");
        alertDialog.setMessage((CharSequence)info);
        alertDialog.show();
    }

    public void onClickNotify(View arg0) {
        if (this.deviceInfo.getDeviceType() == DeviceType.IMAGER) {
            if (this.spnLEDPattern.getSelectedItem().toString().equals(PATTERN_NONE) && this.spnBeepPattern.getSelectedItem().toString().equals(PATTERN_NONE) && this.spnVibratePattern.getSelectedItem().toString().equals(PATTERN_NONE)) {
                this.txtStatus.setText((CharSequence)"Status: Please select at least one pattern");
                return;
            }
        } else if (this.spnVibratePattern.getSelectedItem().toString().equals(PATTERN_NONE)) {
            this.txtStatus.setText((CharSequence)"Status: Please select vibrate pattern");
            return;
        }
        Notification notification = new Notification();
        notification = this.getLEDPattern(notification);
        notification = this.getBeepPattern(notification);
        notification = this.getVibratePattern(notification);
        if (this.notificationDevice != null) {
            if (this.notificationDevice.isConnected()) {
                try {
                    this.notificationDevice.notify(notification);
                    this.txtStatus.setText((CharSequence)"Status: Notification sent!");
                }
                catch (NotificationException e) {
                    this.txtStatus.setText((CharSequence)("Status: " + e.getMessage()));
                }
            } else {
                this.txtStatus.setText((CharSequence)"Status: Notification device is not connected!");
            }
        } else {
            this.txtStatus.setText((CharSequence)"Status: NotificationDevice is null!");
        }
    }

    Notification getBeepPattern(Notification notification) {
        String beepPattern = this.spnBeepPattern.getSelectedItem().toString();
        if (beepPattern.equals(PATTERN1)) {
            Notification.Beep[] lstBeep = new Notification.Beep[8];
            lstBeep[0] = new Notification.Beep();
            lstBeep[0].frequency = 2000;
            lstBeep[0].time = 250;
            lstBeep[1] = new Notification.Beep();
            lstBeep[1].frequency = 0;
            lstBeep[1].time = 250;
            lstBeep[2] = new Notification.Beep();
            lstBeep[2].frequency = 2000;
            lstBeep[2].time = 250;
            lstBeep[3] = new Notification.Beep();
            lstBeep[3].frequency = 0;
            lstBeep[3].time = 250;
            lstBeep[4] = new Notification.Beep();
            lstBeep[4].frequency = 2000;
            lstBeep[4].time = 250;
            lstBeep[5] = new Notification.Beep();
            lstBeep[5].frequency = 0;
            lstBeep[5].time = 250;
            lstBeep[6] = new Notification.Beep();
            lstBeep[6].frequency = 2000;
            lstBeep[6].time = 250;
            lstBeep[7] = new Notification.Beep();
            lstBeep[7].frequency = 0;
            lstBeep[7].time = 250;
            notification.beep.pattern = lstBeep;
        } else if (beepPattern.equals(PATTERN2)) {
            Notification.Beep[] lstBeep = new Notification.Beep[4];
            lstBeep[0] = new Notification.Beep();
            lstBeep[0].frequency = 3000;
            lstBeep[0].time = 2500;
            lstBeep[1] = new Notification.Beep();
            lstBeep[1].frequency = 0;
            lstBeep[1].time = 1000;
            lstBeep[2] = new Notification.Beep();
            lstBeep[2].frequency = 3000;
            lstBeep[2].time = 2500;
            lstBeep[3] = new Notification.Beep();
            lstBeep[3].frequency = 0;
            lstBeep[3].time = 1000;
            notification.beep.pattern = lstBeep;
        } else if (beepPattern.equals(PATTERN3)) {
            notification.beep.pattern = new Notification.Beep[1];
            notification.beep.pattern[0] = new Notification.Beep();
            notification.beep.pattern[0].frequency = 3000;
            notification.beep.pattern[0].time = 250;
        }
        return notification;
    }

    Notification getLEDPattern(Notification notification) {
        String ledPattern = this.spnLEDPattern.getSelectedItem().toString();
        String ledColor = this.spnLEDColor.getSelectedItem().toString();
        LedColor color = LedColor.valueOf(ledColor);
        notification.led.color = color.getValue();
        if (ledPattern.equals(PATTERN1)) {
            notification.led.onTime = 250;
            notification.led.offTime = 250;
            notification.led.repeatCount = 3;
        } else if (ledPattern.equals(PATTERN2)) {
            notification.led.onTime = 2550;
            notification.led.offTime = 1000;
            notification.led.repeatCount = 1;
        } else if (ledPattern.equals(PATTERN3)) {
            notification.led.onTime = 250;
            notification.led.offTime = 250;
        }
        return notification;
    }

    Notification getVibratePattern(Notification notification) {
        String vibratePattern = this.spnVibratePattern.getSelectedItem().toString();
        if (vibratePattern.equals(PATTERN1)) {
            long[] lngArrVib = new long[]{250L, 250L, 250L, 250L, 250L, 250L, 250L, 250L};
            notification.vibrate.pattern = lngArrVib;
        } else if (vibratePattern.equals(PATTERN2)) {
            long[] lngArrVib = new long[]{1000L, 2550L, 1000L, 2550L};
            notification.vibrate.pattern = lngArrVib;
        } else if (vibratePattern.equals(PATTERN3)) {
            notification.vibrate.time = 250L;
        }
        return notification;
    }

    public void onClickCancel(View arg0) {
        if (this.notificationDevice != null) {
            if (this.notificationDevice.isConnected()) {
                try {
                    this.notificationDevice.cancelNotification();
                    this.txtStatus.setText((CharSequence)"Status: Notification cancelled!");
                }
                catch (NotificationException e) {
                    this.txtStatus.setText((CharSequence)("Status: " + e.getMessage()));
                }
            } else {
                this.txtStatus.setText((CharSequence)"Status: Notification device is not connected!");
            }
        } else {
            this.txtStatus.setText((CharSequence)"Status: NotificationDevice is null!");
        }
    }

    public void onClickReconnect(View arg0) {
        if (this.notificationDevice != null) {
            try {
                this.notificationDevice.release();
                this.notificationDevice = null;
                this.initDevice();
            }
            catch (NotificationException e) {
                this.txtStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        } else {
            this.txtStatus.setText((CharSequence)"Status: NotificationDevice is null!");
        }
    }

    private void initDevice() {
        if (this.notificationDevice == null) {
            if (this.deviceInfoList != null && this.deviceInfoList.size() != 0) {
                try {
                    this.deviceInfo = this.deviceInfoList.get(this.deviceIndex);
                    this.notificationDevice = this.notificationManager.getDevice(this.deviceInfo);
                }
                catch (NotificationException e) {
                    this.txtStatus.setText((CharSequence)("Status: " + e.getMessage()));
                }
            } else {
                this.txtStatus.setText((CharSequence)"Status: Failed to get the specified device! Please close and restart the application!");
                return;
            }
        }
        if (this.notificationDevice != null) {
            try {
                this.notificationDevice.enable();
                this.txtStatus.setText((CharSequence)("Status: " + this.deviceInfo.getFriendlyName() + " is enabled!"));
            }
            catch (NotificationException e) {
                this.txtStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        } else {
            this.txtStatus.setText((CharSequence)"Status: Failed to initialize the notification device!");
        }
    }

    private void deInitDevice() {
        try {
            if (this.notificationDevice != null) {
                this.notificationDevice.release();
                this.notificationDevice = null;
            } else {
                this.txtStatus.setText((CharSequence)"Status: Already Released!");
            }
        }
        catch (Exception e) {
            this.txtStatus.setText((CharSequence)"Status: Release failed!");
            e.printStackTrace();
        }
    }

    protected void onPause() {
        super.onPause();
        this.deInitDevice();
        if (this.notificationManager != null) {
            this.notificationManager = null;
            this.deviceInfoList = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release(EMDKManager.FEATURE_TYPE.NOTIFICATION);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.emdkManager != null) {
            this.notificationManager = (NotificationManager)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.NOTIFICATION);
            this.enumerateNotificationDevices();
            this.spnNotificationDevice.setSelection(this.deviceIndex);
            this.initDevice();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.deInitDevice();
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public static enum LedColor {
        Yellow(0xFFFF00),
        Orange(16747520),
        Red(0xFF0000),
        Blue(255),
        Purple(0x800080),
        Black(0),
        Grey(0xC0C0C0),
        Pink(16711862);

        private int value = 255;

        private LedColor(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }
}

