/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.profileclocksample1;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Xml;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.ProfileManager;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener {
    private String profileName = "ClockProfile-1";
    private ProfileManager profileManager = null;
    private EMDKManager emdkManager = null;
    private TextView statusTextView = null;
    private EditText tzEditText = null;
    private EditText dateEditText = null;
    private EditText timeEditText = null;
    private String timeZone = "GMT+05:45";
    private String date = "2014-11-22";
    private String time = "11:22:33";
    private String errorType = "";
    private String parmName = "";
    private String errorDescription = "";
    private String errorString = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903040);
        this.tzEditText = (EditText)this.findViewById(2130837507);
        this.dateEditText = (EditText)this.findViewById(2130837506);
        this.timeEditText = (EditText)this.findViewById(2130837508);
        this.statusTextView = (TextView)this.findViewById(2130837514);
        this.tzEditText.setText((CharSequence)this.timeZone);
        this.dateEditText.setText((CharSequence)this.date);
        this.timeEditText.setText((CharSequence)this.time);
        this.addSetButtonListener();
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode == EMDKResults.STATUS_CODE.SUCCESS) {
            // empty if block
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.profileManager != null) {
            this.profileManager = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2130968576, menu2);
        return true;
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
        this.statusTextView.setText((CharSequence)"Status: EMDK closed unexpectedly! Please close and restart the application.");
    }

    public void onOpened(EMDKManager emdkManager) {
        this.statusTextView.setText((CharSequence)"EMDK open success.");
        this.emdkManager = emdkManager;
        this.profileManager = (ProfileManager)emdkManager.getInstance(EMDKManager.FEATURE_TYPE.PROFILE);
    }

    private void addSetButtonListener() {
        Button setButton = (Button)this.findViewById(2130837505);
        setButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (MainActivity.this.readValues()) {
                    MainActivity.this.modifyProfile_XMLString();
                } else {
                    MainActivity.this.statusTextView.setText((CharSequence)"The above fields cannot be empty.");
                }
            }
        });
    }

    private boolean readValues() {
        this.timeZone = this.tzEditText.getText().toString().trim();
        this.date = this.dateEditText.getText().toString().trim();
        this.time = this.timeEditText.getText().toString().trim();
        return this.timeZone != null && this.timeZone.length() > 0 && this.date != null && this.date.length() > 0 && this.time != null && this.time.length() > 0;
    }

    private void modifyProfile_XMLString() {
        this.statusTextView.setText((CharSequence)"");
        this.errorType = "";
        this.parmName = "";
        this.errorDescription = "";
        this.errorString = "";
        String[] modifyData = new String[]{"<?xml version=\"1.0\" encoding=\"utf-8\"?><characteristic type=\"Profile\"><parm name=\"ProfileName\" value=\"ClockProfile-1\"/><characteristic type=\"Clock\" version=\"0.2\"><parm name=\"TimeZone\" value=\"" + this.timeZone + "\"/><parm name=\"Date\" value=\"" + this.date + "\"/><parm name=\"Time\" value=\"" + this.time + "\"/></characteristic></characteristic>"};
        new ProcessProfileTask().execute(new String[]{modifyData[0]});
    }

    public void parseXML(XmlPullParser myParser) {
        try {
            int event = myParser.getEventType();
            while (event != 1) {
                String name = myParser.getName();
                switch (event) {
                    case 2: {
                        if (name.equals("parm-error")) {
                            this.parmName = myParser.getAttributeValue(null, "name");
                            this.errorDescription = myParser.getAttributeValue(null, "desc");
                            this.errorString = " (Name: " + this.parmName + ", Error Description: " + this.errorDescription + ")";
                            return;
                        }
                        if (!name.equals("characteristic-error")) break;
                        this.errorType = myParser.getAttributeValue(null, "type");
                        this.errorDescription = myParser.getAttributeValue(null, "desc");
                        this.errorString = " (Type: " + this.errorType + ", Error Description: " + this.errorDescription + ")";
                        return;
                    }
                }
                event = myParser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ProcessProfileTask
    extends AsyncTask<String, Void, EMDKResults> {
        private ProcessProfileTask() {
        }

        protected EMDKResults doInBackground(String ... params) {
            EMDKResults results = MainActivity.this.profileManager.processProfile(MainActivity.this.profileName, ProfileManager.PROFILE_FLAG.SET, params);
            return results;
        }

        protected void onPostExecute(EMDKResults results) {
            super.onPostExecute((Object)results);
            String resultString = "";
            if (results.statusCode == EMDKResults.STATUS_CODE.CHECK_XML) {
                String statusXMLResponse = results.getStatusString();
                try {
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput((Reader)new StringReader(statusXMLResponse));
                    MainActivity.this.parseXML(parser);
                    resultString = TextUtils.isEmpty((CharSequence)MainActivity.this.parmName) && TextUtils.isEmpty((CharSequence)MainActivity.this.errorType) && TextUtils.isEmpty((CharSequence)MainActivity.this.errorDescription) ? "Profile update success." : "Profile update failed." + MainActivity.this.errorString;
                }
                catch (XmlPullParserException e) {
                    resultString = e.getMessage();
                }
            }
            MainActivity.this.statusTextView.setText((CharSequence)resultString);
        }
    }
}

