/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnectionException;
import com.symbol.emdk.emdkservice.IEMDKService;

public class EMDKServiceConnection
implements ServiceConnection {
    private static final String LOG_TAG = "EMDK_Service_Connection";
    private static final String EMDK_SERVICE_CLASS = ".EMDKService";
    private static final String EMDK_SERVICE_PACKAGE = "com.symbol.emdk.emdkservice";
    private static final String INTENT_ACTION_BIND_EMDK_SERVICE = "symbol.intent.action.emdkservice";
    private final Context context;
    IEMDKService service;
    boolean isEMDKServiceConnected = false;
    private EMDKManager emdkManager;
    IBinder deathNotifyBinder = new MyLocalBinder();

    EMDKServiceConnection(Context context, EMDKManager emdkManager) throws Exception {
        this.context = context;
        this.emdkManager = emdkManager;
        Intent bindIntent = new Intent(INTENT_ACTION_BIND_EMDK_SERVICE);
        bindIntent.setClassName(EMDK_SERVICE_PACKAGE, "com.symbol.emdk.emdkservice.EMDKService");
        if (!this.context.bindService(bindIntent, (ServiceConnection)this, 1)) {
            throw new EMDKServiceConnectionException("Could not bind to EMDK Service");
        }
        Log.d((String)LOG_TAG, (String)"#EMDK-API# The EMDK Service will be connected soon (asynchronous call)!");
    }

    public boolean isServiceConnected() {
        return this.isEMDKServiceConnected;
    }

    public IEMDKService getService() {
        return this.service;
    }

    void release() {
        if (this.isEMDKServiceConnected) {
            try {
                this.service.deinitEMDKManager();
                this.context.unbindService((ServiceConnection)this);
                this.service = null;
                this.isEMDKServiceConnected = false;
                Log.d((String)LOG_TAG, (String)"#EMDK-API# The connection to the EMDK Service was closed.!");
            }
            catch (RemoteException e) {
                Log.e((String)LOG_TAG, (String)("" + e.getMessage()));
            }
        }
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        Log.d((String)LOG_TAG, (String)"#EMDK-API# The EMDK Service is now connected!");
        this.service = IEMDKService.Stub.asInterface(service);
        if (this.service != null) {
            try {
                this.service.initEMDKManager();
                this.service.passDeathListener(this.deathNotifyBinder);
                this.isEMDKServiceConnected = true;
            }
            catch (RemoteException e) {
                Log.e((String)LOG_TAG, (String)("" + e.getMessage()));
            }
            this.notifyonConnected();
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        Log.d((String)LOG_TAG, (String)"#EMDK-API# The connection to the EMDK Service got disconnected unexpectedly!");
        this.isEMDKServiceConnected = false;
        this.service = null;
        this.notifyonDisconnected();
    }

    void notifyonConnected() {
        if (this.emdkManager.listeners != null) {
            for (EMDKManager.EMDKListener c : this.emdkManager.listeners) {
                c.onOpened(this.emdkManager);
            }
        }
    }

    void notifyonDisconnected() {
        if (this.emdkManager.listeners != null) {
            for (EMDKManager.EMDKListener c : this.emdkManager.listeners) {
                c.onClosed();
            }
        }
    }

    public class MyLocalBinder
    extends Binder {
    }
}

