/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.barcode.ConnectionCallbackInternal;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.ScannerException;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.emdkservice.barcode.SvcScannerInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class BarcodeManager
extends EMDKBase {
    private static String TAG = "Barcode_Manager";
    static BarcodeManager barcodeManager = null;
    Context context;
    EMDKServiceConnection emdkServiceConnection;
    ConnectionCallbackInternal connectionCallbackPrivate;
    ArrayList<ScannerInfo> supportedScanners;
    Scanner activeScanner;
    List<ScannerConnectionListener> connectionListenerCallbacks;
    List<String> connectionListenerIntents;
    static List<Scanner> createdScannerDevices = new CopyOnWriteArrayList<Scanner>();

    BarcodeManager(Context context, EMDKServiceConnection emdkServiceConnection) throws ScannerException {
        block5: {
            super(EMDKManager.FEATURE_TYPE.BARCODE);
            this.context = null;
            this.emdkServiceConnection = null;
            this.connectionCallbackPrivate = null;
            this.supportedScanners = new ArrayList();
            this.activeScanner = null;
            this.connectionListenerCallbacks = null;
            this.connectionListenerIntents = null;
            if (emdkServiceConnection == null || !emdkServiceConnection.isServiceConnected()) {
                throw new ScannerException(ScannerResults.FAILURE);
            }
            this.emdkServiceConnection = emdkServiceConnection;
            this.context = context;
            try {
                if (0 == this.emdkServiceConnection.getService().scnIntialize()) {
                    List<SvcScannerInfo> temp = this.emdkServiceConnection.getService().scnGetSupportedDevicesInfo();
                    for (SvcScannerInfo scnInfo : temp) {
                        this.supportedScanners.add(new ScannerInfo(scnInfo));
                    }
                    break block5;
                }
                throw new ScannerException(ScannerResults.FAILURE);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new ScannerException(ScannerResults.FAILURE);
            }
        }
        barcodeManager = this;
        this.registerConnectionNotification();
    }

    public List<ScannerInfo> getSupportedDevicesInfo() {
        block4: {
            try {
                if (this.emdkServiceConnection.isServiceConnected()) {
                    this.supportedScanners.clear();
                    List<SvcScannerInfo> temp = this.emdkServiceConnection.getService().scnGetSupportedDevicesInfo();
                    for (SvcScannerInfo scnInfo : temp) {
                        this.supportedScanners.add(new ScannerInfo(scnInfo));
                    }
                    break block4;
                }
                throw new ScannerException(ScannerResults.FAILURE);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return this.supportedScanners;
    }

    Scanner getDevice(String friendlyName) {
        for (ScannerInfo scannerInfo : this.supportedScanners) {
            if (!friendlyName.equalsIgnoreCase(scannerInfo.friendlyName)) continue;
            return this.getDeviceInternal(scannerInfo);
        }
        return null;
    }

    public Scanner getDevice(ScannerInfo scannerInfo) {
        if (scannerInfo != null) {
            for (ScannerInfo temp : this.supportedScanners) {
                if (temp.scannerIndex != scannerInfo.scannerIndex) continue;
                return this.getDeviceInternal(scannerInfo);
            }
        }
        return null;
    }

    public Scanner getDevice(DeviceIdentifier deviceIdentifier) {
        Scanner scanner = null;
        int index = 0;
        switch (deviceIdentifier) {
            case DEFAULT: {
                for (ScannerInfo scannerInfo : this.supportedScanners) {
                    if (!scannerInfo.isDefaultScanner) continue;
                    return this.getDeviceInternal(scannerInfo);
                }
                break;
            }
            case INTERNAL_CAMERA1: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.CAMERA, ScannerInfo.ConnectionType.INTERNAL, index);
                break;
            }
            case INTERNAL_IMAGER1: {
                for (ScannerInfo scannerInfo : this.supportedScanners) {
                    if (scannerInfo.deviceType == ScannerInfo.DeviceType.IMAGER && scannerInfo.connectionType == ScannerInfo.ConnectionType.INTERNAL) {
                        scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.INTERNAL, index);
                    }
                    if (scanner != null || scannerInfo.deviceType != ScannerInfo.DeviceType.IMAGER || scannerInfo.connectionType != ScannerInfo.ConnectionType.SERIAL_SSI) continue;
                    scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.SERIAL_SSI, index);
                }
                break;
            }
            case INTERNAL_LASER1: {
                for (ScannerInfo scannerInfo : this.supportedScanners) {
                    if (scannerInfo.deviceType == ScannerInfo.DeviceType.LASER && scannerInfo.connectionType == ScannerInfo.ConnectionType.INTERNAL) {
                        scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.LASER, ScannerInfo.ConnectionType.INTERNAL, index);
                    }
                    if (scanner != null || scannerInfo.deviceType != ScannerInfo.DeviceType.LASER || scannerInfo.connectionType != ScannerInfo.ConnectionType.SERIAL_SSI) continue;
                    scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.LASER, ScannerInfo.ConnectionType.SERIAL_SSI, index);
                }
                break;
            }
            case BLUETOOTH_IMAGER1: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.BLUETOOTH_SSI, DeviceIdentifier.BLUETOOTH_IMAGER1, index);
                break;
            }
            case PLUGGABLE_LASER1: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.LASER, ScannerInfo.ConnectionType.PLUGGABLE_SSI, index);
                break;
            }
            case BLUETOOTH_IMAGER_RS6000: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.BLUETOOTH_SSI, DeviceIdentifier.BLUETOOTH_IMAGER_RS6000, index);
                break;
            }
            case PLUGGABLE_IMAGER_RS5000: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.PLUGGABLE_SSI, DeviceIdentifier.PLUGGABLE_IMAGER_RS5000, index);
                break;
            }
            case BLUETOOTH_IMAGER_DS3678: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.BLUETOOTH_SSI, DeviceIdentifier.BLUETOOTH_IMAGER_DS3678, index);
                break;
            }
            case PLUGGABLE_IMAGER_DS3608: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.USB, DeviceIdentifier.PLUGGABLE_IMAGER_DS3608, index);
                break;
            }
            case BLUETOOTH_LASER_LI3678: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.LASER, ScannerInfo.ConnectionType.BLUETOOTH_SSI, DeviceIdentifier.BLUETOOTH_LASER_LI3678, index);
                break;
            }
            case PLUGGABLE_LASER_LI3608: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.LASER, ScannerInfo.ConnectionType.USB, DeviceIdentifier.PLUGGABLE_LASER_LI3608, index);
                break;
            }
            case BLUETOOTH_IMAGER_DS2278: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.BLUETOOTH_SSI, DeviceIdentifier.BLUETOOTH_IMAGER_DS2278, index);
                break;
            }
            case BLUETOOTH_IMAGER_DS8178: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.BLUETOOTH_SSI, DeviceIdentifier.BLUETOOTH_IMAGER_DS8178, index);
                break;
            }
            case BLUETOOTH_IMAGER_RS5100: {
                scanner = this.getScannerByIdentifier(ScannerInfo.DeviceType.IMAGER, ScannerInfo.ConnectionType.BLUETOOTH_SSI, DeviceIdentifier.BLUETOOTH_IMAGER_RS5100, index);
                break;
            }
        }
        return scanner;
    }

    private Scanner getScannerByIdentifier(ScannerInfo.DeviceType deviceType, ScannerInfo.ConnectionType connectionType, DeviceIdentifier deviceIdentifier, int index) {
        int count = 0;
        for (ScannerInfo scannerInfo : this.supportedScanners) {
            if (scannerInfo.deviceType != deviceType || scannerInfo.connectionType != connectionType || scannerInfo.deviceIdentifier != deviceIdentifier) continue;
            if (count == index) {
                return this.getDeviceInternal(scannerInfo);
            }
            ++count;
        }
        return null;
    }

    private Scanner getScannerByIdentifier(ScannerInfo.DeviceType deviceType, ScannerInfo.ConnectionType connectionType, int index) {
        int count = 0;
        for (ScannerInfo scannerInfo : this.supportedScanners) {
            if (scannerInfo.deviceType != deviceType || scannerInfo.connectionType != connectionType) continue;
            if (count == index) {
                return this.getDeviceInternal(scannerInfo);
            }
            ++count;
        }
        return null;
    }

    private Scanner getDeviceInternal(ScannerInfo scannerInfo) {
        for (Scanner scanner : createdScannerDevices) {
            if (scanner.scannerInfo.scannerIndex != scannerInfo.scannerIndex) continue;
            return scanner;
        }
        Scanner scanner = null;
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                if (0 == this.emdkServiceConnection.getService().scnGetDevice(scannerInfo.scannerIndex)) {
                    scanner = new Scanner(scannerInfo, this.context, this.emdkServiceConnection);
                    createdScannerDevices.add(scanner);
                }
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return scanner;
    }

    public void addConnectionListener(ScannerConnectionListener connectionListener) {
        if (this.connectionListenerCallbacks == null) {
            this.connectionListenerCallbacks = new CopyOnWriteArrayList<ScannerConnectionListener>();
        }
        this.connectionListenerCallbacks.add(connectionListener);
    }

    public void removeConnectionListener(ScannerConnectionListener connectionListener) {
        if (this.connectionListenerCallbacks != null) {
            this.connectionListenerCallbacks.remove(connectionListener);
            if (this.connectionListenerCallbacks.size() <= 0) {
                this.connectionListenerCallbacks = null;
            }
        }
    }

    void addConnectionListener(String intentName) {
        if (this.connectionListenerIntents == null) {
            this.connectionListenerIntents = new CopyOnWriteArrayList<String>();
        }
        this.connectionListenerIntents.add(intentName);
    }

    void removeConnectionListener(String intentName) {
        if (this.connectionListenerIntents != null) {
            this.connectionListenerIntents.remove(intentName);
            if (this.connectionListenerIntents.size() <= 0) {
                this.connectionListenerIntents = null;
            }
        }
    }

    void registerConnectionNotification() {
        if (this.connectionCallbackPrivate == null) {
            this.connectionCallbackPrivate = new ConnectionCallbackInternal(this);
            try {
                this.emdkServiceConnection.getService().scnAddConnectionListener(this.connectionCallbackPrivate);
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)("Caught exception : " + e.getMessage()));
            }
        }
    }

    void unRegisterConnectionNotification() {
        if (this.connectionCallbackPrivate != null && this.connectionListenerCallbacks == null && this.connectionListenerIntents == null) {
            if (this.emdkServiceConnection.isServiceConnected()) {
                try {
                    this.emdkServiceConnection.getService().scnRemoveConectionListener(this.connectionCallbackPrivate);
                }
                catch (RemoteException e) {
                    Log.d((String)TAG, (String)"Caught remote exception");
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            this.connectionCallbackPrivate = null;
        }
    }

    void release() {
        try {
            if (createdScannerDevices != null) {
                for (Scanner scanner : createdScannerDevices) {
                    scanner.release();
                }
                createdScannerDevices.clear();
            }
            if (this.connectionListenerIntents != null) {
                this.connectionListenerIntents.clear();
                this.connectionListenerIntents = null;
            }
            if (this.connectionListenerCallbacks != null) {
                this.connectionListenerCallbacks.clear();
                this.connectionListenerCallbacks = null;
            }
            this.unRegisterConnectionNotification();
            if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
                try {
                    this.emdkServiceConnection.getService().scnUnIntialize();
                }
                catch (RemoteException e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
        }
        catch (ScannerException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
    }

    public static enum DeviceIdentifier {
        DEFAULT(0),
        INTERNAL_CAMERA1(1),
        INTERNAL_IMAGER1(2),
        INTERNAL_LASER1(3),
        BLUETOOTH_IMAGER1(4),
        PLUGGABLE_LASER1(5),
        BLUETOOTH_IMAGER_RS6000(6),
        PLUGGABLE_IMAGER_RS5000(7),
        BLUETOOTH_IMAGER_DS3678(8),
        PLUGGABLE_IMAGER_DS3608(9),
        BLUETOOTH_LASER_LI3678(10),
        PLUGGABLE_LASER_LI3608(11),
        BLUETOOTH_IMAGER_DS2278(12),
        BLUETOOTH_IMAGER_DS8178(13),
        BLUETOOTH_IMAGER_RS5100(14),
        UNDEFINED(99);

        private final int id;

        private DeviceIdentifier(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum ConnectionState {
        CONNECTED,
        DISCONNECTED;

    }

    public static interface ScannerConnectionListener {
        public void onConnectionChange(ScannerInfo var1, ConnectionState var2);
    }
}

