/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.emdkservice.barcode.ISvcScanConnectionCallback;
import com.symbol.emdk.emdkservice.barcode.SvcConnectionStatus;

class ConnectionCallbackInternal
extends ISvcScanConnectionCallback.Stub {
    private static String TAG = "Connection_Callback_Internal";
    BarcodeManager barcodeManager = null;

    public ConnectionCallbackInternal(BarcodeManager barcodeManager) {
        this.barcodeManager = barcodeManager;
    }

    @Override
    public void onConnectionChange(SvcConnectionStatus connectionStatus) throws RemoteException {
        new ConnectionCallbackThread(this.barcodeManager, connectionStatus).start();
    }

    class ConnectionCallbackThread
    extends Thread {
        SvcConnectionStatus threadedConnectionStatus;
        BarcodeManager threadedBarcodeManager = null;

        ConnectionCallbackThread(BarcodeManager barcodeManager, SvcConnectionStatus connectionStatus) {
            if (barcodeManager == null || connectionStatus == null) {
                return;
            }
            this.threadedConnectionStatus = connectionStatus;
            this.threadedBarcodeManager = barcodeManager;
        }

        @Override
        public void run() {
            try {
                BarcodeManager.ConnectionState connectionState = BarcodeManager.ConnectionState.values()[this.threadedConnectionStatus.getConnectionState().ordinal()];
                ScannerInfo scannerInfo = new ScannerInfo(this.threadedConnectionStatus.getScannerInfo());
                if (this.threadedBarcodeManager.connectionListenerCallbacks != null) {
                    for (BarcodeManager.ScannerConnectionListener callback : this.threadedBarcodeManager.connectionListenerCallbacks) {
                        if (callback == null) continue;
                        callback.onConnectionChange(scannerInfo, connectionState);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }
}

