/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.barcode.ScanDataCollection;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.barcode.TokenizedData;
import com.symbol.emdk.emdkservice.barcode.ISvcScanDataCallback;
import com.symbol.emdk.emdkservice.barcode.SvcScanData;
import com.symbol.emdk.emdkservice.barcode.SvcScanDataCollection;
import com.symbol.emdk.emdkservice.barcode.SvcToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

class DataCallbackInternal
extends ISvcScanDataCallback.Stub {
    private static final String TAG = "Data_Callback_Internal";
    Scanner scanner;

    DataCallbackInternal(Scanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void onData(SvcScanDataCollection scanData) throws RemoteException {
        new DataCallbackThread(this.scanner, scanData).start();
    }

    class EMDKServiceObjectReader
    extends ObjectInputStream {
        public EMDKServiceObjectReader(InputStream input) throws StreamCorruptedException, IOException {
            super(input);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass read = super.readClassDescriptor();
            if (read.getName().startsWith("com.symbol.emdk.emdkservice.barcode.")) {
                return ObjectStreamClass.lookup(Class.forName(read.getName().replace("com.symbol.emdk.emdkservice.barcode.", "com.symbol.emdk.barcode.")));
            }
            return read;
        }
    }

    class DataCallbackThread
    extends Thread {
        SvcScanDataCollection scanData;
        Scanner scannerReference;

        DataCallbackThread(Scanner scanner, SvcScanDataCollection scanData) {
            this.scanData = scanData;
            this.scannerReference = scanner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.scannerReference == null) {
                    return;
                }
                if (this.scannerReference.triggerType == Scanner.TriggerType.SOFT_ONCE) {
                    this.scannerReference.triggerType = Scanner.TriggerType.HARD;
                }
                ScanDataCollection scanDataCollection = new ScanDataCollection();
                scanDataCollection.friendlyName = this.scanData.getFriendlyName();
                scanDataCollection.result = ScannerResults.values()[this.scanData.getResult().ordinal()];
                for (SvcScanData temp : this.scanData.getScanData()) {
                    ScanDataCollection.ScanData data = new ScanDataCollection.ScanData(scanDataCollection);
                    if (temp.pfd != null) {
                        FileInputStream is = null;
                        ObjectInputStream ois = null;
                        byte[] fdRawData = null;
                        try {
                            Log.e((String)DataCallbackInternal.TAG, (String)"temp.pfd != null");
                            is = new FileInputStream(temp.pfd.getFileDescriptor());
                            ois = new EMDKServiceObjectReader(is);
                            Object obj = ois.readObject();
                            Log.d((String)DataCallbackInternal.TAG, (String)("obj type:" + obj.getClass().getName()));
                            fdRawData = (byte[])obj;
                            Log.d((String)DataCallbackInternal.TAG, (String)"obj parsed to byte[]");
                        }
                        catch (RuntimeException e) {
                            Log.e((String)DataCallbackInternal.TAG, (String)("Caught RuntimeException : " + e.getMessage()));
                        }
                        catch (ClassNotFoundException e) {
                            Log.e((String)DataCallbackInternal.TAG, (String)("Caught ClassNotFoundException : " + e.getMessage()));
                        }
                        catch (IOException e) {
                            Log.e((String)DataCallbackInternal.TAG, (String)("Caught IOException : " + e.getMessage()));
                        }
                        catch (Exception e) {
                            if (e.getMessage() != null) {
                                Log.e((String)DataCallbackInternal.TAG, (String)("Caught exception : " + e.getMessage()));
                            } else {
                                Log.e((String)DataCallbackInternal.TAG, (String)"Caught exception");
                            }
                        }
                        finally {
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException e) {
                                    Log.e((String)DataCallbackInternal.TAG, (String)("" + e.getMessage()));
                                }
                                ois = null;
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    Log.e((String)DataCallbackInternal.TAG, (String)("" + e.getMessage()));
                                }
                                is = null;
                            }
                            System.gc();
                        }
                        data.rawData = fdRawData;
                    } else {
                        data.rawData = temp.getRawData();
                    }
                    data.strData = temp.getStringData();
                    data.charsetName = temp.getCharsetName();
                    data.labelType = ScanDataCollection.LabelType.values()[temp.getLabelType().ordinal()];
                    data.timeStamp = temp.getTimeStamp();
                    scanDataCollection.scanData.add(data);
                }
                scanDataCollection.labelIdentifier = this.scanData.getLabelIdentifier();
                scanDataCollection.tokenizedData = new TokenizedData();
                for (SvcToken svcToken : this.scanData.getTokenizedData()) {
                    TokenizedData.Token token = new TokenizedData.Token(scanDataCollection.tokenizedData);
                    token.key = svcToken.getKey();
                    token.dataType = svcToken.getDataType();
                    token.format = svcToken.getFormat();
                    token.data = svcToken.getData();
                    token.rawData = svcToken.getRawData();
                    scanDataCollection.tokenizedData.tokenList.add(token);
                }
                if (this.scannerReference.dataListenerCallbacks != null) {
                    for (Scanner.DataListener callback : this.scannerReference.dataListenerCallbacks) {
                        if (callback == null) continue;
                        callback.onData(scanDataCollection);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)DataCallbackInternal.TAG, (String)("" + e.getMessage()));
            }
        }
    }
}

