/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.DataCallbackInternal;
import com.symbol.emdk.barcode.InterfaceConfig;
import com.symbol.emdk.barcode.ScanDataCollection;
import com.symbol.emdk.barcode.ScannerConfig;
import com.symbol.emdk.barcode.ScannerException;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.barcode.ScannerUtils;
import com.symbol.emdk.barcode.StatusCallbackInternal;
import com.symbol.emdk.barcode.StatusData;
import com.symbol.emdk.emdkservice.barcode.SvcErrorCode;
import com.symbol.emdk.emdkservice.barcode.SvcScannerConfig;
import com.symbol.emdk.emdkservice.barcode.SvcScannerInfo;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Scanner {
    public static final String TAG = "Scanner";
    ScannerInfo scannerInfo;
    private ScannerConfig scannerConfig;
    private boolean isScnInfoUpdateNeed = true;
    private boolean isReleased = false;
    private Context context;
    List<DataListener> dataListenerCallbacks = null;
    List<String> dataListenerIntents = null;
    List<StatusListener> statusListenerCallbacks = null;
    List<String> statusListenerIntents = null;
    private StatusCallbackInternal statusCallbackInternal;
    private DataCallbackInternal dataCallbackInternal;
    private ScannerConfig config = null;
    private ScannerConfig prevConfig = null;
    EMDKServiceConnection emdkServiceConnection = null;
    public TriggerType triggerType = TriggerType.HARD;

    Scanner(ScannerInfo scannerInfo, Context context, EMDKServiceConnection emdkServiceConnection) {
        this.scannerInfo = scannerInfo;
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
    }

    SvcScannerConfig getDefaultConfig() throws ScannerException {
        SvcScannerConfig svcScannerConfig = null;
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                svcScannerConfig = this.emdkServiceConnection.getService().scnGetDefaultConfig(this.scannerInfo.scannerIndex);
                if (null != svcScannerConfig) {
                    retValue = ScannerResults.SUCCESS.getValue();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (ScannerResults.SUCCESS.getValue() != retValue) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
        return svcScannerConfig;
    }

    public boolean isEnabled() {
        if (this.isReleased) {
            return false;
        }
        Boolean retValue = false;
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().scnIsEnabled(this.scannerInfo.scannerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return retValue;
    }

    boolean isReleased() {
        return this.isReleased;
    }

    public boolean isReadPending() {
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                return this.emdkServiceConnection.getService().isReadPending(this.scannerInfo.scannerIndex);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public ScannerInfo getScannerInfo() {
        try {
            SvcScannerInfo scnInfo = this.emdkServiceConnection.getService().scnGetScannerInfo(this.scannerInfo.scannerIndex);
            this.scannerInfo.updateScannerInfo(scnInfo);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Caught exception : " + e.getMessage()));
        }
        return this.scannerInfo;
    }

    public ScannerConfig getConfig() throws ScannerException {
        ScannerConfig cfg = new ScannerConfig();
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcScannerConfig mSvcScannerConfig = this.emdkServiceConnection.getService().scnGetConfig(this.scannerInfo.scannerIndex);
                if (null != mSvcScannerConfig) {
                    cfg.updateScannerConfig(mSvcScannerConfig);
                    retValue = ScannerResults.SUCCESS.getValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ScannerResults.SUCCESS.getValue() != retValue) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
        return cfg;
    }

    public void setConfig(ScannerConfig scannerConfig) throws ScannerException {
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        SvcErrorCode error = new SvcErrorCode();
        if (null != scannerConfig) {
            if (this.emdkServiceConnection.isServiceConnected()) {
                SvcScannerConfig mSvcScannerConfig = new SvcScannerConfig();
                scannerConfig.updateSvcScannerConfig(mSvcScannerConfig);
                try {
                    error = this.emdkServiceConnection.getService().scnSetConfig(this.scannerInfo.scannerIndex, mSvcScannerConfig, mSvcScannerConfig.getModifiedParamBundle());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
        } else {
            throw new ScannerException(ScannerResults.INVALID_VALUE);
        }
        if (ScannerResults.SUCCESS.getValue() != error.errorCode) {
            throw new ScannerException(ScannerUtils.getScannerResult(error.errorCode), error.errorCode, error.errorDescription);
        }
    }

    public void enable() throws ScannerException {
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().scnEnable(this.scannerInfo.scannerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (ScannerResults.SUCCESS.getValue() != retValue) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
    }

    public void disable() throws ScannerException {
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().scnDisable(this.scannerInfo.scannerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (ScannerResults.SUCCESS.getValue() != retValue) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
    }

    public void release() throws ScannerException {
        if (!this.isReleased) {
            boolean isBTScanner = false;
            boolean isPluggableScanner = false;
            if (null != this.scannerInfo) {
                isBTScanner = ScannerInfo.ConnectionType.BLUETOOTH_SSI == this.scannerInfo.connectionType;
                isPluggableScanner = ScannerInfo.ConnectionType.PLUGGABLE_SSI == this.scannerInfo.connectionType;
            }
            Log.d((String)TAG, (String)("scanner.release: isBTScanner: " + isBTScanner));
            Log.d((String)TAG, (String)("scanner.release: isPluggableScanner: " + isPluggableScanner));
            int retValue = ScannerResults.FAILURE.getValue();
            if (this.emdkServiceConnection.isServiceConnected()) {
                try {
                    if (null != this.scannerInfo) {
                        retValue = this.emdkServiceConnection.getService().scnRelease(this.scannerInfo.scannerIndex);
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            this.isReleased = true;
            this.scannerConfig = null;
            if (this.dataListenerCallbacks != null) {
                this.dataListenerCallbacks.clear();
                this.dataListenerCallbacks = null;
            }
            if (this.dataListenerIntents != null) {
                this.dataListenerIntents.clear();
                this.dataListenerIntents = null;
            }
            if (this.statusListenerCallbacks != null) {
                this.statusListenerCallbacks.clear();
                this.statusListenerCallbacks = null;
            }
            if (this.statusListenerIntents != null) {
                this.statusListenerIntents.clear();
                this.statusListenerIntents = null;
            }
            this.statusCallbackInternal = null;
            this.dataCallbackInternal = null;
            BarcodeManager.createdScannerDevices.remove(this);
            if (ScannerResults.SUCCESS.getValue() != retValue) {
                throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
            }
        }
    }

    public void read() throws ScannerException {
        if (this.dataListenerCallbacks == null && this.dataListenerIntents == null) {
            throw new ScannerException(ScannerResults.NO_DATA_LISTENER);
        }
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().scnRead(this.scannerInfo.scannerIndex, this.triggerType.getValue());
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (ScannerResults.SUCCESS.getValue() != retValue) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
    }

    public void cancelRead() throws ScannerException {
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().scnCancelRead(this.scannerInfo.scannerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (retValue != 0) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
    }

    public void addDataListener(DataListener listener) {
        if (!this.isReleased) {
            if (this.dataListenerCallbacks == null) {
                this.dataListenerCallbacks = new CopyOnWriteArrayList<DataListener>();
            }
            this.dataListenerCallbacks.add(listener);
            this.registerDataNotification();
        }
    }

    public void removeDataListener(DataListener listener) {
        if (this.dataListenerCallbacks != null) {
            this.dataListenerCallbacks.remove(listener);
            if (this.dataListenerCallbacks.size() == 0) {
                this.dataListenerCallbacks = null;
                try {
                    this.cancelRead();
                }
                catch (ScannerException e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
                this.unRegisterDataNotification();
            }
        }
    }

    void addDataListener(String intentName) {
        if (!this.isReleased) {
            if (this.dataListenerIntents == null) {
                this.dataListenerIntents = new CopyOnWriteArrayList<String>();
            }
            this.dataListenerIntents.add(intentName);
            this.registerDataNotification();
        }
    }

    void removeDataListener(String intentName) {
        if (this.dataListenerIntents != null) {
            this.dataListenerIntents.remove(intentName);
            if (this.dataListenerIntents.size() == 0) {
                this.dataListenerIntents = null;
                try {
                    this.cancelRead();
                }
                catch (ScannerException e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
                this.unRegisterDataNotification();
            }
        }
    }

    public void addStatusListener(StatusListener listener) {
        if (!this.isReleased) {
            if (this.statusListenerCallbacks == null) {
                this.statusListenerCallbacks = new CopyOnWriteArrayList<StatusListener>();
            }
            this.statusListenerCallbacks.add(listener);
            this.registerStatusNotification();
        }
    }

    public void removeStatusListener(StatusListener listener) {
        if (this.statusListenerCallbacks != null) {
            this.statusListenerCallbacks.remove(listener);
            if (this.statusListenerCallbacks.size() == 0) {
                this.statusListenerCallbacks = null;
                this.unRegisterStatusNotification();
            }
        }
    }

    void addStatusListener(String intentName) {
        if (!this.isReleased) {
            if (this.statusListenerIntents == null) {
                this.statusListenerIntents = new CopyOnWriteArrayList<String>();
            }
            this.statusListenerIntents.add(intentName);
            this.registerStatusNotification();
        }
    }

    void removeStatusListener(String intentName) {
        if (this.statusListenerIntents != null) {
            this.statusListenerIntents.remove(intentName);
            if (this.statusListenerIntents.size() == 0) {
                this.statusListenerIntents = null;
            }
            this.unRegisterStatusNotification();
        }
    }

    void registerDataNotification() {
        if (this.dataListenerCallbacks == null && this.dataListenerIntents == null) {
            return;
        }
        if (this.dataCallbackInternal == null) {
            this.dataCallbackInternal = new DataCallbackInternal(this);
            try {
                this.emdkServiceConnection.getService().scnAddDataListener(this.scannerInfo.scannerIndex, this.dataCallbackInternal);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    void unRegisterDataNotification() {
        block4: {
            try {
                if (this.dataCallbackInternal == null || this.dataListenerCallbacks != null || this.dataListenerIntents != null) break block4;
                try {
                    this.emdkServiceConnection.getService().scnRemoveDataListener(this.scannerInfo.scannerIndex, this.dataCallbackInternal);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
                this.dataCallbackInternal = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void registerStatusNotification() {
        if (this.statusListenerCallbacks == null && this.statusListenerIntents == null) {
            return;
        }
        if (this.statusCallbackInternal == null) {
            this.statusCallbackInternal = new StatusCallbackInternal(this);
            try {
                this.emdkServiceConnection.getService().scnAddStatusListener(this.scannerInfo.scannerIndex, this.statusCallbackInternal);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    void unRegisterStatusNotification() {
        if (this.statusCallbackInternal != null && this.statusListenerCallbacks == null && this.statusListenerIntents == null) {
            try {
                this.emdkServiceConnection.getService().scnRemoveStatusListener(this.scannerInfo.scannerIndex, this.statusCallbackInternal);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
            this.statusCallbackInternal = null;
        }
    }

    public InterfaceConfig getInterfaceConfig() throws ScannerException {
        InterfaceConfig config = new InterfaceConfig();
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        ScannerConfig cfg = new ScannerConfig();
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                Log.d((String)"dd:", (String)"emdk::getInterfaceConfig::scnGetConfig");
                SvcScannerConfig mSvcScannerConfig = this.emdkServiceConnection.getService().scnGetConfig(this.scannerInfo.scannerIndex);
                Log.d((String)"dd:", (String)("emdk::getInterfaceConfig::scnGetConfig::mSvcScannerConfig::" + mSvcScannerConfig));
                if (null != mSvcScannerConfig) {
                    cfg.updateScannerConfig(mSvcScannerConfig);
                    retValue = ScannerResults.SUCCESS.getValue();
                }
            }
            catch (Exception e) {
                Log.d((String)"dd:", (String)"emdk::getInterfaceConfig::scnGetConfig::exception");
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (ScannerResults.SUCCESS.getValue() != retValue) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
        Log.d((String)"dd:", (String)"emdk::getInterfaceConfig::scnGetConfig::success");
        config.displayBluetoothAddressBarcode = cfg.interfaceParams.displayBluetoothAddressBarcode;
        config.connectionEstablishTime = cfg.interfaceParams.connectionEstablishTime;
        return config;
    }

    public void setInterfaceConfig(InterfaceConfig interfaceConfig) throws ScannerException {
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        SvcErrorCode error = new SvcErrorCode();
        if (null != interfaceConfig) {
            if (this.emdkServiceConnection.isServiceConnected()) {
                try {
                    SvcScannerConfig svcScannerConfig = this.emdkServiceConnection.getService().scnGetConfig(this.scannerInfo.scannerIndex);
                    if (null != svcScannerConfig) {
                        svcScannerConfig.interfaceParams.displayBluetoothAddressBarcode = interfaceConfig.displayBluetoothAddressBarcode;
                        svcScannerConfig.interfaceParams.connectionEstablishTime = interfaceConfig.connectionEstablishTime;
                        error = this.emdkServiceConnection.getService().scnSetConfig(this.scannerInfo.scannerIndex, svcScannerConfig, svcScannerConfig.getModifiedParamBundle());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new ScannerException(ScannerResults.INVALID_VALUE);
        }
        if (ScannerResults.SUCCESS.getValue() != error.errorCode) {
            throw new ScannerException(ScannerUtils.getScannerResult(error.errorCode), error.errorCode, error.errorDescription);
        }
    }

    public Bundle getParams(Bundle parameters) throws ScannerException {
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        Bundle retValue = new Bundle();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().scnGetParams(this.scannerInfo.scannerIndex, parameters);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("API-Service error in getParams() " + e.getMessage()));
            }
        }
        int errorCode = retValue.getInt("ERROR_CODE");
        if (ScannerResults.SUCCESS.getValue() != errorCode) {
            throw new ScannerException(ScannerUtils.getScannerResult(errorCode), errorCode);
        }
        return retValue.getBundle("PARAM_BUNDLE");
    }

    public void setParams(Bundle parameters) throws ScannerException {
        if (this.isReleased) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        int retValue = ScannerResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().scnSetParams(this.scannerInfo.scannerIndex, parameters);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("API-Service error in setParams() " + e.getMessage()));
            }
        }
        if (ScannerResults.SUCCESS.getValue() != retValue) {
            throw new ScannerException(ScannerUtils.getScannerResult(retValue), retValue);
        }
    }

    public static enum TriggerType {
        HARD(0),
        SOFT_ONCE(1),
        SOFT_ALWAYS(2);

        int id = 0;

        private TriggerType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static interface StatusListener {
        public void onStatus(StatusData var1);
    }

    public static interface DataListener {
        public void onData(ScanDataCollection var1);
    }
}

