/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import android.os.Bundle;
import android.util.Log;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.ScannerException;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.emdkservice.barcode.SvcScannerConfig;
import java.util.HashMap;
import java.util.Locale;

public class ScannerConfig {
    private static final String TAG = "Scanner_Config";
    private HashMap<String, Boolean> supportedParamList = new HashMap();
    public SkipOnUnSupported skipOnUnsupported = SkipOnUnSupported.UNSUPPORTED_PARAM;
    private Bundle paramBundle = null;
    private Bundle paramBundleModified;
    InterfaceParams interfaceParams = new InterfaceParams();
    public ScanParams scanParams = new ScanParams();
    public DecoderParams decoderParams = new DecoderParams();
    public ReaderParams readerParams = new ReaderParams();
    public NGSimulScanParams ngSimulScanParams = new NGSimulScanParams();
    @Deprecated
    public UdiParams udiParams = new UdiParams();
    @Deprecated
    public MultiBarcodeParams multiBarcodeParams = new MultiBarcodeParams();
    public OcrParams ocrParams = new OcrParams();

    ScannerConfig() {
    }

    public boolean isParamSupported(String param) {
        boolean isSupported = false;
        try {
            int index = param.indexOf(".");
            if (index != -1) {
                String temp = param.substring(index + 1);
                Boolean isSupportedObj = this.supportedParamList.get(temp.toLowerCase(Locale.ENGLISH));
                if (isSupportedObj != null) {
                    isSupported = isSupportedObj;
                }
            } else if (this.paramBundle != null && this.paramBundle.containsKey(param.toLowerCase(Locale.ENGLISH))) {
                isSupported = true;
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("" + ex.getMessage()));
        }
        return isSupported;
    }

    public void resetToDefault(Scanner scanner) throws ScannerException {
        if (scanner == null) {
            throw new ScannerException(ScannerResults.INVALID_VALUE);
        }
        if (scanner.isReleased()) {
            throw new ScannerException(ScannerResults.INVALID_OBJECT);
        }
        if (!scanner.isEnabled()) {
            throw new ScannerException(ScannerResults.SCANNER_NOT_ENABLED);
        }
        SvcScannerConfig svcCfg = scanner.getDefaultConfig();
        if (null != svcCfg) {
            this.updateScannerConfig(svcCfg);
        }
    }

    void updateScannerConfig(SvcScannerConfig svcScnCfg) {
        this.interfaceParams.updateParams(svcScnCfg.interfaceParams);
        this.scanParams.updateParams(svcScnCfg.scanParams);
        this.readerParams.updateParams(svcScnCfg.readerParams);
        this.decoderParams.updateParams(svcScnCfg.decoderParams);
        this.udiParams.updateParams(svcScnCfg.udiParams);
        this.ocrParams.updateParams(svcScnCfg.ocrParams);
        this.multiBarcodeParams.updateParams(svcScnCfg.multiBarcodeParams);
        this.ngSimulScanParams.updateParams(svcScnCfg.ngSimulScanParams);
        if (null != this.supportedParamList) {
            this.supportedParamList.clear();
        }
        this.supportedParamList = null;
        this.supportedParamList = svcScnCfg.supportedParamList;
        if (null != this.paramBundle) {
            this.paramBundle.clear();
        }
        this.paramBundle = null;
        this.paramBundle = svcScnCfg.getParamBundle();
    }

    void updateSvcScannerConfig(SvcScannerConfig svcScnCfg) {
        svcScnCfg.skipOnUnsupported = SvcScannerConfig.SkipOnUnSupported.values()[this.skipOnUnsupported.ordinal()];
        this.interfaceParams.updateSvcParams(svcScnCfg.interfaceParams);
        this.scanParams.updateSvcParams(svcScnCfg.scanParams);
        this.readerParams.updateSvcParams(svcScnCfg.readerParams);
        this.decoderParams.updateSvcParams(svcScnCfg.decoderParams);
        this.udiParams.updateSvcParams(svcScnCfg.udiParams);
        this.ocrParams.updateSvcParams(svcScnCfg.ocrParams);
        this.multiBarcodeParams.updateSvcParams(svcScnCfg.multiBarcodeParams);
        this.ngSimulScanParams.updateSvcParams(svcScnCfg.ngSimulScanParams);
        svcScnCfg.setModifiedParamBundle(this.paramBundleModified);
    }

    private int[] getOrdinalsFromAutoCharacterSetPreference(AutoCharacterSetPreference[] autoCharaSetPreference) {
        int[] ordinalArray = null;
        if (autoCharaSetPreference != null) {
            ordinalArray = new int[autoCharaSetPreference.length];
            for (int i = 0; i < ordinalArray.length; ++i) {
                if (autoCharaSetPreference[i] == null) continue;
                ordinalArray[i] = autoCharaSetPreference[i].ordinal();
            }
        }
        return ordinalArray;
    }

    private AutoCharacterSetPreference[] getValuesFromAutoCharacterSetPreference(int[] ordinalArray) {
        AutoCharacterSetPreference[] enumValues = null;
        if (ordinalArray != null) {
            enumValues = new AutoCharacterSetPreference[ordinalArray.length];
            for (int i = 0; i < enumValues.length; ++i) {
                enumValues[i] = AutoCharacterSetPreference.values()[ordinalArray[i]];
            }
        }
        return enumValues;
    }

    private int[] getOrdinalsFromSvcAutoCharacterSetPreference(SvcScannerConfig.AutoCharacterSetPreference[] autoCharaSetPreference) {
        int[] ordinalArray = null;
        if (autoCharaSetPreference != null) {
            ordinalArray = new int[autoCharaSetPreference.length];
            for (int i = 0; i < ordinalArray.length; ++i) {
                ordinalArray[i] = autoCharaSetPreference[i].ordinal();
            }
        }
        return ordinalArray;
    }

    private SvcScannerConfig.AutoCharacterSetPreference[] getValuesFromSvcAutoCharacterSetPreference(int[] ordinalArray) {
        SvcScannerConfig.AutoCharacterSetPreference[] enumValues = null;
        if (ordinalArray != null) {
            enumValues = new SvcScannerConfig.AutoCharacterSetPreference[ordinalArray.length];
            for (int i = 0; i < ordinalArray.length; ++i) {
                enumValues[i] = SvcScannerConfig.AutoCharacterSetPreference.values()[ordinalArray[i]];
            }
        }
        return enumValues;
    }

    public static enum NGSimulScanMode {
        NONE(1),
        MULTI_BARCODE(3);

        private final int id;

        private NGSimulScanMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrCheckDigitValidation {
        NONE(0),
        PRODUCT_ADD_RIGHT_TO_LEFT(1),
        DIGIT_ADD_RIGHT_TO_LEFT(2),
        PRODUCT_ADD_LEFT_TO_RIGHT(3),
        DIGIT_ADD_LEFT_TO_RIGHT(4),
        PRODUCT_ADD_RIGHT_TO_LEFT_SIMPLE_REMAINDER(5),
        DIGIT_ADD_RIGHT_TO_LEFT_SIMPLE_REMAINDER(6),
        HEALTH_INDUSTRY_HIBCC43(9);

        private final int id;

        private OcrCheckDigitValidation(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrOrientation {
        DEGREE_0(0),
        DEGREE_270(1),
        DEGREE_180(2),
        DEGREE_90(3),
        OMNIDIRECTIONAL(4);

        private final int id;

        private OcrOrientation(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PresentationModeSensitivity {
        LOW(80),
        MEDIUM(120),
        HIGH(190);

        private final int id;

        private PresentationModeSensitivity(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DpmIlluminationControl {
        DIRECT(0),
        INDIRECT(11),
        CYCLE(10);

        private final int id;

        private DpmIlluminationControl(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DpmModes {
        DISABLED(0),
        MODE_1(1),
        MODE_2(2);

        private final int id;

        private DpmModes(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SignatureImageBitsPerPixel {
        BPP_1(0),
        BPP_4(1),
        BPP_8(2);

        private final int id;

        private SignatureImageBitsPerPixel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SignatureImageFormat {
        JPEG(1),
        BMP(3),
        TIFF(4);

        private final int id;

        private SignatureImageFormat(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum GridMatrixMirror {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private GridMatrixMirror(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum GridMatrixInverse {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private GridMatrixInverse(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DotCodeMirror {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private DotCodeMirror(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DotCodeInverse {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private DotCodeInverse(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SceneDetectionQualifier {
        NONE(0),
        PROXIMITY_SENSOR_INPUT(1);

        private final int id;

        private SceneDetectionQualifier(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AutoCharacterSetPreference {
        UTF_8("UTF-8"),
        GB2312("GB2312");

        private final String id;

        private AutoCharacterSetPreference(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum AutoCharacterSetFailureOption {
        NONE("NONE"),
        UTF_8("UTF-8"),
        ISO_8859_1("ISO-8859-1"),
        Shift_JIS("Shift_JIS"),
        GB18030("GB18030");

        private final String id;

        private AutoCharacterSetFailureOption(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum CharacterSet {
        AUTO("AUTO"),
        UTF_8("UTF-8"),
        ISO_8859_1("ISO-8859-1"),
        Shift_JIS("Shift_JIS"),
        GB18030("GB18030");

        private final String id;

        private CharacterSet(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum OcrLines {
        ONE_LINE(1),
        TWO_LINES(2),
        THREE_LINES(3);

        private final int id;

        private OcrLines(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum InverseOcr {
        REGULAR_ONLY(0),
        INVERSE_ONLY(1),
        AUTO_DISCRIMINATE(2);

        private final int id;

        private InverseOcr(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrBVariant {
        FULL_ASCII(0),
        BANKING(1),
        LIMITED(2),
        ISBN_1(6),
        ISBN_2(7),
        TRAVEL_DOCUMENT_1(3),
        TRAVEL_DOCUMENT_2(8),
        TRAVEL_DOCUMENT_3(20),
        PASSPORT(4),
        VISA_TYPE_A(9),
        VISA_TYPE_B(10),
        ICAO_TRAVEL_DOCUMENT(11);

        private final int id;

        private OcrBVariant(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrAVariant {
        FULL_ASCII(0),
        RESERVED_1(1),
        RESERVED_2(2),
        BANKING(3);

        private final int id;

        private OcrAVariant(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum ScanMode {
        SINGLE_BARCODE(1),
        UDI(2),
        MULTI_BARCODE(3);

        private final int id;

        private ScanMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PairAfterScannerReboot {
        DISABLE(0),
        ENABLE(1);

        private final int id;

        private PairAfterScannerReboot(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AimType {
        TRIGGER(0),
        TIMED_HOLD(1),
        TIMED_RELEASE(2),
        PRESS_AND_RELEASE(3),
        PRESENTATION(4),
        CONTINUOUS_READ(5),
        PRESS_AND_SUSTAIN(6);

        private final int id;

        private AimType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum GS1LimitedSecurityLevel {
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3),
        LEVEL_4(4);

        private final int id;

        private GS1LimitedSecurityLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum BeamWidth {
        NARROW(0),
        NORMAL(1),
        WIDE(2);

        private final int id;

        private BeamWidth(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AdaptiveScanning {
        ENABLE(0),
        DISABLE(1);

        private final int id;

        private AdaptiveScanning(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PoorQualityDecodeEffortLevel {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private final int id;

        private PoorQualityDecodeEffortLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OneDQuietZoneLevel {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private final int id;

        private OneDQuietZoneLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DecodeAudioFeedbackMode {
        LOCAL(0),
        REMOTE(1),
        BOTH(2),
        DISABLE(3);

        private final int id;

        private DecodeAudioFeedbackMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DecodeLEDFeedbackMode {
        LOCAL(0),
        REMOTE(1),
        BOTH(2),
        DISABLE(3);

        private final int id;

        private DecodeLEDFeedbackMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AimingPattern {
        OFF("off"),
        ON("on");

        private final String id;

        private AimingPattern(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum SkipOnUnSupported {
        NONE,
        UNSUPPORTED_PARAM,
        UNSUPPORTED_VALUE,
        ALL;

    }

    public static enum PowerMode {
        LOW(0),
        OPTIMIZED(1),
        HIGH(2),
        ALWAYS_ON(3);

        private final int id;

        private PowerMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AudioStreamType {
        RINGER(0),
        MEDIA(1),
        ALARAMS(2);

        private final int id;

        private AudioStreamType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum Inverse1DMode {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private Inverse1DMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum LcdMode {
        DISABLED(0),
        ENABLED(1);

        private final int id;

        private LcdMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum IlluminationMode {
        OFF("off"),
        ON("torch");

        private final String id;

        private IlluminationMode(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum ViewFinderMode {
        ENABLED(1),
        STATIC_RECTICLE(2);

        private final int id;

        private ViewFinderMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum BooklandFormat {
        ISBN_10(0),
        ISBN_13(1);

        private final int id;

        private BooklandFormat(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CouponReport {
        OLD(0),
        NEW(1),
        BOTH(2);

        private final int id;

        private CouponReport(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SupplementalMode {
        NO(0),
        ALWAYS(1),
        AUTO(2),
        SMART(3),
        S_378_379(4),
        S_978_979(5),
        S_414_419_434_439(6),
        S_977(7);

        private final int id;

        private SupplementalMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CodeIdType {
        NONE(0),
        AIM(1),
        SYMBOL(2);

        private final int id;

        private CodeIdType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PicklistEx {
        DISABLED(0),
        HARDWARE(1),
        SOFTWARE(2);

        private final int id;

        private PicklistEx(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum PickList {
        DISABLED(0),
        ENABLED(1);

        private final int id;

        private PickList(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum UccLinkMode {
        LINK_FLAG_IGNORED(0),
        ALWAYS_LINKED(1),
        AUTO_DISCRIMINATE(2);

        private final int id;

        private UccLinkMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CheckDigitScheme {
        MOD_11_10(0),
        MOD_10_10(1);

        private final int id;

        private CheckDigitScheme(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum VerifyCheckDigit {
        NO(0),
        ONE(1),
        TWO(2);

        private final int id;

        private VerifyCheckDigit(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CheckDigit {
        ONE(0),
        TWO(1);

        private final int id;

        private CheckDigit(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CheckDigitType {
        NO(0),
        USS(1),
        OPCC(2);

        private final int id;

        private CheckDigitType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum LinearSecurityLevel {
        SHORT_OR_CODABAR(1),
        ALL_TWICE(2),
        LONG_AND_SHORT(3),
        ALL_THRICE(4);

        private final int id;

        private LinearSecurityLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SecurityLevel {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private final int id;

        private SecurityLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum HanXinInverse {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private HanXinInverse(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum Isbt128ContactMode {
        NEVER(0),
        ALWAYS(1),
        AUTO(2);

        private final int id;

        private Isbt128ContactMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum Preamble {
        NONE(0),
        SYS_CHAR(1),
        COUNTRY_AND_SYS_CHAR(2);

        private final int id;

        private Preamble(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public class NGSimulScanParams {
        public NGSimulScanMode ngSimulScanMode = NGSimulScanMode.NONE;
        public MultiBarcodeParams multiBarcodeParams = new MultiBarcodeParams();
        private TemplateParams templateParams = new TemplateParams();

        NGSimulScanParams() {
        }

        void updateParams(SvcScannerConfig.NGSimulScanParams svcParam) {
            this.ngSimulScanMode = NGSimulScanMode.values()[svcParam.ngSimulScanMode.ordinal()];
            this.multiBarcodeParams.updateParams(svcParam.multiBarcodeParams);
            this.templateParams.updateParams(svcParam.templateParams);
        }

        void updateSvcParams(SvcScannerConfig.NGSimulScanParams svcParam) {
            svcParam.ngSimulScanMode = SvcScannerConfig.NGSimulScanMode.values()[this.ngSimulScanMode.ordinal()];
            this.multiBarcodeParams.updateSvcParams(svcParam.multiBarcodeParams);
            this.templateParams.updateSvcParams(svcParam.templateParams);
        }

        private class TemplateParams {
            public int templateID = 0;

            TemplateParams() {
            }

            void updateParams(SvcScannerConfig.NGSimulScanParams.TemplateParams svcParam) {
                this.templateID = svcParam.templateID;
            }

            void updateSvcParams(SvcScannerConfig.NGSimulScanParams.TemplateParams svcParam) {
                svcParam.templateID = this.templateID;
            }
        }

        public class MultiBarcodeParams {
            public int barcodeCount = 5;
            public boolean instantReporting = false;
            public boolean reportDecodedBarcodes = false;

            MultiBarcodeParams() {
            }

            void updateParams(SvcScannerConfig.NGSimulScanParams.MultiBarcodeParams svcParam) {
                this.barcodeCount = svcParam.barcodeCount;
                this.instantReporting = svcParam.instantReporting;
                this.reportDecodedBarcodes = svcParam.reportDecodedBarcodes;
            }

            void updateSvcParams(SvcScannerConfig.NGSimulScanParams.MultiBarcodeParams svcParam) {
                svcParam.barcodeCount = this.barcodeCount;
                svcParam.instantReporting = this.instantReporting;
                svcParam.reportDecodedBarcodes = this.reportDecodedBarcodes;
            }
        }
    }

    public class OcrParams {
        public InverseOcr inverseOcr = InverseOcr.REGULAR_ONLY;
        public OcrLines ocrLines = OcrLines.ONE_LINE;
        public int maxCharacters = 100;
        public int minCharacters = 3;
        public int quietZone = 50;
        public String template = "99999999";
        public OcrOrientation orientation = OcrOrientation.DEGREE_0;
        public String subset = "";
        public int checkDigitModulus = 1;
        public String checkDigitMultiplier = "121212121212";
        public OcrCheckDigitValidation checkDigitValidation = OcrCheckDigitValidation.NONE;

        OcrParams() {
        }

        void updateParams(SvcScannerConfig.OcrParams svcParam) {
            this.inverseOcr = InverseOcr.values()[svcParam.inverseOcr.ordinal()];
            this.ocrLines = OcrLines.values()[svcParam.ocrLines.ordinal()];
            this.maxCharacters = svcParam.maxCharacters;
            this.minCharacters = svcParam.minCharacters;
            this.quietZone = svcParam.quietZone;
            this.template = svcParam.template;
            this.orientation = OcrOrientation.values()[svcParam.orientation.ordinal()];
            this.subset = svcParam.subset;
            this.checkDigitModulus = svcParam.checkDigitModulus;
            this.checkDigitMultiplier = svcParam.checkDigitMultiplier;
            this.checkDigitValidation = OcrCheckDigitValidation.values()[svcParam.checkDigitValidation.ordinal()];
        }

        void updateSvcParams(SvcScannerConfig.OcrParams svcParam) {
            svcParam.inverseOcr = SvcScannerConfig.InverseOcr.values()[this.inverseOcr.ordinal()];
            svcParam.ocrLines = SvcScannerConfig.OcrLines.values()[this.ocrLines.ordinal()];
            svcParam.maxCharacters = this.maxCharacters;
            svcParam.minCharacters = this.minCharacters;
            svcParam.quietZone = this.quietZone;
            svcParam.template = this.template;
            svcParam.orientation = SvcScannerConfig.OcrOrientation.values()[this.orientation.ordinal()];
            svcParam.subset = this.subset;
            svcParam.checkDigitModulus = this.checkDigitModulus;
            svcParam.checkDigitMultiplier = this.checkDigitMultiplier;
            svcParam.checkDigitValidation = SvcScannerConfig.OcrCheckDigitValidation.values()[this.checkDigitValidation.ordinal()];
        }
    }

    @Deprecated
    public class MultiBarcodeParams {
        @Deprecated
        public int barcodeCount = 5;
        @Deprecated
        public boolean instantReporting = false;
        @Deprecated
        public boolean reportDecodedBarcodes = false;

        MultiBarcodeParams() {
        }

        void updateParams(SvcScannerConfig.MultiBarcodeParams svcParam) {
            this.barcodeCount = svcParam.barcodeCount;
            this.instantReporting = svcParam.instantReporting;
            this.reportDecodedBarcodes = svcParam.reportDecodedBarcodes;
        }

        void updateSvcParams(SvcScannerConfig.MultiBarcodeParams svcParam) {
            svcParam.barcodeCount = this.barcodeCount;
            svcParam.instantReporting = this.instantReporting;
            svcParam.reportDecodedBarcodes = this.reportDecodedBarcodes;
        }
    }

    @Deprecated
    public class UdiParams {
        @Deprecated
        public boolean enableGS1 = true;
        @Deprecated
        public boolean enableHIBCC = true;
        @Deprecated
        public boolean enableICCBBA = true;

        UdiParams() {
        }

        void updateParams(SvcScannerConfig.UdiParams svcParam) {
            this.enableGS1 = svcParam.enableGS1;
            this.enableHIBCC = svcParam.enableHIBCC;
            this.enableICCBBA = svcParam.enableICCBBA;
        }

        void updateSvcParams(SvcScannerConfig.UdiParams svcParam) {
            svcParam.enableGS1 = this.enableGS1;
            svcParam.enableHIBCC = this.enableHIBCC;
            svcParam.enableICCBBA = this.enableICCBBA;
        }
    }

    public class ReaderParams {
        public ReaderSpecific readerSpecific = new ReaderSpecific();

        ReaderParams() {
        }

        void updateParams(SvcScannerConfig.ReaderParams svcParam) {
            this.readerSpecific.updateParams(svcParam.readerSpecific);
        }

        void updateSvcParams(SvcScannerConfig.ReaderParams svcParam) {
            this.readerSpecific.updateSvcParams(svcParam.readerSpecific);
        }

        public class ReaderSpecific {
            public ImagerSpecific imagerSpecific = new ImagerSpecific();
            public CameraSpecific cameraSpecific = new CameraSpecific();
            public LaserSpecific laserSpecific = new LaserSpecific();

            void updateParams(SvcScannerConfig.ReaderParams.ReaderSpecific svcParam) {
                this.imagerSpecific.updateParams(svcParam.imagerSpecific);
                this.cameraSpecific.updateParams(svcParam.cameraSpecific);
                this.laserSpecific.updateParams(svcParam.laserSpecific);
            }

            void updateSvcParams(SvcScannerConfig.ReaderParams.ReaderSpecific svcParam) {
                this.imagerSpecific.updateSvcParams(svcParam.imagerSpecific);
                this.cameraSpecific.updateSvcParams(svcParam.cameraSpecific);
                this.laserSpecific.updateSvcParams(svcParam.laserSpecific);
            }

            public class LaserSpecific {
                @Deprecated
                public ContinuousRead continuousRead;
                public int beamTimer;
                public LinearSecurityLevel linearSecurityLevel;
                public Inverse1DMode inverse1DMode;
                public PowerMode powerMode;
                public OneDQuietZoneLevel oneDQuietZoneLevel;
                public PoorQualityDecodeEffortLevel poorQualityDecodeEffortLevel;
                public AdaptiveScanning adaptiveScanning;
                public BeamWidth beamWidth;
                public AimType aimType;
                public int aimTimer;
                public int sameSymbolTimeout;
                public int differentSymbolTimeout;
                public CharacterSet characterSetSelection;
                public AutoCharacterSetFailureOption autoCharacterSetFailureOption;
                public AutoCharacterSetPreference[] autoCharacterSetPreferredOrder;
                public boolean disconnectOnExit;
                public int connectionIdleTime;
                public PairAfterScannerReboot pairAfterScannerReboot;

                LaserSpecific() {
                    this.continuousRead = new ContinuousRead();
                    this.linearSecurityLevel = LinearSecurityLevel.ALL_TWICE;
                    this.inverse1DMode = Inverse1DMode.DISABLED;
                    this.powerMode = PowerMode.OPTIMIZED;
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.LEVEL_1;
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.LEVEL_0;
                    this.adaptiveScanning = AdaptiveScanning.ENABLE;
                    this.beamWidth = BeamWidth.NORMAL;
                    this.aimType = AimType.TRIGGER;
                    this.aimTimer = 0;
                    this.sameSymbolTimeout = 500;
                    this.differentSymbolTimeout = 500;
                    this.characterSetSelection = CharacterSet.UTF_8;
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.UTF_8;
                    this.autoCharacterSetPreferredOrder = new AutoCharacterSetPreference[]{AutoCharacterSetPreference.UTF_8, AutoCharacterSetPreference.GB2312};
                    this.disconnectOnExit = false;
                    this.connectionIdleTime = 600;
                    this.pairAfterScannerReboot = PairAfterScannerReboot.ENABLE;
                }

                void updateParams(SvcScannerConfig.ReaderParams.ReaderSpecific.LaserSpecific svcParam) {
                    this.beamTimer = svcParam.beamTimer;
                    this.linearSecurityLevel = LinearSecurityLevel.values()[svcParam.linearSecurityLevel.ordinal()];
                    this.inverse1DMode = Inverse1DMode.values()[svcParam.inverse1DMode.ordinal()];
                    this.powerMode = PowerMode.values()[svcParam.powerMode.ordinal()];
                    switch (svcParam.continuousAimType) {
                        case CONTINUOUS_READ: {
                            this.continuousRead.isContinuousScan = true;
                            break;
                        }
                        case DUALTRIGGER: {
                            this.continuousRead.isContinuousScan = false;
                        }
                    }
                    this.continuousRead.sameSymbolTimeout = svcParam.continuousSameSymbolTimeout;
                    this.continuousRead.differentSymbolTimeout = svcParam.continuousDifferentSymbolTimeout;
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.values()[svcParam.oneDQuietZoneLevel.ordinal()];
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.values()[svcParam.poorQualityDecodeEffortLevel.ordinal()];
                    this.adaptiveScanning = AdaptiveScanning.values()[svcParam.adaptiveScanning.ordinal()];
                    this.beamWidth = BeamWidth.values()[svcParam.beamWidth.ordinal()];
                    this.aimType = AimType.values()[svcParam.aimType.ordinal()];
                    this.aimTimer = svcParam.aimTimer;
                    this.sameSymbolTimeout = svcParam.sameSymbolTimeout;
                    this.differentSymbolTimeout = svcParam.differentSymbolTimeout;
                    this.characterSetSelection = CharacterSet.values()[svcParam.characterSetSelection.ordinal()];
                    this.autoCharacterSetPreferredOrder = ScannerConfig.this.getValuesFromAutoCharacterSetPreference(ScannerConfig.this.getOrdinalsFromSvcAutoCharacterSetPreference(svcParam.autoCharacterSetPreferredOrder));
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.values()[svcParam.autoCharacterSetFailureOption.ordinal()];
                    this.disconnectOnExit = svcParam.disconnectOnExit;
                    this.connectionIdleTime = svcParam.connectionIdleTime;
                    this.pairAfterScannerReboot = PairAfterScannerReboot.values()[svcParam.pairAfterScannerReboot.ordinal()];
                }

                void updateSvcParams(SvcScannerConfig.ReaderParams.ReaderSpecific.LaserSpecific svcParam) {
                    svcParam.beamTimer = this.beamTimer;
                    svcParam.linearSecurityLevel = SvcScannerConfig.LinearSecurityLevel.values()[this.linearSecurityLevel.ordinal()];
                    svcParam.inverse1DMode = SvcScannerConfig.Inverse1DMode.values()[this.inverse1DMode.ordinal()];
                    svcParam.powerMode = SvcScannerConfig.PowerMode.values()[this.powerMode.ordinal()];
                    svcParam.continuousAimType = this.continuousRead.isContinuousScan ? SvcScannerConfig.AimType.CONTINUOUS_READ : SvcScannerConfig.AimType.DUALTRIGGER;
                    svcParam.continuousSameSymbolTimeout = this.continuousRead.sameSymbolTimeout;
                    svcParam.continuousDifferentSymbolTimeout = this.continuousRead.differentSymbolTimeout;
                    svcParam.oneDQuietZoneLevel = SvcScannerConfig.OneDQuietZoneLevel.values()[this.oneDQuietZoneLevel.ordinal()];
                    svcParam.poorQualityDecodeEffortLevel = SvcScannerConfig.PoorQualityDecodeEffortLevel.values()[this.poorQualityDecodeEffortLevel.ordinal()];
                    svcParam.adaptiveScanning = SvcScannerConfig.AdaptiveScanning.values()[this.adaptiveScanning.ordinal()];
                    svcParam.beamWidth = SvcScannerConfig.BeamWidth.values()[this.beamWidth.ordinal()];
                    svcParam.aimType = SvcScannerConfig.AimType.values()[this.aimType.ordinal()];
                    svcParam.aimTimer = this.aimTimer;
                    svcParam.sameSymbolTimeout = this.sameSymbolTimeout;
                    svcParam.differentSymbolTimeout = this.differentSymbolTimeout;
                    svcParam.characterSetSelection = SvcScannerConfig.CharacterSetSelection.values()[this.characterSetSelection.ordinal()];
                    svcParam.autoCharacterSetPreferredOrder = ScannerConfig.this.getValuesFromSvcAutoCharacterSetPreference(ScannerConfig.this.getOrdinalsFromAutoCharacterSetPreference(this.autoCharacterSetPreferredOrder));
                    svcParam.autoCharacterSetFailureOption = SvcScannerConfig.AutoCharacterSetFailureOption.values()[this.autoCharacterSetFailureOption.ordinal()];
                    svcParam.disconnectOnExit = this.disconnectOnExit;
                    svcParam.connectionIdleTime = this.connectionIdleTime;
                    svcParam.pairAfterScannerReboot = SvcScannerConfig.PairAfterScannerReboot.values()[this.pairAfterScannerReboot.ordinal()];
                }
            }

            public class CameraSpecific {
                @Deprecated
                public ContinuousRead continuousRead;
                public int beamTimer;
                public int viewfinderSize;
                public int viewfinderOffsetX;
                public int viewfinderOffsetY;
                public LinearSecurityLevel linearSecurityLevel;
                public IlluminationMode illuminationMode;
                public Inverse1DMode inverse1DMode;
                public ViewFinderMode viewfinderMode;
                public OneDQuietZoneLevel oneDQuietZoneLevel;
                public PoorQualityDecodeEffortLevel poorQualityDecodeEffortLevel;
                public PicklistEx picklistEx;
                public AimType aimType;
                public int aimTimer;
                public int sameSymbolTimeout;
                public int differentSymbolTimeout;
                public CharacterSet characterSetSelection;
                public AutoCharacterSetFailureOption autoCharacterSetFailureOption;
                public AutoCharacterSetPreference[] autoCharacterSetPreferredOrder;
                @Deprecated
                public ScanMode scanMode;
                public int zoom;
                public boolean digimarcDecoding;

                CameraSpecific() {
                    this.continuousRead = new ContinuousRead();
                    this.linearSecurityLevel = LinearSecurityLevel.ALL_TWICE;
                    this.illuminationMode = IlluminationMode.OFF;
                    this.inverse1DMode = Inverse1DMode.DISABLED;
                    this.viewfinderMode = ViewFinderMode.STATIC_RECTICLE;
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.LEVEL_1;
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.LEVEL_0;
                    this.picklistEx = PicklistEx.DISABLED;
                    this.aimType = AimType.TRIGGER;
                    this.aimTimer = 0;
                    this.sameSymbolTimeout = 500;
                    this.differentSymbolTimeout = 500;
                    this.characterSetSelection = CharacterSet.UTF_8;
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.UTF_8;
                    this.autoCharacterSetPreferredOrder = new AutoCharacterSetPreference[]{AutoCharacterSetPreference.UTF_8, AutoCharacterSetPreference.GB2312};
                    this.scanMode = ScanMode.SINGLE_BARCODE;
                    this.zoom = 1;
                    this.digimarcDecoding = true;
                }

                void updateParams(SvcScannerConfig.ReaderParams.ReaderSpecific.CameraSpecific svcParam) {
                    this.beamTimer = svcParam.beamTimer;
                    this.linearSecurityLevel = LinearSecurityLevel.values()[svcParam.linearSecurityLevel.ordinal()];
                    this.illuminationMode = IlluminationMode.values()[svcParam.illuminationMode.ordinal()];
                    this.inverse1DMode = Inverse1DMode.values()[svcParam.inverse1DMode.ordinal()];
                    this.viewfinderMode = ViewFinderMode.values()[svcParam.viewfinderMode.ordinal()];
                    switch (svcParam.continuousAimType) {
                        case CONTINUOUS_READ: {
                            this.continuousRead.isContinuousScan = true;
                            break;
                        }
                        case DUALTRIGGER: {
                            this.continuousRead.isContinuousScan = false;
                        }
                    }
                    this.continuousRead.sameSymbolTimeout = svcParam.continuousSameSymbolTimeout;
                    this.continuousRead.differentSymbolTimeout = svcParam.continuousDifferentSymbolTimeout;
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.values()[svcParam.oneDQuietZoneLevel.ordinal()];
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.values()[svcParam.poorQualityDecodeEffortLevel.ordinal()];
                    this.viewfinderSize = svcParam.viewfinderSize;
                    this.viewfinderOffsetX = svcParam.viewfinderOffsetX;
                    this.viewfinderOffsetY = svcParam.viewfinderOffsetY;
                    this.picklistEx = PicklistEx.values()[svcParam.picklistEx.ordinal()];
                    this.aimType = AimType.values()[svcParam.aimType.ordinal()];
                    this.aimTimer = svcParam.aimTimer;
                    this.sameSymbolTimeout = svcParam.sameSymbolTimeout;
                    this.differentSymbolTimeout = svcParam.differentSymbolTimeout;
                    this.characterSetSelection = CharacterSet.values()[svcParam.characterSetSelection.ordinal()];
                    this.autoCharacterSetPreferredOrder = ScannerConfig.this.getValuesFromAutoCharacterSetPreference(ScannerConfig.this.getOrdinalsFromSvcAutoCharacterSetPreference(svcParam.autoCharacterSetPreferredOrder));
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.values()[svcParam.autoCharacterSetFailureOption.ordinal()];
                    this.scanMode = ScanMode.values()[svcParam.scanMode.ordinal()];
                    this.zoom = svcParam.zoom;
                    this.digimarcDecoding = svcParam.digimarcDecoding;
                }

                void updateSvcParams(SvcScannerConfig.ReaderParams.ReaderSpecific.CameraSpecific svcParam) {
                    svcParam.beamTimer = this.beamTimer;
                    svcParam.linearSecurityLevel = SvcScannerConfig.LinearSecurityLevel.values()[this.linearSecurityLevel.ordinal()];
                    svcParam.illuminationMode = SvcScannerConfig.IlluminationMode.values()[this.illuminationMode.ordinal()];
                    svcParam.inverse1DMode = SvcScannerConfig.Inverse1DMode.values()[this.inverse1DMode.ordinal()];
                    svcParam.viewfinderMode = SvcScannerConfig.ViewFinderMode.values()[this.viewfinderMode.ordinal()];
                    svcParam.continuousAimType = this.continuousRead.isContinuousScan ? SvcScannerConfig.AimType.CONTINUOUS_READ : SvcScannerConfig.AimType.DUALTRIGGER;
                    svcParam.continuousSameSymbolTimeout = this.continuousRead.sameSymbolTimeout;
                    svcParam.continuousDifferentSymbolTimeout = this.continuousRead.differentSymbolTimeout;
                    svcParam.oneDQuietZoneLevel = SvcScannerConfig.OneDQuietZoneLevel.values()[this.oneDQuietZoneLevel.ordinal()];
                    svcParam.poorQualityDecodeEffortLevel = SvcScannerConfig.PoorQualityDecodeEffortLevel.values()[this.poorQualityDecodeEffortLevel.ordinal()];
                    svcParam.viewfinderSize = this.viewfinderSize;
                    svcParam.viewfinderOffsetX = this.viewfinderOffsetX;
                    svcParam.viewfinderOffsetY = this.viewfinderOffsetY;
                    svcParam.picklistEx = SvcScannerConfig.PicklistEx.values()[this.picklistEx.ordinal()];
                    svcParam.aimType = SvcScannerConfig.AimType.values()[this.aimType.ordinal()];
                    svcParam.aimTimer = this.aimTimer;
                    svcParam.sameSymbolTimeout = this.sameSymbolTimeout;
                    svcParam.differentSymbolTimeout = this.differentSymbolTimeout;
                    svcParam.characterSetSelection = SvcScannerConfig.CharacterSetSelection.values()[this.characterSetSelection.ordinal()];
                    svcParam.autoCharacterSetPreferredOrder = ScannerConfig.this.getValuesFromSvcAutoCharacterSetPreference(ScannerConfig.this.getOrdinalsFromAutoCharacterSetPreference(this.autoCharacterSetPreferredOrder));
                    svcParam.autoCharacterSetFailureOption = SvcScannerConfig.AutoCharacterSetFailureOption.values()[this.autoCharacterSetFailureOption.ordinal()];
                    svcParam.scanMode = SvcScannerConfig.ScanMode.values()[this.scanMode.ordinal()];
                    svcParam.zoom = this.zoom;
                    svcParam.digimarcDecoding = this.digimarcDecoding;
                }
            }

            public class ImagerSpecific {
                public PresentationModeParams presentationModeParams = new PresentationModeParams();
                @Deprecated
                public ContinuousRead continuousRead = new ContinuousRead();
                public int beamTimer;
                public LinearSecurityLevel linearSecurityLevel = LinearSecurityLevel.ALL_TWICE;
                @Deprecated
                public PickList pickList = PickList.DISABLED;
                public PicklistEx picklistEx = PicklistEx.DISABLED;
                public LcdMode lcdMode = LcdMode.DISABLED;
                public Inverse1DMode inverse1DMode = Inverse1DMode.AUTO;
                public int illuminationBrightness = 10;
                public boolean disconnectOnExit = false;
                public int connectionIdleTime = 600;
                public IlluminationMode illuminationMode = IlluminationMode.ON;
                public AimingPattern aimingPattern = AimingPattern.OFF;
                public OneDQuietZoneLevel oneDQuietZoneLevel = OneDQuietZoneLevel.LEVEL_1;
                public PoorQualityDecodeEffortLevel poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.LEVEL_0;
                public AimType aimType = AimType.TRIGGER;
                public int aimTimer = 0;
                public int sameSymbolTimeout = 500;
                public int differentSymbolTimeout = 500;
                public PairAfterScannerReboot pairAfterScannerReboot = PairAfterScannerReboot.ENABLE;
                @Deprecated
                public ScanMode scanMode = ScanMode.SINGLE_BARCODE;
                public boolean digimarcDecoding = true;
                public CharacterSet characterSetSelection = CharacterSet.UTF_8;
                public AutoCharacterSetFailureOption autoCharacterSetFailureOption = AutoCharacterSetFailureOption.UTF_8;
                public AutoCharacterSetPreference[] autoCharacterSetPreferredOrder = new AutoCharacterSetPreference[]{AutoCharacterSetPreference.UTF_8, AutoCharacterSetPreference.GB2312};
                public SceneDetectionQualifier sceneDetectionQualifier = SceneDetectionQualifier.NONE;
                public DpmModes dpmMode = DpmModes.MODE_2;
                public DpmIlluminationControl dpmIlluminationControl = DpmIlluminationControl.CYCLE;

                ImagerSpecific() {
                }

                void updateParams(SvcScannerConfig.ReaderParams.ReaderSpecific.ImagerSpecific svcParam) {
                    this.beamTimer = svcParam.beamTimer;
                    this.linearSecurityLevel = LinearSecurityLevel.values()[svcParam.linearSecurityLevel.ordinal()];
                    this.pickList = PickList.values()[svcParam.pickList.ordinal()];
                    this.lcdMode = LcdMode.values()[svcParam.lcdMode.ordinal()];
                    this.inverse1DMode = Inverse1DMode.values()[svcParam.inverse1DMode.ordinal()];
                    this.illuminationBrightness = svcParam.illuminationBrightness;
                    this.disconnectOnExit = svcParam.disconnectOnExit;
                    this.connectionIdleTime = svcParam.connectionIdleTime;
                    switch (svcParam.continuousAimType) {
                        case CONTINUOUS_READ: {
                            this.continuousRead.isContinuousScan = true;
                            break;
                        }
                        case DUALTRIGGER: {
                            this.continuousRead.isContinuousScan = false;
                        }
                    }
                    this.continuousRead.sameSymbolTimeout = svcParam.continuosSameSymbolTimeout;
                    this.continuousRead.differentSymbolTimeout = svcParam.continuousDifferentSymbolTimeout;
                    this.illuminationMode = IlluminationMode.values()[svcParam.illuminationMode.ordinal()];
                    this.aimingPattern = AimingPattern.values()[svcParam.aimingPattern.ordinal()];
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.values()[svcParam.oneDQuietZoneLevel.ordinal()];
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.values()[svcParam.poorQualityDecodeEffortLevel.ordinal()];
                    this.picklistEx = PicklistEx.values()[svcParam.picklistEx.ordinal()];
                    this.aimType = AimType.values()[svcParam.aimType.ordinal()];
                    this.aimTimer = svcParam.aimTimer;
                    this.sameSymbolTimeout = svcParam.sameSymbolTimeout;
                    this.differentSymbolTimeout = svcParam.differentSymbolTimeout;
                    this.pairAfterScannerReboot = PairAfterScannerReboot.values()[svcParam.pairAfterScannerReboot.ordinal()];
                    this.scanMode = ScanMode.values()[svcParam.scanMode.ordinal()];
                    this.digimarcDecoding = svcParam.digimarcDecoding;
                    this.characterSetSelection = CharacterSet.values()[svcParam.characterSetSelection.ordinal()];
                    this.autoCharacterSetPreferredOrder = ScannerConfig.this.getValuesFromAutoCharacterSetPreference(ScannerConfig.this.getOrdinalsFromSvcAutoCharacterSetPreference(svcParam.autoCharacterSetPreferredOrder));
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.values()[svcParam.autoCharacterSetFailureOption.ordinal()];
                    this.sceneDetectionQualifier = SceneDetectionQualifier.values()[svcParam.sceneDetectionQualifier.ordinal()];
                    this.dpmMode = DpmModes.values()[svcParam.dpmMode.ordinal()];
                    this.dpmIlluminationControl = DpmIlluminationControl.values()[svcParam.dpmIlluminationControl.ordinal()];
                    this.presentationModeParams.sensitivity = PresentationModeSensitivity.values()[svcParam.presentationModeParams.sensitivity.ordinal()];
                }

                void updateSvcParams(SvcScannerConfig.ReaderParams.ReaderSpecific.ImagerSpecific svcParam) {
                    svcParam.beamTimer = this.beamTimer;
                    svcParam.linearSecurityLevel = SvcScannerConfig.LinearSecurityLevel.values()[this.linearSecurityLevel.ordinal()];
                    svcParam.pickList = SvcScannerConfig.PickList.values()[this.pickList.ordinal()];
                    svcParam.lcdMode = SvcScannerConfig.LcdMode.values()[this.lcdMode.ordinal()];
                    svcParam.inverse1DMode = SvcScannerConfig.Inverse1DMode.values()[this.inverse1DMode.ordinal()];
                    svcParam.illuminationBrightness = this.illuminationBrightness;
                    svcParam.disconnectOnExit = this.disconnectOnExit;
                    svcParam.connectionIdleTime = this.connectionIdleTime;
                    svcParam.continuousAimType = this.continuousRead.isContinuousScan ? SvcScannerConfig.AimType.CONTINUOUS_READ : SvcScannerConfig.AimType.DUALTRIGGER;
                    svcParam.continuosSameSymbolTimeout = this.continuousRead.sameSymbolTimeout;
                    svcParam.continuousDifferentSymbolTimeout = this.continuousRead.differentSymbolTimeout;
                    svcParam.illuminationMode = SvcScannerConfig.IlluminationMode.values()[this.illuminationMode.ordinal()];
                    svcParam.aimingPattern = SvcScannerConfig.AimingPattern.values()[this.aimingPattern.ordinal()];
                    svcParam.oneDQuietZoneLevel = SvcScannerConfig.OneDQuietZoneLevel.values()[this.oneDQuietZoneLevel.ordinal()];
                    svcParam.poorQualityDecodeEffortLevel = SvcScannerConfig.PoorQualityDecodeEffortLevel.values()[this.poorQualityDecodeEffortLevel.ordinal()];
                    svcParam.picklistEx = SvcScannerConfig.PicklistEx.values()[this.picklistEx.ordinal()];
                    svcParam.aimType = SvcScannerConfig.AimType.values()[this.aimType.ordinal()];
                    svcParam.aimTimer = this.aimTimer;
                    svcParam.sameSymbolTimeout = this.sameSymbolTimeout;
                    svcParam.differentSymbolTimeout = this.differentSymbolTimeout;
                    svcParam.pairAfterScannerReboot = SvcScannerConfig.PairAfterScannerReboot.values()[this.pairAfterScannerReboot.ordinal()];
                    svcParam.scanMode = SvcScannerConfig.ScanMode.values()[this.scanMode.ordinal()];
                    svcParam.digimarcDecoding = this.digimarcDecoding;
                    svcParam.characterSetSelection = SvcScannerConfig.CharacterSetSelection.values()[this.characterSetSelection.ordinal()];
                    svcParam.autoCharacterSetPreferredOrder = ScannerConfig.this.getValuesFromSvcAutoCharacterSetPreference(ScannerConfig.this.getOrdinalsFromAutoCharacterSetPreference(this.autoCharacterSetPreferredOrder));
                    svcParam.autoCharacterSetFailureOption = SvcScannerConfig.AutoCharacterSetFailureOption.values()[this.autoCharacterSetFailureOption.ordinal()];
                    svcParam.sceneDetectionQualifier = SvcScannerConfig.SceneDetectionQualifier.values()[this.sceneDetectionQualifier.ordinal()];
                    svcParam.dpmMode = SvcScannerConfig.DpmModes.values()[this.dpmMode.ordinal()];
                    svcParam.dpmIlluminationControl = SvcScannerConfig.DpmIlluminationControl.values()[this.dpmIlluminationControl.ordinal()];
                    svcParam.presentationModeParams.sensitivity = SvcScannerConfig.PresentationModeSensitivity.values()[this.presentationModeParams.sensitivity.ordinal()];
                }

                public class PresentationModeParams {
                    public PresentationModeSensitivity sensitivity = PresentationModeSensitivity.HIGH;
                }
            }

            @Deprecated
            public class ContinuousRead {
                @Deprecated
                public boolean isContinuousScan = false;
                @Deprecated
                public int sameSymbolTimeout = 500;
                @Deprecated
                public int differentSymbolTimeout = 500;
            }
        }
    }

    public class DecoderParams {
        public AustralianPostal australianPostal = new AustralianPostal();
        public Aztec aztec = new Aztec();
        public CanadianPostal canadianPostal = new CanadianPostal();
        public Chinese2of5 chinese2of5 = new Chinese2of5();
        public CodaBar codaBar = new CodaBar();
        public Code11 code11 = new Code11();
        public Code128 code128 = new Code128();
        public Code39 code39 = new Code39();
        public Code93 code93 = new Code93();
        public CompositeAB compositeAB = new CompositeAB();
        public CompositeC compositeC = new CompositeC();
        public D2of5 d2of5 = new D2of5();
        public DataMatrix dataMatrix = new DataMatrix();
        public DutchPostal dutchPostal = new DutchPostal();
        public Ean13 ean13 = new Ean13();
        public Ean8 ean8 = new Ean8();
        public Gs1Databar gs1Databar = new Gs1Databar();
        public Gs1DatabarLim gs1DatabarLim = new Gs1DatabarLim();
        public Gs1DatabarExp gs1DatabarExp = new Gs1DatabarExp();
        public I2of5 i2of5 = new I2of5();
        public JapanesePostal japanesePostal = new JapanesePostal();
        public Korean3of5 korean3of5 = new Korean3of5();
        public Matrix2of5 matrix2of5 = new Matrix2of5();
        public MaxiCode maxiCode = new MaxiCode();
        public MicroPdf microPDF = new MicroPdf();
        public MicroQr microQR = new MicroQr();
        public Msi msi = new Msi();
        public Pdf417 pdf417 = new Pdf417();
        public QrCode qrCode = new QrCode();
        public Signature signature = new Signature();
        public Tlc39 tlc39 = new Tlc39();
        public TriOptic39 triOptic39 = new TriOptic39();
        public UkPostal ukPostal = new UkPostal();
        public Upca upca = new Upca();
        public Upce0 upce0 = new Upce0();
        public Upce1 upce1 = new Upce1();
        public UpcEanParams upcEanParams = new UpcEanParams();
        public Us4StateFics us4StateFics = new Us4StateFics();
        public Us4State us4State = new Us4State();
        public UsPlanet usPlanet = new UsPlanet();
        public UsPostNet usPostNet = new UsPostNet();
        public WebCode webCode = new WebCode();
        public MailMark mailMark = new MailMark();
        public HanXin hanXin = new HanXin();
        public OcrA ocrA = new OcrA();
        public OcrB ocrB = new OcrB();
        public Gs1Datamatrix gs1Datamatrix = new Gs1Datamatrix();
        public Gs1QrCode gs1QrCode = new Gs1QrCode();
        public DotCode dotCode = new DotCode();
        public GridMatrix gridMatrix = new GridMatrix();
        public MICRE13B micrE13B = new MICRE13B();
        public USCurrency usCurrency = new USCurrency();
        public FinnishPostal4S finnishPostal4S = new FinnishPostal4S();

        DecoderParams() {
        }

        void updateParams(SvcScannerConfig.DecoderParams svcParam) {
            this.australianPostal.updateParams(svcParam.australianPostal);
            this.aztec.updateParams(svcParam.aztec);
            this.canadianPostal.updateParams(svcParam.canadianPostal);
            this.chinese2of5.updateParams(svcParam.chinese2of5);
            this.codaBar.updateParams(svcParam.codaBar);
            this.code11.updateParams(svcParam.code11);
            this.code128.updateParams(svcParam.code128);
            this.code39.updateParams(svcParam.code39);
            this.code93.updateParams(svcParam.code93);
            this.compositeAB.updateParams(svcParam.compositeAB);
            this.compositeC.updateParams(svcParam.compositeC);
            this.d2of5.updateParams(svcParam.d2of5);
            this.dataMatrix.updateParams(svcParam.dataMatrix);
            this.dutchPostal.updateParams(svcParam.dutchPostal);
            this.ean13.updateParams(svcParam.ean13);
            this.ean8.updateParams(svcParam.ean8);
            this.gs1Databar.updateParams(svcParam.gs1Databar);
            this.gs1DatabarLim.updateParams(svcParam.gs1DatabarLim);
            this.gs1DatabarExp.updateParams(svcParam.gs1DatabarExp);
            this.i2of5.updateParams(svcParam.i2of5);
            this.japanesePostal.updateParams(svcParam.japanesePostal);
            this.korean3of5.updateParams(svcParam.korean3of5);
            this.matrix2of5.updateParams(svcParam.matrix2of5);
            this.maxiCode.updateParams(svcParam.maxiCode);
            this.microPDF.updateParams(svcParam.microPDF);
            this.microQR.updateParams(svcParam.microQR);
            this.msi.updateParams(svcParam.msi);
            this.pdf417.updateParams(svcParam.pdf417);
            this.qrCode.updateParams(svcParam.qrCode);
            this.signature.updateParams(svcParam.signature);
            this.tlc39.updateParams(svcParam.tlc39);
            this.triOptic39.updateParams(svcParam.triOptic39);
            this.ukPostal.updateParams(svcParam.ukPostal);
            this.upca.updateParams(svcParam.upca);
            this.upce0.updateParams(svcParam.upce0);
            this.upce1.updateParams(svcParam.upce1);
            this.upcEanParams.updateParams(svcParam.upcEanParams);
            this.us4State.updateParams(svcParam.us4State);
            this.usPlanet.updateParams(svcParam.usPlanet);
            this.usPostNet.updateParams(svcParam.usPostNet);
            this.webCode.updateParams(svcParam.webCode);
            this.mailMark.updateParams(svcParam.mailMark);
            this.hanXin.updateParams(svcParam.hanXin);
            this.ocrA.updateParams(svcParam.ocrA);
            this.ocrB.updateParams(svcParam.ocrB);
            this.gs1Datamatrix.updateParams(svcParam.gs1Datamatrix);
            this.gs1QrCode.updateParams(svcParam.gs1QrCode);
            this.dotCode.updateParams(svcParam.dotCode);
            this.gridMatrix.updateParams(svcParam.gridMatrix);
            this.micrE13B.updateParams(svcParam.micrE13B);
            this.usCurrency.updateParams(svcParam.usCurrency);
            this.finnishPostal4S.updateParams(svcParam.finnishPostal4S);
        }

        void updateSvcParams(SvcScannerConfig.DecoderParams svcParam) {
            this.australianPostal.updateSvcParams(svcParam.australianPostal);
            this.aztec.updateSvcParams(svcParam.aztec);
            this.canadianPostal.updateSvcParams(svcParam.canadianPostal);
            this.chinese2of5.updateSvcParams(svcParam.chinese2of5);
            this.codaBar.updateSvcParams(svcParam.codaBar);
            this.code11.updateSvcParams(svcParam.code11);
            this.code128.updateSvcParams(svcParam.code128);
            this.code39.updateSvcParams(svcParam.code39);
            this.code93.updateSvcParams(svcParam.code93);
            this.compositeAB.updateSvcParams(svcParam.compositeAB);
            this.compositeC.updateSvcParams(svcParam.compositeC);
            this.d2of5.updateSvcParams(svcParam.d2of5);
            this.dataMatrix.updateSvcParams(svcParam.dataMatrix);
            this.dutchPostal.updateSvcParams(svcParam.dutchPostal);
            this.ean13.updateSvcParams(svcParam.ean13);
            this.ean8.updateSvcParams(svcParam.ean8);
            this.gs1Databar.updateSvcParams(svcParam.gs1Databar);
            this.gs1DatabarLim.updateSvcParams(svcParam.gs1DatabarLim);
            this.gs1DatabarExp.updateSvcParams(svcParam.gs1DatabarExp);
            this.i2of5.updateSvcParams(svcParam.i2of5);
            this.japanesePostal.updateSvcParams(svcParam.japanesePostal);
            this.korean3of5.updateSvcParams(svcParam.korean3of5);
            this.matrix2of5.updateSvcParams(svcParam.matrix2of5);
            this.maxiCode.updateSvcParams(svcParam.maxiCode);
            this.microPDF.updateSvcParams(svcParam.microPDF);
            this.microQR.updateSvcParams(svcParam.microQR);
            this.msi.updateSvcParams(svcParam.msi);
            this.pdf417.updateSvcParams(svcParam.pdf417);
            this.qrCode.updateSvcParams(svcParam.qrCode);
            this.signature.updateSvcParams(svcParam.signature);
            this.tlc39.updateSvcParams(svcParam.tlc39);
            this.triOptic39.updateSvcParams(svcParam.triOptic39);
            this.ukPostal.updateSvcParams(svcParam.ukPostal);
            this.upca.updateSvcParams(svcParam.upca);
            this.upce0.updateSvcParams(svcParam.upce0);
            this.upce1.updateSvcParams(svcParam.upce1);
            this.upcEanParams.updateSvcParams(svcParam.upcEanParams);
            this.us4State.updateSvcParams(svcParam.us4State);
            this.usPlanet.updateSvcParams(svcParam.usPlanet);
            this.usPostNet.updateSvcParams(svcParam.usPostNet);
            this.webCode.updateSvcParams(svcParam.webCode);
            this.mailMark.updateSvcParams(svcParam.mailMark);
            this.hanXin.updateSvcParams(svcParam.hanXin);
            this.ocrA.updateSvcParams(svcParam.ocrA);
            this.ocrB.updateSvcParams(svcParam.ocrB);
            this.gs1Datamatrix.updateSvcParams(svcParam.gs1Datamatrix);
            this.gs1QrCode.updateSvcParams(svcParam.gs1QrCode);
            this.dotCode.updateSvcParams(svcParam.dotCode);
            this.gridMatrix.updateSvcParams(svcParam.gridMatrix);
            this.micrE13B.updateSvcParams(svcParam.micrE13B);
            this.usCurrency.updateSvcParams(svcParam.usCurrency);
            this.finnishPostal4S.updateSvcParams(svcParam.finnishPostal4S);
        }

        public class FinnishPostal4S
        extends BaseDecoder {
            public FinnishPostal4S() {
                this.enabled = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.FinnishPostal4S svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.FinnishPostal4S svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class USCurrency
        extends BaseDecoder {
            USCurrency() {
                this.enabled = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.USCurrency svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.USCurrency svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class MICRE13B
        extends BaseDecoder {
            MICRE13B() {
                this.enabled = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.MICRE13B svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.MICRE13B svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class GridMatrix
        extends BaseDecoder {
            public GridMatrixInverse inverse;
            public GridMatrixMirror mirror;

            GridMatrix() {
                this.inverse = GridMatrixInverse.DISABLED;
                this.mirror = GridMatrixMirror.AUTO;
            }

            void updateParams(SvcScannerConfig.DecoderParams.GridMatrix svcParam) {
                this.enabled = svcParam.enabled;
                this.inverse = GridMatrixInverse.values()[svcParam.inverse.ordinal()];
                this.mirror = GridMatrixMirror.values()[svcParam.mirror.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.GridMatrix svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.inverse = SvcScannerConfig.GridMatrixInverse.values()[this.inverse.ordinal()];
                svcParam.mirror = SvcScannerConfig.GridMatrixMirror.values()[this.mirror.ordinal()];
            }
        }

        public class DotCode
        extends BaseDecoder {
            public DotCodeInverse inverse;
            public DotCodeMirror mirror;

            DotCode() {
                this.inverse = DotCodeInverse.AUTO;
                this.mirror = DotCodeMirror.AUTO;
            }

            void updateParams(SvcScannerConfig.DecoderParams.DotCode svcParam) {
                this.enabled = svcParam.enabled;
                this.inverse = DotCodeInverse.values()[svcParam.inverse.ordinal()];
                this.mirror = DotCodeMirror.values()[svcParam.mirror.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.DotCode svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.inverse = SvcScannerConfig.DotCodeInverse.values()[this.inverse.ordinal()];
                svcParam.mirror = SvcScannerConfig.DotCodeMirror.values()[this.mirror.ordinal()];
            }
        }

        public class Gs1QrCode
        extends BaseDecoder {
            Gs1QrCode() {
                this.enabled = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Gs1QrCode svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Gs1QrCode svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Gs1Datamatrix
        extends BaseDecoder {
            Gs1Datamatrix() {
                this.enabled = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Gs1Datamatrix svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Gs1Datamatrix svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class OcrB
        extends BaseDecoder {
            public OcrBVariant ocrBVariant;

            OcrB() {
                this.ocrBVariant = OcrBVariant.FULL_ASCII;
            }

            void updateParams(SvcScannerConfig.DecoderParams.OcrB svcParam) {
                this.enabled = svcParam.enabled;
                this.ocrBVariant = OcrBVariant.values()[svcParam.ocrBVariant.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.OcrB svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.ocrBVariant = SvcScannerConfig.OcrBVariant.values()[this.ocrBVariant.ordinal()];
            }
        }

        public class OcrA
        extends BaseDecoder {
            public OcrAVariant ocrAVariant;

            OcrA() {
                this.ocrAVariant = OcrAVariant.FULL_ASCII;
            }

            void updateParams(SvcScannerConfig.DecoderParams.OcrA svcParam) {
                this.enabled = svcParam.enabled;
                this.ocrAVariant = OcrAVariant.values()[svcParam.ocrAVariant.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.OcrA svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.ocrAVariant = SvcScannerConfig.OcrAVariant.values()[this.ocrAVariant.ordinal()];
            }
        }

        public class WebCode
        extends BaseDecoder {
            public boolean subType;

            WebCode() {
                this.subType = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.WebCode svcParam) {
                this.enabled = svcParam.enabled;
                this.subType = svcParam.subType;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.WebCode svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.subType = this.subType;
            }
        }

        public class UsPostNet
        extends BaseDecoder {
            public boolean reportCheckDigit;

            UsPostNet() {
                this.reportCheckDigit = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.UsPostNet svcParam) {
                this.enabled = svcParam.enabled;
                this.reportCheckDigit = svcParam.reportCheckDigit;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.UsPostNet svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.reportCheckDigit = this.reportCheckDigit;
            }
        }

        public class UsPlanet
        extends BaseDecoder {
            public boolean reportCheckDigit;

            UsPlanet() {
                this.reportCheckDigit = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.UsPlanet svcParam) {
                this.enabled = svcParam.enabled;
                this.reportCheckDigit = svcParam.reportCheckDigit;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.UsPlanet svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.reportCheckDigit = this.reportCheckDigit;
            }
        }

        public class Us4State
        extends BaseDecoder {
            Us4State() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.Us4State svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Us4State svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Us4StateFics
        extends BaseDecoder {
            Us4StateFics() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.Us4StateFics svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Us4StateFics svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class UpcEanParams {
            public boolean booklandCode = false;
            public BooklandFormat booklandFormat = BooklandFormat.ISBN_10;
            public boolean convertDataBarToUpcEan = false;
            public boolean couponCode = false;
            @Deprecated
            public boolean linearDecode = true;
            public boolean randomWeightCheckDigit = false;
            public SecurityLevel securityLevel = SecurityLevel.LEVEL_1;
            public boolean supplemental2 = true;
            public boolean supplemental5 = true;
            public SupplementalMode supplementalMode = SupplementalMode.NO;
            public int supplementalRetries = 10;
            public CouponReport couponReport = CouponReport.BOTH;
            public boolean eanZeroExtend = false;
            public boolean reducedQuietZone = false;

            UpcEanParams() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.UpcEanParams svcParam) {
                this.booklandCode = svcParam.booklandCode;
                this.booklandFormat = BooklandFormat.values()[svcParam.booklandFormat.ordinal()];
                this.convertDataBarToUpcEan = svcParam.convertDataBarToUpcEan;
                this.couponCode = svcParam.couponCode;
                this.linearDecode = svcParam.linearDecode;
                this.randomWeightCheckDigit = svcParam.randomWeightCheckDigit;
                this.securityLevel = SecurityLevel.values()[svcParam.securityLevel.ordinal()];
                this.supplemental2 = svcParam.supplemental2;
                this.supplemental5 = svcParam.supplemental5;
                this.supplementalMode = SupplementalMode.values()[svcParam.supplementalMode.ordinal()];
                this.supplementalRetries = svcParam.supplementalRetries;
                this.couponReport = CouponReport.values()[svcParam.couponReport.ordinal()];
                this.eanZeroExtend = svcParam.eanZeroExtend;
                this.reducedQuietZone = svcParam.reducedQuietZone;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.UpcEanParams svcParam) {
                svcParam.booklandCode = this.booklandCode;
                svcParam.booklandFormat = SvcScannerConfig.BooklandFormat.values()[this.booklandFormat.ordinal()];
                svcParam.convertDataBarToUpcEan = this.convertDataBarToUpcEan;
                svcParam.couponCode = this.couponCode;
                svcParam.linearDecode = this.linearDecode;
                svcParam.randomWeightCheckDigit = this.randomWeightCheckDigit;
                svcParam.securityLevel = SvcScannerConfig.SecurityLevel.values()[this.securityLevel.ordinal()];
                svcParam.supplemental2 = this.supplemental2;
                svcParam.supplemental5 = this.supplemental5;
                svcParam.supplementalMode = SvcScannerConfig.SupplementalMode.values()[this.supplementalMode.ordinal()];
                svcParam.supplementalRetries = this.supplementalRetries;
                svcParam.couponReport = SvcScannerConfig.CouponReport.values()[this.couponReport.ordinal()];
                svcParam.eanZeroExtend = this.eanZeroExtend;
                svcParam.reducedQuietZone = this.reducedQuietZone;
            }
        }

        public class Upce1
        extends BaseDecoder {
            public boolean reportCheckDigit;
            public Preamble preamble;
            public boolean convertToUpca;

            Upce1() {
                this.reportCheckDigit = false;
                this.preamble = Preamble.NONE;
                this.convertToUpca = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Upce1 svcParam) {
                this.enabled = svcParam.enabled;
                this.reportCheckDigit = svcParam.reportCheckDigit;
                this.preamble = Preamble.values()[svcParam.preamble.ordinal()];
                this.convertToUpca = svcParam.convertToUpca;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Upce1 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.reportCheckDigit = this.reportCheckDigit;
                svcParam.preamble = SvcScannerConfig.Preamble.values()[this.preamble.ordinal()];
                svcParam.convertToUpca = this.convertToUpca;
            }
        }

        public class Upce0
        extends BaseDecoder {
            public boolean reportCheckDigit;
            public Preamble preamble;
            public boolean convertToUpca;

            Upce0() {
                this.reportCheckDigit = false;
                this.preamble = Preamble.NONE;
                this.convertToUpca = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Upce0 svcParam) {
                this.enabled = svcParam.enabled;
                this.reportCheckDigit = svcParam.reportCheckDigit;
                this.preamble = Preamble.values()[svcParam.preamble.ordinal()];
                this.convertToUpca = svcParam.convertToUpca;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Upce0 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.reportCheckDigit = this.reportCheckDigit;
                svcParam.preamble = SvcScannerConfig.Preamble.values()[this.preamble.ordinal()];
                svcParam.convertToUpca = this.convertToUpca;
            }
        }

        public class Upca
        extends BaseDecoder {
            public boolean reportCheckDigit;
            public Preamble preamble;

            Upca() {
                this.reportCheckDigit = true;
                this.preamble = Preamble.SYS_CHAR;
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Upca svcParam) {
                this.enabled = svcParam.enabled;
                this.reportCheckDigit = svcParam.reportCheckDigit;
                this.preamble = Preamble.values()[svcParam.preamble.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Upca svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.reportCheckDigit = this.reportCheckDigit;
                svcParam.preamble = SvcScannerConfig.Preamble.values()[this.preamble.ordinal()];
            }
        }

        public class UkPostal
        extends BaseDecoder {
            public boolean reportCheckDigit;

            UkPostal() {
                this.reportCheckDigit = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.UkPostal svcParam) {
                this.enabled = svcParam.enabled;
                this.reportCheckDigit = svcParam.reportCheckDigit;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.UkPostal svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.reportCheckDigit = this.reportCheckDigit;
            }
        }

        public class TriOptic39
        extends BaseDecoder {
            public boolean redundancy;

            TriOptic39() {
                this.redundancy = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.TriOptic39 svcParam) {
                this.enabled = svcParam.enabled;
                this.redundancy = svcParam.redundancy;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.TriOptic39 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.redundancy = this.redundancy;
            }
        }

        public class Tlc39
        extends BaseDecoder {
            Tlc39() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.Tlc39 svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Tlc39 svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Signature
        extends BaseDecoder {
            public int width;
            public int height;
            public SignatureImageFormat format;
            public int jpegQuality;
            public SignatureImageBitsPerPixel bpp;

            Signature() {
                this.width = 400;
                this.height = 400;
                this.format = SignatureImageFormat.BMP;
                this.jpegQuality = 65;
                this.bpp = SignatureImageBitsPerPixel.BPP_8;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Signature svcParam) {
                this.enabled = svcParam.enabled;
                this.width = svcParam.width;
                this.height = svcParam.height;
                this.format = SignatureImageFormat.values()[svcParam.format.ordinal()];
                this.jpegQuality = svcParam.jpegQuality;
                this.bpp = SignatureImageBitsPerPixel.values()[svcParam.bpp.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Signature svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.width = this.width;
                svcParam.height = this.height;
                svcParam.format = SvcScannerConfig.SignatureImageFormat.values()[this.format.ordinal()];
                svcParam.jpegQuality = this.jpegQuality;
                svcParam.bpp = SvcScannerConfig.SignatureImageBitsPerPixel.values()[this.bpp.ordinal()];
            }
        }

        public class QrCode
        extends BaseDecoder {
            QrCode() {
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.QrCode svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.QrCode svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Pdf417
        extends BaseDecoder {
            Pdf417() {
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Pdf417 svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Pdf417 svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Msi
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public CheckDigit checkDigits;
            public CheckDigitScheme checkDigitScheme;
            public boolean reportCheckDigit;

            Msi() {
                this.length1 = 4;
                this.length2 = 55;
                this.redundancy = true;
                this.checkDigits = CheckDigit.ONE;
                this.checkDigitScheme = CheckDigitScheme.MOD_10_10;
                this.reportCheckDigit = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Msi svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
                this.checkDigits = CheckDigit.values()[svcParam.checkDigits.ordinal()];
                this.checkDigitScheme = CheckDigitScheme.values()[svcParam.checkDigitScheme.ordinal()];
                this.reportCheckDigit = svcParam.reportCheckDigit;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Msi svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
                svcParam.checkDigits = SvcScannerConfig.CheckDigit.values()[this.checkDigits.ordinal()];
                svcParam.checkDigitScheme = SvcScannerConfig.CheckDigitScheme.values()[this.checkDigitScheme.ordinal()];
                svcParam.reportCheckDigit = this.reportCheckDigit;
            }
        }

        public class MicroQr
        extends BaseDecoder {
            MicroQr() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.MicroQr svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.MicroQr svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class MicroPdf
        extends BaseDecoder {
            MicroPdf() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.MicroPdf svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.MicroPdf svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class MaxiCode
        extends BaseDecoder {
            MaxiCode() {
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.MaxiCode svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.MaxiCode svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Matrix2of5
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public boolean reportCheckDigit;
            public boolean verifyCheckDigit;

            Matrix2of5() {
                this.length1 = 10;
                this.length2 = 0;
                this.redundancy = false;
                this.reportCheckDigit = true;
                this.verifyCheckDigit = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Matrix2of5 svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
                this.reportCheckDigit = svcParam.reportCheckDigit;
                this.verifyCheckDigit = svcParam.verifyCheckDigit;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Matrix2of5 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
                svcParam.reportCheckDigit = this.reportCheckDigit;
                svcParam.verifyCheckDigit = this.verifyCheckDigit;
            }
        }

        public class Korean3of5
        extends BaseDecoder {
            Korean3of5() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.Korean3of5 svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Korean3of5 svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class JapanesePostal
        extends BaseDecoder {
            JapanesePostal() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.JapanesePostal svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.JapanesePostal svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class I2of5
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public CheckDigitType verifyCheckDigit;
            public boolean reportCheckDigit;
            public boolean convertToEan13;
            public SecurityLevel securityLevel;
            public boolean reducedQuietZone;
            public boolean febraban;

            I2of5() {
                this.length1 = 14;
                this.length2 = 10;
                this.redundancy = true;
                this.verifyCheckDigit = CheckDigitType.NO;
                this.reportCheckDigit = false;
                this.convertToEan13 = false;
                this.securityLevel = SecurityLevel.LEVEL_1;
                this.reducedQuietZone = false;
                this.febraban = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.I2of5 svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
                this.verifyCheckDigit = CheckDigitType.values()[svcParam.verifyCheckDigit.ordinal()];
                this.reportCheckDigit = svcParam.reportCheckDigit;
                this.convertToEan13 = svcParam.convertToEan13;
                this.securityLevel = SecurityLevel.values()[svcParam.securityLevel.ordinal()];
                this.reducedQuietZone = svcParam.reducedQuietZone;
                this.febraban = svcParam.febraban;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.I2of5 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
                svcParam.verifyCheckDigit = SvcScannerConfig.CheckDigitType.values()[this.verifyCheckDigit.ordinal()];
                svcParam.reportCheckDigit = this.reportCheckDigit;
                svcParam.convertToEan13 = this.convertToEan13;
                svcParam.securityLevel = SvcScannerConfig.SecurityLevel.values()[this.securityLevel.ordinal()];
                svcParam.reducedQuietZone = this.reducedQuietZone;
                svcParam.febraban = this.febraban;
            }
        }

        public class Gs1DatabarExp
        extends BaseDecoder {
            Gs1DatabarExp() {
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Gs1DatabarExp svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Gs1DatabarExp svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Gs1DatabarLim
        extends BaseDecoder {
            public GS1LimitedSecurityLevel securityLevel;

            Gs1DatabarLim() {
                this.securityLevel = GS1LimitedSecurityLevel.LEVEL_2;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Gs1DatabarLim svcParam) {
                this.enabled = svcParam.enabled;
                this.securityLevel = GS1LimitedSecurityLevel.values()[svcParam.securityLevel.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Gs1DatabarLim svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.securityLevel = SvcScannerConfig.GS1LimitedSecurityLevel.values()[this.securityLevel.ordinal()];
            }
        }

        public class Gs1Databar
        extends BaseDecoder {
            Gs1Databar() {
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Gs1Databar svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Gs1Databar svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Ean8
        extends BaseDecoder {
            public boolean convertToEan13;

            Ean8() {
                this.convertToEan13 = false;
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Ean8 svcParam) {
                this.enabled = svcParam.enabled;
                this.convertToEan13 = svcParam.convertToEan13;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Ean8 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.convertToEan13 = this.convertToEan13;
            }
        }

        public class Ean13
        extends BaseDecoder {
            Ean13() {
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Ean13 svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Ean13 svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class DutchPostal
        extends BaseDecoder {
            public boolean dutchPostal3S;

            DutchPostal() {
                this.dutchPostal3S = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.DutchPostal svcParam) {
                this.enabled = svcParam.enabled;
                this.dutchPostal3S = svcParam.dutchPostal3S;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.DutchPostal svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.dutchPostal3S = this.dutchPostal3S;
            }
        }

        public class DataMatrix
        extends BaseDecoder {
            DataMatrix() {
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.DataMatrix svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.DataMatrix svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class D2of5
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;

            D2of5() {
                this.length1 = 0;
                this.length2 = 14;
                this.redundancy = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.D2of5 svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.D2of5 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
            }
        }

        public class CompositeC
        extends BaseDecoder {
            CompositeC() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.CompositeC svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.CompositeC svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class CompositeAB
        extends BaseDecoder {
            public UccLinkMode uccLinkMode;

            CompositeAB() {
                this.uccLinkMode = UccLinkMode.AUTO_DISCRIMINATE;
            }

            void updateParams(SvcScannerConfig.DecoderParams.CompositeAB svcParam) {
                this.enabled = svcParam.enabled;
                this.uccLinkMode = UccLinkMode.values()[svcParam.uccLinkMode.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.CompositeAB svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.uccLinkMode = SvcScannerConfig.UccLinkMode.values()[this.uccLinkMode.ordinal()];
            }
        }

        public class Code93
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;

            Code93() {
                this.length1 = 0;
                this.length2 = 55;
                this.redundancy = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Code93 svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Code93 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
            }
        }

        public class Code39
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean verifyCheckDigit;
            public boolean reportCheckDigit;
            public boolean fullAscii;
            public boolean redundancy;
            public boolean convertToCode32;
            public boolean reportCode32Prefix;
            public SecurityLevel securityLevel;
            public boolean reducedQuietZone;

            Code39() {
                this.length1 = 0;
                this.length2 = 55;
                this.verifyCheckDigit = false;
                this.reportCheckDigit = false;
                this.fullAscii = false;
                this.redundancy = false;
                this.convertToCode32 = false;
                this.reportCode32Prefix = false;
                this.securityLevel = SecurityLevel.LEVEL_1;
                this.reducedQuietZone = false;
                this.enabled = true;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Code39 svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.verifyCheckDigit = svcParam.verifyCheckDigit;
                this.reportCheckDigit = svcParam.reportCheckDigit;
                this.fullAscii = svcParam.fullAscii;
                this.redundancy = svcParam.redundancy;
                this.convertToCode32 = svcParam.convertToCode32;
                this.reportCode32Prefix = svcParam.reportCode32Prefix;
                this.securityLevel = SecurityLevel.values()[svcParam.securityLevel.ordinal()];
                this.reducedQuietZone = svcParam.reducedQuietZone;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Code39 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.verifyCheckDigit = this.verifyCheckDigit;
                svcParam.reportCheckDigit = this.reportCheckDigit;
                svcParam.fullAscii = this.fullAscii;
                svcParam.redundancy = this.redundancy;
                svcParam.convertToCode32 = this.convertToCode32;
                svcParam.reportCode32Prefix = this.reportCode32Prefix;
                svcParam.securityLevel = SvcScannerConfig.SecurityLevel.values()[this.securityLevel.ordinal()];
                svcParam.reducedQuietZone = this.reducedQuietZone;
            }
        }

        public class Code128
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public boolean enablePlain;
            public boolean enableEan128;
            public boolean enableIsbt128;
            public Isbt128ContactMode isbt128ConcatMode;
            public boolean checkIsbtTable;
            public SecurityLevel securityLevel;
            public boolean reducedQuietZone;

            Code128() {
                this.length1 = 0;
                this.length2 = 55;
                this.redundancy = false;
                this.enablePlain = true;
                this.enableEan128 = true;
                this.enableIsbt128 = true;
                this.isbt128ConcatMode = Isbt128ContactMode.NEVER;
                this.checkIsbtTable = false;
                this.securityLevel = SecurityLevel.LEVEL_1;
                this.reducedQuietZone = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Code128 svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
                this.enablePlain = svcParam.enablePlain;
                this.enableEan128 = svcParam.enableEan128;
                this.enableIsbt128 = svcParam.enableIsbt128;
                this.isbt128ConcatMode = Isbt128ContactMode.values()[svcParam.isbt128ConcatMode.ordinal()];
                this.checkIsbtTable = svcParam.checkIsbtTable;
                this.securityLevel = SecurityLevel.values()[svcParam.securityLevel.ordinal()];
                this.reducedQuietZone = svcParam.reducedQuietZone;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Code128 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
                svcParam.enablePlain = this.enablePlain;
                svcParam.enableEan128 = this.enableEan128;
                svcParam.enableIsbt128 = this.enableIsbt128;
                svcParam.isbt128ConcatMode = SvcScannerConfig.Isbt128ContactMode.values()[this.isbt128ConcatMode.ordinal()];
                svcParam.checkIsbtTable = this.checkIsbtTable;
                svcParam.securityLevel = SvcScannerConfig.SecurityLevel.values()[this.securityLevel.ordinal()];
                svcParam.reducedQuietZone = this.reducedQuietZone;
            }
        }

        public class Code11
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public VerifyCheckDigit verifyCheckDigit;
            public boolean reportCheckDigit;

            Code11() {
                this.length1 = 4;
                this.length2 = 55;
                this.redundancy = true;
                this.verifyCheckDigit = VerifyCheckDigit.ONE;
                this.reportCheckDigit = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.Code11 svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
                this.verifyCheckDigit = VerifyCheckDigit.values()[svcParam.verifyCheckDigit.ordinal()];
                this.reportCheckDigit = svcParam.reportCheckDigit;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Code11 svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
                svcParam.verifyCheckDigit = SvcScannerConfig.VerifyCheckDigit.values()[this.verifyCheckDigit.ordinal()];
                svcParam.reportCheckDigit = this.reportCheckDigit;
            }
        }

        public class CodaBar
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public boolean clsiEditing;
            public boolean notisEditing;

            CodaBar() {
                this.length1 = 6;
                this.length2 = 55;
                this.redundancy = true;
                this.clsiEditing = false;
                this.notisEditing = false;
            }

            void updateParams(SvcScannerConfig.DecoderParams.CodaBar svcParam) {
                this.enabled = svcParam.enabled;
                this.length1 = svcParam.length1;
                this.length2 = svcParam.length2;
                this.redundancy = svcParam.redundancy;
                this.clsiEditing = svcParam.clsiEditing;
                this.notisEditing = svcParam.notisEditing;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.CodaBar svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.length1 = this.length1;
                svcParam.length2 = this.length2;
                svcParam.redundancy = this.redundancy;
                svcParam.clsiEditing = this.clsiEditing;
                svcParam.notisEditing = this.notisEditing;
            }
        }

        public class Chinese2of5
        extends BaseDecoder {
            Chinese2of5() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.Chinese2of5 svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Chinese2of5 svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class CanadianPostal
        extends BaseDecoder {
            CanadianPostal() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.CanadianPostal svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.CanadianPostal svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class Aztec
        extends BaseDecoder {
            Aztec() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.Aztec svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.Aztec svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class HanXin
        extends BaseDecoder {
            public HanXinInverse hanXinInverse;

            HanXin() {
                this.hanXinInverse = HanXinInverse.DISABLED;
            }

            void updateParams(SvcScannerConfig.DecoderParams.HanXin svcParam) {
                this.enabled = svcParam.enabled;
                this.hanXinInverse = HanXinInverse.values()[svcParam.hanXinInverse.ordinal()];
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.HanXin svcParam) {
                svcParam.enabled = this.enabled;
                svcParam.hanXinInverse = SvcScannerConfig.HanXinInverse.values()[this.hanXinInverse.ordinal()];
            }
        }

        public class MailMark
        extends BaseDecoder {
            MailMark() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.MailMark svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.MailMark svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public class AustralianPostal
        extends BaseDecoder {
            AustralianPostal() {
            }

            void updateParams(SvcScannerConfig.DecoderParams.AustralianPostal svcParam) {
                this.enabled = svcParam.enabled;
            }

            void updateSvcParams(SvcScannerConfig.DecoderParams.AustralianPostal svcParam) {
                svcParam.enabled = this.enabled;
            }
        }

        public abstract class BaseDecoder {
            public boolean enabled;
        }
    }

    public class ScanParams {
        public CodeIdType codeIdType = CodeIdType.NONE;
        public String decodeAudioFeedbackUri = "";
        public boolean decodeHapticFeedback = false;
        public int decodeLEDTime = 75;
        public AudioStreamType audioStreamType = AudioStreamType.RINGER;
        public boolean decodeLEDFeedback = false;
        public DecodeLEDFeedbackMode decodeLEDFeedbackMode = DecodeLEDFeedbackMode.BOTH;
        public DecodeAudioFeedbackMode decodeAudioFeedbackMode = DecodeAudioFeedbackMode.BOTH;
        public boolean decodeScreenNotification = false;
        public int decodeScreenNotificationTime = 1000;
        public int decodeScreenTranslucencyLevel = 3;

        ScanParams() {
        }

        void updateParams(SvcScannerConfig.ScanParams svcParam) {
            this.decodeAudioFeedbackUri = svcParam.decodeAudioFeedbackUri;
            this.decodeHapticFeedback = svcParam.decodeHapticFeedback;
            this.decodeLEDTime = svcParam.decodeLEDTime;
            this.decodeLEDFeedback = svcParam.decodeLEDFeedback;
            this.codeIdType = CodeIdType.values()[svcParam.codeIdType.ordinal()];
            this.audioStreamType = AudioStreamType.values()[svcParam.audioStreamType.ordinal()];
            this.decodeLEDFeedbackMode = DecodeLEDFeedbackMode.values()[svcParam.decodeLEDFeedbackMode.ordinal()];
            this.decodeAudioFeedbackMode = DecodeAudioFeedbackMode.values()[svcParam.decodeAudioFeedbackMode.ordinal()];
            this.decodeScreenNotification = svcParam.decodeScreenNotification;
            this.decodeScreenNotificationTime = svcParam.decodeScreenNotificationTime;
            this.decodeScreenTranslucencyLevel = svcParam.decodeScreenTranslucencyLevel;
        }

        void updateSvcParams(SvcScannerConfig.ScanParams svcParam) {
            svcParam.decodeAudioFeedbackUri = this.decodeAudioFeedbackUri;
            svcParam.decodeHapticFeedback = this.decodeHapticFeedback;
            svcParam.decodeLEDTime = this.decodeLEDTime;
            svcParam.decodeLEDFeedback = this.decodeLEDFeedback;
            svcParam.codeIdType = SvcScannerConfig.CodeIdType.values()[this.codeIdType.ordinal()];
            svcParam.audioStreamType = SvcScannerConfig.AudioStreamType.values()[this.audioStreamType.ordinal()];
            svcParam.decodeLEDFeedbackMode = SvcScannerConfig.DecodeLEDFeedbackMode.values()[this.decodeLEDFeedbackMode.ordinal()];
            svcParam.decodeAudioFeedbackMode = SvcScannerConfig.DecodeAudioFeedbackMode.values()[this.decodeAudioFeedbackMode.ordinal()];
            svcParam.decodeScreenNotification = this.decodeScreenNotification;
            svcParam.decodeScreenNotificationTime = this.decodeScreenNotificationTime;
            svcParam.decodeScreenTranslucencyLevel = this.decodeScreenTranslucencyLevel;
        }
    }

    class InterfaceParams {
        public boolean displayBluetoothAddressBarcode = true;
        public int connectionEstablishTime = 45;

        InterfaceParams() {
        }

        void updateParams(SvcScannerConfig.InterfaceParams svcParam) {
            this.displayBluetoothAddressBarcode = svcParam.displayBluetoothAddressBarcode;
            this.connectionEstablishTime = svcParam.connectionEstablishTime;
        }

        void updateSvcParams(SvcScannerConfig.InterfaceParams svcParam) {
            svcParam.displayBluetoothAddressBarcode = this.displayBluetoothAddressBarcode;
            svcParam.connectionEstablishTime = this.connectionEstablishTime;
        }
    }
}

