/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.StatusData;
import com.symbol.emdk.emdkservice.barcode.ISvcScanStatusCallback;
import com.symbol.emdk.emdkservice.barcode.SvcStatusData;

class StatusCallbackInternal
extends ISvcScanStatusCallback.Stub {
    Scanner scanner;

    StatusCallbackInternal(Scanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void onStatus(SvcStatusData scanStatus) throws RemoteException {
        new StatusCallbackThread(this.scanner, scanStatus).start();
    }

    class StatusCallbackThread
    extends Thread {
        private static final String TAG = "Status_Callback_Thread";
        SvcStatusData scanStatus;
        Scanner scanner;

        StatusCallbackThread(Scanner scanner, SvcStatusData scanStatus) {
            if (scanner == null || scanStatus == null) {
                return;
            }
            this.scanStatus = scanStatus;
            this.scanner = scanner;
        }

        @Override
        public void run() {
            try {
                if (this.scanStatus != null && (!this.scanner.statusListenerCallbacks.isEmpty() || this.scanner.statusListenerIntents.isEmpty())) {
                    StatusData statusData = new StatusData();
                    statusData.friendlyName = this.scanStatus.getFriendlyName();
                    statusData.scannerState = StatusData.ScannerStates.values()[this.scanStatus.getState().ordinal()];
                    if (statusData.getState() == StatusData.ScannerStates.IDLE && this.scanner.triggerType == Scanner.TriggerType.SOFT_ONCE) {
                        this.scanner.triggerType = Scanner.TriggerType.HARD;
                    }
                    for (Scanner.StatusListener callback : this.scanner.statusListenerCallbacks) {
                        if (callback == null) continue;
                        callback.onStatus(statusData);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }
}

