/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.barcode;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;

public class SvcScanData
implements Parcelable {
    protected int id = 0;
    public ParcelFileDescriptor pfd = null;
    byte[] rawData = null;
    String charsetName = "";
    LabelType labelType = LabelType.UNDEFINED;
    String timeStamp = "";
    String strData = null;
    public static final Parcelable.Creator<SvcScanData> CREATOR = new Parcelable.Creator<SvcScanData>(){

        public SvcScanData createFromParcel(Parcel source) {
            return new SvcScanData(source);
        }

        public SvcScanData[] newArray(int size) {
            return new SvcScanData[size];
        }
    };

    SvcScanData() {
    }

    public SvcScanData(Parcel source) {
        this.charsetName = source.readString();
        this.labelType = LabelType.values()[source.readInt()];
        this.timeStamp = source.readString();
        this.rawData = new byte[source.readInt()];
        source.readByteArray(this.rawData);
        this.strData = source.readString();
        this.id = source.readInt();
        int validpfd = source.readInt();
        if (validpfd == 1) {
            this.pfd = (ParcelFileDescriptor)source.readValue(ParcelFileDescriptor.class.getClassLoader());
        }
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public String getStringData() {
        return this.strData;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public LabelType getLabelType() {
        return this.labelType;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.charsetName);
        dest.writeInt(this.labelType.ordinal());
        dest.writeString(this.timeStamp);
        dest.writeInt(this.rawData.length);
        dest.writeByteArray(this.rawData);
        dest.writeString(this.strData);
        dest.writeInt(this.id);
        if (this.pfd != null) {
            dest.writeInt(1);
            dest.writeValue((Object)this.pfd);
        } else {
            dest.writeInt(0);
        }
    }

    public static enum LabelType {
        AUSPOSTAL(0),
        AZTEC(1),
        BOOKLAND(2),
        CANPOSTAL(3),
        CHINESE_2OF5(4),
        CODABAR(5),
        CODE11(6),
        CODE128(7),
        CODE32(8),
        CODE39(9),
        CODE93(10),
        COMPOSITE_AB(11),
        COMPOSITE_C(12),
        COUPON(13),
        D2OF5(14),
        DATAMATRIX(15),
        DUTCHPOSTAL(16),
        DATABAR_COUPON(17),
        EAN128(18),
        EAN13(19),
        EAN8(20),
        GS1_DATABAR(21),
        GS1_DATABAR_EXP(22),
        GS1_DATABAR_LIM(23),
        I2OF5(24),
        IATA2OF5(25),
        ISBT128(26),
        JAPPOSTAL(27),
        KOREAN_3OF5(28),
        MATRIX_2OF5(29),
        MAXICODE(30),
        MICROPDF(31),
        MICROQR(32),
        MSI(33),
        OCR(34),
        PDF417(35),
        QRCODE(36),
        SIGNATURE(37),
        TLC39(38),
        TRIOPTIC39(39),
        UKPOSTAL(40),
        UPCA(41),
        UPCE0(42),
        UPCE1(43),
        US4STATE(44),
        US4STATE_FICS(45),
        USPLANET(46),
        USPOSTNET(47),
        WEBCODE(48),
        MAILMARK(49),
        HANXIN(50),
        GS1_DATAMATRIX(51),
        GS1_QRCODE(52),
        DOTCODE(53),
        GRIDMATRIX(54),
        FINNISHPOSTAL_4S(55),
        UNDEFINED(255);

        private final int id;

        private LabelType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }
}

