/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.notification;

import com.symbol.emdk.emdkservice.notification.SvcNotificationDeviceInfo;
import com.symbol.emdk.notification.ConnectionType;
import com.symbol.emdk.notification.DeviceType;
import com.symbol.emdk.notification.NotificationManager;

public class DeviceInfo {
    int deviceIndex = 0;
    String friendlyName = "";
    String modelNumber = "";
    DeviceType deviceType = DeviceType.UNDEFINED;
    ConnectionType connectionType = ConnectionType.UNDEFINED;
    boolean isDefaultDevice = false;
    boolean isConnected = false;
    boolean isLEDSupported = false;
    boolean isBeepSupported = false;
    boolean isVibrateSupported = false;
    NotificationManager.DeviceIdentifier deviceIdentifier = NotificationManager.DeviceIdentifier.DEFAULT;

    DeviceInfo() {
    }

    DeviceInfo(SvcNotificationDeviceInfo deviceInfo) {
        this.updateDeviceInfo(deviceInfo);
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public NotificationManager.DeviceIdentifier getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public boolean isDefaultDevice() {
        return this.isDefaultDevice;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isLEDSupported() {
        return this.isLEDSupported;
    }

    public boolean isBeepSupported() {
        return this.isBeepSupported;
    }

    public boolean isVibrateSupported() {
        return this.isVibrateSupported;
    }

    void updateDeviceInfo(SvcNotificationDeviceInfo deviceInfo) {
        this.deviceIndex = deviceInfo.deviceIndex;
        this.friendlyName = deviceInfo.friendlyName;
        this.modelNumber = deviceInfo.modelNumber;
        switch (deviceInfo.deviceType) {
            case IMAGER: {
                this.deviceType = DeviceType.IMAGER;
                break;
            }
            case VIBRATOR: {
                this.deviceType = DeviceType.VIBRATOR;
                break;
            }
            default: {
                this.deviceType = DeviceType.UNDEFINED;
            }
        }
        switch (deviceInfo.connectionType) {
            case BLUETOOTH_SSI: {
                this.connectionType = ConnectionType.BLUETOOTH_SSI;
                break;
            }
            case PLUGGABLE: {
                this.connectionType = ConnectionType.PLUGGABLE;
                break;
            }
            default: {
                this.connectionType = ConnectionType.UNDEFINED;
            }
        }
        switch (deviceInfo.deviceIdentifier) {
            case DEFAULT: {
                this.deviceIdentifier = NotificationManager.DeviceIdentifier.DEFAULT;
                break;
            }
            case BLUETOOTH_IMAGER_RS6000: {
                this.deviceIdentifier = NotificationManager.DeviceIdentifier.BLUETOOTH_IMAGER_RS6000;
                break;
            }
            case EXTERNAL_VIBRATOR1: {
                this.deviceIdentifier = NotificationManager.DeviceIdentifier.EXTERNAL_VIBRATOR1;
                break;
            }
            case BLUETOOTH_IMAGER_RS5100: {
                this.deviceIdentifier = NotificationManager.DeviceIdentifier.BLUETOOTH_IMAGER_RS5100;
                break;
            }
            case BLUETOOTH_GENERIC: {
                this.deviceIdentifier = NotificationManager.DeviceIdentifier.BLUETOOTH_GENERIC;
            }
        }
        this.isDefaultDevice = deviceInfo.isDefaultDevice;
        this.isConnected = deviceInfo.isConnected;
        this.isLEDSupported = deviceInfo.isLEDSupported;
        this.isBeepSupported = deviceInfo.isBeepSupported;
        this.isVibrateSupported = deviceInfo.isVibrateSupported;
    }
}

