/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.personalshopper;

public enum DiagnosticResults {
    SUCCESS(0),
    FAILURE(1),
    FEATURE_NOT_SUPPORTED(2),
    INVALID_VALUE(3),
    INVALID_OBJECT(4),
    UNDEFINED(255);

    private int id;
    private String discription;

    private DiagnosticResults(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.length() == 0) {
            return DiagnosticResults.getErrorDescription(this);
        }
        return this.discription;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(DiagnosticResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success";
                break;
            }
            case FAILURE: {
                errDescription = "Failure";
                break;
            }
            case INVALID_VALUE: {
                errDescription = "The value is invalid.";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                errDescription = "Feature not supported";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "Invalid Object";
                break;
            }
            default: {
                errDescription = "Error code not defined.";
            }
        }
        return errDescription;
    }
}

