/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.personalshopper;

import android.content.Context;
import android.os.Build;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.personalshopper.Cradle;
import com.symbol.emdk.personalshopper.CradleException;
import com.symbol.emdk.personalshopper.Diagnostic;
import com.symbol.emdk.personalshopper.DiagnosticException;
import com.symbol.emdk.personalshopper.PersonalShopperException;
import com.symbol.emdk.personalshopper.PersonalShopperResults;

public class PersonalShopper
extends EMDKBase {
    private static final String TAG = "Personal_Shopper";
    Context context = null;
    EMDKServiceConnection emdkServiceConnection = null;
    String model = "";
    public Cradle cradle = null;
    public Diagnostic diagnostic = null;

    PersonalShopper(Context context, EMDKServiceConnection emdkServiceConnection) throws PersonalShopperException {
        super(EMDKManager.FEATURE_TYPE.PERSONALSHOPPER);
        if (emdkServiceConnection == null || !emdkServiceConnection.isServiceConnected()) {
            Log.e((String)TAG, (String)"Something is NUll");
        } else {
            this.emdkServiceConnection = emdkServiceConnection;
            this.context = context;
            this.model = Build.MODEL;
            if (!(this.model.contains("MC18") || this.model.contains("PS20") || this.model.contains("PS30"))) {
                throw new PersonalShopperException(PersonalShopperResults.FEATURE_NOT_SUPPORTED);
            }
            try {
                if (0 == this.emdkServiceConnection.getService().PersonalShopperInitialize()) {
                    Log.d((String)TAG, (String)"Initialized");
                    this.cradle = new Cradle(context, emdkServiceConnection);
                    if (this.cradle == null) {
                        Log.e((String)TAG, (String)"Error creating a new Cradle object");
                        throw new PersonalShopperException(PersonalShopperResults.FAILURE);
                    }
                    this.diagnostic = new Diagnostic(context, emdkServiceConnection);
                    if (this.diagnostic == null) {
                        Log.e((String)TAG, (String)"Error creating a new Diagnostic object");
                        throw new PersonalShopperException(PersonalShopperResults.FAILURE);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error adding PersonalShopper");
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new PersonalShopperException(PersonalShopperResults.FAILURE);
            }
        }
    }

    void release() {
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                this.emdkServiceConnection.getService().PersonalShopperUnInitialize();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (this.cradle != null) {
            try {
                this.cradle.release();
            }
            catch (CradleException e) {
                e.printStackTrace();
            }
        }
        if (this.diagnostic != null) {
            try {
                this.diagnostic.release();
            }
            catch (DiagnosticException e) {
                e.printStackTrace();
            }
        }
        this.cradle = null;
        this.diagnostic = null;
    }
}

