/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.personalshopper;

enum PersonalShopperResults {
    SUCCESS(0),
    FAILURE(1),
    ALREADY_IN_USE(2),
    FEATURE_NOT_SUPPORTED(3),
    INVALID_OBJECT(4),
    UNDEFINED(255);

    private int id;
    private String discription;

    private PersonalShopperResults(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.length() == 0) {
            return PersonalShopperResults.getErrorDescription(this);
        }
        return this.discription;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(PersonalShopperResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success";
                break;
            }
            case FAILURE: {
                errDescription = "Failure";
                break;
            }
            case ALREADY_IN_USE: {
                errDescription = "Already in use.";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                errDescription = "Feature not supported";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "Invalid Object";
                break;
            }
            default: {
                errDescription = "Error code not defined.";
            }
        }
        return errDescription;
    }
}

