/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.sam;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.IEMDKService;
import com.symbol.emdk.emdkservice.SvcError;
import com.symbol.emdk.emdkservice.sam.SvcSAMInfo;
import com.symbol.emdk.sam.SAM;
import com.symbol.emdk.sam.SAMException;
import com.symbol.emdk.sam.SAMResults;
import java.util.ArrayList;
import java.util.List;

public class SAMManager
extends EMDKBase {
    private static final int SAM_PRESENT = 1;
    private static final String TAG = "SAM_Manager";
    private Context mContext;
    IEMDKService emdkService = null;
    List<SAM> listPresentSAMs = null;

    SAMManager(Context context, EMDKServiceConnection emdkServiceConnection) throws Exception {
        super(EMDKManager.FEATURE_TYPE.SAM);
        this.mContext = context;
        if (emdkServiceConnection != null) {
            this.emdkService = emdkServiceConnection.getService();
        }
        try {
            if (this.emdkService != null) {
                int result = this.emdkService.samInitSAMManager();
                if (result == SvcError.EMDKErrorCode.UNLICENSED_FEATURE.getValue()) {
                    throw new Exception("Unlicensed feature.");
                }
                if (result == SvcError.EMDKErrorCode.UNSUPPORTED_FEATURE.getValue()) {
                    throw new Exception("Unsupported feature.");
                }
            }
        }
        catch (RemoteException e) {
            throw new Exception("" + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<SAM> enumerateSAMs() throws SAMException {
        if (this.listPresentSAMs != null) return this.listPresentSAMs;
        if (this.emdkService == null) throw new SAMException(SAMResults.FAILURE);
        try {
            List<SvcSAMInfo> infoList = this.emdkService.samEnumerateSams();
            if (infoList == null) return this.listPresentSAMs;
            this.listPresentSAMs = new ArrayList<SAM>();
            for (SvcSAMInfo info : infoList) {
                if (info.getSamPresenseStatus() != 1) continue;
                SAM sam = new SAM(this, info);
                this.listPresentSAMs.add(sam);
            }
            return this.listPresentSAMs;
        }
        catch (Exception e) {
            throw new SAMException(SAMResults.FAILURE);
        }
    }

    public int getActiveSlot() throws SAMException {
        int returnVar = -1;
        try {
            if (this.emdkService != null) {
                returnVar = this.emdkService.samGetActiveSlot();
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        if (returnVar == -1) {
            throw new SAMException(SAMResults.SAM_NOT_INITIALIZED);
        }
        return returnVar;
    }

    void release() {
        try {
            if (this.emdkService != null) {
                this.emdkService.samShutdownSAMManager();
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
    }

    IEMDKService getEmdkService() {
        return this.emdkService;
    }
}

