/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.serialcomm;

import com.symbol.emdk.emdkservice.serialcomm.SvcSerialCommConfig;

public class SerialCommConfig {
    public long baudRate;
    public DataBits dataBit;
    public ParityBits parity;
    public StopBits stopBit;
    public FlowControlMode flowControlMode;

    SerialCommConfig(SvcSerialCommConfig svcConfig) {
        this.baudRate = svcConfig.baudRate;
        this.dataBit = DataBits.values()[svcConfig.dataBit];
        this.parity = ParityBits.values()[svcConfig.parity];
        this.stopBit = StopBits.values()[svcConfig.stopBit];
        this.flowControlMode = FlowControlMode.values()[svcConfig.flowControlMode];
    }

    public static enum FlowControlMode {
        NONE(0),
        RTS_CTS(1),
        DSR_DTR(2),
        XON_XOFF(3);

        int id = 0;

        private FlowControlMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum StopBits {
        ONE(0),
        ONE_AND_HALF(1),
        TWO(2);

        int id = 0;

        private StopBits(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum ParityBits {
        NONE(0),
        ODD(1),
        EVEN(2),
        MARK(3),
        SPACE(4);

        int id = 0;

        private ParityBits(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DataBits {
        SEVEN(0),
        EIGHT(1);

        int id = 0;

        private DataBits(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static class BaudRates {
        public static final long BR_300 = 300L;
        public static final long BR_1200 = 1200L;
        public static final long BR_2400 = 2400L;
        public static final long BR_4800 = 4800L;
        public static final long BR_9600 = 9600L;
        public static final long BR_14400 = 14400L;
        public static final long BR_19200 = 19200L;
        public static final long BR_28800 = 28800L;
        public static final long BR_38400 = 38400L;
        public static final long BR_57600 = 57600L;
        public static final long BR_115200 = 115200L;
        public static final long BR_230400 = 230400L;
        public static final long BR_460800 = 460800L;
        public static final long BR_921600 = 921600L;
    }
}

