/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.serialcomm;

public enum SerialCommResults {
    SUCCESS(0),
    FAILURE(1),
    INVALID_VALUE(3),
    DEVICE_NOT_CONNECTED(4),
    NOT_ENABLED(5),
    ALREADY_ENABLED(6),
    EMDK_NOT_OPENED(7),
    FEATURE_NOT_SUPPORTED(8),
    INVALID_OBJECT(9),
    DEVICE_NOT_READY(10),
    COMM_PORT_IN_USE(11),
    DATA_SIZE_TOO_LARGE(12),
    READ_ONLY_SIGNAL(13),
    SIGNAL_OUT_OF_RANGE(14),
    UNDEFINED(255);

    private int id;
    private String discription;

    private SerialCommResults(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.length() == 0) {
            return SerialCommResults.getErrorDescription(this);
        }
        return this.discription;
    }

    void setValue(int id) {
        this.id = id;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(SerialCommResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success";
                break;
            }
            case FAILURE: {
                errDescription = "Failure";
                break;
            }
            case DEVICE_NOT_CONNECTED: {
                errDescription = "The remote device is not connected or attached to the mobile device.";
                break;
            }
            case ALREADY_ENABLED: {
                errDescription = "The communication channel is already enabled.";
                break;
            }
            case INVALID_VALUE: {
                errDescription = "Invalid value";
                break;
            }
            case EMDK_NOT_OPENED: {
                errDescription = "EMDK not opened.";
                break;
            }
            case NOT_ENABLED: {
                errDescription = "The communication channel is not enabled.";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                errDescription = "The feature is not supported.";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "The object is not valid.";
                break;
            }
            case DEVICE_NOT_READY: {
                errDescription = "Serial port is not ready to use. Try later.";
                break;
            }
            case COMM_PORT_IN_USE: {
                errDescription = "The serial communication port is already used by other instance.";
                break;
            }
            case DATA_SIZE_TOO_LARGE: {
                errDescription = "The number of bytes to write can't exceed maximum limit(4096 Bytes).";
                break;
            }
            case READ_ONLY_SIGNAL: {
                errDescription = "The signal state requested to set is read only, can't be set.";
                break;
            }
            case SIGNAL_OUT_OF_RANGE: {
                errDescription = "The signal state requested to set is read only, can't be set.";
                break;
            }
            case UNDEFINED: {
                errDescription = "Error code not defined.";
            }
        }
        return errDescription;
    }
}

