/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.util.Log;
import com.symbol.emdk.emdkservice.SvcProfileResult;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EMDKResults {
    private String xmlString = null;
    private Document xmlDocument = null;
    private static final String TAG = "EMDK_Results";
    int totalFeatureCount = -1;
    int successFeaturesCount = -1;
    public EXTENDED_STATUS_CODE extendedStatusCode;
    public STATUS_CODE statusCode;
    private String exceptionMessage = "";

    public String getExtendedStatusMessage() {
        String excepMess = "";
        excepMess = this.extendedStatusCode == EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED && this.exceptionMessage.length() != 0 ? this.extendedStatusCode.getMessage() + " Exception : " + this.exceptionMessage : this.extendedStatusCode.getMessage();
        return excepMess;
    }

    public int getTotalFeaturesCount() {
        return this.totalFeatureCount;
    }

    public int getSuccessFeaturesCount() {
        return this.successFeaturesCount;
    }

    EMDKResults(STATUS_CODE statusCode) {
        this.statusCode = statusCode;
        this.extendedStatusCode = EXTENDED_STATUS_CODE.NONE;
        this.xmlString = this.createResponseXML(statusCode, this.extendedStatusCode);
        this.xmlDocument = this.getDocumentFromString(this.xmlString);
    }

    EMDKResults(STATUS_CODE statusCode, EXTENDED_STATUS_CODE extendedStatusCode) {
        this.statusCode = statusCode;
        this.extendedStatusCode = extendedStatusCode;
        this.xmlString = this.createResponseXML(statusCode, extendedStatusCode);
        this.xmlDocument = this.getDocumentFromString(this.xmlString);
    }

    EMDKResults(STATUS_CODE statusCode, EXTENDED_STATUS_CODE extendedStatusCode, String exceptionMessage) {
        if (exceptionMessage == null) {
            exceptionMessage = "";
        }
        this.exceptionMessage = exceptionMessage;
        this.statusCode = statusCode;
        this.extendedStatusCode = extendedStatusCode;
        this.xmlString = this.createResponseXML(statusCode, extendedStatusCode);
        this.xmlDocument = this.getDocumentFromString(this.xmlString);
    }

    EMDKResults(String statusString) {
        this.xmlString = statusString;
        this.xmlDocument = this.getDocumentFromString(statusString);
        this.statusCode = this.getStatusCodeFromXMLString();
        this.extendedStatusCode = this.getExtStatusCodeFromXMLString();
    }

    EMDKResults(SvcProfileResult result) {
        this.xmlString = result.profileString;
        this.xmlDocument = this.getDocumentFromString(this.xmlString);
        this.statusCode = STATUS_CODE.values()[result.errorCode.getValue()];
        this.extendedStatusCode = EXTENDED_STATUS_CODE.NONE;
        this.successFeaturesCount = result.successFeaturesCount;
        this.totalFeatureCount = result.totalFeatureCount;
    }

    public Document getStatusDocument() {
        return this.xmlDocument;
    }

    public String getStatusString() {
        return this.xmlString;
    }

    private String createResponseXML(STATUS_CODE statusCode, EXTENDED_STATUS_CODE extendedStatusCode) {
        String description = "";
        switch (statusCode) {
            case UNKNOWN: {
                description = "Unknown failure";
                break;
            }
            case FAILURE: {
                description = "Failure";
                break;
            }
            case SUCCESS: {
                description = "Success";
                break;
            }
            case NULL_POINTER: {
                description = "Null pointer is passed";
                break;
            }
            case EMPTY_PROFILENAME: {
                description = "Profile name is empty";
                break;
            }
            case EMDK_NOT_OPENED: {
                description = "EMDK is not opened";
                break;
            }
            case CHECK_XML: {
                description = "Review the XML for details";
                break;
            }
            case PREVIOUS_REQUEST_IN_PROGRESS: {
                description = "The previous request is in progress, wait for it to complete before next request.";
                break;
            }
            case PROCESSING: {
                description = "The processing of profile started, the result will be returned through the data listener callback registered.";
                break;
            }
            case NO_DATA_LISTENER: {
                description = "The asynchronous method is issued without adding the data listener.";
                break;
            }
            case FEATURE_NOT_READY_TO_USE: {
                description = "The requested feature is not ready to use. Try later.";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                description = "The requested feature is not supported on this device.";
                break;
            }
            case MXMF_IS_NOT_AVAILABLE_ON_THIS_DEVICE: {
                description = "The MXMF is not available on this device.";
                break;
            }
        }
        String response = "<?xml version=\"1.0\" encoding=\"utf-8\"?><wap-provisioningdoc><characteristic type=\"status\"><parm name=\"code\" value=\"" + statusCode.getValue() + "\"/><parm name=\"description\" value=\"" + description + "\"/><characteristic type=\"extended_status\"><parm name=\"code\" value=\"" + extendedStatusCode.getValue() + "\"/><parm name=\"description\" value=\"" + this.getExtendedStatusMessage() + "\"/></characteristic></characteristic></wap-provisioningdoc>";
        return response;
    }

    private Document getDocumentFromString(String strDoc) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            Log.e((String)TAG, (String)("" + e1.getMessage()));
        }
        Document tdoc = null;
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(strDoc));
        try {
            if (db != null) {
                tdoc = db.parse(is);
            }
        }
        catch (SAXException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        return tdoc;
    }

    private EXTENDED_STATUS_CODE getExtStatusCodeFromXMLString() {
        EXTENDED_STATUS_CODE response;
        block4: {
            response = EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED;
            if (this.xmlDocument != null) {
                XPath xpath = XPathFactory.newInstance().newXPath();
                String xpathPattern = "/wap-provisioningdoc/characteristic/characteristic[@type='extended_status']/parm[@name='code']";
                try {
                    XPathExpression expr = xpath.compile(xpathPattern);
                    Object result = expr.evaluate(this.xmlDocument, XPathConstants.NODESET);
                    NodeList statusNodes = (NodeList)result;
                    String strStatusCode = statusNodes.item(0).getAttributes().getNamedItem("value").getNodeValue();
                    int iStatusCode = Integer.parseInt(strStatusCode);
                    response = EXTENDED_STATUS_CODE.values()[iStatusCode];
                }
                catch (XPathExpressionException e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
                catch (Exception e) {
                    if (e.getClass().equals(ArrayIndexOutOfBoundsException.class)) break block4;
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
        }
        return response;
    }

    private STATUS_CODE getStatusCodeFromXMLString() {
        STATUS_CODE response = STATUS_CODE.FAILURE;
        if (this.xmlDocument != null) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String xpathPattern = "/wap-provisioningdoc/characteristic[@type='status']/parm[@name='code']";
            try {
                XPathExpression expr = xpath.compile(xpathPattern);
                Object result = expr.evaluate(this.xmlDocument, XPathConstants.NODESET);
                NodeList statusNodes = (NodeList)result;
                String strStatusCode = statusNodes.item(0).getAttributes().getNamedItem("value").getNodeValue();
                int iStatusCode = Integer.parseInt(strStatusCode);
                switch (iStatusCode) {
                    case 0: {
                        response = STATUS_CODE.SUCCESS;
                        break;
                    }
                    case 1: {
                        response = STATUS_CODE.FAILURE;
                        break;
                    }
                    case 2: {
                        response = STATUS_CODE.UNKNOWN;
                        break;
                    }
                    case 3: {
                        response = STATUS_CODE.NULL_POINTER;
                        break;
                    }
                    case 4: {
                        response = STATUS_CODE.EMPTY_PROFILENAME;
                        break;
                    }
                    case 5: {
                        response = STATUS_CODE.EMDK_NOT_OPENED;
                        break;
                    }
                    case 6: {
                        response = STATUS_CODE.CHECK_XML;
                        break;
                    }
                    case 7: {
                        response = STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS;
                        break;
                    }
                    case 8: {
                        response = STATUS_CODE.PROCESSING;
                        break;
                    }
                    case 9: {
                        response = STATUS_CODE.NO_DATA_LISTENER;
                        break;
                    }
                    case 10: {
                        response = STATUS_CODE.FEATURE_NOT_READY_TO_USE;
                        break;
                    }
                    case 11: {
                        response = STATUS_CODE.FEATURE_NOT_SUPPORTED;
                        break;
                    }
                    case 12: {
                        response = STATUS_CODE.MXMF_IS_NOT_AVAILABLE_ON_THIS_DEVICE;
                    }
                }
            }
            catch (XPathExpressionException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return response;
    }

    public static enum STATUS_CODE {
        SUCCESS(0),
        FAILURE(1),
        UNKNOWN(2),
        NULL_POINTER(3),
        EMPTY_PROFILENAME(4),
        EMDK_NOT_OPENED(5),
        CHECK_XML(6),
        PREVIOUS_REQUEST_IN_PROGRESS(7),
        PROCESSING(8),
        NO_DATA_LISTENER(9),
        FEATURE_NOT_READY_TO_USE(10),
        FEATURE_NOT_SUPPORTED(11),
        MXMF_IS_NOT_AVAILABLE_ON_THIS_DEVICE(12);

        private final int id;

        private STATUS_CODE(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum EXTENDED_STATUS_CODE {
        NONE(0, ""),
        PROFILE_NOT_FOUND_IN_CONFIG(1, "Profile name not found in current config."),
        FEATURE_TYPE_NOT_FOUND_IN_CONFIG(2, "Feature type not found in the profile in current EMDKConfig.xml."),
        FEATURE_NAME_NOT_FOUND_IN_CONFIG(3, "Feature name not found for the feature in current EMDKConfig.xml."),
        FEATURE_NAME_NOT_FOUND_IN_EXTRADATA(4, "The feature name not found in extraData"),
        FEATURE_TYPE_NOT_FOUND_IN_EXTRADATA(5, "The feature type not found in extraData."),
        PROFILE_NOT_FOUND_IN_EXTRADATA(6, "The profile not found in extraData."),
        FEATURE_NOT_UNIQUE_IN_CONFIG(7, "Feature and feature name combination is not unique in current EMDKConfig.xml."),
        FEATURE_NOT_UNIQUE_IN_EXTRADATA(8, "The Feature and Feature name combination is not unique in extraData."),
        DEPENDACY_COMPONENT_FAILURE(10, "Failed to access dependency component."),
        GENERAL_EXCEPTION_OCCURED(12, " Exception occurred while performing requested operation."),
        NAMEVALUE_MISSMATCH_IN_CONFIG(13, "One or more names of parameters not found in current EMDKConfig.xml."),
        NAMEVALUE_MISMATCH_IN_EXTRADATA(14, "One or more names of parameters not found in extraData."),
        INVALID_PROFILE_CONFIGURATION(15, " The current EMDKConfig.xml is invalid."),
        PROFILE_NAME_FORMAT_ERROR(16, "The give profileName format is invalid."),
        ACTIVITY_SELECTION_MERGING_NOT_SUPPORTED(17, "The ActivitySelection merging is not supported."),
        INVALID_VALUE(18, "The parameter/s given are invalid."),
        APP_NOT_ALLOWED_TO_SUBMIT_XML(19, "Application is not allowed to submit xml.");

        private final int id;
        private final String extStatusMessage;

        private EXTENDED_STATUS_CODE(int id, String extStatMessage) {
            this.id = id;
            this.extStatusMessage = extStatMessage;
        }

        int getValue() {
            return this.id;
        }

        String getMessage() {
            return this.extStatusMessage;
        }
    }
}

