/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.util.Log;
import com.symbol.emdk.XmlToObjParser;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public class ProfileConfig {
    private static final String TAG = "Profile_Config";
    public String profileName = "";
    public String modifiedDate = "";
    public DataCapture dataCapture = new DataCapture();
    public ActivitySelection activitySelection = new ActivitySelection();
    private ProfileConfig refConfigBackup = null;

    String parseObjectToXML(String profileName) throws TransformerException, ParserConfigurationException, IOException {
        ParserHelper parserObj = new ParserHelper();
        String xmlString = parserObj.parseObjectToXML(profileName, this);
        return xmlString;
    }

    void parseXMLToObject(String profileName, String profileXML) throws XPathExpressionException {
        XmlToObjParser xmlToObjParser = new XmlToObjParser();
        xmlToObjParser.parseXMLToObject(profileName, profileXML, this);
        this.saveSettingsForComparison();
    }

    void saveSettingsForComparison() {
        if (this.refConfigBackup == null) {
            this.refConfigBackup = new ProfileConfig();
        }
        this.refConfigBackup.profileName = this.profileName;
        this.refConfigBackup.modifiedDate = this.modifiedDate;
        this.dataCapture.saveSettingsForComparison();
        this.activitySelection.saveSettingsForComparison();
    }

    String getFieldValue(Object o, Field field) {
        String fieldValue = "";
        try {
            Class<?> cls = field.getType();
            if (cls.equals(POWER_MODE.class)) {
                fieldValue = ((POWER_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(ILLUMINATION_MODE.class)) {
                fieldValue = ((ILLUMINATION_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(ENABLED_STATE.class)) {
                fieldValue = ((ENABLED_STATE)((Object)field.get(o))).getValue();
            } else if (cls.equals(INVERSE_1D_MODE.class)) {
                fieldValue = ((INVERSE_1D_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(PREAMBLE.class)) {
                fieldValue = ((PREAMBLE)((Object)field.get(o))).getValue();
            } else if (cls.equals(ISBT128_CONTACT_MODE.class)) {
                fieldValue = ((ISBT128_CONTACT_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(SECURITY_LEVEL.class)) {
                fieldValue = ((SECURITY_LEVEL)((Object)field.get(o))).getValue();
            } else if (cls.equals(LINEAR_SECURITY_LEVEL.class)) {
                fieldValue = ((LINEAR_SECURITY_LEVEL)((Object)field.get(o))).getValue();
            } else if (cls.equals(CHECK_DIGIT_TYPE.class)) {
                fieldValue = ((CHECK_DIGIT_TYPE)((Object)field.get(o))).getValue();
            } else if (cls.equals(CHECK_DIGIT.class)) {
                fieldValue = ((CHECK_DIGIT)((Object)field.get(o))).getValue();
            } else if (cls.equals(VERIFY_CHECK_DIGIT.class)) {
                fieldValue = ((VERIFY_CHECK_DIGIT)((Object)field.get(o))).getValue();
            } else if (cls.equals(CHECK_DIGIT_SCHEME.class)) {
                fieldValue = ((CHECK_DIGIT_SCHEME)((Object)field.get(o))).getValue();
            } else if (cls.equals(UCC_LINK_MODE.class)) {
                fieldValue = ((UCC_LINK_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(PICK_LIST.class)) {
                fieldValue = ((PICK_LIST)((Object)field.get(o))).getValue();
            } else if (cls.equals(CODE_ID_TYPE.class)) {
                fieldValue = ((CODE_ID_TYPE)((Object)field.get(o))).getValue();
            } else if (cls.equals(VOLUME_SLIDER_TYPE.class)) {
                fieldValue = ((VOLUME_SLIDER_TYPE)((Object)field.get(o))).getValue();
            } else if (cls.equals(SUPPLEMENTAL_MODE.class)) {
                fieldValue = ((SUPPLEMENTAL_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(COUPON_REPORT.class)) {
                fieldValue = ((COUPON_REPORT)((Object)field.get(o))).getValue();
            } else if (cls.equals(BOOKLAND_FORMAT.class)) {
                fieldValue = ((BOOKLAND_FORMAT)((Object)field.get(o))).getValue();
            } else if (cls.equals(VIEWFINDER_MODE.class)) {
                fieldValue = ((VIEWFINDER_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(INTENT_DELIVERY.class)) {
                fieldValue = ((INTENT_DELIVERY)((Object)field.get(o))).getValue();
            } else if (cls.equals(ACTION_KEY_CHAR.class)) {
                fieldValue = ((ACTION_KEY_CHAR)((Object)field.get(o))).getValue();
            } else if (cls.equals(LCD_MODE.class)) {
                fieldValue = ((LCD_MODE)((Object)field.get(o))).getValue();
            } else if (cls.equals(AIM_TYPE.class)) {
                fieldValue = ((AIM_TYPE)((Object)field.get(o))).getValue();
            } else {
                fieldValue = field.get(o).toString();
                String name = field.getName();
                if ((name.equalsIgnoreCase("length1") || name.equalsIgnoreCase("length2") || name.equalsIgnoreCase("low_power_timeout") || name.equalsIgnoreCase("datacapture_led_id") || name.equalsIgnoreCase("good_decode_led_timer") || name.equalsIgnoreCase("retry_count")) && fieldValue.equalsIgnoreCase("2147483647")) {
                    fieldValue = "";
                }
            }
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        return fieldValue;
    }

    private class ParserHelper {
        private Document document = null;

        private ParserHelper() {
        }

        public String parseObjectToXML(String profileNameStr, ProfileConfig profileData) throws TransformerException, ParserConfigurationException, IOException {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            Element rootElement = this.document.createElement("wap-provisioningdoc");
            this.document.appendChild(rootElement);
            Element parent = this.document.createElement("characteristic");
            rootElement.appendChild(parent);
            parent.setAttribute("type", "Profile");
            Element subChild1 = this.document.createElement("parm");
            parent.appendChild(subChild1);
            subChild1.setAttribute("name", "ProfileName");
            if (!profileNameStr.equalsIgnoreCase("")) {
                subChild1.setAttribute("value", profileNameStr);
            } else {
                subChild1.setAttribute("value", profileData.profileName);
            }
            Element subChild2 = this.document.createElement("parm");
            parent.appendChild(subChild2);
            subChild2.setAttribute("name", "ModifiedDate");
            subChild2.setAttribute("value", Calendar.getInstance().getTime().toString());
            if (profileData.dataCapture != null) {
                profileData.dataCapture.parseObjToXml(this.document, parent);
            }
            if (profileData.activitySelection != null) {
                profileData.activitySelection.parseObjToXml(this.document, parent);
            }
            DOMSource domSource = new DOMSource(this.document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            String retXml = writer.toString();
            writer.close();
            this.document = null;
            return retXml;
        }
    }

    @Deprecated
    public static enum AIM_TYPE {
        DEFAULT("Default"),
        TRIGGER("0"),
        CONTINUOUS_READ("5");

        private final String id;

        private AIM_TYPE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum ACTION_KEY_CHAR {
        DEFAULT("Default"),
        NONE("-1"),
        TAB("9"),
        LINEFEED("10"),
        CARRIAGERETURN("13");

        private final String id;

        private ACTION_KEY_CHAR(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum INTENT_DELIVERY {
        DEFAULT("Default"),
        SEND_VIA_STARTACTIVITY("0"),
        SEND_VIA_STARTSERVICE("1"),
        BROADCAST_INTENT("2");

        private final String id;

        private INTENT_DELIVERY(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum VIEWFINDER_MODE {
        DEFAULT("Default"),
        DISABLED("0"),
        ENABLED("1"),
        STATIC_RECTICLE("2");

        private final String id;

        private VIEWFINDER_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum BOOKLAND_FORMAT {
        DEFAULT("Default"),
        ISBN_10("0"),
        ISBN_13("1");

        private final String id;

        private BOOKLAND_FORMAT(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum COUPON_REPORT {
        DEFAULT("Default"),
        OLD("0"),
        NEW("1"),
        BOTH("2");

        private final String id;

        private COUPON_REPORT(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum SUPPLEMENTAL_MODE {
        DEFAULT("Default"),
        NO("0"),
        ALWAYS("1"),
        AUTO("2"),
        SMART("3"),
        S_378_379("4"),
        S_978_979("5"),
        S_414_419_434_439("6"),
        S_977("7");

        private final String id;

        private SUPPLEMENTAL_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum VOLUME_SLIDER_TYPE {
        DEFAULT("Default"),
        RINGER_AND_NOTIFICATIONS("0"),
        MUSIC_AND_MEDIA("1"),
        ALARM("2");

        private final String id;

        private VOLUME_SLIDER_TYPE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum CODE_ID_TYPE {
        DEFAULT("Default"),
        NONE("0"),
        AIM("1"),
        SYMBOL("2");

        private final String id;

        private CODE_ID_TYPE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum PICK_LIST {
        DEFAULT("Default"),
        DISABLED("0"),
        ENABLED("1"),
        CENTERED("2");

        private final String id;

        private PICK_LIST(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum UCC_LINK_MODE {
        DEFAULT("Default"),
        LINK_FLAG_IGNORED("0"),
        ALWAYS_LINKED("1"),
        AUTO_DISCRIMINATE("2");

        private final String id;

        private UCC_LINK_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum CHECK_DIGIT_SCHEME {
        DEFAULT("Default"),
        MOD_11_10("0"),
        MOD_10_10("1");

        private final String id;

        private CHECK_DIGIT_SCHEME(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum VERIFY_CHECK_DIGIT {
        DEFAULT("Default"),
        NO("0"),
        ONE("1"),
        TWO("2");

        private final String id;

        private VERIFY_CHECK_DIGIT(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum CHECK_DIGIT {
        DEFAULT("Default"),
        ONE("0"),
        TWO("1");

        private final String id;

        private CHECK_DIGIT(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum CHECK_DIGIT_TYPE {
        DEFAULT("Default"),
        NO("0"),
        USS("1"),
        OPCC("2");

        private final String id;

        private CHECK_DIGIT_TYPE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum LINEAR_SECURITY_LEVEL {
        DEFAULT("Default"),
        SHORT_OR_CODABAR("1"),
        ALL_TWICE("2"),
        LONG_AND_SHORT("3"),
        ALL_THRICE("4");

        private final String id;

        private LINEAR_SECURITY_LEVEL(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum POWER_MODE {
        DEFAULT("Default"),
        LOW("0"),
        OPTIMIZED("1"),
        HIGH("2"),
        ALWAYS_ON("3");

        private final String id;

        private POWER_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum SECURITY_LEVEL {
        DEFAULT("Default"),
        LEVEL_0("0"),
        LEVEL_1("1"),
        LEVEL_2("2"),
        LEVEL_3("3");

        private final String id;

        private SECURITY_LEVEL(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum ISBT128_CONTACT_MODE {
        DEFAULT("Default"),
        NEVER("0"),
        ALWAYS("1"),
        AUTO("2");

        private final String id;

        private ISBT128_CONTACT_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum PREAMBLE {
        DEFAULT("Default"),
        NONE("0"),
        SYS_CHAR("1"),
        COUNTRY_AND_SYS_CHAR("2");

        private final String id;

        private PREAMBLE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum INVERSE_1D_MODE {
        DEFAULT("Default"),
        DISABLED("0"),
        ENABLED("1"),
        AUTO("2");

        private final String id;

        private INVERSE_1D_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum LCD_MODE {
        DEFAULT("Default"),
        DISABLED("0"),
        ENABLED("3");

        private final String id;

        private LCD_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum ILLUMINATION_MODE {
        DEFAULT("Default"),
        OFF("off"),
        ON("torch");

        private final String id;

        private ILLUMINATION_MODE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum ENABLED_STATE {
        DEFAULT("Default"),
        FALSE("false"),
        TRUE("true");

        private final String id;

        private ENABLED_STATE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum DEVICETYPES {
        AUTO,
        INTERNAL_LASER1,
        INTERNAL_CAMERA1,
        INTERNAL_IMAGER1;

    }

    @Deprecated
    public class ActivitySelection {
        public ArrayList<ActivityElement> activities = new ArrayList();

        private void saveSettingsForComparison() {
            ((ProfileConfig)ProfileConfig.this).refConfigBackup.activitySelection.activities = this.activities;
        }

        private boolean parseObjToXml(Document document, Element parent) {
            boolean status = false;
            Element element = document.createElement("characteristic");
            element.setAttribute("type", this.getClass().getSimpleName());
            element.setAttribute("version", "0.1");
            try {
                for (ActivityElement ae : this.activities) {
                    Element charNode = document.createElement("characteristic");
                    charNode.setAttribute("type", "Application");
                    element.appendChild(charNode);
                    Element packageNode = document.createElement("parm");
                    charNode.appendChild(packageNode);
                    packageNode.setAttribute("name", "package");
                    packageNode.setAttribute("value", ae.packageName);
                    Element activitiesNode = document.createElement("characteristic");
                    activitiesNode.setAttribute("type", "Activities");
                    charNode.appendChild(activitiesNode);
                    for (String activityName : ae.activityList) {
                        Element parmNode = document.createElement("parm");
                        activitiesNode.appendChild(parmNode);
                        parmNode.setAttribute("name", "Activity");
                        parmNode.setAttribute("value", activityName);
                        status = true;
                    }
                }
                if (status) {
                    parent.appendChild(element);
                }
            }
            catch (Exception e) {
                Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
            }
            return status;
        }

        @Deprecated
        public class ActivityElement {
            public String packageName = "";
            private ArrayList<String> activityList = new ArrayList();

            public ActivityElement(String packageName, String ... activities) {
                this.packageName = packageName;
                for (String activityName : activities) {
                    this.activityList.add(activityName);
                }
            }
        }
    }

    @Deprecated
    public class DataCapture {
        public MSR msr = new MSR();
        public Barcode barcode = new Barcode();
        public DataDelivery dataDelivery = new DataDelivery();

        DataCapture() {
        }

        void saveSettingsForComparison() {
            this.msr.saveSettingsForComparison();
            this.barcode.saveSettingsForComparison();
            this.dataDelivery.saveSettingsForComparison();
        }

        private boolean parseObjToXml(Document document, Element parent) {
            this.msr.parseObjToXml(document, parent);
            this.barcode.parseObjToXml(document, parent);
            this.dataDelivery.parseObjToXml(document, parent);
            return true;
        }

        @Deprecated
        public class DataDelivery {
            public Intent intent = new Intent();
            public Keystroke keystroke = new Keystroke();

            DataDelivery() {
            }

            void saveSettingsForComparison() {
                this.intent.saveSettingsForComparison();
                this.keystroke.saveSettingsForComparison();
            }

            private boolean parseObjToXml(Document document, Element parent) {
                this.keystroke.parseObjToXml(document, parent);
                this.intent.parseObjToXml(document, parent);
                return true;
            }

            @Deprecated
            public class BasicDataFormatting {
                public ENABLED_STATE bdf_enabled = ENABLED_STATE.DEFAULT;
                public String bdf_prefix = "";
                public String bdf_suffix = "";
                public ENABLED_STATE bdf_send_data = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE bdf_send_hex = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE bdf_send_tab = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE bdf_send_enter = ENABLED_STATE.DEFAULT;

                private BasicDataFormatting() {
                }

                private void saveSettingsForComparison(BasicDataFormatting refBDF) {
                    refBDF.bdf_enabled = this.bdf_enabled;
                    refBDF.bdf_prefix = this.bdf_prefix;
                    refBDF.bdf_suffix = this.bdf_suffix;
                    refBDF.bdf_send_data = this.bdf_send_data;
                    refBDF.bdf_send_hex = this.bdf_send_hex;
                    refBDF.bdf_send_tab = this.bdf_send_tab;
                    refBDF.bdf_send_enter = this.bdf_send_enter;
                }

                private boolean parseObjToXml(Document document, Element parent, BasicDataFormatting refBDF) {
                    boolean status = false;
                    String className = this.getClass().getSimpleName();
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", className);
                    try {
                        Field[] publicFields;
                        Class<?> c = this.getClass();
                        for (Field field : publicFields = c.getFields()) {
                            String name = field.getName();
                            Object value = field.get(this);
                            if (refBDF != null && value.equals(field.get(refBDF))) continue;
                            Element parmNode = document.createElement("parm");
                            element.appendChild(parmNode);
                            parmNode.setAttribute("name", name);
                            parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                            status = true;
                        }
                        if (status) {
                            parent.appendChild(element);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                    }
                    return status;
                }
            }

            @Deprecated
            public class Keystroke {
                public ENABLED_STATE ime_output_enabled = ENABLED_STATE.DEFAULT;
                public ACTION_KEY_CHAR keystroke_action_char = ACTION_KEY_CHAR.DEFAULT;
                public BasicDataFormatting basicDataFormatting = new BasicDataFormatting();

                private Keystroke() {
                }

                private void saveSettingsForComparison() {
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.keystroke.ime_output_enabled = this.ime_output_enabled;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.keystroke.keystroke_action_char = this.keystroke_action_char;
                    this.basicDataFormatting.saveSettingsForComparison(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.keystroke.basicDataFormatting);
                }

                private boolean parseObjToXml(Document document, Element parent) {
                    boolean status = false;
                    String className = this.getClass().getSimpleName();
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", className);
                    element.setAttribute("version", "0.1");
                    try {
                        Field[] publicFields;
                        Class<?> c = this.getClass();
                        for (Field field : publicFields = c.getFields()) {
                            String name = field.getName();
                            if (name.equalsIgnoreCase("BasicDataFormatting")) continue;
                            Object value = field.get(this);
                            if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.keystroke != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.keystroke))) continue;
                            Element parmNode = document.createElement("parm");
                            element.appendChild(parmNode);
                            parmNode.setAttribute("name", name);
                            parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                            status = true;
                        }
                        if (this.basicDataFormatting != null) {
                            BasicDataFormatting org = null;
                            if (null != ProfileConfig.this.refConfigBackup && null != ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.keystroke) {
                                org = ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.keystroke.basicDataFormatting;
                            }
                            if (this.basicDataFormatting.parseObjToXml(document, element, org)) {
                                status = true;
                            }
                        }
                        if (status) {
                            parent.appendChild(element);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                    }
                    return status;
                }
            }

            @Deprecated
            public class Intent {
                private String variablePrefix = "intent_";
                public ENABLED_STATE output_enabled = ENABLED_STATE.DEFAULT;
                public String action = "";
                public String category = "";
                public INTENT_DELIVERY delivery = INTENT_DELIVERY.DEFAULT;
                public BasicDataFormatting basicDataFormatting = new BasicDataFormatting();

                private Intent() {
                }

                private void saveSettingsForComparison() {
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent.output_enabled = this.output_enabled;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent.action = this.action;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent.category = this.category;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent.delivery = this.delivery;
                    this.basicDataFormatting.saveSettingsForComparison(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent.basicDataFormatting);
                }

                private boolean parseObjToXml(Document document, Element parent) {
                    boolean status = false;
                    String className = this.getClass().getSimpleName();
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", className);
                    element.setAttribute("version", "0.1");
                    try {
                        Field[] publicFields;
                        Class<?> c = this.getClass();
                        for (Field field : publicFields = c.getFields()) {
                            String name = field.getName();
                            if (name.equalsIgnoreCase("BasicDataFormatting")) continue;
                            Object value = field.get(this);
                            if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent))) continue;
                            Element parmNode = document.createElement("parm");
                            element.appendChild(parmNode);
                            parmNode.setAttribute("name", this.variablePrefix + name);
                            parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                            status = true;
                        }
                        if (this.basicDataFormatting != null) {
                            BasicDataFormatting org = null;
                            if (null != ProfileConfig.this.refConfigBackup && null != ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent) {
                                org = ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.dataDelivery.intent.basicDataFormatting;
                            }
                            if (this.basicDataFormatting.parseObjToXml(document, element, org)) {
                                status = true;
                            }
                        }
                        if (status) {
                            parent.appendChild(element);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                    }
                    return status;
                }
            }
        }

        @Deprecated
        public class Barcode {
            public ENABLED_STATE scanner_input_enabled = ENABLED_STATE.DEFAULT;
            public DEVICETYPES scannerSelection = DEVICETYPES.AUTO;
            public Decoders decoders = new Decoders();
            public DecoderParams decoderParams = new DecoderParams();
            public ReaderParams readerParams = new ReaderParams();
            public ScanParams scanParams = new ScanParams();
            public UpcEanParams upcEanParams = new UpcEanParams();

            private Barcode() {
            }

            private void saveSettingsForComparison() {
                ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanner_input_enabled = this.scanner_input_enabled;
                ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scannerSelection = this.scannerSelection;
                if (this.decoders != null) {
                    this.decoders.saveSettingsForComparison();
                }
                if (this.decoderParams != null) {
                    this.decoderParams.saveSettingsForComparison();
                }
                if (this.readerParams != null) {
                    this.readerParams.saveSettingsForComparison();
                }
                if (this.scanParams != null) {
                    this.scanParams.saveSettingsForComparison();
                }
                if (this.upcEanParams != null) {
                    this.upcEanParams.saveSettingsForComparison();
                }
            }

            private boolean parseObjToXml(Document document, Element parent) {
                boolean status = false;
                Element element = document.createElement("characteristic");
                element.setAttribute("type", "Barcode");
                element.setAttribute("version", "0.1");
                if (ProfileConfig.this.refConfigBackup == null || ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode == null || this.scanner_input_enabled != ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanner_input_enabled) {
                    Element scnNode = document.createElement("parm");
                    element.appendChild(scnNode);
                    scnNode.setAttribute("name", "scanner_input_enabled");
                    scnNode.setAttribute("value", this.scanner_input_enabled.getValue());
                    status = true;
                }
                if (ProfileConfig.this.refConfigBackup == null || ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode == null || this.scannerSelection != ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scannerSelection) {
                    Element scnSelNode = document.createElement("parm");
                    element.appendChild(scnSelNode);
                    scnSelNode.setAttribute("name", "scannerSelection");
                    scnSelNode.setAttribute("value", this.scannerSelection.toString());
                    status = true;
                }
                if (this.decoders != null && this.decoders.parseObjToXml(document, element)) {
                    status = true;
                }
                if (this.decoderParams != null && this.decoderParams.parseObjToXml(document, element)) {
                    status = true;
                }
                if (this.readerParams != null && this.readerParams.parseObjToXml(document, element)) {
                    status = true;
                }
                if (this.scanParams != null && this.scanParams.parseObjToXml(document, element)) {
                    status = true;
                }
                if (this.upcEanParams != null && this.upcEanParams.parseObjToXml(document, element)) {
                    status = true;
                }
                if (status) {
                    parent.appendChild(element);
                }
                return status;
            }

            @Deprecated
            public class UpcEanParams {
                private String variablePrefix = "upcean_";
                public SECURITY_LEVEL security_level = SECURITY_LEVEL.DEFAULT;
                public ENABLED_STATE supplemental2 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE supplemental5 = ENABLED_STATE.DEFAULT;
                public SUPPLEMENTAL_MODE supplemental_mode = SUPPLEMENTAL_MODE.DEFAULT;
                public int retry_count = Integer.MAX_VALUE;
                public ENABLED_STATE random_weight_check_digit = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE linear_decode = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE bookland = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE coupon = ENABLED_STATE.DEFAULT;
                public COUPON_REPORT coupon_report = COUPON_REPORT.DEFAULT;
                public ENABLED_STATE ean_zero_extend = ENABLED_STATE.DEFAULT;
                public BOOKLAND_FORMAT bookland_format = BOOKLAND_FORMAT.DEFAULT;
                public ENABLED_STATE databar_to_upc_ean = ENABLED_STATE.DEFAULT;

                private UpcEanParams() {
                }

                private void saveSettingsForComparison() {
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.security_level = this.security_level;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.supplemental2 = this.supplemental2;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.supplemental5 = this.supplemental5;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.supplemental_mode = this.supplemental_mode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.retry_count = this.retry_count;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.random_weight_check_digit = this.random_weight_check_digit;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.linear_decode = this.linear_decode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.bookland = this.bookland;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.coupon = this.coupon;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.coupon_report = this.coupon_report;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.ean_zero_extend = this.ean_zero_extend;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.bookland_format = this.bookland_format;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams.databar_to_upc_ean = this.databar_to_upc_ean;
                }

                private boolean parseObjToXml(Document document, Element parent) {
                    boolean status = false;
                    String className = this.getClass().getSimpleName();
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", className);
                    try {
                        Field[] publicFields;
                        Class<?> c = this.getClass();
                        for (Field field : publicFields = c.getFields()) {
                            String name = field.getName();
                            Object value = field.get(this);
                            if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.upcEanParams))) continue;
                            Element parmNode = document.createElement("parm");
                            element.appendChild(parmNode);
                            if (!name.equalsIgnoreCase("databar_to_upc_ean")) {
                                parmNode.setAttribute("name", this.variablePrefix + name);
                            } else {
                                parmNode.setAttribute("name", name);
                            }
                            parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                            status = true;
                        }
                        if (status) {
                            parent.appendChild(element);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                    }
                    return status;
                }
            }

            @Deprecated
            public class ScanParams {
                public CODE_ID_TYPE code_id_type = CODE_ID_TYPE.DEFAULT;
                public VOLUME_SLIDER_TYPE volume_slider_type = VOLUME_SLIDER_TYPE.DEFAULT;
                public String decode_audio_feedback_uri = "";
                public ENABLED_STATE decode_haptic_feedback = ENABLED_STATE.DEFAULT;
                public int good_decode_led_timer = Integer.MAX_VALUE;
                public ENABLED_STATE decoding_led_feedback = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE bt_disconnect_on_exit = ENABLED_STATE.DEFAULT;
                public int connection_idle_time = 600;
                public ENABLED_STATE display_bt_address_barcode = ENABLED_STATE.DEFAULT;
                public int establish_connection_time = 45;
                @Deprecated
                public int datacapture_led_id = Integer.MAX_VALUE;

                private ScanParams() {
                }

                private void saveSettingsForComparison() {
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.code_id_type = this.code_id_type;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.decode_audio_feedback_uri = this.decode_audio_feedback_uri;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.decode_haptic_feedback = this.decode_haptic_feedback;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.good_decode_led_timer = this.good_decode_led_timer;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.decoding_led_feedback = this.decoding_led_feedback;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.bt_disconnect_on_exit = this.bt_disconnect_on_exit;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.connection_idle_time = this.connection_idle_time;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.display_bt_address_barcode = this.display_bt_address_barcode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.establish_connection_time = this.establish_connection_time;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams.datacapture_led_id = this.datacapture_led_id;
                }

                private boolean parseObjToXml(Document document, Element parent) {
                    boolean status = false;
                    String className = this.getClass().getSimpleName();
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", className);
                    try {
                        Field[] publicFields;
                        Class<?> c = this.getClass();
                        for (Field field : publicFields = c.getFields()) {
                            String name = field.getName();
                            Object value = field.get(this);
                            if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.scanParams))) continue;
                            Element parmNode = document.createElement("parm");
                            element.appendChild(parmNode);
                            parmNode.setAttribute("name", name);
                            parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                            status = true;
                        }
                        if (status) {
                            parent.appendChild(element);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                    }
                    return status;
                }
            }

            @Deprecated
            public class ReaderParams {
                public AIM_TYPE aim_type = AIM_TYPE.DEFAULT;
                public int same_barcode_timeout = 500;
                public int different_barcode_timeout = 500;
                public int beam_timer = Integer.MAX_VALUE;
                public POWER_MODE power_mode = POWER_MODE.DEFAULT;
                public LINEAR_SECURITY_LEVEL linear_security_level = LINEAR_SECURITY_LEVEL.DEFAULT;
                public PICK_LIST picklist = PICK_LIST.DEFAULT;
                public ILLUMINATION_MODE illumination_mode = ILLUMINATION_MODE.DEFAULT;
                public LCD_MODE lcd_mode = LCD_MODE.DEFAULT;
                @Deprecated
                public int low_power_timeout = Integer.MAX_VALUE;
                public int illumination_brightness = 10;
                public INVERSE_1D_MODE inverse_1d_mode = INVERSE_1D_MODE.DEFAULT;
                public VIEWFINDER_MODE viewfinder_mode = VIEWFINDER_MODE.DEFAULT;

                private ReaderParams() {
                }

                private void saveSettingsForComparison() {
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.aim_type = this.aim_type;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.same_barcode_timeout = this.same_barcode_timeout;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.different_barcode_timeout = this.different_barcode_timeout;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.beam_timer = this.beam_timer;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.power_mode = this.power_mode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.linear_security_level = this.linear_security_level;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.picklist = this.picklist;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.illumination_mode = this.illumination_mode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.lcd_mode = this.lcd_mode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.low_power_timeout = this.low_power_timeout;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.illumination_brightness = this.illumination_brightness;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.inverse_1d_mode = this.inverse_1d_mode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams.viewfinder_mode = this.viewfinder_mode;
                }

                private boolean parseObjToXml(Document document, Element parent) {
                    boolean status = false;
                    String className = this.getClass().getSimpleName();
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", className);
                    try {
                        Field[] publicFields;
                        Class<?> c = this.getClass();
                        for (Field field : publicFields = c.getFields()) {
                            String name = field.getName();
                            Object value = field.get(this);
                            if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.readerParams))) continue;
                            Element parmNode = document.createElement("parm");
                            element.appendChild(parmNode);
                            parmNode.setAttribute("name", name);
                            parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                            status = true;
                        }
                        if (status) {
                            parent.appendChild(element);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                    }
                    return status;
                }
            }

            @Deprecated
            public class DecoderParams {
                private String variablePrefix = "decoder_";
                public UPCA upca = new UPCA();
                public UPCE0 upce0 = new UPCE0();
                public EAN8 ean8 = new EAN8();
                public Code128 code128 = new Code128();
                public Code39 code39 = new Code39();
                public Interleaved_2of5 interleaved_2of5 = new Interleaved_2of5();
                public Composite_AB composite_AB = new Composite_AB();
                public USPostnet usPostnet = new USPostnet();
                public USPlanet usPlanet = new USPlanet();
                public UK_Postal uk_Postal = new UK_Postal();
                public Codabar codabar = new Codabar();
                public MSI msi = new MSI();
                public Code93 code93 = new Code93();
                public Trioptic39 trioptic39 = new Trioptic39();
                public Discrete_2of5 discrete_2of5 = new Discrete_2of5();
                public Code11 code11 = new Code11();
                public Matrix_2of5 matrix_2of5 = new Matrix_2of5();
                public UPCE1 upce1 = new UPCE1();

                private DecoderParams() {
                }

                private void saveSettingsForComparison() {
                    this.upca.saveSettingsForComparison();
                    this.upce0.saveSettingsForComparison();
                    this.ean8.saveSettingsForComparison();
                    this.code128.saveSettingsForComparison();
                    this.code39.saveSettingsForComparison();
                    this.interleaved_2of5.saveSettingsForComparison();
                    this.composite_AB.saveSettingsForComparison();
                    this.usPostnet.saveSettingsForComparison();
                    this.uk_Postal.saveSettingsForComparison();
                    this.codabar.saveSettingsForComparison();
                    this.msi.saveSettingsForComparison();
                    this.code93.saveSettingsForComparison();
                    this.discrete_2of5.saveSettingsForComparison();
                    this.code11.saveSettingsForComparison();
                    this.matrix_2of5.saveSettingsForComparison();
                    this.upce1.saveSettingsForComparison();
                }

                private boolean parseObjToXml(Document document, Element parent) {
                    boolean status = false;
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", this.getClass().getSimpleName());
                    if (this.upca != null && this.upca.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.upce0 != null && this.upce0.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.ean8 != null && this.ean8.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.code128 != null && this.code128.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.code39 != null && this.code39.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.interleaved_2of5 != null && this.interleaved_2of5.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.composite_AB != null && this.composite_AB.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.usPostnet != null && this.usPostnet.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.usPlanet != null && this.usPlanet.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.uk_Postal != null && this.uk_Postal.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.codabar != null && this.codabar.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.msi != null && this.msi.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.code93 != null && this.code93.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.trioptic39 != null && this.trioptic39.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.discrete_2of5 != null && this.discrete_2of5.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.matrix_2of5 != null && this.matrix_2of5.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.code11 != null && this.code11.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (this.upce1 != null && this.upce1.parseObjToXml(document, element)) {
                        status = true;
                    }
                    if (status) {
                        parent.appendChild(element);
                    }
                    return status;
                }

                @Deprecated
                public class UPCE1 {
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;
                    public PREAMBLE preamble = PREAMBLE.DEFAULT;
                    public ENABLED_STATE convert_to_upca = ENABLED_STATE.DEFAULT;

                    private UPCE1() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce1.report_check_digit = this.report_check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce1.preamble = this.preamble;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce1.convert_to_upca = this.convert_to_upca;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce1 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce1))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Matrix_2of5 {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE verify_check_digit = ENABLED_STATE.DEFAULT;

                    private Matrix_2of5() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.matrix_2of5.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.matrix_2of5.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.matrix_2of5.redundancy = this.redundancy;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.matrix_2of5.verify_check_digit = this.verify_check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.matrix_2of5.report_check_digit = this.report_check_digit;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.matrix_2of5 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.matrix_2of5))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Code11 {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;
                    public VERIFY_CHECK_DIGIT verify_check_digit = VERIFY_CHECK_DIGIT.DEFAULT;
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;

                    private Code11() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code11.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code11.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code11.redundancy = this.redundancy;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code11.verify_check_digit = this.verify_check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code11.report_check_digit = this.report_check_digit;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code11 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code11))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Discrete_2of5 {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;

                    private Discrete_2of5() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.discrete_2of5.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.discrete_2of5.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.discrete_2of5.redundancy = this.redundancy;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.discrete_2of5 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.discrete_2of5))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + "d2of5_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Trioptic39 {
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;

                    private Trioptic39() {
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.trioptic39 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.trioptic39))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Code93 {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;

                    private Code93() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code93.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code93.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code93.redundancy = this.redundancy;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code93 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code93))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class MSI {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;
                    public CHECK_DIGIT check_digit = CHECK_DIGIT.DEFAULT;
                    public CHECK_DIGIT_SCHEME check_digit_scheme = CHECK_DIGIT_SCHEME.DEFAULT;
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;

                    private MSI() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi.redundancy = this.redundancy;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi.check_digit = this.check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi.check_digit_scheme = this.check_digit_scheme;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi.report_check_digit = this.report_check_digit;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.msi))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Codabar {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE clsi_editing = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE notis_editing = ENABLED_STATE.DEFAULT;

                    private Codabar() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.codabar.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.codabar.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.codabar.redundancy = this.redundancy;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.codabar.clsi_editing = this.clsi_editing;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.codabar.notis_editing = this.notis_editing;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.codabar != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.codabar))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class UK_Postal {
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;

                    private UK_Postal() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.uk_Postal.report_check_digit = this.report_check_digit;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.uk_Postal != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.uk_Postal))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class USPlanet {
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;

                    private USPlanet() {
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.usPlanet != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.usPlanet))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class USPostnet {
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;

                    private USPostnet() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.usPostnet.report_check_digit = this.report_check_digit;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.usPostnet != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.usPostnet))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Composite_AB {
                    public UCC_LINK_MODE ucc_link_mode = UCC_LINK_MODE.DEFAULT;

                    private Composite_AB() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.composite_AB.ucc_link_mode = this.ucc_link_mode;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.composite_AB != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.composite_AB))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Interleaved_2of5 {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;
                    public CHECK_DIGIT_TYPE check_digit = CHECK_DIGIT_TYPE.DEFAULT;
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE convert_itf14_to_ean13 = ENABLED_STATE.DEFAULT;
                    public SECURITY_LEVEL security_level = SECURITY_LEVEL.DEFAULT;

                    private Interleaved_2of5() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5.redundancy = this.redundancy;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5.check_digit = this.check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5.report_check_digit = this.report_check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5.convert_itf14_to_ean13 = this.convert_itf14_to_ean13;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5.security_level = this.security_level;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.interleaved_2of5))) continue;
                                String xmlAttrValue = "";
                                xmlAttrValue = name.equalsIgnoreCase("convert_itf14_to_ean13") ? DecoderParams.this.variablePrefix + "itf14_convert_to_ean13" : DecoderParams.this.variablePrefix + "i2of5_" + name;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", xmlAttrValue);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Code39 {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE verify_check_digit = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE full_ascii = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE convert_to_code32 = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE report_code32_prefix = ENABLED_STATE.DEFAULT;
                    public SECURITY_LEVEL security_level = SECURITY_LEVEL.DEFAULT;

                    private Code39() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.verify_check_digit = this.verify_check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.report_check_digit = this.report_check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.full_ascii = this.full_ascii;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.redundancy = this.redundancy;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.convert_to_code32 = this.convert_to_code32;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.report_code32_prefix = this.report_code32_prefix;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39.security_level = this.security_level;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code39))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class Code128 {
                    public int length1 = Integer.MAX_VALUE;
                    public int length2 = Integer.MAX_VALUE;
                    public ENABLED_STATE redundancy = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE enable_plain = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE enable_ean128 = ENABLED_STATE.DEFAULT;
                    public ENABLED_STATE enable_isbt128 = ENABLED_STATE.DEFAULT;
                    public ISBT128_CONTACT_MODE isbt128_concat_mode = ISBT128_CONTACT_MODE.DEFAULT;
                    public ENABLED_STATE check_isbt_table = ENABLED_STATE.DEFAULT;
                    public SECURITY_LEVEL security_level = SECURITY_LEVEL.DEFAULT;

                    private Code128() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.length1 = this.length1;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.length2 = this.length2;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.redundancy = this.redundancy;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.enable_plain = this.enable_plain;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.enable_ean128 = this.enable_ean128;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.enable_isbt128 = this.enable_isbt128;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.isbt128_concat_mode = this.isbt128_concat_mode;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.check_isbt_table = this.check_isbt_table;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128.security_level = this.security_level;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.code128))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class EAN8 {
                    public ENABLED_STATE convert_to_ean13 = ENABLED_STATE.DEFAULT;

                    private EAN8() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.ean8.convert_to_ean13 = this.convert_to_ean13;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.ean8 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.ean8))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class UPCE0 {
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;
                    public PREAMBLE preamble = PREAMBLE.DEFAULT;
                    public ENABLED_STATE convert_to_upca = ENABLED_STATE.DEFAULT;

                    private UPCE0() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce0.report_check_digit = this.report_check_digit;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce0.preamble = this.preamble;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce0.convert_to_upca = this.convert_to_upca;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce0 != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upce0))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }

                @Deprecated
                public class UPCA {
                    public PREAMBLE preamble = PREAMBLE.DEFAULT;
                    public ENABLED_STATE report_check_digit = ENABLED_STATE.DEFAULT;

                    private UPCA() {
                    }

                    private void saveSettingsForComparison() {
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upca.preamble = this.preamble;
                        ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upca.report_check_digit = this.report_check_digit;
                    }

                    private boolean parseObjToXml(Document document, Element parent) {
                        boolean status = false;
                        String className = this.getClass().getSimpleName();
                        Element element = document.createElement("characteristic");
                        element.setAttribute("type", className);
                        try {
                            Field[] publicFields;
                            Class<?> c = this.getClass();
                            for (Field field : publicFields = c.getFields()) {
                                String name = field.getName();
                                Object value = field.get(this);
                                if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upca != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoderParams.upca))) continue;
                                Element parmNode = document.createElement("parm");
                                element.appendChild(parmNode);
                                parmNode.setAttribute("name", DecoderParams.this.variablePrefix + className.toLowerCase(Locale.ENGLISH) + "_" + name);
                                parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                                status = true;
                            }
                            if (status) {
                                parent.appendChild(element);
                            }
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                        }
                        return status;
                    }
                }
            }

            @Deprecated
            public class Decoders {
                private String variablePrefix = "decoder_";
                public ENABLED_STATE upca = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE upce0 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE ean13 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE ean8 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE code128 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE code39 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE i2of5 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE gs1_databar = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE gs1_databar_lim = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE gs1_databar_exp = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE datamatrix = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE qrcode = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE pdf417 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE composite_ab = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE composite_c = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE microqr = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE aztec = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE maxicode = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE micropdf = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE uspostnet = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE usplanet = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE uk_postal = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE japanese_postal = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE australian_postal = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE canadian_postal = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE dutch_postal = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE us4state = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE us4state_fics = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE codabar = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE msi = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE code93 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE trioptic39 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE d2of5 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE chinese_2of5 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE korean_3of5 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE code11 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE tlc39 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE signature = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE webcode = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE matrix_2of5 = ENABLED_STATE.DEFAULT;
                public ENABLED_STATE upce1 = ENABLED_STATE.DEFAULT;

                private Decoders() {
                }

                private void saveSettingsForComparison() {
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.australian_postal = this.australian_postal;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.aztec = this.aztec;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.canadian_postal = this.canadian_postal;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.chinese_2of5 = this.chinese_2of5;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.codabar = this.codabar;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.code11 = this.code11;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.code128 = this.code128;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.code39 = this.code39;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.code93 = this.code93;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.composite_ab = this.composite_ab;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.composite_c = this.composite_c;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.d2of5 = this.d2of5;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.datamatrix = this.datamatrix;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.dutch_postal = this.dutch_postal;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.ean13 = this.ean13;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.ean8 = this.ean8;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.gs1_databar = this.gs1_databar;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.gs1_databar_exp = this.gs1_databar_exp;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.gs1_databar_lim = this.gs1_databar_lim;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.i2of5 = this.i2of5;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.japanese_postal = this.japanese_postal;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.korean_3of5 = this.korean_3of5;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.matrix_2of5 = this.matrix_2of5;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.maxicode = this.maxicode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.micropdf = this.micropdf;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.microqr = this.microqr;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.msi = this.msi;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.pdf417 = this.pdf417;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.qrcode = this.qrcode;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.signature = this.signature;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.tlc39 = this.tlc39;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.trioptic39 = this.trioptic39;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.uk_postal = this.uk_postal;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.upca = this.upca;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.upce0 = this.upce0;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.upce1 = this.upce1;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.us4state = this.us4state;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.us4state_fics = this.us4state_fics;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.usplanet = this.usplanet;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.uspostnet = this.uspostnet;
                    ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders.webcode = this.webcode;
                }

                private boolean parseObjToXml(Document document, Element parent) {
                    boolean status = false;
                    Element element = document.createElement("characteristic");
                    element.setAttribute("type", this.getClass().getSimpleName());
                    try {
                        Field[] publicFields;
                        Class<?> c = this.getClass();
                        for (Field field : publicFields = c.getFields()) {
                            String name = field.getName();
                            Object value = field.get(this);
                            if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.barcode.decoders))) continue;
                            Element parmNode = document.createElement("parm");
                            element.appendChild(parmNode);
                            parmNode.setAttribute("name", this.variablePrefix + name);
                            parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                            status = true;
                        }
                        if (status) {
                            parent.appendChild(element);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                    }
                    return status;
                }
            }
        }

        @Deprecated
        public class MSR {
            public ENABLED_STATE msr_input_enabled = ENABLED_STATE.DEFAULT;

            private void saveSettingsForComparison() {
                ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.msr.msr_input_enabled = this.msr_input_enabled;
            }

            private boolean parseObjToXml(Document document, Element parent) {
                boolean status = false;
                Element element = document.createElement("characteristic");
                element.setAttribute("type", this.getClass().getSimpleName());
                element.setAttribute("version", "0.1");
                try {
                    Field[] publicFields;
                    Class<?> c = this.getClass();
                    for (Field field : publicFields = c.getFields()) {
                        String name = field.getName();
                        Object value = field.get(this);
                        if (ProfileConfig.this.refConfigBackup != null && ((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.msr != null && value.equals(field.get(((ProfileConfig)ProfileConfig.this).refConfigBackup.dataCapture.msr))) continue;
                        Element parmNode = document.createElement("parm");
                        element.appendChild(parmNode);
                        parmNode.setAttribute("name", name);
                        parmNode.setAttribute("value", ProfileConfig.this.getFieldValue(this, field));
                        status = true;
                    }
                    if (status) {
                        parent.appendChild(element);
                    }
                }
                catch (IllegalAccessException e) {
                    Log.e((String)ProfileConfig.TAG, (String)("" + e.getMessage()));
                }
                return status;
            }
        }
    }
}

