/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;

public class VersionManager
extends EMDKBase {
    private static final String TAG = "Version_Manager";
    private EMDKServiceConnection emdkServiceConnection = null;

    VersionManager(Context context, EMDKServiceConnection emdkServiceConnection) {
        super(EMDKManager.FEATURE_TYPE.VERSION);
        this.emdkServiceConnection = emdkServiceConnection;
    }

    boolean initiliaze() {
        return this.emdkServiceConnection.isServiceConnected();
    }

    public String getVersion(VERSION_TYPE versionKey) {
        String versionString = versionKey.getValue();
        try {
            versionString = this.emdkServiceConnection.getService().getVersion(versionString);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        return versionString;
    }

    void release() {
        this.emdkServiceConnection = null;
    }

    public static enum VERSION_TYPE {
        EMDK("EMDK"),
        MX("MX"),
        BARCODE("BARCODE");

        private final String id;

        private VERSION_TYPE(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }
}

