/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.util.Log;
import com.symbol.emdk.ProfileConfig;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XmlToObjParser {
    private Document document = null;
    ProfileConfig profileData = null;
    private static final String TAG = "XML_To_Object_Parser";
    private static final String FEATURE_BARCODE = "Barcode";
    private static final String FEATURE_KEYSTROKE = "Keystroke";
    private static final String FEATURE_INTENT = "Intent";
    private static final String FEATURE_MSR = "MSR";

    XmlToObjParser() {
    }

    protected boolean parseXMLToObject(String profileName, String profileXML, ProfileConfig profileData) throws XPathExpressionException {
        if (profileData == null) {
            return false;
        }
        this.profileData = profileData;
        this.document = this.getDocumentFromString(profileXML);
        if (this.document == null) {
            return false;
        }
        Node profileNode = this.getProfileNode(profileName, this.document);
        if (profileNode == null) {
            return false;
        }
        NodeList nodes = profileNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeName().equalsIgnoreCase("parm")) {
                String name = nodes.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String value = nodes.item(i).getAttributes().getNamedItem("value").getNodeValue();
                if (name.equalsIgnoreCase("ProfileName")) {
                    profileData.profileName = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("ModifiedDate")) continue;
                profileData.modifiedDate = value;
                continue;
            }
            if (!nodes.item(i).getNodeName().equalsIgnoreCase("characteristic")) continue;
            String type = nodes.item(i).getAttributes().getNamedItem("type").getNodeValue();
            if (type.equalsIgnoreCase(FEATURE_BARCODE)) {
                this.parseBarcodeNode(nodes.item(i));
                continue;
            }
            if (type.equalsIgnoreCase(FEATURE_MSR)) {
                this.parseMSRNode(nodes.item(i));
                continue;
            }
            if (type.equalsIgnoreCase(FEATURE_KEYSTROKE)) {
                this.parseKeystrokeNode(nodes.item(i));
                continue;
            }
            if (!type.equalsIgnoreCase(FEATURE_INTENT)) continue;
            this.parseIntentNode(nodes.item(i));
        }
        return true;
    }

    private void parseBarcodeNode(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            if (nodes.item(j).getNodeName().equalsIgnoreCase("parm")) {
                String nameValue = nodes.item(j).getAttributes().getNamedItem("name").getNodeValue();
                if (nameValue.equalsIgnoreCase("scanner_input_enabled")) {
                    this.parseScanner_input_enabled(nodes.item(j));
                    continue;
                }
                if (!nameValue.equalsIgnoreCase("ScannerSelection")) continue;
                this.parseScannerSelection(nodes.item(j));
                continue;
            }
            if (!nodes.item(j).getNodeName().equalsIgnoreCase("characteristic")) continue;
            String typeValue = nodes.item(j).getAttributes().getNamedItem("type").getNodeValue();
            if (typeValue.equalsIgnoreCase("ActivitySelection")) {
                this.parseActivitySelection(nodes.item(j));
                continue;
            }
            if (typeValue.equalsIgnoreCase("Decoders")) {
                this.parseDecoders(nodes.item(j));
                continue;
            }
            if (typeValue.equalsIgnoreCase("DecoderParams")) {
                this.parseDecoderParams(nodes.item(j));
                continue;
            }
            if (typeValue.equalsIgnoreCase("ReaderParams")) {
                this.parseReaderParams(nodes.item(j));
                continue;
            }
            if (typeValue.equalsIgnoreCase("UpcEanParams")) {
                this.parseUpcEanParams(nodes.item(j));
                continue;
            }
            if (!typeValue.equalsIgnoreCase("ScanParams")) continue;
            this.parseScanParams(nodes.item(j));
        }
    }

    private ProfileConfig.PREAMBLE getPreamble(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.PREAMBLE.NONE;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.PREAMBLE.SYS_CHAR;
        }
        if (str.equalsIgnoreCase("2")) {
            return ProfileConfig.PREAMBLE.COUNTRY_AND_SYS_CHAR;
        }
        return ProfileConfig.PREAMBLE.DEFAULT;
    }

    private ProfileConfig.ISBT128_CONTACT_MODE getIsbtContactMode(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.ISBT128_CONTACT_MODE.NEVER;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.ISBT128_CONTACT_MODE.ALWAYS;
        }
        if (str.equalsIgnoreCase("2")) {
            return ProfileConfig.ISBT128_CONTACT_MODE.AUTO;
        }
        return ProfileConfig.ISBT128_CONTACT_MODE.DEFAULT;
    }

    private ProfileConfig.SECURITY_LEVEL getSecurityLevel(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.SECURITY_LEVEL.LEVEL_0;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.SECURITY_LEVEL.LEVEL_1;
        }
        if (str.equalsIgnoreCase("2")) {
            return ProfileConfig.SECURITY_LEVEL.LEVEL_2;
        }
        if (str.equalsIgnoreCase("3")) {
            return ProfileConfig.SECURITY_LEVEL.LEVEL_3;
        }
        return ProfileConfig.SECURITY_LEVEL.DEFAULT;
    }

    private ProfileConfig.CHECK_DIGIT_TYPE getCheckDigitType(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.CHECK_DIGIT_TYPE.NO;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.CHECK_DIGIT_TYPE.USS;
        }
        if (str.equalsIgnoreCase("2")) {
            return ProfileConfig.CHECK_DIGIT_TYPE.OPCC;
        }
        return ProfileConfig.CHECK_DIGIT_TYPE.DEFAULT;
    }

    private ProfileConfig.CHECK_DIGIT getCheckDigit(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.CHECK_DIGIT.ONE;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.CHECK_DIGIT.TWO;
        }
        return ProfileConfig.CHECK_DIGIT.DEFAULT;
    }

    private ProfileConfig.CHECK_DIGIT_SCHEME getCheckDigitScheme(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.CHECK_DIGIT_SCHEME.MOD_11_10;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.CHECK_DIGIT_SCHEME.MOD_10_10;
        }
        return ProfileConfig.CHECK_DIGIT_SCHEME.DEFAULT;
    }

    private ProfileConfig.UCC_LINK_MODE getUccLinkMode(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.UCC_LINK_MODE.LINK_FLAG_IGNORED;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.UCC_LINK_MODE.ALWAYS_LINKED;
        }
        if (str.equalsIgnoreCase("2")) {
            return ProfileConfig.UCC_LINK_MODE.AUTO_DISCRIMINATE;
        }
        return ProfileConfig.UCC_LINK_MODE.DEFAULT;
    }

    private ProfileConfig.VERIFY_CHECK_DIGIT getVerifyCheckDigit(String str) {
        if (str.equalsIgnoreCase("0")) {
            return ProfileConfig.VERIFY_CHECK_DIGIT.NO;
        }
        if (str.equalsIgnoreCase("1")) {
            return ProfileConfig.VERIFY_CHECK_DIGIT.ONE;
        }
        if (str.equalsIgnoreCase("2")) {
            return ProfileConfig.VERIFY_CHECK_DIGIT.TWO;
        }
        return ProfileConfig.VERIFY_CHECK_DIGIT.DEFAULT;
    }

    private ProfileConfig.ENABLED_STATE getEnableState(String stateStr) {
        if (stateStr.equalsIgnoreCase("0") || stateStr.equalsIgnoreCase("FALSE")) {
            return ProfileConfig.ENABLED_STATE.FALSE;
        }
        if (stateStr.equalsIgnoreCase("1") || stateStr.equalsIgnoreCase("TRUE")) {
            return ProfileConfig.ENABLED_STATE.TRUE;
        }
        return ProfileConfig.ENABLED_STATE.DEFAULT;
    }

    private ProfileConfig.POWER_MODE getPower_Mode(String stateStr) {
        if (stateStr.equalsIgnoreCase("0")) {
            return ProfileConfig.POWER_MODE.LOW;
        }
        if (stateStr.equalsIgnoreCase("1")) {
            return ProfileConfig.POWER_MODE.OPTIMIZED;
        }
        if (stateStr.equalsIgnoreCase("2")) {
            return ProfileConfig.POWER_MODE.HIGH;
        }
        if (stateStr.equalsIgnoreCase("3")) {
            return ProfileConfig.POWER_MODE.ALWAYS_ON;
        }
        return ProfileConfig.POWER_MODE.DEFAULT;
    }

    private ProfileConfig.ILLUMINATION_MODE getIllumination_Mode(String stateStr) {
        if (stateStr.equalsIgnoreCase("off")) {
            return ProfileConfig.ILLUMINATION_MODE.OFF;
        }
        if (stateStr.equalsIgnoreCase("torch")) {
            return ProfileConfig.ILLUMINATION_MODE.ON;
        }
        return ProfileConfig.ILLUMINATION_MODE.DEFAULT;
    }

    private ProfileConfig.LCD_MODE getLCD_Mode(String stateStr) {
        if (stateStr.equalsIgnoreCase("0")) {
            return ProfileConfig.LCD_MODE.DISABLED;
        }
        if (stateStr.equalsIgnoreCase("1")) {
            return ProfileConfig.LCD_MODE.ENABLED;
        }
        return ProfileConfig.LCD_MODE.DEFAULT;
    }

    private ProfileConfig.INVERSE_1D_MODE getInverse_1D_Mode(String stateStr) {
        if (stateStr.equalsIgnoreCase("0")) {
            return ProfileConfig.INVERSE_1D_MODE.DISABLED;
        }
        if (stateStr.equalsIgnoreCase("1")) {
            return ProfileConfig.INVERSE_1D_MODE.ENABLED;
        }
        if (stateStr.equalsIgnoreCase("2")) {
            return ProfileConfig.INVERSE_1D_MODE.AUTO;
        }
        return ProfileConfig.INVERSE_1D_MODE.DEFAULT;
    }

    private void parseScanner_input_enabled(Node node) {
        String scannerEnabled = "";
        try {
            scannerEnabled = node.getAttributes().getNamedItem("value").getNodeValue();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("" + ex.getMessage()));
        }
        this.profileData.dataCapture.barcode.scanner_input_enabled = this.getEnableState(scannerEnabled);
    }

    private void parseScannerSelection(Node node) {
        try {
            String scannerSelection = node.getAttributes().getNamedItem("value").getNodeValue();
            this.profileData.dataCapture.barcode.scannerSelection = scannerSelection.equalsIgnoreCase(ProfileConfig.DEVICETYPES.INTERNAL_CAMERA1.toString()) ? ProfileConfig.DEVICETYPES.INTERNAL_CAMERA1 : (scannerSelection.equalsIgnoreCase(ProfileConfig.DEVICETYPES.INTERNAL_IMAGER1.toString()) ? ProfileConfig.DEVICETYPES.INTERNAL_IMAGER1 : (scannerSelection.equalsIgnoreCase(ProfileConfig.DEVICETYPES.INTERNAL_LASER1.toString()) ? ProfileConfig.DEVICETYPES.INTERNAL_LASER1 : ProfileConfig.DEVICETYPES.AUTO));
        }
        catch (Exception ex) {
            this.profileData.dataCapture.barcode.scannerSelection = ProfileConfig.DEVICETYPES.AUTO;
        }
    }

    private void parseActivitySelection(Node node) {
    }

    private void parseDecoders(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int k = 0; k < nodes.getLength(); ++k) {
            if (!nodes.item(k).getNodeName().equalsIgnoreCase("parm")) continue;
            String name = nodes.item(k).getAttributes().getNamedItem("name").getNodeValue();
            String value = nodes.item(k).getAttributes().getNamedItem("value").getNodeValue();
            ProfileConfig.ENABLED_STATE state = this.getEnableState(value);
            if (state == ProfileConfig.ENABLED_STATE.DEFAULT) continue;
            if (name.equalsIgnoreCase("decoder_australian_postal")) {
                this.profileData.dataCapture.barcode.decoders.australian_postal = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_aztec")) {
                this.profileData.dataCapture.barcode.decoders.aztec = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_canadian_postal")) {
                this.profileData.dataCapture.barcode.decoders.canadian_postal = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_chinese_2of5")) {
                this.profileData.dataCapture.barcode.decoders.chinese_2of5 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_codabar")) {
                this.profileData.dataCapture.barcode.decoders.codabar = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_code11")) {
                this.profileData.dataCapture.barcode.decoders.code11 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_code128")) {
                this.profileData.dataCapture.barcode.decoders.code128 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_code39")) {
                this.profileData.dataCapture.barcode.decoders.code39 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_code93")) {
                this.profileData.dataCapture.barcode.decoders.code93 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_composite_ab")) {
                this.profileData.dataCapture.barcode.decoders.composite_ab = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_composite_c")) {
                this.profileData.dataCapture.barcode.decoders.composite_c = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_d2of5")) {
                this.profileData.dataCapture.barcode.decoders.d2of5 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_datamatrix")) {
                this.profileData.dataCapture.barcode.decoders.datamatrix = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_dutch_postal")) {
                this.profileData.dataCapture.barcode.decoders.dutch_postal = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_ean13")) {
                this.profileData.dataCapture.barcode.decoders.ean13 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_ean8")) {
                this.profileData.dataCapture.barcode.decoders.ean8 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_gs1_databar")) {
                this.profileData.dataCapture.barcode.decoders.gs1_databar = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_gs1_databar_exp")) {
                this.profileData.dataCapture.barcode.decoders.gs1_databar_exp = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_gs1_databar_lim")) {
                this.profileData.dataCapture.barcode.decoders.gs1_databar_lim = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_i2of5")) {
                this.profileData.dataCapture.barcode.decoders.i2of5 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_japanese_postal")) {
                this.profileData.dataCapture.barcode.decoders.japanese_postal = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_korean_3of5")) {
                this.profileData.dataCapture.barcode.decoders.korean_3of5 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_matrix_2of5")) {
                this.profileData.dataCapture.barcode.decoders.matrix_2of5 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_maxicode")) {
                this.profileData.dataCapture.barcode.decoders.maxicode = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_micropdf")) {
                this.profileData.dataCapture.barcode.decoders.micropdf = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_microqr")) {
                this.profileData.dataCapture.barcode.decoders.microqr = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_msi")) {
                this.profileData.dataCapture.barcode.decoders.msi = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_pdf417")) {
                this.profileData.dataCapture.barcode.decoders.pdf417 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_qrcode")) {
                this.profileData.dataCapture.barcode.decoders.qrcode = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_signature")) {
                this.profileData.dataCapture.barcode.decoders.signature = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_tlc39")) {
                this.profileData.dataCapture.barcode.decoders.tlc39 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_trioptic39")) {
                this.profileData.dataCapture.barcode.decoders.trioptic39 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_uk_postal")) {
                this.profileData.dataCapture.barcode.decoders.uk_postal = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_upca")) {
                this.profileData.dataCapture.barcode.decoders.upca = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_upce0")) {
                this.profileData.dataCapture.barcode.decoders.upce0 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_upce1")) {
                this.profileData.dataCapture.barcode.decoders.upce1 = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_us4state")) {
                this.profileData.dataCapture.barcode.decoders.us4state = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_us4state_fics")) {
                this.profileData.dataCapture.barcode.decoders.us4state_fics = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_usplanet")) {
                this.profileData.dataCapture.barcode.decoders.usplanet = state;
                continue;
            }
            if (name.equalsIgnoreCase("decoder_uspostnet")) {
                this.profileData.dataCapture.barcode.decoders.uspostnet = state;
                continue;
            }
            if (!name.equalsIgnoreCase("decoder_webcode")) continue;
            this.profileData.dataCapture.barcode.decoders.webcode = state;
        }
    }

    private void parseDecoderParams(Node node) {
        NodeList decoderParamCategoryNodes = node.getChildNodes();
        for (int k = 0; k < decoderParamCategoryNodes.getLength(); ++k) {
            if (!decoderParamCategoryNodes.item(k).getNodeName().equalsIgnoreCase("characteristic")) continue;
            NodeList decoderParamNodes = decoderParamCategoryNodes.item(k).getChildNodes();
            for (int n = 0; n < decoderParamNodes.getLength(); ++n) {
                if (!decoderParamNodes.item(n).getNodeName().equalsIgnoreCase("parm")) continue;
                String key = decoderParamNodes.item(n).getAttributes().getNamedItem("name").getNodeValue();
                String value = decoderParamNodes.item(n).getAttributes().getNamedItem("value").getNodeValue();
                if (key.equalsIgnoreCase("decoder_upca_preamble")) {
                    this.profileData.dataCapture.barcode.decoderParams.upca.preamble = this.getPreamble(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_upca_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.upca.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_upce0_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.upce0.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_upce0_preamble")) {
                    this.profileData.dataCapture.barcode.decoderParams.upce0.preamble = this.getPreamble(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_upce0_convert_to_upca")) {
                    this.profileData.dataCapture.barcode.decoderParams.upce0.convert_to_upca = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_ean8_convert_to_ean13")) {
                    this.profileData.dataCapture.barcode.decoderParams.ean8.convert_to_ean13 = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_enable_plain")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.enable_plain = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_enable_ean128")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.enable_ean128 = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_enable_isbt128")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.enable_isbt128 = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_enable_isbt128_concat_mode")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.isbt128_concat_mode = this.getIsbtContactMode(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_check_isbt_table")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.check_isbt_table = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code128_security_level")) {
                    this.profileData.dataCapture.barcode.decoderParams.code128.security_level = this.getSecurityLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_i2of5_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.interleaved_2of5.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_i2of5_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.interleaved_2of5.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_i2of5_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.interleaved_2of5.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_i2of5_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.interleaved_2of5.check_digit = this.getCheckDigitType(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_i2of5_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.interleaved_2of5.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_itf14_convert_to_ean13")) {
                    this.profileData.dataCapture.barcode.decoderParams.interleaved_2of5.convert_itf14_to_ean13 = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_i2of5_security_level")) {
                    this.profileData.dataCapture.barcode.decoderParams.interleaved_2of5.security_level = this.getSecurityLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_composite_ab_ucc_link_mode")) {
                    this.profileData.dataCapture.barcode.decoderParams.composite_AB.ucc_link_mode = this.getUccLinkMode(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_uspostnet_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.usPostnet.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_usplanet_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.usPlanet.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_uk_postal_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.uk_Postal.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_codabar_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.codabar.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_codabar_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.codabar.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_codabar_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.codabar.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_codabar_clsi_editing")) {
                    this.profileData.dataCapture.barcode.decoderParams.codabar.clsi_editing = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_codabar_notis_editing")) {
                    this.profileData.dataCapture.barcode.decoderParams.codabar.notis_editing = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_msi_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.msi.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_msi_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.msi.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_msi_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.msi.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_msi_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.msi.check_digit = this.getCheckDigit(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_msi_check_digit_scheme")) {
                    this.profileData.dataCapture.barcode.decoderParams.msi.check_digit_scheme = this.getCheckDigitScheme(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_msi_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.msi.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code93_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.code93.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code93_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.code93.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code93_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.code93.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_trioptic39_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.trioptic39.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_d2of5_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.discrete_2of5.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_d2of5_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.discrete_2of5.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_d2of5_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.discrete_2of5.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code11_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.code11.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code11_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.code11.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code11_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.code11.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code11_verify_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.code11.verify_check_digit = this.getVerifyCheckDigit(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_code11_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.code11.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_matrix_2of5_length1")) {
                    this.profileData.dataCapture.barcode.decoderParams.matrix_2of5.length1 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_matrix_2of5_length2")) {
                    this.profileData.dataCapture.barcode.decoderParams.matrix_2of5.length2 = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_matrix_2of5_redundancy")) {
                    this.profileData.dataCapture.barcode.decoderParams.matrix_2of5.redundancy = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_matrix_2of5_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.matrix_2of5.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_matrix_2of5_verify_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.matrix_2of5.verify_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_upce1_report_check_digit")) {
                    this.profileData.dataCapture.barcode.decoderParams.upce1.report_check_digit = this.getEnableState(value);
                    continue;
                }
                if (key.equalsIgnoreCase("decoder_upce1_preamble")) {
                    this.profileData.dataCapture.barcode.decoderParams.upce1.preamble = this.getPreamble(value);
                    continue;
                }
                if (!key.equalsIgnoreCase("decoder_upce1_convert_to_upca")) continue;
                this.profileData.dataCapture.barcode.decoderParams.upce1.convert_to_upca = this.getEnableState(value);
            }
        }
    }

    private void parseReaderParams(Node node) {
        NodeList nodes = node.getChildNodes();
        block22: for (int k = 0; k < nodes.getLength(); ++k) {
            if (!nodes.item(k).getNodeName().equalsIgnoreCase("parm")) continue;
            String name = nodes.item(k).getAttributes().getNamedItem("name").getNodeValue();
            String value = nodes.item(k).getAttributes().getNamedItem("value").getNodeValue();
            int intValue = Integer.MAX_VALUE;
            try {
                if (!value.equals("Default")) {
                    intValue = Integer.parseInt(value);
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("" + ex.getMessage()));
            }
            if (name.equalsIgnoreCase("beam_timer")) {
                this.profileData.dataCapture.barcode.readerParams.beam_timer = intValue;
                continue;
            }
            if (name.equalsIgnoreCase("same_barcode_timeout")) {
                this.profileData.dataCapture.barcode.readerParams.same_barcode_timeout = intValue;
                continue;
            }
            if (name.equalsIgnoreCase("different_barcode_timeout")) {
                this.profileData.dataCapture.barcode.readerParams.different_barcode_timeout = intValue;
                continue;
            }
            if (name.equalsIgnoreCase("linear_security_level")) {
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.readerParams.linear_security_level = ProfileConfig.LINEAR_SECURITY_LEVEL.SHORT_OR_CODABAR;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.readerParams.linear_security_level = ProfileConfig.LINEAR_SECURITY_LEVEL.ALL_TWICE;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.readerParams.linear_security_level = ProfileConfig.LINEAR_SECURITY_LEVEL.LONG_AND_SHORT;
                        break;
                    }
                    case 3: {
                        this.profileData.dataCapture.barcode.readerParams.linear_security_level = ProfileConfig.LINEAR_SECURITY_LEVEL.ALL_THRICE;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.readerParams.linear_security_level = ProfileConfig.LINEAR_SECURITY_LEVEL.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (name.equalsIgnoreCase("picklist")) {
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.readerParams.picklist = ProfileConfig.PICK_LIST.DISABLED;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.readerParams.picklist = ProfileConfig.PICK_LIST.ENABLED;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.readerParams.picklist = ProfileConfig.PICK_LIST.CENTERED;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.readerParams.picklist = ProfileConfig.PICK_LIST.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (name.equalsIgnoreCase("power_mode")) {
                this.profileData.dataCapture.barcode.readerParams.power_mode = this.getPower_Mode(value);
                continue;
            }
            if (name.equalsIgnoreCase("illumination_mode")) {
                this.profileData.dataCapture.barcode.readerParams.illumination_mode = this.getIllumination_Mode(value);
                continue;
            }
            if (name.equalsIgnoreCase("lcd_mode")) {
                this.profileData.dataCapture.barcode.readerParams.lcd_mode = this.getLCD_Mode(value);
                continue;
            }
            if (name.equalsIgnoreCase("low_power_timeout")) {
                this.profileData.dataCapture.barcode.readerParams.low_power_timeout = intValue;
                continue;
            }
            if (name.equalsIgnoreCase("illumination_brightness")) {
                this.profileData.dataCapture.barcode.readerParams.illumination_brightness = intValue;
                continue;
            }
            if (name.equalsIgnoreCase("inverse_1d_mode")) {
                this.profileData.dataCapture.barcode.readerParams.inverse_1d_mode = this.getInverse_1D_Mode(value);
                continue;
            }
            if (name.equalsIgnoreCase("viewfinder_mode")) {
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.readerParams.viewfinder_mode = ProfileConfig.VIEWFINDER_MODE.DISABLED;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.readerParams.viewfinder_mode = ProfileConfig.VIEWFINDER_MODE.ENABLED;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.readerParams.viewfinder_mode = ProfileConfig.VIEWFINDER_MODE.STATIC_RECTICLE;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.readerParams.viewfinder_mode = ProfileConfig.VIEWFINDER_MODE.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (!name.equalsIgnoreCase("aim_type")) continue;
            switch (intValue) {
                case 0: {
                    this.profileData.dataCapture.barcode.readerParams.aim_type = ProfileConfig.AIM_TYPE.TRIGGER;
                    continue block22;
                }
                case 5: {
                    this.profileData.dataCapture.barcode.readerParams.aim_type = ProfileConfig.AIM_TYPE.CONTINUOUS_READ;
                    continue block22;
                }
                default: {
                    this.profileData.dataCapture.barcode.readerParams.aim_type = ProfileConfig.AIM_TYPE.DEFAULT;
                }
            }
        }
    }

    private void parseUpcEanParams(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int k = 0; k < nodes.getLength(); ++k) {
            int intValue;
            if (!nodes.item(k).getNodeName().equalsIgnoreCase("parm")) continue;
            String name = nodes.item(k).getAttributes().getNamedItem("name").getNodeValue();
            String value = nodes.item(k).getAttributes().getNamedItem("value").getNodeValue();
            if (name.equalsIgnoreCase("upcean_security_level")) {
                intValue = Integer.MAX_VALUE;
                try {
                    if (!value.equals("Default")) {
                        intValue = Integer.parseInt(value);
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("" + ex.getMessage()));
                }
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.upcEanParams.security_level = ProfileConfig.SECURITY_LEVEL.LEVEL_0;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.upcEanParams.security_level = ProfileConfig.SECURITY_LEVEL.LEVEL_1;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.upcEanParams.security_level = ProfileConfig.SECURITY_LEVEL.LEVEL_2;
                        break;
                    }
                    case 3: {
                        this.profileData.dataCapture.barcode.upcEanParams.security_level = ProfileConfig.SECURITY_LEVEL.LEVEL_3;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.upcEanParams.security_level = ProfileConfig.SECURITY_LEVEL.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (name.equalsIgnoreCase("upcean_supplemental2")) {
                this.profileData.dataCapture.barcode.upcEanParams.supplemental2 = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_supplemental5")) {
                this.profileData.dataCapture.barcode.upcEanParams.supplemental5 = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_supplemental_mode")) {
                intValue = Integer.MAX_VALUE;
                try {
                    if (!value.equals("Default")) {
                        intValue = Integer.parseInt(value);
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("" + ex.getMessage()));
                }
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.NO;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.ALWAYS;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.AUTO;
                        break;
                    }
                    case 3: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.SMART;
                        break;
                    }
                    case 4: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.S_378_379;
                        break;
                    }
                    case 5: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.S_978_979;
                        break;
                    }
                    case 6: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.S_414_419_434_439;
                        break;
                    }
                    case 7: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.S_977;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.upcEanParams.supplemental_mode = ProfileConfig.SUPPLEMENTAL_MODE.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (name.equalsIgnoreCase("upcean_retry_count")) {
                this.profileData.dataCapture.barcode.upcEanParams.retry_count = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_random_weight_check_digit")) {
                this.profileData.dataCapture.barcode.upcEanParams.random_weight_check_digit = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_linear_decode")) {
                this.profileData.dataCapture.barcode.upcEanParams.linear_decode = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_bookland")) {
                this.profileData.dataCapture.barcode.upcEanParams.bookland = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_coupon")) {
                this.profileData.dataCapture.barcode.upcEanParams.coupon = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_ean_zero_extend")) {
                this.profileData.dataCapture.barcode.upcEanParams.ean_zero_extend = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("upcean_coupon_report")) {
                intValue = Integer.MAX_VALUE;
                try {
                    if (!value.equals("Default")) {
                        intValue = Integer.parseInt(value);
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("" + ex.getMessage()));
                }
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.upcEanParams.coupon_report = ProfileConfig.COUPON_REPORT.OLD;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.upcEanParams.coupon_report = ProfileConfig.COUPON_REPORT.NEW;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.upcEanParams.coupon_report = ProfileConfig.COUPON_REPORT.BOTH;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.upcEanParams.coupon_report = ProfileConfig.COUPON_REPORT.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (name.equalsIgnoreCase("upcean_bookland_format")) {
                intValue = Integer.MAX_VALUE;
                try {
                    if (!value.equals("Default")) {
                        intValue = Integer.parseInt(value);
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("" + ex.getMessage()));
                }
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.upcEanParams.bookland_format = ProfileConfig.BOOKLAND_FORMAT.ISBN_10;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.upcEanParams.bookland_format = ProfileConfig.BOOKLAND_FORMAT.ISBN_13;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.upcEanParams.bookland_format = ProfileConfig.BOOKLAND_FORMAT.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (!name.equalsIgnoreCase("databar_to_upc_ean")) continue;
            this.profileData.dataCapture.barcode.upcEanParams.databar_to_upc_ean = this.getEnableState(value);
        }
    }

    private void parseScanParams(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int k = 0; k < nodes.getLength(); ++k) {
            int intValue;
            if (!nodes.item(k).getNodeName().equalsIgnoreCase("parm")) continue;
            String name = nodes.item(k).getAttributes().getNamedItem("name").getNodeValue();
            String value = nodes.item(k).getAttributes().getNamedItem("value").getNodeValue();
            if (name.equalsIgnoreCase("code_id_type")) {
                intValue = Integer.MAX_VALUE;
                try {
                    if (!value.equals("Default")) {
                        intValue = Integer.parseInt(value);
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("" + ex.getMessage()));
                }
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.scanParams.code_id_type = ProfileConfig.CODE_ID_TYPE.NONE;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.scanParams.code_id_type = ProfileConfig.CODE_ID_TYPE.AIM;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.scanParams.code_id_type = ProfileConfig.CODE_ID_TYPE.SYMBOL;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.scanParams.code_id_type = ProfileConfig.CODE_ID_TYPE.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (name.equalsIgnoreCase("volume_slider_type")) {
                intValue = Integer.MAX_VALUE;
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("" + ex.getMessage()));
                }
                switch (intValue) {
                    case 0: {
                        this.profileData.dataCapture.barcode.scanParams.volume_slider_type = ProfileConfig.VOLUME_SLIDER_TYPE.RINGER_AND_NOTIFICATIONS;
                        break;
                    }
                    case 1: {
                        this.profileData.dataCapture.barcode.scanParams.volume_slider_type = ProfileConfig.VOLUME_SLIDER_TYPE.MUSIC_AND_MEDIA;
                        break;
                    }
                    case 2: {
                        this.profileData.dataCapture.barcode.scanParams.volume_slider_type = ProfileConfig.VOLUME_SLIDER_TYPE.ALARM;
                        break;
                    }
                    default: {
                        this.profileData.dataCapture.barcode.scanParams.volume_slider_type = ProfileConfig.VOLUME_SLIDER_TYPE.DEFAULT;
                        break;
                    }
                }
                continue;
            }
            if (name.equalsIgnoreCase("decode_audio_feedback_uri")) {
                this.profileData.dataCapture.barcode.scanParams.decode_audio_feedback_uri = value;
                continue;
            }
            if (name.equalsIgnoreCase("decode_haptic_feedback")) {
                this.profileData.dataCapture.barcode.scanParams.decode_haptic_feedback = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("good_decode_led_timer")) {
                this.profileData.dataCapture.barcode.scanParams.good_decode_led_timer = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("decoding_led_feedback")) {
                this.profileData.dataCapture.barcode.scanParams.decoding_led_feedback = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("bt_disconnect_on_exit")) {
                this.profileData.dataCapture.barcode.scanParams.bt_disconnect_on_exit = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("connection_idle_time")) {
                this.profileData.dataCapture.barcode.scanParams.connection_idle_time = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("display_bt_address_barcode")) {
                this.profileData.dataCapture.barcode.scanParams.display_bt_address_barcode = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("establish_connection_time")) {
                this.profileData.dataCapture.barcode.scanParams.establish_connection_time = Integer.parseInt(value);
                continue;
            }
            if (!name.equalsIgnoreCase("datacapture_led_id")) continue;
            this.profileData.dataCapture.barcode.scanParams.datacapture_led_id = Integer.parseInt(value);
        }
    }

    private void parseKeystrokeNode(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            String type;
            if (nodes.item(j).getNodeName().equalsIgnoreCase("parm")) {
                String value;
                String name = nodes.item(j).getAttributes().getNamedItem("name").getNodeValue();
                if (name.equalsIgnoreCase("ime_output_enabled")) {
                    value = nodes.item(j).getAttributes().getNamedItem("value").getNodeValue();
                    this.profileData.dataCapture.dataDelivery.keystroke.ime_output_enabled = this.getEnableState(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("keystroke_action_char")) continue;
                value = nodes.item(j).getAttributes().getNamedItem("value").getNodeValue();
                if (value.equalsIgnoreCase("-1")) {
                    this.profileData.dataCapture.dataDelivery.keystroke.keystroke_action_char = ProfileConfig.ACTION_KEY_CHAR.NONE;
                    continue;
                }
                if (value.equalsIgnoreCase("9")) {
                    this.profileData.dataCapture.dataDelivery.keystroke.keystroke_action_char = ProfileConfig.ACTION_KEY_CHAR.TAB;
                    continue;
                }
                if (value.equalsIgnoreCase("10")) {
                    this.profileData.dataCapture.dataDelivery.keystroke.keystroke_action_char = ProfileConfig.ACTION_KEY_CHAR.LINEFEED;
                    continue;
                }
                if (value.equalsIgnoreCase("13")) {
                    this.profileData.dataCapture.dataDelivery.keystroke.keystroke_action_char = ProfileConfig.ACTION_KEY_CHAR.CARRIAGERETURN;
                    continue;
                }
                this.profileData.dataCapture.dataDelivery.keystroke.keystroke_action_char = ProfileConfig.ACTION_KEY_CHAR.DEFAULT;
                continue;
            }
            if (!nodes.item(j).getNodeName().equalsIgnoreCase("characteristic") || !(type = nodes.item(j).getAttributes().getNamedItem("type").getNodeValue()).equalsIgnoreCase("BasicDataFormatting")) continue;
            this.parseBasicDataFormatting(nodes.item(j), this.profileData.dataCapture.dataDelivery.keystroke.basicDataFormatting);
        }
    }

    private void parseBasicDataFormatting(Node node, ProfileConfig.DataCapture.DataDelivery.BasicDataFormatting bdfObj) {
        NodeList nodes = node.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            if (!nodes.item(j).getNodeName().equalsIgnoreCase("parm")) continue;
            String name = nodes.item(j).getAttributes().getNamedItem("name").getNodeValue();
            String value = nodes.item(j).getAttributes().getNamedItem("value").getNodeValue();
            if (name.equalsIgnoreCase("bdf_enabled")) {
                bdfObj.bdf_enabled = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("bdf_suffix")) {
                bdfObj.bdf_suffix = value;
                continue;
            }
            if (name.equalsIgnoreCase("bdf_prefix")) {
                bdfObj.bdf_prefix = value;
                continue;
            }
            if (name.equalsIgnoreCase("bdf_send_data")) {
                bdfObj.bdf_send_data = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("bdf_send_enter")) {
                bdfObj.bdf_send_enter = this.getEnableState(value);
                continue;
            }
            if (name.equalsIgnoreCase("bdf_send_hex")) {
                bdfObj.bdf_send_hex = this.getEnableState(value);
                continue;
            }
            if (!name.equalsIgnoreCase("bdf_send_tab")) continue;
            bdfObj.bdf_send_tab = this.getEnableState(value);
        }
    }

    private void parseIntentNode(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            String type;
            if (nodes.item(j).getNodeName().equalsIgnoreCase("parm")) {
                String name = nodes.item(j).getAttributes().getNamedItem("name").getNodeValue();
                String value = nodes.item(j).getAttributes().getNamedItem("value").getNodeValue();
                if (name.equalsIgnoreCase("intent_output_enabled")) {
                    this.profileData.dataCapture.dataDelivery.intent.output_enabled = this.getEnableState(value);
                    continue;
                }
                if (name.equalsIgnoreCase("intent_category")) {
                    this.profileData.dataCapture.dataDelivery.intent.category = value;
                    continue;
                }
                if (name.equalsIgnoreCase("intent_action")) {
                    this.profileData.dataCapture.dataDelivery.intent.action = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("intent_delivery")) continue;
                if (value.equalsIgnoreCase("0")) {
                    this.profileData.dataCapture.dataDelivery.intent.delivery = ProfileConfig.INTENT_DELIVERY.SEND_VIA_STARTACTIVITY;
                    continue;
                }
                if (value.equalsIgnoreCase("1")) {
                    this.profileData.dataCapture.dataDelivery.intent.delivery = ProfileConfig.INTENT_DELIVERY.SEND_VIA_STARTSERVICE;
                    continue;
                }
                if (value.equalsIgnoreCase("2")) {
                    this.profileData.dataCapture.dataDelivery.intent.delivery = ProfileConfig.INTENT_DELIVERY.BROADCAST_INTENT;
                    continue;
                }
                this.profileData.dataCapture.dataDelivery.intent.delivery = ProfileConfig.INTENT_DELIVERY.DEFAULT;
                continue;
            }
            if (!nodes.item(j).getNodeName().equalsIgnoreCase("characteristic") || !(type = nodes.item(j).getAttributes().getNamedItem("type").getNodeValue()).equalsIgnoreCase("BasicDataFormatting")) continue;
            this.parseBasicDataFormatting(nodes.item(j), this.profileData.dataCapture.dataDelivery.intent.basicDataFormatting);
        }
    }

    private void parseMSRNode(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            String name;
            if (!nodes.item(j).getNodeName().equalsIgnoreCase("parm") || !(name = nodes.item(j).getAttributes().getNamedItem("name").getNodeValue()).equalsIgnoreCase("msr_input_enabled")) continue;
            String value = nodes.item(j).getAttributes().getNamedItem("value").getNodeValue();
            this.profileData.dataCapture.msr.msr_input_enabled = this.getEnableState(value);
        }
    }

    private Document getDocumentFromString(String xmlString) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            Log.e((String)TAG, (String)("" + e1.getMessage()));
        }
        Document tdoc = null;
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xmlString));
        try {
            if (db != null) {
                tdoc = db.parse(is);
            }
        }
        catch (SAXException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        return tdoc;
    }

    private Node getProfileNode(String profileName, Document doc) {
        try {
            String XPATH_GET_ALL_NAME_NODES = "/wap-provisioningdoc/characteristic/parm[@name='ProfileName']";
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression exprProfName = xPath.compile(XPATH_GET_ALL_NAME_NODES);
            NodeList nodes = (NodeList)exprProfName.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!nodes.item(i).getAttributes().getNamedItem("value").getNodeValue().equals(profileName)) continue;
                return nodes.item(i).getParentNode();
            }
            return null;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("" + ex.getMessage()));
            return null;
        }
    }
}

