/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.emdkservice.barcode.SvcScannerInfo;

public class ScannerInfo {
    int scannerIndex = 0;
    String friendlyName = "";
    String modelNumber = "";
    DeviceType deviceType = DeviceType.UNDEFINED;
    ConnectionType connectionType = ConnectionType.INTERNAL;
    BarcodeManager.DeviceIdentifier deviceIdentifier = BarcodeManager.DeviceIdentifier.UNDEFINED;
    DecoderType decoderType = DecoderType.UNDEFINED;
    boolean isDefaultScanner = false;
    boolean isConnected = true;

    ScannerInfo() {
    }

    ScannerInfo(SvcScannerInfo scnInfo) {
        this.updateScannerInfo(scnInfo);
    }

    void updateScannerInfo(SvcScannerInfo scnInfo) {
        this.scannerIndex = scnInfo.scannerIndex;
        this.friendlyName = scnInfo.friendlyName;
        this.modelNumber = scnInfo.modelNumber;
        this.isDefaultScanner = scnInfo.isDefaultScanner;
        this.isConnected = scnInfo.isConnected;
        switch (scnInfo.deviceType) {
            case CAMERA: {
                this.deviceType = DeviceType.CAMERA;
                break;
            }
            case IMAGER: {
                this.deviceType = DeviceType.IMAGER;
                break;
            }
            case LASER: {
                this.deviceType = DeviceType.LASER;
                break;
            }
            default: {
                this.deviceType = DeviceType.UNDEFINED;
            }
        }
        switch (scnInfo.decoderType) {
            case ONE_DIMENSIONAL: {
                this.decoderType = DecoderType.ONE_DIMENSIONAL;
                break;
            }
            case TWO_DIMENSIONAL: {
                this.decoderType = DecoderType.TWO_DIMENSIONAL;
                break;
            }
            default: {
                this.decoderType = DecoderType.UNDEFINED;
            }
        }
        switch (scnInfo.connectionType) {
            case BLUETOOTH_SSI: {
                this.connectionType = ConnectionType.BLUETOOTH_SSI;
                break;
            }
            case INTERNAL: {
                this.connectionType = ConnectionType.INTERNAL;
                break;
            }
            case SERIAL_SSI: {
                this.connectionType = ConnectionType.SERIAL_SSI;
                break;
            }
            case USB: {
                this.connectionType = ConnectionType.USB;
                break;
            }
            case PLUGGABLE_SSI: {
                this.connectionType = ConnectionType.PLUGGABLE_SSI;
                break;
            }
            default: {
                this.connectionType = ConnectionType.UNDEFINED;
            }
        }
        switch (scnInfo.deviceIdentifier) {
            case INTERNAL_IMAGER1: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.INTERNAL_IMAGER1;
                break;
            }
            case INTERNAL_LASER1: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.INTERNAL_LASER1;
                break;
            }
            case INTERNAL_CAMERA1: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.INTERNAL_CAMERA1;
                break;
            }
            case BLUETOOTH_IMAGER1: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.BLUETOOTH_IMAGER1;
                break;
            }
            case PLUGGABLE_LASER1: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.PLUGGABLE_LASER1;
                break;
            }
            case BLUETOOTH_IMAGER_RS6000: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.BLUETOOTH_IMAGER_RS6000;
                break;
            }
            case PLUGGABLE_IMAGER_RS5000: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.PLUGGABLE_IMAGER_RS5000;
                break;
            }
            case BLUETOOTH_IMAGER_DS3678: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.BLUETOOTH_IMAGER_DS3678;
                break;
            }
            case PLUGGABLE_IMAGER_DS3608: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.PLUGGABLE_IMAGER_DS3608;
                break;
            }
            case BLUETOOTH_LASER_LI3678: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.BLUETOOTH_LASER_LI3678;
                break;
            }
            case PLUGGABLE_LASER_LI3608: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.PLUGGABLE_LASER_LI3608;
                break;
            }
            case BLUETOOTH_IMAGER_DS2278: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.BLUETOOTH_IMAGER_DS2278;
                break;
            }
            case BLUETOOTH_IMAGER_DS8178: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.BLUETOOTH_IMAGER_DS8178;
                break;
            }
            case BLUETOOTH_IMAGER_RS5100: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.BLUETOOTH_IMAGER_RS5100;
                break;
            }
            default: {
                this.deviceIdentifier = BarcodeManager.DeviceIdentifier.UNDEFINED;
            }
        }
    }

    public boolean isDefaultScanner() {
        return this.isDefaultScanner;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public BarcodeManager.DeviceIdentifier getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public DecoderType getDecoderType() {
        return this.decoderType;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public static enum DecoderType {
        ONE_DIMENSIONAL,
        TWO_DIMENSIONAL,
        UNDEFINED;

    }

    public static enum ConnectionType {
        INTERNAL,
        BLUETOOTH_SSI,
        SERIAL_SSI,
        USB,
        PLUGGABLE_SSI,
        UNDEFINED;

    }

    public static enum DeviceType {
        CAMERA(0),
        IMAGER(1),
        LASER(2),
        UNDEFINED(255);

        int id = 255;

        private DeviceType(int id) {
            this.id = id;
        }
    }
}

