/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.barcode;

import android.annotation.SuppressLint;
import android.util.Log;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.ScanDataCollection;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.barcode.ScannerResults;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@SuppressLint(value={"UseSparseArrays"})
class ScannerUtils {
    private static final String TAG = "Scanner_Utils";
    private static Map<Integer, ScannerResults> scannerResultsLookUp;
    private static Map<String, ScanDataCollection.LabelType> LabelMap;

    ScannerUtils() {
    }

    static void updateSupportedList(ScannerInfo si, boolean connectionState) {
        for (ScannerInfo scannerInfo : BarcodeManager.barcodeManager.supportedScanners) {
            if (!scannerInfo.friendlyName.equalsIgnoreCase(si.friendlyName)) continue;
            BarcodeManager.barcodeManager.supportedScanners.remove(scannerInfo);
            return;
        }
        si.isConnected = connectionState;
        BarcodeManager.barcodeManager.supportedScanners.add(si);
    }

    static ScannerResults getScannerResult(int errCode) {
        ScannerResults results = scannerResultsLookUp.get(errCode);
        if (results == null) {
            return ScannerResults.UNDEFINED;
        }
        return results;
    }

    static ScanDataCollection.LabelType getLabelType(String sfLabelType) {
        ScanDataCollection.LabelType labelType = ScanDataCollection.LabelType.UNDEFINED;
        ScanDataCollection.LabelType temp = LabelMap.get(sfLabelType);
        if (temp != null) {
            labelType = temp;
        }
        return labelType;
    }

    static {
        try {
            ScannerResults[] vals = ScannerResults.values();
            scannerResultsLookUp = new HashMap<Integer, ScannerResults>(vals.length);
            for (ScannerResults scnRes : vals) {
                scannerResultsLookUp.put(scnRes.getValue(), scnRes);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        HashMap<String, ScanDataCollection.LabelType> tempMap = new HashMap<String, ScanDataCollection.LabelType>();
        tempMap.put("LABEL-TYPE-AUSPOSTAL", ScanDataCollection.LabelType.AUSPOSTAL);
        tempMap.put("LABEL-TYPE-Australian Postal", ScanDataCollection.LabelType.AUSPOSTAL);
        tempMap.put("LABEL-TYPE-AZTEC", ScanDataCollection.LabelType.AZTEC);
        tempMap.put("LABEL-TYPE-BOOKLAND", ScanDataCollection.LabelType.BOOKLAND);
        tempMap.put("LABEL-TYPE-CANPOSTAL", ScanDataCollection.LabelType.CANPOSTAL);
        tempMap.put("LABEL-TYPE-Canadian Postal", ScanDataCollection.LabelType.CANPOSTAL);
        tempMap.put("LABEL-TYPE-CHINESE-2OF5", ScanDataCollection.LabelType.CHINESE_2OF5);
        tempMap.put("LABEL-TYPE-CHINESE 2OF5", ScanDataCollection.LabelType.CHINESE_2OF5);
        tempMap.put("LABEL-TYPE-CODABAR", ScanDataCollection.LabelType.CODABAR);
        tempMap.put("LABEL-TYPE-CODE11", ScanDataCollection.LabelType.CODE11);
        tempMap.put("LABEL-TYPE-CODE128", ScanDataCollection.LabelType.CODE128);
        tempMap.put("LABEL-TYPE-CODE32", ScanDataCollection.LabelType.CODE32);
        tempMap.put("LABEL-TYPE-CODE39", ScanDataCollection.LabelType.CODE39);
        tempMap.put("LABEL-TYPE-CODE93", ScanDataCollection.LabelType.CODE93);
        tempMap.put("LABEL-TYPE-COMPOSITE-AB", ScanDataCollection.LabelType.COMPOSITE_AB);
        tempMap.put("LABEL-TYPE-COMPOSITE AB", ScanDataCollection.LabelType.COMPOSITE_AB);
        tempMap.put("LABEL-TYPE-COMPOSITE-C", ScanDataCollection.LabelType.COMPOSITE_C);
        tempMap.put("LABEL-TYPE-COMPOSITE C", ScanDataCollection.LabelType.COMPOSITE_C);
        tempMap.put("LABEL-TYPE-COUPON", ScanDataCollection.LabelType.COUPON);
        tempMap.put("LABEL-TYPE-D2OF5", ScanDataCollection.LabelType.D2OF5);
        tempMap.put("LABEL-TYPE-Discrete 2of5", ScanDataCollection.LabelType.D2OF5);
        tempMap.put("LABEL-TYPE-DATABAR-COUPON", ScanDataCollection.LabelType.DATABAR_COUPON);
        tempMap.put("LABEL-TYPE-DATABAR COUPON", ScanDataCollection.LabelType.DATABAR_COUPON);
        tempMap.put("LABEL-TYPE-DATAMATRIX", ScanDataCollection.LabelType.DATAMATRIX);
        tempMap.put("LABEL-TYPE-DUTCHPOSTAL", ScanDataCollection.LabelType.DUTCHPOSTAL);
        tempMap.put("LABEL-TYPE-Dutch Postal", ScanDataCollection.LabelType.DUTCHPOSTAL);
        tempMap.put("LABEL-TYPE-EAN128", ScanDataCollection.LabelType.EAN128);
        tempMap.put("LABEL-TYPE-EAN13", ScanDataCollection.LabelType.EAN13);
        tempMap.put("LABEL-TYPE-EAN8", ScanDataCollection.LabelType.EAN8);
        tempMap.put("LABEL-TYPE-GS1-DATABAR", ScanDataCollection.LabelType.GS1_DATABAR);
        tempMap.put("LABEL-TYPE-GS1 DATABAR", ScanDataCollection.LabelType.GS1_DATABAR);
        tempMap.put("LABEL-TYPE-GS1-DATABAR-EXP", ScanDataCollection.LabelType.GS1_DATABAR_EXP);
        tempMap.put("LABEL-TYPE-GS1 DataBar Expanded", ScanDataCollection.LabelType.GS1_DATABAR_EXP);
        tempMap.put("LABEL-TYPE-GS1-DATABAR-LIM", ScanDataCollection.LabelType.GS1_DATABAR_LIM);
        tempMap.put("LABEL-TYPE-GS1 DataBar Limited", ScanDataCollection.LabelType.GS1_DATABAR_LIM);
        tempMap.put("LABEL-TYPE-HAN XIN", ScanDataCollection.LabelType.HANXIN);
        tempMap.put("LABEL-TYPE-I2OF5", ScanDataCollection.LabelType.I2OF5);
        tempMap.put("LABEL-TYPE-Interleaved 2of5", ScanDataCollection.LabelType.I2OF5);
        tempMap.put("LABEL-TYPE-IATA2OF5", ScanDataCollection.LabelType.IATA2OF5);
        tempMap.put("LABEL-TYPE-ISBT128", ScanDataCollection.LabelType.ISBT128);
        tempMap.put("LABEL-TYPE-JAPPOSTAL", ScanDataCollection.LabelType.JAPPOSTAL);
        tempMap.put("LABEL-TYPE-Japanese Postal", ScanDataCollection.LabelType.JAPPOSTAL);
        tempMap.put("LABEL-TYPE-KOREAN-3OF5", ScanDataCollection.LabelType.KOREAN_3OF5);
        tempMap.put("LABEL-TYPE-KOREAN 3OF5", ScanDataCollection.LabelType.KOREAN_3OF5);
        tempMap.put("LABEL-TYPE-MAIL MARK", ScanDataCollection.LabelType.MAILMARK);
        tempMap.put("LABEL-TYPE-MATRIX-2OF5", ScanDataCollection.LabelType.MATRIX_2OF5);
        tempMap.put("LABEL-TYPE-MATRIX 2OF5", ScanDataCollection.LabelType.MATRIX_2OF5);
        tempMap.put("LABEL-TYPE-MAXICODE", ScanDataCollection.LabelType.MAXICODE);
        tempMap.put("LABEL-TYPE-MICROPDF", ScanDataCollection.LabelType.MICROPDF);
        tempMap.put("LABEL-TYPE-MICROQR", ScanDataCollection.LabelType.MICROQR);
        tempMap.put("LABEL-TYPE-MSI", ScanDataCollection.LabelType.MSI);
        tempMap.put("LABEL-TYPE-OCR", ScanDataCollection.LabelType.OCR);
        tempMap.put("LABEL-TYPE-PDF417", ScanDataCollection.LabelType.PDF417);
        tempMap.put("LABEL-TYPE-QRCODE", ScanDataCollection.LabelType.QRCODE);
        tempMap.put("LABEL-TYPE-SIGNATURE", ScanDataCollection.LabelType.SIGNATURE);
        tempMap.put("LABEL-TYPE-TLC39", ScanDataCollection.LabelType.TLC39);
        tempMap.put("LABEL-TYPE-TRIOPTIC39", ScanDataCollection.LabelType.TRIOPTIC39);
        tempMap.put("LABEL-TYPE-UKPOSTAL", ScanDataCollection.LabelType.UKPOSTAL);
        tempMap.put("LABEL-TYPE-UK Postal", ScanDataCollection.LabelType.UKPOSTAL);
        tempMap.put("LABEL-TYPE-UPCA", ScanDataCollection.LabelType.UPCA);
        tempMap.put("LABEL-TYPE-UPCE0", ScanDataCollection.LabelType.UPCE0);
        tempMap.put("LABEL-TYPE-UPCE1", ScanDataCollection.LabelType.UPCE1);
        tempMap.put("LABEL-TYPE-US4STATE", ScanDataCollection.LabelType.US4STATE);
        tempMap.put("LABEL-TYPE-US4STATE-FICS", ScanDataCollection.LabelType.US4STATE_FICS);
        tempMap.put("LABEL-TYPE-US4STATE FICS", ScanDataCollection.LabelType.US4STATE_FICS);
        tempMap.put("LABEL-TYPE-USPLANET", ScanDataCollection.LabelType.USPLANET);
        tempMap.put("LABEL-TYPE-US Planet", ScanDataCollection.LabelType.USPLANET);
        tempMap.put("LABEL-TYPE-USPOSTNET", ScanDataCollection.LabelType.USPOSTNET);
        tempMap.put("LABEL-TYPE-US Postnet", ScanDataCollection.LabelType.USPOSTNET);
        tempMap.put("LABEL-TYPE-GS1-DATAMATRIX", ScanDataCollection.LabelType.GS1_DATAMATRIX);
        tempMap.put("LABEL-TYPE-GS1-QRCODE", ScanDataCollection.LabelType.GS1_QRCODE);
        tempMap.put("LABEL-TYPE-DOTCODE", ScanDataCollection.LabelType.DOTCODE);
        tempMap.put("LABEL-TYPE-GRIDMATRIX", ScanDataCollection.LabelType.GRIDMATRIX);
        tempMap.put("LABEL-TYPE-FINNISHPOSTAL-4S", ScanDataCollection.LabelType.FINNISHPOSTAL_4S);
        LabelMap = Collections.unmodifiableMap(tempMap);
    }
}

