/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.barcode;

public enum ScannerResults {
    SUCCESS(0),
    ALREADY_SCANNING(2),
    SCANNER_IN_USE(3),
    VF_ERROR(4),
    INVALID_VALUE(5),
    SCAN_PARAM_NOT_SUPPORTED(6),
    SCAN_DATA_FAILURE(8),
    SCAN_PARAM_READ_ONLY(9),
    LENGTH_MISMATCH(10),
    SCANNER_OPERATION_FAILURE(11),
    FEATURE_NOT_SUPPORTED(12),
    SCANNER_NOT_SUPPORTED(13),
    FAILURE(14),
    SCANNER_NOT_ENABLED(16),
    SCANNER_NOT_CONNECTED(19),
    SCANNER_TIMED_OUT(100),
    INVALID_OBJECT(101),
    NO_DATA_LISTENER(102),
    TRIGGER_KEY_REG_FAILED(103),
    TRIGGER_KEY_IN_USE(104),
    TRIGGER_KEY_UNREG_FAILED(104),
    SCANNER_INIT_FAILURE(105),
    SCANNER_DEINIT_FAILURE(106),
    UNDEFINED(255);

    private int id;
    private String discription;

    private ScannerResults(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.length() == 0) {
            return ScannerResults.getErrorDescription(this);
        }
        return this.discription;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(ScannerResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success";
                break;
            }
            case FAILURE: {
                errDescription = "Failure";
                break;
            }
            case ALREADY_SCANNING: {
                errDescription = "Already scanning. Wait for current scanning to complete.";
                break;
            }
            case SCANNER_IN_USE: {
                errDescription = "Cannot enable scanner and is already in use.";
                break;
            }
            case VF_ERROR: {
                errDescription = "View finder error.";
                break;
            }
            case INVALID_VALUE: {
                errDescription = "The value is invalid.";
                break;
            }
            case SCAN_PARAM_NOT_SUPPORTED: {
                errDescription = "Particular parameter not supported.";
                break;
            }
            case SCAN_DATA_FAILURE: {
                errDescription = "Unexpected scan data";
                break;
            }
            case SCAN_PARAM_READ_ONLY: {
                errDescription = "Read only parameters.";
                break;
            }
            case LENGTH_MISMATCH: {
                errDescription = "Decoded barcode does not meet length requirements.";
                break;
            }
            case SCANNER_OPERATION_FAILURE: {
                errDescription = "Scanner operation failed.";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                errDescription = "The feature is not supported.";
                break;
            }
            case SCANNER_NOT_SUPPORTED: {
                errDescription = "Scanner not supported.";
                break;
            }
            case SCANNER_NOT_ENABLED: {
                errDescription = "The scanner device is not enabled.";
                break;
            }
            case SCANNER_NOT_CONNECTED: {
                errDescription = "Scanner not connected.";
                break;
            }
            case SCANNER_TIMED_OUT: {
                errDescription = "The timer out error occurred.";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "The object is not valid.";
                break;
            }
            case NO_DATA_LISTENER: {
                errDescription = "Scan read is issued without adding the data listener.";
                break;
            }
            case TRIGGER_KEY_REG_FAILED: {
                errDescription = "Failed to register for the hard trigger key notification.";
                break;
            }
            case TRIGGER_KEY_IN_USE: {
                errDescription = "Trigger key is already used by other.";
                break;
            }
            case TRIGGER_KEY_UNREG_FAILED: {
                errDescription = "Failed to unRegister for the hard trigger key notification.";
                break;
            }
            case SCANNER_INIT_FAILURE: {
                errDescription = "Scanner initialization failed.";
                break;
            }
            case SCANNER_DEINIT_FAILURE: {
                errDescription = "Scanner de-initialization failed.";
                break;
            }
            default: {
                errDescription = "Error code not defined.";
            }
        }
        return errDescription;
    }
}

