/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.barcode;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.symbol.emdk.emdkservice.barcode.SvcScannerException;
import java.util.HashMap;
import java.util.Locale;

public class SvcScannerConfig
implements Parcelable {
    private static final String TAG = "Svc_Scanner_Config";
    private boolean mGetParamList = false;
    public HashMap<String, Boolean> supportedParamList = new HashMap();
    public SkipOnUnSupported skipOnUnsupported = SkipOnUnSupported.UNSUPPORTED_PARAM;
    private Bundle paramBundle = null;
    private Bundle modifiedParamBundle;
    public InterfaceParams interfaceParams = new InterfaceParams();
    public ScanParams scanParams = new ScanParams();
    public DecoderParams decoderParams = new DecoderParams();
    public ReaderParams readerParams = new ReaderParams();
    @Deprecated
    public UdiParams udiParams = new UdiParams();
    @Deprecated
    public MultiBarcodeParams multiBarcodeParams = new MultiBarcodeParams();
    public OcrParams ocrParams = new OcrParams();
    public NGSimulScanParams ngSimulScanParams = new NGSimulScanParams();
    public static final Parcelable.Creator<SvcScannerConfig> CREATOR = new Parcelable.Creator<SvcScannerConfig>(){

        public SvcScannerConfig createFromParcel(Parcel source) {
            return new SvcScannerConfig(source);
        }

        public SvcScannerConfig[] newArray(int size) {
            return new SvcScannerConfig[size];
        }
    };

    public SvcScannerConfig() {
    }

    public Bundle getParamBundle() {
        return this.paramBundle;
    }

    public Bundle getModifiedParamBundle() {
        return this.modifiedParamBundle;
    }

    public void setModifiedParamBundle(Bundle paramBundle) {
        this.modifiedParamBundle = paramBundle;
    }

    public boolean isParamSupported(String param) {
        boolean isSupported = false;
        try {
            String temp;
            Boolean isSupportedObj;
            int index = param.indexOf(".");
            if (index != -1 && (isSupportedObj = this.supportedParamList.get((temp = param.substring(index + 1)).toLowerCase(Locale.ENGLISH))) != null) {
                isSupported = isSupportedObj;
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("" + ex.getMessage()));
        }
        return isSupported;
    }

    private SvcScannerConfig(Parcel in) {
        boolean bGetParamList;
        this.skipOnUnsupported = SkipOnUnSupported.values()[in.readInt()];
        this.interfaceParams.readFromParcel(in);
        this.scanParams.readFromParcel(in);
        this.readerParams.readFromParcel(in);
        this.decoderParams.readFromParcel(in);
        this.udiParams.readFromParcel(in);
        this.ocrParams.readFromParcel(in);
        this.multiBarcodeParams.readFromParcel(in);
        this.ngSimulScanParams.readFromParcel(in);
        Bundle b = in.readBundle();
        boolean bl = bGetParamList = 1 == b.getInt("mGetParamList");
        if (bGetParamList) {
            if (null != this.supportedParamList) {
                this.supportedParamList.clear();
            }
            this.supportedParamList = null;
            this.supportedParamList = (HashMap)b.getSerializable("supportedParamList");
            if (null != this.paramBundle) {
                this.paramBundle.clear();
            }
            this.paramBundle = null;
            this.paramBundle = b.getBundle("passthroughGetParamList");
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.skipOnUnsupported.ordinal());
        this.interfaceParams.writeToParcel(dest, flags);
        this.scanParams.writeToParcel(dest, flags);
        this.readerParams.writeToParcel(dest, flags);
        this.decoderParams.writeToParcel(dest, flags);
        this.udiParams.writeToParcel(dest, flags);
        this.ocrParams.writeToParcel(dest, flags);
        this.multiBarcodeParams.writeToParcel(dest, flags);
        this.ngSimulScanParams.writeToParcel(dest, flags);
        Bundle b = new Bundle();
        b.putInt("mGetParamList", this.mGetParamList ? 1 : 0);
        if (this.mGetParamList) {
            b.putSerializable("supportedParamList", this.supportedParamList);
            b.putBundle("passthroughGetParamList", this.paramBundle);
        }
        dest.writeBundle(b);
    }

    public static enum NGSimulScanMode {
        NONE(0),
        MULTI_BARCODE(1),
        TEMPLATE_MODE(2);

        private final int id;

        private NGSimulScanMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrCheckDigitValidation {
        NONE(0),
        PRODUCT_ADD_RIGHT_TO_LEFT(1),
        DIGIT_ADD_RIGHT_TO_LEFT(2),
        PRODUCT_ADD_LEFT_TO_RIGHT(3),
        DIGIT_ADD_LEFT_TO_RIGHT(4),
        PRODUCT_ADD_RIGHT_TO_LEFT_SIMPLE_REMAINDER(5),
        DIGIT_ADD_RIGHT_TO_LEFT_SIMPLE_REMAINDER(6),
        HEALTH_INDUSTRY_HIBCC43(9);

        private final int id;

        private OcrCheckDigitValidation(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrOrientation {
        DEGREE_0(0),
        DEGREE_270(1),
        DEGREE_180(2),
        DEGREE_90(3),
        OMNIDIRECTIONAL(4);

        private final int id;

        private OcrOrientation(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PresentationModeSensitivity {
        LOW(80),
        MEDIUM(120),
        HIGH(190);

        private final int id;

        private PresentationModeSensitivity(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DpmIlluminationControl {
        DIRECT(0),
        INDIRECT(11),
        CYCLE(10);

        private final int id;

        private DpmIlluminationControl(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DpmModes {
        DISABLED(0),
        MODE_1(1),
        MODE_2(2);

        private final int id;

        private DpmModes(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SignatureImageBitsPerPixel {
        BPP_1(0),
        BPP_4(1),
        BPP_8(2);

        private final int id;

        private SignatureImageBitsPerPixel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SignatureImageFormat {
        JPEG(1),
        BMP(3),
        TIFF(4);

        private final int id;

        private SignatureImageFormat(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum GridMatrixMirror {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private GridMatrixMirror(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum GridMatrixInverse {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private GridMatrixInverse(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DotCodeMirror {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private DotCodeMirror(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DotCodeInverse {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private DotCodeInverse(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SceneDetectionQualifier {
        NONE(0),
        PROXIMITY_SENSOR_INPUT(1);

        private final int id;

        private SceneDetectionQualifier(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AutoCharacterSetPreference {
        UTF_8("UTF-8"),
        GB2312("GB2312");

        private final String id;

        private AutoCharacterSetPreference(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum AutoCharacterSetFailureOption {
        NONE("NONE"),
        UTF_8("UTF-8"),
        ISO_8859_1("ISO-8859-1"),
        Shift_JIS("Shift_JIS"),
        GB18030("GB18030");

        private final String id;

        private AutoCharacterSetFailureOption(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum CharacterSetSelection {
        AUTO("AUTO"),
        UTF_8("UTF-8"),
        ISO_8859_1("ISO-8859-1"),
        Shift_JIS("Shift_JIS"),
        GB18030("GB18030");

        private final String id;

        private CharacterSetSelection(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    @Deprecated
    public static enum ScanMode {
        SINGLE_BARCODE(1),
        UDI(2),
        MULTI_BARCODE(4);

        private final int id;

        private ScanMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PairAfterScannerReboot {
        DISABLE(0),
        ENABLE(1);

        private final int id;

        private PairAfterScannerReboot(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PicklistEx {
        DISABLED(0),
        Hardware(1),
        Software(2),
        OUTDOOR(3);

        private final int id;

        private PicklistEx(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrLines {
        ONE_LINE(1),
        TWO_LINES(2),
        THREE_LINES(3);

        private final int id;

        private OcrLines(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum InverseOcr {
        REGULAR_ONLY(0),
        INVERSE_ONLY(1),
        AUTO_DISCRIMINATE(2);

        private final int id;

        private InverseOcr(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrBVariant {
        FULL_ASCII(0),
        BANKING(1),
        LIMITED(2),
        ISBN_1(6),
        ISBN_2(7),
        TRAVEL_DOCUMENT_1(3),
        TRAVEL_DOCUMENT_2(8),
        TRAVEL_DOCUMENT_3(20),
        PASSPORT(4),
        VISA_TYPE_A(9),
        VISA_TYPE_B(10),
        ICAO_TRAVEL_DOCUMENT(11);

        private final int id;

        private OcrBVariant(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OcrAVariant {
        FULL_ASCII(0),
        RESERVED_1(1),
        RESERVED_2(2),
        BANKING(3);

        private final int id;

        private OcrAVariant(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum GS1LimitedSecurityLevel {
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3),
        LEVEL_4(4);

        private final int id;

        private GS1LimitedSecurityLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum BeamWidth {
        NARROW(0),
        NORMAL(1),
        WIDE(2);

        private final int id;

        private BeamWidth(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AdaptiveScanning {
        ENABLE(0),
        DISABLE(1);

        private final int id;

        private AdaptiveScanning(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PoorQualityDecodeEffortLevel {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private final int id;

        private PoorQualityDecodeEffortLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum OneDQuietZoneLevel {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private final int id;

        private OneDQuietZoneLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DecodeAudioFeedbackMode {
        LOCAL(0),
        REMOTE(1),
        BOTH(2),
        DISABLE(3);

        private final int id;

        private DecodeAudioFeedbackMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum DecodeLEDFeedbackMode {
        LOCAL(0),
        REMOTE(1),
        BOTH(2),
        DISABLE(3);

        private final int id;

        private DecodeLEDFeedbackMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AimingPattern {
        OFF("off"),
        ON("on");

        private final String id;

        private AimingPattern(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum SkipOnUnSupported {
        NONE,
        UNSUPPORTED_PARAM,
        UNSUPPORTED_VALUE,
        ALL;

    }

    public static enum PowerMode {
        LOW(0),
        OPTIMIZED(1),
        HIGH(2),
        ALWAYS_ON(3);

        private final int id;

        private PowerMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AudioStreamType {
        RINGER(0),
        MEDIA(1),
        ALARAMS(2);

        private final int id;

        private AudioStreamType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum Inverse1DMode {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private Inverse1DMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum LcdMode {
        DISABLED(0),
        ENABLED(1);

        private final int id;

        private LcdMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum IlluminationMode {
        OFF("off"),
        ON("torch");

        private final String id;

        private IlluminationMode(String id) {
            this.id = id;
        }

        String getValue() {
            return this.id;
        }
    }

    public static enum ViewFinderMode {
        ENABLED(1),
        STATIC_RECTICLE(2);

        private final int id;

        private ViewFinderMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum BooklandFormat {
        ISBN_10(0),
        ISBN_13(1);

        private final int id;

        private BooklandFormat(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CouponReport {
        OLD(0),
        NEW(1),
        BOTH(2);

        private final int id;

        private CouponReport(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SupplementalMode {
        NO(0),
        ALWAYS(1),
        AUTO(2),
        SMART(3),
        S_378_379(4),
        S_978_979(5),
        S_414_419_434_439(6),
        S_977(7);

        private final int id;

        private SupplementalMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CodeIdType {
        NONE(0),
        AIM(1),
        SYMBOL(2);

        private final int id;

        private CodeIdType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum PickList {
        DISABLED(0),
        ENABLED(1);

        private final int id;

        private PickList(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum UccLinkMode {
        LINK_FLAG_IGNORED(0),
        ALWAYS_LINKED(1),
        AUTO_DISCRIMINATE(2);

        private final int id;

        private UccLinkMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CheckDigitScheme {
        MOD_11_10(0),
        MOD_10_10(1);

        private final int id;

        private CheckDigitScheme(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum VerifyCheckDigit {
        NO(0),
        ONE(1),
        TWO(2);

        private final int id;

        private VerifyCheckDigit(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum HanXinInverse {
        DISABLED(0),
        ENABLED(1),
        AUTO(2);

        private final int id;

        private HanXinInverse(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CheckDigit {
        ONE(0),
        TWO(1);

        private final int id;

        private CheckDigit(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum CheckDigitType {
        NO(0),
        USS(1),
        OPCC(2);

        private final int id;

        private CheckDigitType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum LinearSecurityLevel {
        SHORT_OR_CODABAR(1),
        ALL_TWICE(2),
        LONG_AND_SHORT(3),
        ALL_THRICE(4);

        private final int id;

        private LinearSecurityLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum AimType {
        DUALTRIGGER(0),
        TIMED_HOLD(1),
        TIMED_RELEASE(2),
        PRESS_AND_RELEASE(3),
        PRESENTATION(4),
        CONTINUOUS_READ(5),
        PRESS_AND_SUSTAIN(6);

        private final int id;

        private AimType(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum SecurityLevel {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private final int id;

        private SecurityLevel(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum Isbt128ContactMode {
        NEVER(0),
        ALWAYS(1),
        AUTO(2);

        private final int id;

        private Isbt128ContactMode(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum Preamble {
        NONE(0),
        SYS_CHAR(1),
        COUNTRY_AND_SYS_CHAR(2);

        private final int id;

        private Preamble(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public class NGSimulScanParams {
        public NGSimulScanMode ngSimulScanMode = NGSimulScanMode.NONE;
        public MultiBarcodeParams multiBarcodeParams = new MultiBarcodeParams();
        public TemplateParams templateParams = new TemplateParams();

        NGSimulScanParams() {
        }

        public void readFromParcel(Parcel in) {
            this.ngSimulScanMode = NGSimulScanMode.values()[in.readInt()];
            this.multiBarcodeParams.readFromParcel(in);
            this.templateParams.readFromParcel(in);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ngSimulScanMode.ordinal());
            this.multiBarcodeParams.writeToParcel(dest, flags);
            this.templateParams.writeToParcel(dest, flags);
        }

        public class TemplateParams {
            public int templateID = 0;

            TemplateParams() {
            }

            public void readFromParcel(Parcel in) {
                this.templateID = in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.templateID);
            }
        }

        public class MultiBarcodeParams {
            public int barcodeCount = 5;
            public boolean instantReporting = false;
            public boolean reportDecodedBarcodes = false;

            MultiBarcodeParams() {
            }

            public void readFromParcel(Parcel in) {
                this.barcodeCount = in.readInt();
                this.instantReporting = 1 == in.readInt();
                this.reportDecodedBarcodes = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.barcodeCount);
                dest.writeInt(this.instantReporting ? 1 : 0);
                dest.writeInt(this.reportDecodedBarcodes ? 1 : 0);
            }
        }
    }

    public class OcrParams {
        public InverseOcr inverseOcr = InverseOcr.REGULAR_ONLY;
        public OcrLines ocrLines = OcrLines.ONE_LINE;
        public int maxCharacters = 100;
        public int minCharacters = 3;
        public int quietZone = 50;
        public String template = "99999999";
        public OcrOrientation orientation = OcrOrientation.DEGREE_0;
        public String subset = "";
        public int checkDigitModulus = 1;
        public String checkDigitMultiplier = "121212121212";
        public OcrCheckDigitValidation checkDigitValidation = OcrCheckDigitValidation.NONE;

        OcrParams() {
        }

        void getAllParams() throws SvcScannerException {
        }

        void setAllParams(OcrParams prev) throws SvcScannerException {
        }

        void saveAllParams(OcrParams objSrc) {
            this.inverseOcr = objSrc.inverseOcr;
            this.ocrLines = objSrc.ocrLines;
            this.maxCharacters = objSrc.maxCharacters;
            this.minCharacters = objSrc.minCharacters;
            this.quietZone = objSrc.quietZone;
            this.template = objSrc.template;
            this.orientation = objSrc.orientation;
            this.subset = objSrc.subset;
            this.checkDigitModulus = objSrc.checkDigitModulus;
            this.checkDigitMultiplier = objSrc.checkDigitMultiplier;
            this.checkDigitValidation = objSrc.checkDigitValidation;
        }

        public void readFromParcel(Parcel in) {
            this.inverseOcr = InverseOcr.values()[in.readInt()];
            this.ocrLines = OcrLines.values()[in.readInt()];
            this.maxCharacters = in.readInt();
            this.minCharacters = in.readInt();
            this.quietZone = in.readInt();
            this.template = in.readString();
            this.orientation = OcrOrientation.values()[in.readInt()];
            this.subset = in.readString();
            this.checkDigitModulus = in.readInt();
            this.checkDigitMultiplier = in.readString();
            this.checkDigitValidation = OcrCheckDigitValidation.values()[in.readInt()];
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.inverseOcr.ordinal());
            dest.writeInt(this.ocrLines.ordinal());
            dest.writeInt(this.maxCharacters);
            dest.writeInt(this.minCharacters);
            dest.writeInt(this.quietZone);
            dest.writeString(this.template);
            dest.writeInt(this.orientation.ordinal());
            dest.writeString(this.subset);
            dest.writeInt(this.checkDigitModulus);
            dest.writeString(this.checkDigitMultiplier);
            dest.writeInt(this.checkDigitValidation.ordinal());
        }
    }

    @Deprecated
    public class MultiBarcodeParams {
        @Deprecated
        public int barcodeCount = 5;
        @Deprecated
        public boolean instantReporting = false;
        @Deprecated
        public boolean reportDecodedBarcodes = false;

        MultiBarcodeParams() {
        }

        public void readFromParcel(Parcel in) {
            this.barcodeCount = in.readInt();
            this.instantReporting = 1 == in.readInt();
            this.reportDecodedBarcodes = 1 == in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.barcodeCount);
            dest.writeInt(this.instantReporting ? 1 : 0);
            dest.writeInt(this.reportDecodedBarcodes ? 1 : 0);
        }
    }

    @Deprecated
    public class UdiParams {
        @Deprecated
        public Boolean enableGS1 = true;
        @Deprecated
        public Boolean enableHIBCC = true;
        @Deprecated
        public Boolean enableICCBBA = true;

        UdiParams() {
        }

        public void readFromParcel(Parcel in) {
            this.enableGS1 = in.readInt() == 1;
            this.enableHIBCC = in.readInt() == 1;
            this.enableICCBBA = in.readInt() == 1;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.enableGS1 != false ? 1 : 0);
            dest.writeInt(this.enableHIBCC != false ? 1 : 0);
            dest.writeInt(this.enableICCBBA != false ? 1 : 0);
        }
    }

    public class DecoderParams {
        public AustralianPostal australianPostal = new AustralianPostal();
        public Aztec aztec = new Aztec();
        public CanadianPostal canadianPostal = new CanadianPostal();
        public Chinese2of5 chinese2of5 = new Chinese2of5();
        public CodaBar codaBar = new CodaBar();
        public Code11 code11 = new Code11();
        public Code128 code128 = new Code128();
        public Code39 code39 = new Code39();
        public Code93 code93 = new Code93();
        public CompositeAB compositeAB = new CompositeAB();
        public CompositeC compositeC = new CompositeC();
        public D2of5 d2of5 = new D2of5();
        public DataMatrix dataMatrix = new DataMatrix();
        public DutchPostal dutchPostal = new DutchPostal();
        public Ean13 ean13 = new Ean13();
        public Ean8 ean8 = new Ean8();
        public Gs1Databar gs1Databar = new Gs1Databar();
        public Gs1DatabarLim gs1DatabarLim = new Gs1DatabarLim();
        public Gs1DatabarExp gs1DatabarExp = new Gs1DatabarExp();
        public I2of5 i2of5 = new I2of5();
        public JapanesePostal japanesePostal = new JapanesePostal();
        public Korean3of5 korean3of5 = new Korean3of5();
        public Matrix2of5 matrix2of5 = new Matrix2of5();
        public MaxiCode maxiCode = new MaxiCode();
        public MicroPdf microPDF = new MicroPdf();
        public MicroQr microQR = new MicroQr();
        public Msi msi = new Msi();
        public Pdf417 pdf417 = new Pdf417();
        public QrCode qrCode = new QrCode();
        public Signature signature = new Signature();
        public Tlc39 tlc39 = new Tlc39();
        public TriOptic39 triOptic39 = new TriOptic39();
        public UkPostal ukPostal = new UkPostal();
        public Upca upca = new Upca();
        public Upce0 upce0 = new Upce0();
        public Upce1 upce1 = new Upce1();
        public UpcEanParams upcEanParams = new UpcEanParams();
        public Us4StateFics us4StateFics = new Us4StateFics();
        public Us4State us4State = new Us4State();
        public UsPlanet usPlanet = new UsPlanet();
        public UsPostNet usPostNet = new UsPostNet();
        public WebCode webCode = new WebCode();
        public MailMark mailMark = new MailMark();
        public HanXin hanXin = new HanXin();
        public OcrA ocrA = new OcrA();
        public OcrB ocrB = new OcrB();
        public Gs1Datamatrix gs1Datamatrix = new Gs1Datamatrix();
        public Gs1QrCode gs1QrCode = new Gs1QrCode();
        public DotCode dotCode = new DotCode();
        public GridMatrix gridMatrix = new GridMatrix();
        public MICRE13B micrE13B = new MICRE13B();
        public USCurrency usCurrency = new USCurrency();
        public FinnishPostal4S finnishPostal4S = new FinnishPostal4S();

        DecoderParams() {
        }

        void setAllParams(DecoderParams prev) throws SvcScannerException {
        }

        void getAllParams() throws SvcScannerException {
        }

        void saveAllParams(DecoderParams objSrc) {
        }

        public void readFromParcel(Parcel in) {
            this.australianPostal.readFromParcel(in);
            this.aztec.readFromParcel(in);
            this.canadianPostal.readFromParcel(in);
            this.chinese2of5.readFromParcel(in);
            this.codaBar.readFromParcel(in);
            this.code11.readFromParcel(in);
            this.code128.readFromParcel(in);
            this.code39.readFromParcel(in);
            this.code93.readFromParcel(in);
            this.compositeAB.readFromParcel(in);
            this.compositeC.readFromParcel(in);
            this.d2of5.readFromParcel(in);
            this.dataMatrix.readFromParcel(in);
            this.dutchPostal.readFromParcel(in);
            this.ean13.readFromParcel(in);
            this.ean8.readFromParcel(in);
            this.gs1Databar.readFromParcel(in);
            this.gs1DatabarLim.readFromParcel(in);
            this.gs1DatabarExp.readFromParcel(in);
            this.hanXin.readFromParcel(in);
            this.i2of5.readFromParcel(in);
            this.japanesePostal.readFromParcel(in);
            this.korean3of5.readFromParcel(in);
            this.mailMark.readFromParcel(in);
            this.matrix2of5.readFromParcel(in);
            this.maxiCode.readFromParcel(in);
            this.microPDF.readFromParcel(in);
            this.microQR.readFromParcel(in);
            this.msi.readFromParcel(in);
            this.pdf417.readFromParcel(in);
            this.qrCode.readFromParcel(in);
            this.signature.readFromParcel(in);
            this.tlc39.readFromParcel(in);
            this.triOptic39.readFromParcel(in);
            this.ukPostal.readFromParcel(in);
            this.upca.readFromParcel(in);
            this.upce0.readFromParcel(in);
            this.upce1.readFromParcel(in);
            this.upcEanParams.readFromParcel(in);
            this.us4State.readFromParcel(in);
            this.usPlanet.readFromParcel(in);
            this.usPostNet.readFromParcel(in);
            this.webCode.readFromParcel(in);
            this.ocrA.readFromParcel(in);
            this.ocrB.readFromParcel(in);
            this.gs1Datamatrix.readFromParcel(in);
            this.gs1QrCode.readFromParcel(in);
            this.dotCode.readFromParcel(in);
            this.gridMatrix.readFromParcel(in);
            this.micrE13B.readFromParcel(in);
            this.usCurrency.readFromParcel(in);
            this.finnishPostal4S.readFromParcel(in);
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.australianPostal.writeToParcel(dest, flags);
            this.aztec.writeToParcel(dest, flags);
            this.canadianPostal.writeToParcel(dest, flags);
            this.chinese2of5.writeToParcel(dest, flags);
            this.codaBar.writeToParcel(dest, flags);
            this.code11.writeToParcel(dest, flags);
            this.code128.writeToParcel(dest, flags);
            this.code39.writeToParcel(dest, flags);
            this.code93.writeToParcel(dest, flags);
            this.compositeAB.writeToParcel(dest, flags);
            this.compositeC.writeToParcel(dest, flags);
            this.d2of5.writeToParcel(dest, flags);
            this.dataMatrix.writeToParcel(dest, flags);
            this.dutchPostal.writeToParcel(dest, flags);
            this.ean13.writeToParcel(dest, flags);
            this.ean8.writeToParcel(dest, flags);
            this.gs1Databar.writeToParcel(dest, flags);
            this.gs1DatabarLim.writeToParcel(dest, flags);
            this.gs1DatabarExp.writeToParcel(dest, flags);
            this.hanXin.writeToParcel(dest, flags);
            this.i2of5.writeToParcel(dest, flags);
            this.japanesePostal.writeToParcel(dest, flags);
            this.korean3of5.writeToParcel(dest, flags);
            this.mailMark.writeToParcel(dest, flags);
            this.matrix2of5.writeToParcel(dest, flags);
            this.maxiCode.writeToParcel(dest, flags);
            this.microPDF.writeToParcel(dest, flags);
            this.microQR.writeToParcel(dest, flags);
            this.msi.writeToParcel(dest, flags);
            this.pdf417.writeToParcel(dest, flags);
            this.qrCode.writeToParcel(dest, flags);
            this.signature.writeToParcel(dest, flags);
            this.tlc39.writeToParcel(dest, flags);
            this.triOptic39.writeToParcel(dest, flags);
            this.ukPostal.writeToParcel(dest, flags);
            this.upca.writeToParcel(dest, flags);
            this.upce0.writeToParcel(dest, flags);
            this.upce1.writeToParcel(dest, flags);
            this.upcEanParams.writeToParcel(dest, flags);
            this.us4State.writeToParcel(dest, flags);
            this.usPlanet.writeToParcel(dest, flags);
            this.usPostNet.writeToParcel(dest, flags);
            this.webCode.writeToParcel(dest, flags);
            this.ocrA.writeToParcel(dest, flags);
            this.ocrB.writeToParcel(dest, flags);
            this.gs1Datamatrix.writeToParcel(dest, flags);
            this.gs1QrCode.writeToParcel(dest, flags);
            this.dotCode.writeToParcel(dest, flags);
            this.gridMatrix.writeToParcel(dest, flags);
            this.micrE13B.writeToParcel(dest, flags);
            this.usCurrency.writeToParcel(dest, flags);
            this.finnishPostal4S.writeToParcel(dest, flags);
        }

        public class FinnishPostal4S
        extends BaseDecoder {
            FinnishPostal4S() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class USCurrency
        extends BaseDecoder {
            USCurrency() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class MICRE13B
        extends BaseDecoder {
            MICRE13B() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class GridMatrix
        extends BaseDecoder {
            public GridMatrixInverse inverse;
            public GridMatrixMirror mirror;

            GridMatrix() {
                this.inverse = GridMatrixInverse.DISABLED;
                this.mirror = GridMatrixMirror.DISABLED;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.inverse = GridMatrixInverse.values()[in.readInt()];
                this.mirror = GridMatrixMirror.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.inverse.ordinal());
                dest.writeInt(this.mirror.ordinal());
            }
        }

        public class DotCode
        extends BaseDecoder {
            public DotCodeInverse inverse;
            public DotCodeMirror mirror;

            DotCode() {
                this.inverse = DotCodeInverse.AUTO;
                this.mirror = DotCodeMirror.AUTO;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.inverse = DotCodeInverse.values()[in.readInt()];
                this.mirror = DotCodeMirror.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.inverse.ordinal());
                dest.writeInt(this.mirror.ordinal());
            }
        }

        public class Gs1QrCode
        extends BaseDecoder {
            Gs1QrCode() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Gs1Datamatrix
        extends BaseDecoder {
            Gs1Datamatrix() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class OcrB
        extends BaseDecoder {
            public OcrBVariant ocrBVariant;

            OcrB() {
                this.ocrBVariant = OcrBVariant.FULL_ASCII;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.ocrBVariant = OcrBVariant.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.ocrBVariant.ordinal());
            }
        }

        public class OcrA
        extends BaseDecoder {
            public OcrAVariant ocrAVariant;

            OcrA() {
                this.ocrAVariant = OcrAVariant.FULL_ASCII;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.ocrAVariant = OcrAVariant.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.ocrAVariant.ordinal());
            }
        }

        public class WebCode
        extends BaseDecoder {
            public boolean subType;

            WebCode() {
                this.subType = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.subType = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.subType ? 1 : 0);
            }
        }

        public class UsPostNet
        extends BaseDecoder {
            public boolean reportCheckDigit;

            UsPostNet() {
                this.reportCheckDigit = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
            }
        }

        public class UsPlanet
        extends BaseDecoder {
            public boolean reportCheckDigit;

            UsPlanet() {
                this.reportCheckDigit = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
            }
        }

        public class Us4State
        extends BaseDecoder {
            Us4State() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Us4StateFics
        extends BaseDecoder {
            Us4StateFics() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class UpcEanParams {
            public boolean booklandCode = false;
            public BooklandFormat booklandFormat = BooklandFormat.ISBN_10;
            public boolean convertDataBarToUpcEan = false;
            public boolean couponCode = false;
            public boolean linearDecode = true;
            public boolean randomWeightCheckDigit = false;
            public SecurityLevel securityLevel = SecurityLevel.LEVEL_1;
            public boolean supplemental2 = true;
            public boolean supplemental5 = true;
            public SupplementalMode supplementalMode = SupplementalMode.NO;
            public int supplementalRetries = 10;
            public CouponReport couponReport = CouponReport.BOTH;
            public boolean reducedQuietZone = false;
            public boolean eanZeroExtend = false;

            UpcEanParams() {
            }

            public void readFromParcel(Parcel in) {
                this.booklandCode = 1 == in.readInt();
                this.booklandFormat = BooklandFormat.values()[in.readInt()];
                this.convertDataBarToUpcEan = 1 == in.readInt();
                this.couponCode = 1 == in.readInt();
                this.linearDecode = 1 == in.readInt();
                this.randomWeightCheckDigit = 1 == in.readInt();
                this.securityLevel = SecurityLevel.values()[in.readInt()];
                this.supplemental2 = 1 == in.readInt();
                this.supplemental5 = 1 == in.readInt();
                this.supplementalMode = SupplementalMode.values()[in.readInt()];
                this.supplementalRetries = in.readInt();
                this.couponReport = CouponReport.values()[in.readInt()];
                this.eanZeroExtend = 1 == in.readInt();
                this.reducedQuietZone = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.booklandCode ? 1 : 0);
                dest.writeInt(this.booklandFormat.ordinal());
                dest.writeInt(this.convertDataBarToUpcEan ? 1 : 0);
                dest.writeInt(this.couponCode ? 1 : 0);
                dest.writeInt(this.linearDecode ? 1 : 0);
                dest.writeInt(this.randomWeightCheckDigit ? 1 : 0);
                dest.writeInt(this.securityLevel.ordinal());
                dest.writeInt(this.supplemental2 ? 1 : 0);
                dest.writeInt(this.supplemental5 ? 1 : 0);
                dest.writeInt(this.supplementalMode.ordinal());
                dest.writeInt(this.supplementalRetries);
                dest.writeInt(this.couponReport.ordinal());
                dest.writeInt(this.eanZeroExtend ? 1 : 0);
                dest.writeInt(this.reducedQuietZone ? 1 : 0);
            }
        }

        public class Upce1
        extends BaseDecoder {
            public boolean reportCheckDigit;
            public Preamble preamble;
            public boolean convertToUpca;

            Upce1() {
                this.reportCheckDigit = false;
                this.preamble = Preamble.NONE;
                this.convertToUpca = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
                this.preamble = Preamble.values()[in.readInt()];
                this.convertToUpca = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
                dest.writeInt(this.preamble.ordinal());
                dest.writeInt(this.convertToUpca ? 1 : 0);
            }
        }

        public class Upce0
        extends BaseDecoder {
            public boolean reportCheckDigit;
            public Preamble preamble;
            public boolean convertToUpca;

            Upce0() {
                this.reportCheckDigit = false;
                this.preamble = Preamble.NONE;
                this.convertToUpca = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
                this.preamble = Preamble.values()[in.readInt()];
                this.convertToUpca = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
                dest.writeInt(this.preamble.ordinal());
                dest.writeInt(this.convertToUpca ? 1 : 0);
            }
        }

        public class Upca
        extends BaseDecoder {
            public boolean reportCheckDigit;
            public Preamble preamble;

            Upca() {
                this.reportCheckDigit = true;
                this.preamble = Preamble.SYS_CHAR;
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
                this.preamble = Preamble.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
                dest.writeInt(this.preamble.ordinal());
            }
        }

        public class UkPostal
        extends BaseDecoder {
            public boolean reportCheckDigit;

            UkPostal() {
                this.reportCheckDigit = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
            }
        }

        public class TriOptic39
        extends BaseDecoder {
            public boolean redundancy;

            TriOptic39() {
                this.redundancy = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.redundancy = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.redundancy ? 1 : 0);
            }
        }

        public class Tlc39
        extends BaseDecoder {
            Tlc39() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Signature
        extends BaseDecoder {
            public int width;
            public int height;
            public SignatureImageFormat format;
            public int jpegQuality;
            public SignatureImageBitsPerPixel bpp;

            Signature() {
                this.width = 400;
                this.height = 400;
                this.format = SignatureImageFormat.BMP;
                this.jpegQuality = 65;
                this.bpp = SignatureImageBitsPerPixel.BPP_8;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.width = in.readInt();
                this.height = in.readInt();
                this.format = SignatureImageFormat.values()[in.readInt()];
                this.jpegQuality = in.readInt();
                this.bpp = SignatureImageBitsPerPixel.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.width);
                dest.writeInt(this.height);
                dest.writeInt(this.format.ordinal());
                dest.writeInt(this.jpegQuality);
                dest.writeInt(this.bpp.ordinal());
            }
        }

        public class QrCode
        extends BaseDecoder {
            QrCode() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Pdf417
        extends BaseDecoder {
            Pdf417() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Msi
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public CheckDigit checkDigits;
            public CheckDigitScheme checkDigitScheme;
            public boolean reportCheckDigit;

            Msi() {
                this.length1 = 4;
                this.length2 = 55;
                this.redundancy = true;
                this.checkDigits = CheckDigit.ONE;
                this.checkDigitScheme = CheckDigitScheme.MOD_10_10;
                this.reportCheckDigit = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
                this.checkDigits = CheckDigit.values()[in.readInt()];
                this.checkDigitScheme = CheckDigitScheme.values()[in.readInt()];
                this.reportCheckDigit = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
                dest.writeInt(this.checkDigits.ordinal());
                dest.writeInt(this.checkDigitScheme.ordinal());
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
            }
        }

        public class MicroQr
        extends BaseDecoder {
            MicroQr() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class MicroPdf
        extends BaseDecoder {
            MicroPdf() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class MaxiCode
        extends BaseDecoder {
            MaxiCode() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Matrix2of5
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public boolean reportCheckDigit;
            public boolean verifyCheckDigit;

            Matrix2of5() {
                this.length1 = 10;
                this.length2 = 0;
                this.redundancy = false;
                this.reportCheckDigit = true;
                this.verifyCheckDigit = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
                this.verifyCheckDigit = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
                dest.writeInt(this.verifyCheckDigit ? 1 : 0);
            }
        }

        public class Korean3of5
        extends BaseDecoder {
            Korean3of5() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class JapanesePostal
        extends BaseDecoder {
            JapanesePostal() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class I2of5
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public CheckDigitType verifyCheckDigit;
            public boolean reportCheckDigit;
            public boolean convertToEan13;
            public SecurityLevel securityLevel;
            public boolean reducedQuietZone;
            public boolean febraban;

            I2of5() {
                this.length1 = 14;
                this.length2 = 10;
                this.redundancy = true;
                this.verifyCheckDigit = CheckDigitType.NO;
                this.reportCheckDigit = false;
                this.convertToEan13 = false;
                this.securityLevel = SecurityLevel.LEVEL_1;
                this.reducedQuietZone = false;
                this.febraban = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
                this.verifyCheckDigit = CheckDigitType.values()[in.readInt()];
                this.reportCheckDigit = 1 == in.readInt();
                this.convertToEan13 = 1 == in.readInt();
                this.securityLevel = SecurityLevel.values()[in.readInt()];
                this.reducedQuietZone = 1 == in.readInt();
                this.febraban = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
                dest.writeInt(this.verifyCheckDigit.ordinal());
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
                dest.writeInt(this.convertToEan13 ? 1 : 0);
                dest.writeInt(this.securityLevel.ordinal());
                dest.writeInt(this.reducedQuietZone ? 1 : 0);
                dest.writeInt(this.febraban ? 1 : 0);
            }
        }

        public class Gs1DatabarExp
        extends BaseDecoder {
            Gs1DatabarExp() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Gs1DatabarLim
        extends BaseDecoder {
            public GS1LimitedSecurityLevel securityLevel;

            Gs1DatabarLim() {
                this.securityLevel = GS1LimitedSecurityLevel.LEVEL_2;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.securityLevel = GS1LimitedSecurityLevel.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.securityLevel.ordinal());
            }
        }

        public class Gs1Databar
        extends BaseDecoder {
            Gs1Databar() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Ean8
        extends BaseDecoder {
            public boolean convertToEan13;

            Ean8() {
                this.convertToEan13 = false;
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.convertToEan13 = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.convertToEan13 ? 1 : 0);
            }
        }

        public class Ean13
        extends BaseDecoder {
            Ean13() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class DutchPostal
        extends BaseDecoder {
            public boolean dutchPostal3S;

            DutchPostal() {
                this.dutchPostal3S = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.dutchPostal3S = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.dutchPostal3S ? 1 : 0);
            }
        }

        public class DataMatrix
        extends BaseDecoder {
            DataMatrix() {
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class D2of5
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;

            D2of5() {
                this.length1 = 0;
                this.length2 = 14;
                this.redundancy = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
            }
        }

        public class CompositeC
        extends BaseDecoder {
            CompositeC() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class CompositeAB
        extends BaseDecoder {
            public UccLinkMode uccLinkMode;

            CompositeAB() {
                this.uccLinkMode = UccLinkMode.AUTO_DISCRIMINATE;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.uccLinkMode = UccLinkMode.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.uccLinkMode.ordinal());
            }
        }

        public class Code93
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;

            Code93() {
                this.length1 = 0;
                this.length2 = 55;
                this.redundancy = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
            }
        }

        public class Code39
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean verifyCheckDigit;
            public boolean reportCheckDigit;
            public boolean fullAscii;
            public boolean redundancy;
            public boolean convertToCode32;
            public boolean reportCode32Prefix;
            public SecurityLevel securityLevel;
            public boolean reducedQuietZone;

            Code39() {
                this.length1 = 0;
                this.length2 = 55;
                this.verifyCheckDigit = false;
                this.reportCheckDigit = false;
                this.fullAscii = false;
                this.redundancy = false;
                this.convertToCode32 = false;
                this.reportCode32Prefix = false;
                this.securityLevel = SecurityLevel.LEVEL_1;
                this.reducedQuietZone = false;
                this.enabled = true;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.verifyCheckDigit = 1 == in.readInt();
                this.reportCheckDigit = 1 == in.readInt();
                this.fullAscii = 1 == in.readInt();
                this.redundancy = 1 == in.readInt();
                this.convertToCode32 = 1 == in.readInt();
                this.reportCode32Prefix = 1 == in.readInt();
                this.securityLevel = SecurityLevel.values()[in.readInt()];
                this.reducedQuietZone = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.verifyCheckDigit ? 1 : 0);
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
                dest.writeInt(this.fullAscii ? 1 : 0);
                dest.writeInt(this.redundancy ? 1 : 0);
                dest.writeInt(this.convertToCode32 ? 1 : 0);
                dest.writeInt(this.reportCode32Prefix ? 1 : 0);
                dest.writeInt(this.securityLevel.ordinal());
                dest.writeInt(this.reducedQuietZone ? 1 : 0);
            }
        }

        public class Code128
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public boolean enablePlain;
            public boolean enableEan128;
            public boolean enableIsbt128;
            public Isbt128ContactMode isbt128ConcatMode;
            public boolean checkIsbtTable;
            public SecurityLevel securityLevel;
            public boolean reducedQuietZone;

            Code128() {
                this.length1 = 0;
                this.length2 = 55;
                this.redundancy = false;
                this.enablePlain = true;
                this.enableEan128 = true;
                this.enableIsbt128 = true;
                this.isbt128ConcatMode = Isbt128ContactMode.NEVER;
                this.checkIsbtTable = false;
                this.securityLevel = SecurityLevel.LEVEL_1;
                this.reducedQuietZone = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
                this.enablePlain = 1 == in.readInt();
                this.enableEan128 = 1 == in.readInt();
                this.enableIsbt128 = 1 == in.readInt();
                this.isbt128ConcatMode = Isbt128ContactMode.values()[in.readInt()];
                this.checkIsbtTable = 1 == in.readInt();
                this.securityLevel = SecurityLevel.values()[in.readInt()];
                this.reducedQuietZone = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
                dest.writeInt(this.enablePlain ? 1 : 0);
                dest.writeInt(this.enableEan128 ? 1 : 0);
                dest.writeInt(this.enableIsbt128 ? 1 : 0);
                dest.writeInt(this.isbt128ConcatMode.ordinal());
                dest.writeInt(this.checkIsbtTable ? 1 : 0);
                dest.writeInt(this.securityLevel.ordinal());
                dest.writeInt(this.reducedQuietZone ? 1 : 0);
            }
        }

        public class Code11
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public VerifyCheckDigit verifyCheckDigit;
            public boolean reportCheckDigit;

            Code11() {
                this.length1 = 4;
                this.length2 = 55;
                this.redundancy = true;
                this.verifyCheckDigit = VerifyCheckDigit.ONE;
                this.reportCheckDigit = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
                this.verifyCheckDigit = VerifyCheckDigit.values()[in.readInt()];
                this.reportCheckDigit = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
                dest.writeInt(this.verifyCheckDigit.ordinal());
                dest.writeInt(this.reportCheckDigit ? 1 : 0);
            }
        }

        public class CodaBar
        extends BaseDecoder {
            public int length1;
            public int length2;
            public boolean redundancy;
            public boolean clsiEditing;
            public boolean notisEditing;

            CodaBar() {
                this.length1 = 6;
                this.length2 = 55;
                this.redundancy = true;
                this.clsiEditing = false;
                this.notisEditing = false;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.length1 = in.readInt();
                this.length2 = in.readInt();
                this.redundancy = 1 == in.readInt();
                this.clsiEditing = 1 == in.readInt();
                this.notisEditing = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.length1);
                dest.writeInt(this.length2);
                dest.writeInt(this.redundancy ? 1 : 0);
                dest.writeInt(this.clsiEditing ? 1 : 0);
                dest.writeInt(this.notisEditing ? 1 : 0);
            }
        }

        public class Chinese2of5
        extends BaseDecoder {
            Chinese2of5() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class CanadianPostal
        extends BaseDecoder {
            CanadianPostal() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class Aztec
        extends BaseDecoder {
            Aztec() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class HanXin
        extends BaseDecoder {
            public HanXinInverse hanXinInverse;

            HanXin() {
                this.hanXinInverse = HanXinInverse.DISABLED;
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
                this.hanXinInverse = HanXinInverse.values()[in.readInt()];
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
                dest.writeInt(this.hanXinInverse.ordinal());
            }
        }

        public class MailMark
        extends BaseDecoder {
            MailMark() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        public class AustralianPostal
        extends BaseDecoder {
            AustralianPostal() {
            }

            public void readFromParcel(Parcel in) {
                this.enabled = 1 == in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.enabled ? 1 : 0);
            }
        }

        abstract class BaseDecoder {
            public boolean enabled;

            BaseDecoder() {
            }
        }
    }

    public class ReaderParams {
        public ReaderSpecific readerSpecific = new ReaderSpecific();

        ReaderParams() {
        }

        public void readFromParcel(Parcel in) {
            this.readerSpecific.readFromParcel(in);
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.readerSpecific.writeToParcel(dest, flags);
        }

        public int[] getOrdinalsFromAutoCharacterSetPreference(AutoCharacterSetPreference[] autoCharaSetPreference) {
            int[] ordinalArray = null;
            if (autoCharaSetPreference != null) {
                ordinalArray = new int[autoCharaSetPreference.length];
                for (int i = 0; i < ordinalArray.length; ++i) {
                    ordinalArray[i] = autoCharaSetPreference[i].ordinal();
                }
            }
            return ordinalArray;
        }

        public AutoCharacterSetPreference[] getValuesFromAutoCharacterSetPreference(int[] ordinalArray) {
            AutoCharacterSetPreference[] enumValues = null;
            if (ordinalArray != null) {
                enumValues = new AutoCharacterSetPreference[ordinalArray.length];
                for (int i = 0; i < enumValues.length; ++i) {
                    enumValues[i] = AutoCharacterSetPreference.values()[ordinalArray[i]];
                }
            }
            return enumValues;
        }

        public class ReaderSpecific {
            public ImagerSpecific imagerSpecific = new ImagerSpecific();
            public CameraSpecific cameraSpecific = new CameraSpecific();
            public LaserSpecific laserSpecific = new LaserSpecific();

            ReaderSpecific() {
            }

            public void readFromParcel(Parcel in) {
                this.imagerSpecific.readFromParcel(in);
                this.cameraSpecific.readFromParcel(in);
                this.laserSpecific.readFromParcel(in);
            }

            public void writeToParcel(Parcel dest, int flags) {
                this.imagerSpecific.writeToParcel(dest, flags);
                this.cameraSpecific.writeToParcel(dest, flags);
                this.laserSpecific.writeToParcel(dest, flags);
            }

            public class LaserSpecific {
                private final String PARAM_POWER_MODE = "power_mode";
                private final String POWER_MODE_NAME = "readerParams.readerSpecific.laserSpecific.powerMode";
                public AimType continuousAimType = AimType.DUALTRIGGER;
                public int continuousSameSymbolTimeout;
                public int continuousDifferentSymbolTimeout;
                public int beamTimer;
                public LinearSecurityLevel linearSecurityLevel = LinearSecurityLevel.ALL_TWICE;
                public Inverse1DMode inverse1DMode = Inverse1DMode.DISABLED;
                public PowerMode powerMode = PowerMode.OPTIMIZED;
                public OneDQuietZoneLevel oneDQuietZoneLevel = OneDQuietZoneLevel.LEVEL_1;
                public PoorQualityDecodeEffortLevel poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.LEVEL_0;
                public AdaptiveScanning adaptiveScanning = AdaptiveScanning.ENABLE;
                public BeamWidth beamWidth = BeamWidth.NORMAL;
                public AimType aimType = AimType.DUALTRIGGER;
                public int aimTimer = 0;
                public int sameSymbolTimeout = 500;
                public int differentSymbolTimeout = 500;
                public CharacterSetSelection characterSetSelection = CharacterSetSelection.UTF_8;
                public AutoCharacterSetPreference[] autoCharacterSetPreferredOrder = new AutoCharacterSetPreference[]{AutoCharacterSetPreference.UTF_8, AutoCharacterSetPreference.GB2312};
                public AutoCharacterSetFailureOption autoCharacterSetFailureOption = AutoCharacterSetFailureOption.UTF_8;
                public boolean disconnectOnExit = false;
                public int connectionIdleTime = 600;
                public PairAfterScannerReboot pairAfterScannerReboot = PairAfterScannerReboot.ENABLE;

                LaserSpecific() {
                }

                public void readFromParcel(Parcel in) {
                    this.beamTimer = in.readInt();
                    this.linearSecurityLevel = LinearSecurityLevel.values()[in.readInt()];
                    this.inverse1DMode = Inverse1DMode.values()[in.readInt()];
                    this.powerMode = PowerMode.values()[in.readInt()];
                    this.continuousAimType = AimType.values()[in.readInt()];
                    this.continuousSameSymbolTimeout = in.readInt();
                    this.continuousDifferentSymbolTimeout = in.readInt();
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.values()[in.readInt()];
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.values()[in.readInt()];
                    this.adaptiveScanning = AdaptiveScanning.values()[in.readInt()];
                    this.beamWidth = BeamWidth.values()[in.readInt()];
                    this.aimType = AimType.values()[in.readInt()];
                    this.aimTimer = in.readInt();
                    this.sameSymbolTimeout = in.readInt();
                    this.differentSymbolTimeout = in.readInt();
                    this.characterSetSelection = CharacterSetSelection.values()[in.readInt()];
                    this.autoCharacterSetPreferredOrder = ReaderParams.this.getValuesFromAutoCharacterSetPreference(in.createIntArray());
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.values()[in.readInt()];
                    this.disconnectOnExit = 1 == in.readInt();
                    this.connectionIdleTime = in.readInt();
                    this.pairAfterScannerReboot = PairAfterScannerReboot.values()[in.readInt()];
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeInt(this.beamTimer);
                    dest.writeInt(this.linearSecurityLevel.ordinal());
                    dest.writeInt(this.inverse1DMode.ordinal());
                    dest.writeInt(this.powerMode.ordinal());
                    dest.writeInt(this.continuousAimType.ordinal());
                    dest.writeInt(this.continuousSameSymbolTimeout);
                    dest.writeInt(this.continuousDifferentSymbolTimeout);
                    dest.writeInt(this.oneDQuietZoneLevel.ordinal());
                    dest.writeInt(this.poorQualityDecodeEffortLevel.ordinal());
                    dest.writeInt(this.adaptiveScanning.ordinal());
                    dest.writeInt(this.beamWidth.ordinal());
                    dest.writeInt(this.aimType.ordinal());
                    dest.writeInt(this.aimTimer);
                    dest.writeInt(this.sameSymbolTimeout);
                    dest.writeInt(this.differentSymbolTimeout);
                    dest.writeInt(this.characterSetSelection.ordinal());
                    dest.writeIntArray(ReaderParams.this.getOrdinalsFromAutoCharacterSetPreference(this.autoCharacterSetPreferredOrder));
                    dest.writeInt(this.autoCharacterSetFailureOption.ordinal());
                    dest.writeInt(this.disconnectOnExit ? 1 : 0);
                    dest.writeInt(this.connectionIdleTime);
                    dest.writeInt(this.pairAfterScannerReboot.ordinal());
                }
            }

            public class CameraSpecific {
                public AimType continuousAimType = AimType.DUALTRIGGER;
                public int continuousSameSymbolTimeout;
                public int continuousDifferentSymbolTimeout;
                public int beamTimer;
                public int viewfinderSize;
                public int viewfinderOffsetX;
                public int viewfinderOffsetY;
                public PicklistEx picklistEx = PicklistEx.DISABLED;
                public LinearSecurityLevel linearSecurityLevel = LinearSecurityLevel.ALL_TWICE;
                public IlluminationMode illuminationMode = IlluminationMode.OFF;
                public Inverse1DMode inverse1DMode = Inverse1DMode.DISABLED;
                public ViewFinderMode viewfinderMode = ViewFinderMode.STATIC_RECTICLE;
                public OneDQuietZoneLevel oneDQuietZoneLevel = OneDQuietZoneLevel.LEVEL_1;
                public PoorQualityDecodeEffortLevel poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.LEVEL_0;
                public AimType aimType = AimType.DUALTRIGGER;
                public int aimTimer = 0;
                public int sameSymbolTimeout = 500;
                public int differentSymbolTimeout = 500;
                public CharacterSetSelection characterSetSelection = CharacterSetSelection.UTF_8;
                public AutoCharacterSetPreference[] autoCharacterSetPreferredOrder = new AutoCharacterSetPreference[]{AutoCharacterSetPreference.UTF_8, AutoCharacterSetPreference.GB2312};
                public AutoCharacterSetFailureOption autoCharacterSetFailureOption = AutoCharacterSetFailureOption.UTF_8;
                @Deprecated
                public ScanMode scanMode = ScanMode.SINGLE_BARCODE;
                public int zoom = 1;
                public boolean digimarcDecoding = true;

                CameraSpecific() {
                }

                public void readFromParcel(Parcel in) {
                    this.beamTimer = in.readInt();
                    this.linearSecurityLevel = LinearSecurityLevel.values()[in.readInt()];
                    this.illuminationMode = IlluminationMode.values()[in.readInt()];
                    this.inverse1DMode = Inverse1DMode.values()[in.readInt()];
                    this.viewfinderMode = ViewFinderMode.values()[in.readInt()];
                    this.continuousAimType = AimType.values()[in.readInt()];
                    this.continuousSameSymbolTimeout = in.readInt();
                    this.continuousDifferentSymbolTimeout = in.readInt();
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.values()[in.readInt()];
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.values()[in.readInt()];
                    this.viewfinderSize = in.readInt();
                    this.viewfinderOffsetX = in.readInt();
                    this.viewfinderOffsetY = in.readInt();
                    this.picklistEx = PicklistEx.values()[in.readInt()];
                    this.aimType = AimType.values()[in.readInt()];
                    this.aimTimer = in.readInt();
                    this.sameSymbolTimeout = in.readInt();
                    this.differentSymbolTimeout = in.readInt();
                    this.characterSetSelection = CharacterSetSelection.values()[in.readInt()];
                    this.autoCharacterSetPreferredOrder = ReaderParams.this.getValuesFromAutoCharacterSetPreference(in.createIntArray());
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.values()[in.readInt()];
                    this.scanMode = ScanMode.values()[in.readInt()];
                    this.zoom = in.readInt();
                    this.digimarcDecoding = in.readInt() == 1;
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeInt(this.beamTimer);
                    dest.writeInt(this.linearSecurityLevel.ordinal());
                    dest.writeInt(this.illuminationMode.ordinal());
                    dest.writeInt(this.inverse1DMode.ordinal());
                    dest.writeInt(this.viewfinderMode.ordinal());
                    dest.writeInt(this.continuousAimType.ordinal());
                    dest.writeInt(this.continuousSameSymbolTimeout);
                    dest.writeInt(this.continuousDifferentSymbolTimeout);
                    dest.writeInt(this.oneDQuietZoneLevel.ordinal());
                    dest.writeInt(this.poorQualityDecodeEffortLevel.ordinal());
                    dest.writeInt(this.viewfinderSize);
                    dest.writeInt(this.viewfinderOffsetX);
                    dest.writeInt(this.viewfinderOffsetY);
                    dest.writeInt(this.picklistEx.ordinal());
                    dest.writeInt(this.aimType.ordinal());
                    dest.writeInt(this.aimTimer);
                    dest.writeInt(this.sameSymbolTimeout);
                    dest.writeInt(this.differentSymbolTimeout);
                    dest.writeInt(this.characterSetSelection.ordinal());
                    dest.writeIntArray(ReaderParams.this.getOrdinalsFromAutoCharacterSetPreference(this.autoCharacterSetPreferredOrder));
                    dest.writeInt(this.autoCharacterSetFailureOption.ordinal());
                    dest.writeInt(this.scanMode.ordinal());
                    dest.writeInt(this.zoom);
                    dest.writeInt(this.digimarcDecoding ? 1 : 0);
                }
            }

            public class ImagerSpecific {
                public PresentationModeParams presentationModeParams = new PresentationModeParams();
                public AimType continuousAimType = AimType.DUALTRIGGER;
                public int continuosSameSymbolTimeout;
                public int continuousDifferentSymbolTimeout;
                public int beamTimer;
                public LinearSecurityLevel linearSecurityLevel = LinearSecurityLevel.ALL_TWICE;
                public PickList pickList = PickList.DISABLED;
                public PicklistEx picklistEx = PicklistEx.DISABLED;
                public LcdMode lcdMode = LcdMode.DISABLED;
                public Inverse1DMode inverse1DMode = Inverse1DMode.AUTO;
                public int illuminationBrightness = 1;
                public boolean disconnectOnExit = false;
                public int connectionIdleTime = 600;
                public IlluminationMode illuminationMode = IlluminationMode.ON;
                public AimingPattern aimingPattern = AimingPattern.OFF;
                public OneDQuietZoneLevel oneDQuietZoneLevel = OneDQuietZoneLevel.LEVEL_1;
                public PoorQualityDecodeEffortLevel poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.LEVEL_0;
                public AimType aimType = AimType.DUALTRIGGER;
                public int aimTimer = 0;
                public int sameSymbolTimeout = 500;
                public int differentSymbolTimeout = 500;
                public PairAfterScannerReboot pairAfterScannerReboot = PairAfterScannerReboot.ENABLE;
                @Deprecated
                public ScanMode scanMode = ScanMode.SINGLE_BARCODE;
                public boolean digimarcDecoding = true;
                public CharacterSetSelection characterSetSelection = CharacterSetSelection.UTF_8;
                public AutoCharacterSetPreference[] autoCharacterSetPreferredOrder = new AutoCharacterSetPreference[]{AutoCharacterSetPreference.UTF_8, AutoCharacterSetPreference.GB2312};
                public AutoCharacterSetFailureOption autoCharacterSetFailureOption = AutoCharacterSetFailureOption.UTF_8;
                public SceneDetectionQualifier sceneDetectionQualifier = SceneDetectionQualifier.NONE;
                public DpmModes dpmMode = DpmModes.MODE_2;
                public DpmIlluminationControl dpmIlluminationControl = DpmIlluminationControl.CYCLE;

                ImagerSpecific() {
                }

                public void readFromParcel(Parcel in) {
                    this.beamTimer = in.readInt();
                    this.linearSecurityLevel = LinearSecurityLevel.values()[in.readInt()];
                    this.pickList = PickList.values()[in.readInt()];
                    this.lcdMode = LcdMode.values()[in.readInt()];
                    this.inverse1DMode = Inverse1DMode.values()[in.readInt()];
                    this.illuminationBrightness = in.readInt();
                    this.disconnectOnExit = 1 == in.readInt();
                    this.connectionIdleTime = in.readInt();
                    this.continuousAimType = AimType.values()[in.readInt()];
                    this.continuosSameSymbolTimeout = in.readInt();
                    this.continuousDifferentSymbolTimeout = in.readInt();
                    this.illuminationMode = IlluminationMode.values()[in.readInt()];
                    this.aimingPattern = AimingPattern.values()[in.readInt()];
                    this.oneDQuietZoneLevel = OneDQuietZoneLevel.values()[in.readInt()];
                    this.poorQualityDecodeEffortLevel = PoorQualityDecodeEffortLevel.values()[in.readInt()];
                    this.picklistEx = PicklistEx.values()[in.readInt()];
                    this.aimType = AimType.values()[in.readInt()];
                    this.aimTimer = in.readInt();
                    this.sameSymbolTimeout = in.readInt();
                    this.differentSymbolTimeout = in.readInt();
                    this.pairAfterScannerReboot = PairAfterScannerReboot.values()[in.readInt()];
                    this.scanMode = ScanMode.values()[in.readInt()];
                    this.digimarcDecoding = 1 == in.readInt();
                    this.characterSetSelection = CharacterSetSelection.values()[in.readInt()];
                    this.autoCharacterSetPreferredOrder = ReaderParams.this.getValuesFromAutoCharacterSetPreference(in.createIntArray());
                    this.autoCharacterSetFailureOption = AutoCharacterSetFailureOption.values()[in.readInt()];
                    this.sceneDetectionQualifier = SceneDetectionQualifier.values()[in.readInt()];
                    this.dpmMode = DpmModes.values()[in.readInt()];
                    this.dpmIlluminationControl = DpmIlluminationControl.values()[in.readInt()];
                    this.presentationModeParams.sensitivity = PresentationModeSensitivity.values()[in.readInt()];
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeInt(this.beamTimer);
                    dest.writeInt(this.linearSecurityLevel.ordinal());
                    dest.writeInt(this.pickList.ordinal());
                    dest.writeInt(this.lcdMode.ordinal());
                    dest.writeInt(this.inverse1DMode.ordinal());
                    dest.writeInt(this.illuminationBrightness);
                    dest.writeInt(this.disconnectOnExit ? 1 : 0);
                    dest.writeInt(this.connectionIdleTime);
                    dest.writeInt(this.continuousAimType.ordinal());
                    dest.writeInt(this.continuosSameSymbolTimeout);
                    dest.writeInt(this.continuousDifferentSymbolTimeout);
                    dest.writeInt(this.illuminationMode.ordinal());
                    dest.writeInt(this.aimingPattern.ordinal());
                    dest.writeInt(this.oneDQuietZoneLevel.ordinal());
                    dest.writeInt(this.poorQualityDecodeEffortLevel.ordinal());
                    dest.writeInt(this.picklistEx.ordinal());
                    dest.writeInt(this.aimType.ordinal());
                    dest.writeInt(this.aimTimer);
                    dest.writeInt(this.sameSymbolTimeout);
                    dest.writeInt(this.differentSymbolTimeout);
                    dest.writeInt(this.pairAfterScannerReboot.ordinal());
                    dest.writeInt(this.scanMode.ordinal());
                    dest.writeInt(this.digimarcDecoding ? 1 : 0);
                    dest.writeInt(this.characterSetSelection.ordinal());
                    dest.writeIntArray(ReaderParams.this.getOrdinalsFromAutoCharacterSetPreference(this.autoCharacterSetPreferredOrder));
                    dest.writeInt(this.autoCharacterSetFailureOption.ordinal());
                    dest.writeInt(this.sceneDetectionQualifier.ordinal());
                    dest.writeInt(this.dpmMode.ordinal());
                    dest.writeInt(this.dpmIlluminationControl.ordinal());
                    dest.writeInt(this.presentationModeParams.sensitivity.ordinal());
                }

                public class PresentationModeParams {
                    public PresentationModeSensitivity sensitivity = PresentationModeSensitivity.HIGH;
                }
            }
        }
    }

    public class ScanParams {
        public CodeIdType codeIdType = CodeIdType.NONE;
        public String decodeAudioFeedbackUri = "";
        public boolean decodeHapticFeedback = false;
        public int decodeLEDTime = 75;
        public AudioStreamType audioStreamType = AudioStreamType.RINGER;
        public boolean decodeLEDFeedback = false;
        public DecodeLEDFeedbackMode decodeLEDFeedbackMode = DecodeLEDFeedbackMode.BOTH;
        public DecodeAudioFeedbackMode decodeAudioFeedbackMode = DecodeAudioFeedbackMode.BOTH;
        public boolean decodeScreenNotification = false;
        public int decodeScreenNotificationTime = 1000;
        public int decodeScreenTranslucencyLevel = 3;

        ScanParams() {
        }

        public void readFromParcel(Parcel in) {
            this.codeIdType = CodeIdType.values()[in.readInt()];
            this.decodeAudioFeedbackUri = in.readString();
            this.decodeHapticFeedback = in.readInt() == 1;
            this.decodeLEDTime = in.readInt();
            this.audioStreamType = AudioStreamType.values()[in.readInt()];
            this.decodeLEDFeedback = in.readInt() == 1;
            this.decodeLEDFeedbackMode = DecodeLEDFeedbackMode.values()[in.readInt()];
            this.decodeAudioFeedbackMode = DecodeAudioFeedbackMode.values()[in.readInt()];
            this.decodeScreenNotification = in.readInt() == 1;
            this.decodeScreenNotificationTime = in.readInt();
            this.decodeScreenTranslucencyLevel = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.codeIdType.ordinal());
            dest.writeString(this.decodeAudioFeedbackUri);
            dest.writeInt(this.decodeHapticFeedback ? 1 : 0);
            dest.writeInt(this.decodeLEDTime);
            dest.writeInt(this.audioStreamType.ordinal());
            dest.writeInt(this.decodeLEDFeedback ? 1 : 0);
            dest.writeInt(this.decodeLEDFeedbackMode.ordinal());
            dest.writeInt(this.decodeAudioFeedbackMode.ordinal());
            dest.writeInt(this.decodeScreenNotification ? 1 : 0);
            dest.writeInt(this.decodeScreenNotificationTime);
            dest.writeInt(this.decodeScreenTranslucencyLevel);
        }
    }

    public class InterfaceParams {
        public boolean displayBluetoothAddressBarcode = true;
        public int connectionEstablishTime = 45;

        InterfaceParams() {
        }

        public void readFromParcel(Parcel in) {
            this.displayBluetoothAddressBarcode = 1 == in.readInt();
            this.connectionEstablishTime = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.displayBluetoothAddressBarcode ? 1 : 0);
            dest.writeInt(this.connectionEstablishTime);
        }
    }
}

