/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.cradle;

public enum SvcCradleResults {
    SUCCESS(0),
    FAILURE(1),
    ALREADY_ENABLED(2),
    ALREADY_UNLOCKED(3),
    ALREADY_DISABLED(4),
    ALREADY_IN_USE(5),
    FEATURE_NOT_SUPPORTED(6),
    INVALID_VALUE(7),
    NOT_ENABLED(8),
    INVALID_OBJECT(9),
    UNDEFINED(255);

    private int id;
    private String discription;

    private SvcCradleResults(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription == "") {
            return SvcCradleResults.getErrorDescription(this);
        }
        return this.discription;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(SvcCradleResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success";
                break;
            }
            case FAILURE: {
                errDescription = "Failure";
                break;
            }
            case ALREADY_DISABLED: {
                errDescription = "Already disabled.";
                break;
            }
            case ALREADY_ENABLED: {
                errDescription = "Already enabled.";
                break;
            }
            case ALREADY_IN_USE: {
                errDescription = "Already in use.";
                break;
            }
            case INVALID_VALUE: {
                errDescription = "The value is invalid.";
                break;
            }
            case ALREADY_UNLOCKED: {
                errDescription = "Cradle already in unlocked state";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                errDescription = "Feature not supported";
                break;
            }
            case NOT_ENABLED: {
                errDescription = "Not Enabled";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "Object not valid";
                break;
            }
            default: {
                errDescription = "Error code not defined.";
            }
        }
        return errDescription;
    }
}

