/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.passthruapduprocessor;

import android.annotation.SuppressLint;
import java.util.HashMap;
import java.util.Map;

public enum SvcPassThruApduResults {
    SUCCESS(0),
    FAILURE(1),
    INIT_FAILURE(2),
    INVALID_OBJECT(3),
    ALREADY_ENABLED(13),
    INVALID_VALUE(252),
    NFC_DISABLED(255),
    FRAMING_ERROR(233),
    BAD_NAD(36),
    CARD_DEACTIVATED(64),
    CARD_MUTED(34),
    PROCESSING_CHAIN_ABORTED(39),
    CMD_FRAME_LOST(241),
    NOT_ENABLED(170),
    SAM_NOT_AVAILABLE(192),
    LENGTH_TOO_SHORT(8),
    NEGATIVE_LENGTH(-1),
    CARD_MEMORY_OVERFLOW(41),
    TX_PARITY_ERROR(132),
    RX_PARITY_ERROR(131),
    RESYNC(38),
    SERIAL_LRC_ERR(240),
    TIME_OUT(129),
    TOO_SHORT_APDU(33),
    UART_BUFFER_OVERFLOW(226),
    VOLTAGE_DROP(227),
    INVALID_APDU(32),
    PROC_BYTE_ERR(160),
    TEMP_ALARAM(228),
    EMDK_NOT_OPENED(65534),
    UNDEFINED(65535);

    private int id;
    private String discription = "";
    @SuppressLint(value={"UseSparseArrays"})
    private static Map<Integer, SvcPassThruApduResults> map;

    private SvcPassThruApduResults(int id) {
        this.id = id;
    }

    public static SvcPassThruApduResults getResult(int id) {
        SvcPassThruApduResults results = map.get(id);
        if (results == null) {
            results = UNDEFINED;
            results.setValue(id, " ");
        }
        return results;
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.length() == 0) {
            return SvcPassThruApduResults.getErrorDescription(this);
        }
        return this.discription;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(SvcPassThruApduResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success";
                break;
            }
            case FAILURE: {
                errDescription = "Failure";
                break;
            }
            case EMDK_NOT_OPENED: {
                errDescription = "The EMDK is not opened.";
                break;
            }
            case INVALID_VALUE: {
                errDescription = "Invalid Input Parameter";
                break;
            }
            case ALREADY_ENABLED: {
                errDescription = "Desfire tag connection already exist";
                break;
            }
            case BAD_NAD: {
                errDescription = "Bad NAD error";
                break;
            }
            case CARD_DEACTIVATED: {
                errDescription = "The smart card is deactivated.";
                break;
            }
            case CARD_MEMORY_OVERFLOW: {
                errDescription = "The memory overflow from the smart card.";
                break;
            }
            case CARD_MUTED: {
                errDescription = "The smart card is muted during the T=1  exachange.";
                break;
            }
            case CMD_FRAME_LOST: {
                errDescription = "Atleast one command frame is lost while processing the APDU.";
                break;
            }
            case FRAMING_ERROR: {
                errDescription = "Error in the frame.";
                break;
            }
            case INIT_FAILURE: {
                errDescription = "The SAM is not initalized properly.";
                break;
            }
            case INVALID_APDU: {
                errDescription = "The APDU command is invalid or wrong";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "Invalid Object";
                break;
            }
            case LENGTH_TOO_SHORT: {
                errDescription = "The length is too short occurs when actual length of data received from SAM is less than expected length.";
                break;
            }
            case NEGATIVE_LENGTH: {
                errDescription = "The negative length error occurs when actual length is less than zero.";
                break;
            }
            case NFC_DISABLED: {
                errDescription = "NFC is disabled on the device. Try enabling the NFC before using the secure NFC API.";
                break;
            }
            case NOT_ENABLED: {
                errDescription = "The connection to SAM is not established.";
                break;
            }
            case PROCESSING_CHAIN_ABORTED: {
                errDescription = "The smart card processing chain aborted during transmission and reception.";
                break;
            }
            case PROC_BYTE_ERR: {
                errDescription = "The Hardware procedure byte error.";
                break;
            }
            case RESYNC: {
                errDescription = "Resyncing is required.";
                break;
            }
            case RX_PARITY_ERROR: {
                errDescription = "The hardware parity error during the reception of the data.";
                break;
            }
            case SAM_NOT_AVAILABLE: {
                errDescription = "SAM not present in the device. Try inserting SAM before using the Secure NFC API.";
                break;
            }
            case SERIAL_LRC_ERR: {
                errDescription = "Serial LRC error.";
                break;
            }
            case TEMP_ALARAM: {
                errDescription = "The temperature is out of range.";
                break;
            }
            case TIME_OUT: {
                errDescription = "The hardware timed out after the waiting time.";
                break;
            }
            case TOO_SHORT_APDU: {
                errDescription = "The hardware error due to APDU length is  short.";
                break;
            }
            case TX_PARITY_ERROR: {
                errDescription = "The hardware parity error during the transmission of data.";
                break;
            }
            case UART_BUFFER_OVERFLOW: {
                errDescription = "UART buffer overflow.";
                break;
            }
            case VOLTAGE_DROP: {
                errDescription = "Voltage supply dropped.";
                break;
            }
            case UNDEFINED: {
                errDescription = "Error code not defined";
                break;
            }
        }
        return errDescription;
    }

    static {
        map = new HashMap<Integer, SvcPassThruApduResults>();
        for (SvcPassThruApduResults smartcardResult : SvcPassThruApduResults.values()) {
            map.put(smartcardResult.id, smartcardResult);
        }
    }
}

