/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.simulscan;

import android.graphics.YuvImage;
import android.os.Parcel;
import android.os.Parcelable;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanElement;

public class SvcSimulScanRegion
extends SvcSimulScanElement {
    YuvImage image = null;
    RegionType regionType = RegionType.DEFAULT;
    int absConfidence = 0;
    int relConfidence = 0;
    public static final Parcelable.Creator<SvcSimulScanRegion> CREATOR = new Parcelable.Creator<SvcSimulScanRegion>(){

        public SvcSimulScanRegion createFromParcel(Parcel source) {
            return new SvcSimulScanRegion(source);
        }

        public SvcSimulScanRegion[] newArray(int size) {
            return new SvcSimulScanRegion[size];
        }
    };

    public SvcSimulScanRegion(String name, YuvImage image, Object data, int number, RegionType processingMode, int absConfidence, int relConfidence) {
        super(name, data, number);
        this.image = image;
        this.regionType = processingMode;
        this.absConfidence = absConfidence;
        this.relConfidence = relConfidence;
    }

    public RegionType getRegionType() {
        return this.regionType;
    }

    private YuvImage readYUVFromParcel(Parcel source) {
        int height = source.readInt();
        int width = source.readInt();
        int format = source.readInt();
        int strideLength = source.readInt();
        int[] strides = new int[strideLength];
        source.readIntArray(strides);
        int dataLength = source.readInt();
        byte[] data = new byte[dataLength];
        source.readByteArray(data);
        return new YuvImage(data, format, width, height, strides);
    }

    public SvcSimulScanRegion(Parcel source) {
        this.number = source.readInt();
        this.name = source.readString();
        this.regionType = RegionType.values()[source.readInt()];
        switch (this.regionType) {
            case OCR: {
                int ocrLength = source.readInt();
                this.data = new String[ocrLength];
                source.readStringArray((String[])this.data);
                this.image = this.readYUVFromParcel(source);
                break;
            }
            case OMR: {
                this.data = source.readInt();
                this.image = this.readYUVFromParcel(source);
                break;
            }
            case BARCODE: {
                this.data = source.readString();
                break;
            }
            case PICTURE: {
                int picLength = source.readInt();
                this.data = new byte[picLength];
                source.readByteArray((byte[])this.data);
                this.image = this.readYUVFromParcel(source);
                break;
            }
        }
        this.absConfidence = source.readInt();
        this.relConfidence = source.readInt();
    }

    public YuvImage getImage() {
        return this.image;
    }

    public int getAbsoluteConfidence() {
        return this.absConfidence;
    }

    public int getRelativeConfidence() {
        return this.relConfidence;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public int describeContents() {
        return 0;
    }

    private void writeYUVToParcel(Parcel dest, YuvImage image) {
        dest.writeInt(image.getHeight());
        dest.writeInt(image.getWidth());
        dest.writeInt(image.getYuvFormat());
        int[] strides = image.getStrides();
        dest.writeInt(strides.length);
        dest.writeIntArray(strides);
        byte[] data = image.getYuvData();
        dest.writeInt(data.length);
        dest.writeByteArray(data);
    }

    public void writeToParcel(Parcel dest, int arg1) {
        dest.writeInt(this.number);
        dest.writeString(this.name);
        dest.writeInt(this.regionType.ordinal());
        switch (this.regionType) {
            case OCR: {
                String[] ocrLines = (String[])this.data;
                dest.writeInt(ocrLines.length);
                dest.writeStringArray(ocrLines);
                this.writeYUVToParcel(dest, this.image);
                break;
            }
            case OMR: {
                dest.writeInt(((Integer)this.data).intValue());
                this.writeYUVToParcel(dest, this.image);
                break;
            }
            case BARCODE: {
                dest.writeString((String)this.data);
                break;
            }
            case PICTURE: {
                byte[] ocrPic = (byte[])this.data;
                dest.writeInt(ocrPic.length);
                dest.writeByteArray(ocrPic);
                this.writeYUVToParcel(dest, this.image);
                break;
            }
        }
        dest.writeInt(this.absConfidence);
        dest.writeInt(this.relConfidence);
    }

    public static enum RegionType {
        DEFAULT,
        OCR,
        OMR,
        BARCODE,
        PICTURE;


        public static RegionType getRegionTypeEnum(String processingMode) {
            if (processingMode.compareToIgnoreCase("barcode") == 0) {
                return BARCODE;
            }
            if (processingMode.compareToIgnoreCase("omr") == 0) {
                return OMR;
            }
            if (processingMode.compareToIgnoreCase("ocr") == 0) {
                return OCR;
            }
            if (processingMode.compareToIgnoreCase("picture") == 0) {
                return PICTURE;
            }
            return DEFAULT;
        }
    }
}

