/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.notification;

import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.emdkservice.notification.IAdminConnectionCallback;
import com.symbol.emdk.emdkservice.notification.SvcAdminConnectionStatus;
import com.symbol.emdk.notification.DeviceInfo;
import com.symbol.emdk.notification.NotificationManager;

class NotificationConnectionCallbackInternal
extends IAdminConnectionCallback.Stub {
    private static String TAG = "Notification_Connection_Callback";
    NotificationManager notificationManager = null;

    public NotificationConnectionCallbackInternal(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public void onConnectionChange(SvcAdminConnectionStatus connectionStatus) throws RemoteException {
        new ConnectionCallbackThread(this.notificationManager, connectionStatus).start();
    }

    class ConnectionCallbackThread
    extends Thread {
        SvcAdminConnectionStatus threadedConnectionStatus;
        NotificationManager threadedBarcodeManager = null;

        ConnectionCallbackThread(NotificationManager notificationManager, SvcAdminConnectionStatus connectionStatus) {
            if (notificationManager == null || connectionStatus == null) {
                return;
            }
            this.threadedConnectionStatus = connectionStatus;
            this.threadedBarcodeManager = notificationManager;
        }

        @Override
        public void run() {
            try {
                NotificationManager.ConnectionState connectionState = NotificationManager.ConnectionState.values()[this.threadedConnectionStatus.getConnectionState().ordinal()];
                DeviceInfo scannerInfo = new DeviceInfo(this.threadedConnectionStatus.getSvcNotificationDeviceInfo());
                if (this.threadedBarcodeManager.notificationDeviceConnectionListeners != null) {
                    for (NotificationManager.NotificationDeviceConnectionListener callback : this.threadedBarcodeManager.notificationDeviceConnectionListeners) {
                        if (callback == null) continue;
                        callback.onConnectionChange(scannerInfo, connectionState);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }
}

