/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.personalshopper;

import android.content.Context;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.cradle.SvcCradleInfo;
import com.symbol.emdk.emdkservice.cradle.SvcCradleLedFlashInfo;
import com.symbol.emdk.emdkservice.cradle.SvcCradleResults;
import com.symbol.emdk.personalshopper.CradleConfig;
import com.symbol.emdk.personalshopper.CradleException;
import com.symbol.emdk.personalshopper.CradleInfo;
import com.symbol.emdk.personalshopper.CradleLedFlashInfo;
import com.symbol.emdk.personalshopper.CradleResults;

public class Cradle {
    private static final String TAG = "Cradle";
    private Context context = null;
    private EMDKServiceConnection emdkServiceConnection = null;
    private boolean isReleased = false;
    public CradleConfig config;

    Cradle(Context context, EMDKServiceConnection emdkServiceConnection) {
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
        this.isReleased = false;
        this.config = new CradleConfig(this.emdkServiceConnection);
    }

    public void enable() throws CradleException {
        int retValue = SvcCradleResults.FAILURE.getValue();
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Cradle object already released");
            throw new CradleException(CradleResults.INVALID_OBJECT);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().crdEnable();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new CradleException(CradleResults.FAILURE);
            }
            if (SvcCradleResults.SUCCESS.getValue() != retValue) {
                Log.e((String)TAG, (String)"Failure in Enable");
                if (retValue == SvcCradleResults.ALREADY_ENABLED.getValue()) {
                    throw new CradleException(CradleResults.ALREADY_ENABLED);
                }
                throw new CradleException(CradleResults.FAILURE);
            }
        } else {
            Log.e((String)TAG, (String)"Failure in service connection");
            throw new CradleException(CradleResults.FAILURE);
        }
    }

    public void disable() throws CradleException {
        int retValue = SvcCradleResults.FAILURE.getValue();
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Cradle object already released");
            throw new CradleException(CradleResults.INVALID_OBJECT);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().crdDisable();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (SvcCradleResults.SUCCESS.getValue() != retValue) {
            Log.e((String)TAG, (String)"Failure in Disable");
            if (retValue == SvcCradleResults.ALREADY_DISABLED.getValue()) {
                throw new CradleException(CradleResults.ALREADY_DISABLED);
            }
            if (retValue == SvcCradleResults.NOT_ENABLED.getValue()) {
                throw new CradleException(CradleResults.NOT_ENABLED);
            }
            throw new CradleException(CradleResults.FAILURE);
        }
    }

    public boolean isEnabled() throws CradleException {
        boolean isEnabled = false;
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Cradle object already released");
            throw new CradleException(CradleResults.INVALID_OBJECT);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                isEnabled = this.emdkServiceConnection.getService().crdIsEnabled();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return isEnabled;
    }

    public CradleInfo getCradleInfo() throws CradleException {
        SvcCradleInfo svcCradleInfo = null;
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Cradle object already released");
            throw new CradleException(CradleResults.INVALID_OBJECT);
        }
        CradleInfo cradleInfo = null;
        try {
            svcCradleInfo = this.emdkServiceConnection.getService().crdGetCradleInfo();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Caught exception : " + e.getMessage()));
            throw new CradleException(CradleResults.FAILURE);
        }
        if (svcCradleInfo == null) {
            throw new CradleException(CradleResults.NOT_ENABLED);
        }
        cradleInfo = new CradleInfo(svcCradleInfo);
        return cradleInfo;
    }

    public CradleResults unlock(int unlockDuration, CradleLedFlashInfo ledFlashInfo) throws CradleException {
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Cradle object already released");
            throw new CradleException(CradleResults.INVALID_OBJECT);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            int retValue;
            if (ledFlashInfo == null) {
                Log.e((String)TAG, (String)"unlock CradleLedFlashInfo is null");
                throw new CradleException(CradleResults.INVALID_OBJECT);
            }
            if (ledFlashInfo.onDuration < 0 || ledFlashInfo.offDuration < 0 || unlockDuration < 0) {
                Log.e((String)TAG, (String)"unlock CradleLedFlashInfo has negative on/off time or unlock duration");
                throw new CradleException(CradleResults.INVALID_VALUE);
            }
            SvcCradleLedFlashInfo cradleLedFlashInfo = new SvcCradleLedFlashInfo();
            cradleLedFlashInfo.isSmoothEffectEnabled = ledFlashInfo.smoothEffect;
            cradleLedFlashInfo.onDuration = ledFlashInfo.onDuration;
            cradleLedFlashInfo.offDuration = ledFlashInfo.offDuration;
            try {
                retValue = this.emdkServiceConnection.getService().crdUnlock(unlockDuration, cradleLedFlashInfo);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new CradleException(CradleResults.FAILURE);
            }
            if (SvcCradleResults.SUCCESS.getValue() != retValue) {
                Log.e((String)TAG, (String)"Failure in unlock");
                if (retValue == SvcCradleResults.NOT_ENABLED.getValue()) {
                    throw new CradleException(CradleResults.NOT_ENABLED);
                }
                if (retValue == SvcCradleResults.INVALID_VALUE.getValue()) {
                    throw new CradleException(CradleResults.INVALID_VALUE);
                }
                if (retValue == SvcCradleResults.ALREADY_UNLOCKED.getValue()) {
                    throw new CradleException(CradleResults.ALREADY_UNLOCKED);
                }
                throw new CradleException(CradleResults.FAILURE);
            }
        }
        return CradleResults.SUCCESS;
    }

    public CradleResults flashLed(int ledFlashCount, CradleLedFlashInfo ledFlashInfo) throws CradleException {
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Cradle object already released");
            throw new CradleException(CradleResults.INVALID_OBJECT);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            int retValue;
            if (ledFlashInfo == null) {
                Log.e((String)TAG, (String)"flashLed CradleLedFlashInfo is null");
                throw new CradleException(CradleResults.INVALID_OBJECT);
            }
            if (ledFlashInfo.onDuration < 0 || ledFlashInfo.offDuration < 0 || ledFlashCount < 0) {
                Log.e((String)TAG, (String)"flashLed CradleLedFlashInfo has negative on/off time or ledFlashcount");
                throw new CradleException(CradleResults.INVALID_VALUE);
            }
            SvcCradleLedFlashInfo cradleLedFlashInfo = new SvcCradleLedFlashInfo();
            cradleLedFlashInfo.isSmoothEffectEnabled = ledFlashInfo.smoothEffect;
            cradleLedFlashInfo.onDuration = ledFlashInfo.onDuration;
            cradleLedFlashInfo.offDuration = ledFlashInfo.offDuration;
            try {
                retValue = this.emdkServiceConnection.getService().crdFlashLeds(ledFlashCount, cradleLedFlashInfo);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new CradleException(CradleResults.FAILURE);
            }
            if (SvcCradleResults.SUCCESS.getValue() != retValue) {
                Log.e((String)TAG, (String)"Failure in cradle led flash");
                if (retValue == SvcCradleResults.NOT_ENABLED.getValue()) {
                    throw new CradleException(CradleResults.NOT_ENABLED);
                }
                throw new CradleException(CradleResults.FAILURE);
            }
        }
        return CradleResults.SUCCESS;
    }

    void release() throws CradleException {
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Cradle object already released");
            throw new CradleException(CradleResults.INVALID_OBJECT);
        }
        this.isReleased = true;
    }
}

