/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.sam;

public enum SAMResults {
    FAILURE(-1),
    SUCCESS(0),
    FAILED_TO_CONNECT(1),
    SAM_NOT_INITIALIZED(2),
    TRANSCEIVE_FAILURE(3),
    INVALID_APDU_COMMAND(4),
    SAM_NOT_CONNECTED(5),
    ANOTHER_SAM_ALREADY_IN_USE(6),
    ALREADY_IN_USE_BY_A_DIFFERENT_USER(7),
    SAM_ALREADY_CONNECTED(8),
    UNLICENSED_FEATURE(9),
    UNDEFINED(255);

    private int val;

    private SAMResults(int i) {
        this.val = i;
    }

    public int getVal() {
        return this.val;
    }

    public static String getErrorDescription(SAMResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case FAILURE: {
                errDescription = "Failure.";
                break;
            }
            case SUCCESS: {
                errDescription = "Success.";
                break;
            }
            case FAILED_TO_CONNECT: {
                errDescription = "Failed to connect to the SAM.";
                break;
            }
            case SAM_NOT_INITIALIZED: {
                errDescription = "SAM not initialized.";
                break;
            }
            case TRANSCEIVE_FAILURE: {
                errDescription = "Transceive Failure.";
                break;
            }
            case INVALID_APDU_COMMAND: {
                errDescription = "Invalid APDU Command.";
                break;
            }
            case SAM_NOT_CONNECTED: {
                errDescription = "SAM not connected.";
                break;
            }
            case ANOTHER_SAM_ALREADY_IN_USE: {
                errDescription = "Another SAM is already in use, please disconnect from previous SAM before connecting to the new SAM.";
                break;
            }
            case ALREADY_IN_USE_BY_A_DIFFERENT_USER: {
                errDescription = "SAM is already in use by a different application.";
                break;
            }
            case SAM_ALREADY_CONNECTED: {
                errDescription = "Already connected to the SAM.";
                break;
            }
            case UNLICENSED_FEATURE: {
                errDescription = "Unlicensed feature.";
                break;
            }
            case UNDEFINED: {
                errDescription = "Error code not defined.";
                break;
            }
            default: {
                errDescription = "Error code not defined.";
            }
        }
        return errDescription;
    }
}

