/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.scanandpair;

import android.content.Context;
import android.media.ToneGenerator;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.scanandpair.ScanAndPairConfig;
import com.symbol.emdk.scanandpair.ScanAndPairException;
import com.symbol.emdk.scanandpair.ScanAndPairResults;
import com.symbol.emdk.scanandpair.ScannerOperations;
import com.symbol.emdk.scanandpair.StatusData;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ScanAndPairManager
extends EMDKBase {
    public ScanAndPairConfig config = new ScanAndPairConfig();
    private static final String TAG = "Scan_And_Pair_Manager";
    private StatusData statusData = new StatusData();
    List<StatusListener> statusListenerCallbacks = null;
    Context context = null;
    Object asyncLock = new Object();
    private boolean isPreviousRequestPending = false;
    EMDKServiceConnection mServiceConnection = null;
    private ToneGenerator mToneGenerator = null;
    private ScannerOperations scannerOperations = null;
    private boolean isReleased = false;

    public boolean isPreviousCommandPending() {
        return this.isPreviousRequestPending;
    }

    ScanAndPairManager(EMDKManager emdkManager, Context context, EMDKServiceConnection emdkServiceConnection) {
        super(EMDKManager.FEATURE_TYPE.SCANANDPAIR);
        this.context = context;
        this.mServiceConnection = emdkServiceConnection;
        this.mToneGenerator = new ToneGenerator(4, 75);
        this.scannerOperations = new ScannerOperations(emdkManager, this);
    }

    public ScanAndPairResults scanAndPair(String pin) {
        if (this.isBluetoothEnabled()) {
            return this.scanAndPairHelper(true, pin);
        }
        return ScanAndPairResults.BLUETOOTH_NOT_ENABLED;
    }

    public ScanAndPairResults scanAndUnpair() {
        return this.scanAndPairHelper(false, null);
    }

    private ScanAndPairResults scanAndPairHelper(boolean isPair, String pairingPin) {
        try {
            if (this.isReleased) {
                throw new ScanAndPairException(ScanAndPairResults.INVALID_OBJECT);
            }
            if (this.config == null) {
                return ScanAndPairResults.INVALID_CONFIG;
            }
            if (this.isPreviousRequestPending) {
                return ScanAndPairResults.PREVIOUS_COMMAND_PENDING;
            }
            if (!this.config.alwaysScan.booleanValue() && this.config.bluetoothInfo.deviceName.isEmpty() && this.config.bluetoothInfo.macAddress.isEmpty()) {
                return ScanAndPairResults.INVALID_BLUETOOTH_DEVICE_INFO;
            }
            if (pairingPin != null) {
                this.config.bluetoothInfo.pairingPin = pairingPin;
            }
            Log.d((String)TAG, (String)"*******************************************************");
            Log.d((String)TAG, (String)"ScanAndPair configuration (Objects are separated by delimiter) : ");
            Log.d((String)TAG, (String)("AlwaysScan : " + this.config.alwaysScan));
            Log.d((String)TAG, (String)("ScanInfo : " + this.config.scanInfo.toString()));
            Log.d((String)TAG, (String)("BluetoothInfo" + this.config.bluetoothInfo.toString()));
            Log.d((String)TAG, (String)("NotificationType : " + (Object)((Object)this.config.notificationType)));
            Log.d((String)TAG, (String)"*******************************************************");
            final boolean isPairRequest = isPair;
            Thread scanAndPairThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Looper.prepare();
                    StatusData statusTemp = new StatusData();
                    try {
                        ScanAndPairManager.this.isPreviousRequestPending = true;
                        boolean callBTPairNUnpair = false;
                        ScanAndPairManager.this.isPreviousRequestPending = true;
                        if (ScanAndPairManager.this.config.alwaysScan.booleanValue()) {
                            try {
                                ScanAndPairManager.this.scannerOperations.readBarcode();
                                callBTPairNUnpair = true;
                                switch (ScanAndPairManager.this.config.scanInfo.scanDataType) {
                                    case DEVICE_NAME: {
                                        ScanAndPairManager.this.config.bluetoothInfo.deviceName = ScanAndPairManager.this.config.scanInfo.getScannedData();
                                        ScanAndPairManager.this.config.bluetoothInfo.macAddress = "";
                                        break;
                                    }
                                    case MAC_ADDRESS: {
                                        ScanAndPairManager.this.config.bluetoothInfo.deviceName = "";
                                        ScanAndPairManager.this.config.bluetoothInfo.macAddress = ScanAndPairManager.this.config.scanInfo.getScannedData();
                                        break;
                                    }
                                    default: {
                                        ScanAndPairManager.this.config.bluetoothInfo.deviceName = ScanAndPairManager.this.config.scanInfo.getScannedData();
                                        ScanAndPairManager.this.config.bluetoothInfo.macAddress = ScanAndPairManager.this.config.scanInfo.getScannedData();
                                        break;
                                    }
                                }
                            }
                            catch (ScanAndPairException e) {
                                Log.e((String)ScanAndPairManager.TAG, (String)("" + e.getMessage()));
                                statusTemp.results = e.getResult();
                                statusTemp.scanAndPairStates = StatusData.ScanAndPairStates.ERROR;
                            }
                            catch (Exception e) {
                                Log.e((String)ScanAndPairManager.TAG, (String)("" + e.getMessage()));
                                statusTemp.results = ScanAndPairResults.FAILURE;
                                statusTemp.scanAndPairStates = StatusData.ScanAndPairStates.ERROR;
                            }
                        } else {
                            callBTPairNUnpair = true;
                        }
                        if (callBTPairNUnpair) {
                            statusTemp.results = ((ScanAndPairManager)ScanAndPairManager.this).statusData.results = ScanAndPairResults.INPROGRESS;
                            statusTemp.scanAndPairStates = StatusData.ScanAndPairStates.DISCOVERING;
                            ScanAndPairManager.this.notifyStatus(statusTemp);
                            if (ScanAndPairManager.this.mServiceConnection.isServiceConnected()) {
                                if (isPairRequest) {
                                    int error = ScanAndPairManager.this.mServiceConnection.getService().snpPair(ScanAndPairManager.this.config.bluetoothInfo.deviceName, ScanAndPairManager.this.config.bluetoothInfo.macAddress, ScanAndPairManager.this.config.bluetoothInfo.pairingPin);
                                    statusTemp.results = ScanAndPairResults.values()[error];
                                    statusTemp.scanAndPairStates = statusTemp.results == ScanAndPairResults.SUCCESS ? StatusData.ScanAndPairStates.PAIRED : StatusData.ScanAndPairStates.ERROR;
                                } else {
                                    int error = ScanAndPairManager.this.mServiceConnection.getService().snpUnPair(ScanAndPairManager.this.config.bluetoothInfo.deviceName, ScanAndPairManager.this.config.bluetoothInfo.macAddress);
                                    statusTemp.results = ScanAndPairResults.values()[error];
                                    statusTemp.scanAndPairStates = statusTemp.results == ScanAndPairResults.SUCCESS ? StatusData.ScanAndPairStates.UNPAIRED : StatusData.ScanAndPairStates.ERROR;
                                }
                            } else {
                                statusTemp.results = ScanAndPairResults.FAILURE;
                                statusTemp.scanAndPairStates = StatusData.ScanAndPairStates.ERROR;
                            }
                        }
                    }
                    catch (Exception e) {
                        statusTemp.results = ScanAndPairResults.FAILURE;
                        statusTemp.scanAndPairStates = StatusData.ScanAndPairStates.ERROR;
                    }
                    ScanAndPairManager.this.isPreviousRequestPending = false;
                    ScanAndPairManager.this.notifyStatus(statusTemp);
                    Looper.loop();
                }
            });
            scanAndPairThread.start();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Error when waiting for Scanner callback !");
            Log.e((String)TAG, (String)("" + e.getMessage()));
            return ScanAndPairResults.FAILURE;
        }
        return ScanAndPairResults.SUCCESS;
    }

    public StatusData getStatus() {
        return this.statusData;
    }

    synchronized void notifyStatus(StatusData snpStatusData) {
        this.statusData.results = snpStatusData.getResult();
        this.statusData.scanAndPairStates = snpStatusData.getState();
        this.sendBeepNotiifcation(snpStatusData);
        if (this.statusListenerCallbacks != null) {
            for (StatusListener callback : this.statusListenerCallbacks) {
                if (callback == null) continue;
                callback.onStatus(snpStatusData);
            }
        }
    }

    public void addStatusListener(StatusListener listener) throws ScanAndPairException {
        if (this.isReleased) {
            throw new ScanAndPairException(ScanAndPairResults.INVALID_OBJECT);
        }
        if (this.statusListenerCallbacks == null) {
            this.statusListenerCallbacks = new CopyOnWriteArrayList<StatusListener>();
        }
        this.statusListenerCallbacks.add(listener);
    }

    public void removeStatusListener(StatusListener listener) throws ScanAndPairException {
        if (this.isReleased) {
            throw new ScanAndPairException(ScanAndPairResults.INVALID_OBJECT);
        }
        if (this.statusListenerCallbacks != null) {
            this.statusListenerCallbacks.remove(listener);
            if (this.statusListenerCallbacks.size() == 0) {
                this.statusListenerCallbacks = null;
            }
        }
    }

    boolean isBluetoothEnabled() {
        boolean result = false;
        if (this.mServiceConnection.isServiceConnected()) {
            try {
                result = this.mServiceConnection.getService().snpIsBluetoothEnabled() == 1;
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return result;
    }

    void release() {
        this.mToneGenerator.release();
        if (this.scannerOperations != null) {
            this.scannerOperations.release();
            this.scannerOperations = null;
        }
        if (this.statusListenerCallbacks != null) {
            this.statusListenerCallbacks.removeAll(this.statusListenerCallbacks);
        }
        this.isReleased = true;
    }

    void sendBeepNotiifcation(StatusData snpStatusData) {
        int count = 0;
        int beepOn = 0;
        int beepOff = 0;
        switch (snpStatusData.getState()) {
            case WAITING: {
                beepOn = 150;
                beepOff = 150;
                count = 2;
                break;
            }
            case SCANNING: {
                break;
            }
            case DISCOVERING: {
                break;
            }
            case PAIRED: {
                beepOn = 150;
                beepOff = 150;
                count = 4;
                break;
            }
            case UNPAIRED: {
                beepOn = 150;
                beepOff = 150;
                count = 4;
                break;
            }
            default: {
                beepOn = 350;
                beepOff = 150;
                count = 6;
            }
        }
        try {
            for (int i = 0; i < count; ++i) {
                this.mToneGenerator.startTone(93, beepOn);
                Thread.sleep(beepOff);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
    }

    public static interface StatusListener {
        public void onStatus(StatusData var1);
    }
}

