/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.scanandpair;

import android.util.Log;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.ScanDataCollection;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.ScannerConfig;
import com.symbol.emdk.barcode.ScannerException;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.barcode.StatusData;
import com.symbol.emdk.scanandpair.ScanAndPairConfig;
import com.symbol.emdk.scanandpair.ScanAndPairException;
import com.symbol.emdk.scanandpair.ScanAndPairManager;
import com.symbol.emdk.scanandpair.ScanAndPairResults;
import com.symbol.emdk.scanandpair.StatusData;
import java.util.Iterator;

class ScannerOperations
implements Scanner.DataListener,
Scanner.StatusListener {
    private static final String TAG = "Scanner_Operations";
    private EMDKManager emdkManager = null;
    private ScanAndPairManager scanAndPairManager = null;
    private BarcodeManager barcodeManager = null;
    private Scanner scanner = null;
    private boolean isReadRequested = false;
    private StatusData scanStatusData = new StatusData();
    private ScanAndPairConfig.DeviceIdentifier deviceIdentifier;
    private Object asyncReadLock = new Object();
    private boolean isPrevStateScanning = false;

    ScannerOperations(EMDKManager emdkManager, ScanAndPairManager scanAndPairManager) {
        this.emdkManager = emdkManager;
        this.scanAndPairManager = scanAndPairManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readBarcode() throws ScanAndPairException {
        Object object = this.asyncReadLock;
        synchronized (object) {
            block28: {
                try {
                    if (this.barcodeManager == null) {
                        this.barcodeManager = (BarcodeManager)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.BARCODE);
                    }
                    if (this.barcodeManager == null) {
                        throw new ScanAndPairException(ScanAndPairResults.SCANNER_INIT_FAILURE);
                    }
                    if (this.scanner == null) {
                        switch (this.scanAndPairManager.config.scanInfo.deviceIdentifier) {
                            case INTERNAL_CAMERA1: {
                                this.scanner = this.barcodeManager.getDevice(BarcodeManager.DeviceIdentifier.INTERNAL_CAMERA1);
                                break;
                            }
                            case INTERNAL_IMAGER1: {
                                this.scanner = this.barcodeManager.getDevice(BarcodeManager.DeviceIdentifier.INTERNAL_IMAGER1);
                                break;
                            }
                            case INTERNAL_LASER1: {
                                this.scanner = this.barcodeManager.getDevice(BarcodeManager.DeviceIdentifier.INTERNAL_LASER1);
                                break;
                            }
                            case BLUETOOTH_IMAGER1: {
                                this.scanner = this.barcodeManager.getDevice(BarcodeManager.DeviceIdentifier.BLUETOOTH_IMAGER1);
                                break;
                            }
                            default: {
                                this.scanner = this.barcodeManager.getDevice(BarcodeManager.DeviceIdentifier.DEFAULT);
                            }
                        }
                    }
                    if (this.scanner != null) {
                        this.scanner.addDataListener(this);
                        this.scanner.addStatusListener(this);
                        this.scanner.enable();
                        ScannerConfig scannerConfig = this.scanner.getConfig();
                        if (this.scanner.getScannerInfo().getDeviceType() == ScannerInfo.DeviceType.CAMERA) {
                            scannerConfig.readerParams.readerSpecific.cameraSpecific.beamTimer = this.scanAndPairManager.config.scanInfo.scanTimeout;
                        } else if (this.scanner.getScannerInfo().getDeviceType() == ScannerInfo.DeviceType.IMAGER) {
                            scannerConfig.readerParams.readerSpecific.imagerSpecific.beamTimer = this.scanAndPairManager.config.scanInfo.scanTimeout;
                        } else if (this.scanner.getScannerInfo().getDeviceType() == ScannerInfo.DeviceType.LASER) {
                            scannerConfig.readerParams.readerSpecific.laserSpecific.beamTimer = this.scanAndPairManager.config.scanInfo.scanTimeout;
                        }
                        this.scanner.setConfig(scannerConfig);
                        this.scanner.triggerType = this.scanAndPairManager.config.scanInfo.triggerType == ScanAndPairConfig.TriggerType.SOFT ? Scanner.TriggerType.SOFT_ALWAYS : Scanner.TriggerType.HARD;
                        if (this.scanner.isEnabled()) {
                            Log.d((String)TAG, (String)"Scanner Initiated. Reading barcode ...");
                            this.scanner.read();
                            this.isReadRequested = true;
                            this.asyncReadLock.wait(this.scanAndPairManager.config.scanInfo.scanTimeout);
                            Log.d((String)TAG, (String)"Barcode reading ends");
                            if (this.scanStatusData.getResult() != ScanAndPairResults.SUCCESS) {
                                throw new ScanAndPairException(this.scanStatusData.getResult());
                            }
                        }
                        break block28;
                    }
                    throw new ScanAndPairException(ScanAndPairResults.SCANNER_INIT_FAILURE);
                }
                catch (ScannerException e) {
                    Log.d((String)TAG, (String)("Caught exception : " + e.getMessage()));
                    throw new ScanAndPairException(this.mapErrorCode(e.getResult()));
                }
                catch (ScanAndPairException e) {
                    Log.d((String)TAG, (String)("Caught exception : " + e.getMessage()));
                    throw e;
                }
                catch (InterruptedException e) {
                    throw new ScanAndPairException(ScanAndPairResults.SCANNER_READ_FAILED);
                }
                catch (Exception e) {
                    throw new ScanAndPairException(ScanAndPairResults.FAILURE);
                }
                finally {
                    this.release();
                }
            }
        }
    }

    void release() {
        if (this.barcodeManager != null) {
            if (this.scanner != null) {
                block7: {
                    try {
                        if (this.scanner.isReadPending()) {
                            this.scanner.cancelRead();
                        }
                        this.scanner.removeDataListener(this);
                        this.scanner.removeStatusListener(this);
                        if (this.scanner.isEnabled()) {
                            this.scanner.disable();
                        }
                    }
                    catch (ScannerException e) {
                        if (e == null) break block7;
                        Log.d((String)TAG, (String)("Caught exception : " + e.getMessage()));
                    }
                }
                this.scanner = null;
            }
            if (this.emdkManager != null) {
                this.emdkManager.release(EMDKManager.FEATURE_TYPE.BARCODE);
            }
            this.barcodeManager = null;
            Log.d((String)TAG, (String)"BarcodeManager released");
        }
    }

    ScanAndPairResults mapErrorCode(ScannerResults result) {
        Log.d((String)TAG, (String)result.getDescription());
        ScanAndPairResults results = ScanAndPairResults.FAILURE;
        switch (result) {
            case SCAN_PARAM_NOT_SUPPORTED: 
            case INVALID_VALUE: {
                results = ScanAndPairResults.INVALID_CONFIG;
                break;
            }
            case TRIGGER_KEY_UNREG_FAILED: 
            case SCANNER_DEINIT_FAILURE: {
                results = ScanAndPairResults.SCANNER_UNINT_FAILED;
                break;
            }
            case TRIGGER_KEY_REG_FAILED: 
            case TRIGGER_KEY_IN_USE: 
            case SCANNER_NOT_ENABLED: 
            case SCANNER_INIT_FAILURE: {
                results = ScanAndPairResults.SCANNER_INIT_FAILURE;
                break;
            }
            case SCANNER_IN_USE: {
                results = ScanAndPairResults.SCANNER_IN_USE;
                break;
            }
            case SCANNER_TIMED_OUT: {
                results = ScanAndPairResults.SCANNER_READ_FAILED;
                break;
            }
            case SCAN_DATA_FAILURE: {
                results = ScanAndPairResults.SCANNER_READ_FAILED;
                break;
            }
            case SCANNER_NOT_SUPPORTED: {
                results = ScanAndPairResults.SCANNER_NOT_SUPPORTED;
                break;
            }
            case SUCCESS: {
                results = ScanAndPairResults.SUCCESS;
                break;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onData(ScanDataCollection scanDataCollection) {
        Object object = this.asyncReadLock;
        synchronized (object) {
            this.isReadRequested = false;
            this.scanStatusData.results = scanDataCollection != null ? this.mapErrorCode(scanDataCollection.getResult()) : ScanAndPairResults.SCANNER_READ_FAILED;
            if (scanDataCollection != null && scanDataCollection.getResult() == ScannerResults.SUCCESS) {
                this.scanStatusData.results = ScanAndPairResults.SUCCESS;
                Iterator<ScanDataCollection.ScanData> iterator = scanDataCollection.getScanData().iterator();
                if (iterator.hasNext()) {
                    ScanDataCollection.ScanData scanData = iterator.next();
                    this.scanAndPairManager.config.scanInfo.setScannedData(scanData.getData().trim());
                }
                Log.d((String)TAG, (String)("Scanned Barcode Data: " + this.scanAndPairManager.config.scanInfo.getScannedData()));
            } else if (this.scanStatusData != null && scanDataCollection != null) {
                this.scanStatusData.results = this.mapErrorCode(scanDataCollection.getResult());
            } else if (this.scanStatusData != null) {
                this.scanStatusData.results = ScanAndPairResults.SCANNER_READ_FAILED;
            }
            this.asyncReadLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatus(com.symbol.emdk.barcode.StatusData statusData) {
        StatusData scanPairStatusData = new StatusData();
        StatusData.ScannerStates scanState = statusData.getState();
        switch (scanState) {
            case IDLE: {
                if (!this.isReadRequested) break;
                this.scanStatusData.results = ScanAndPairResults.SCANNER_READ_FAILED;
                this.isReadRequested = false;
                if (!this.isPrevStateScanning) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Log.d((String)TAG, (String)("Error " + e.getMessage()));
                }
                Object object = this.asyncReadLock;
                synchronized (object) {
                    this.asyncReadLock.notifyAll();
                    this.isPrevStateScanning = false;
                    break;
                }
            }
            case WAITING: {
                String statusString = "Scanner is waiting for trigger press...";
                Log.d((String)TAG, (String)statusString);
                scanPairStatusData.results = ScanAndPairResults.INPROGRESS;
                scanPairStatusData.scanAndPairStates = StatusData.ScanAndPairStates.WAITING;
                this.scanAndPairManager.notifyStatus(scanPairStatusData);
                break;
            }
            case SCANNING: {
                this.isPrevStateScanning = true;
                scanPairStatusData.scanAndPairStates = StatusData.ScanAndPairStates.SCANNING;
                scanPairStatusData.results = ScanAndPairResults.INPROGRESS;
                this.scanAndPairManager.notifyStatus(scanPairStatusData);
                break;
            }
        }
    }
}

