/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscan;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanDeviceInfo;
import com.symbol.emdk.simulscan.SimulScanException;
import com.symbol.emdk.simulscan.SimulScanReader;
import com.symbol.emdk.simulscan.SimulScanReaderInfo;
import com.symbol.emdk.simulscan.SimulScanResults;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class SimulScanManager
extends EMDKBase {
    private static final String TAG = "SimulScan_Manager";
    private Context context = null;
    EMDKServiceConnection emdkServiceConnection = null;
    private ArrayList<SimulScanReaderInfo> supportedReaders = new ArrayList();
    private ArrayList<SimulScanReaderInfo> supportedInternalReaders = new ArrayList();
    private SparseArray<SimulScanReader> createdReaders = new SparseArray();

    protected SimulScanManager(Context context, EMDKServiceConnection emdkServiceConnection) throws SimulScanException {
        super(EMDKManager.FEATURE_TYPE.SIMULSCAN);
        if (emdkServiceConnection == null || !emdkServiceConnection.isServiceConnected()) {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        this.emdkServiceConnection = emdkServiceConnection;
        this.context = context;
        int retValue = SimulScanResults.FAILURE.getValue();
        try {
            retValue = this.emdkServiceConnection.getService().ssdcIntialize();
            if (SimulScanResults.SUCCESS.getValue() != retValue) {
                Log.e((String)TAG, (String)"ssdcIntialize Failed!");
                throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
            }
            List<SvcSimulScanDeviceInfo> devList = this.emdkServiceConnection.getService().ssdcGetSupportedDevicesInfo();
            if (devList.isEmpty()) {
                Log.e((String)TAG, (String)"No SimulScan supported readers");
                throw new SimulScanException(SimulScanResults.FAILURE, "No SimulScan supported readers");
            }
            for (SvcSimulScanDeviceInfo rdInfo : devList) {
                SimulScanReaderInfo newReaderInfo = new SimulScanReaderInfo(rdInfo);
                this.supportedInternalReaders.add(newReaderInfo);
                if (newReaderInfo.deviceIdentifier == DeviceIdentifier.DEFAULT) continue;
                this.supportedReaders.add(newReaderInfo);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Caught exception : " + e.getMessage()));
            throw new SimulScanException(SimulScanResults.FAILURE);
        }
    }

    void release() {
        int nsize = this.createdReaders.size();
        for (int i = 0; i < nsize; ++i) {
            SimulScanReader reader = (SimulScanReader)this.createdReaders.valueAt(i);
            reader.release();
        }
        this.createdReaders.clear();
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                this.emdkServiceConnection.getService().ssdcUnIntialize();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    public List<SimulScanReaderInfo> getSupportedDevicesInfo() {
        return this.supportedReaders;
    }

    public SimulScanReader getDevice(SimulScanReaderInfo simulscanReaderInfo) throws SimulScanException {
        if (this.supportedReaders != null) {
            for (SimulScanReaderInfo temp : this.supportedReaders) {
                if (temp.readerIndex != simulscanReaderInfo.readerIndex) continue;
                return this.getDeviceInternal(simulscanReaderInfo);
            }
        }
        return null;
    }

    private SimulScanReader getDeviceInternal(SimulScanReaderInfo ssdcReaderInfo) throws SimulScanException {
        SimulScanReader reader = (SimulScanReader)this.createdReaders.get(ssdcReaderInfo.readerIndex);
        if (reader != null) {
            return reader;
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            int retValue = SimulScanResults.FAILURE.getValue();
            try {
                retValue = this.emdkServiceConnection.getService().ssdcGetDevice(ssdcReaderInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
            if (SimulScanResults.SUCCESS.getValue() != retValue) {
                throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        reader = new SimulScanReader(ssdcReaderInfo, this.context, this.emdkServiceConnection);
        this.createdReaders.put(reader.getReaderInfo().readerIndex, (Object)reader);
        return reader;
    }

    public SimulScanReader getDevice(DeviceIdentifier deviceIdentifier) throws SimulScanException {
        SimulScanReader reader = null;
        for (SimulScanReaderInfo readerInfo : this.supportedInternalReaders) {
            if (readerInfo.getDeviceIdentifier() != deviceIdentifier) continue;
            reader = this.getDeviceInternal(readerInfo);
            break;
        }
        if (reader == null) {
            Log.e((String)TAG, (String)"Unsupported device identifier");
            throw new SimulScanException(SimulScanResults.FEATURE_NOT_SUPPORTED);
        }
        return reader;
    }

    @Deprecated
    public static enum DeviceIdentifier {
        DEFAULT,
        INTERNAL_CAMERA1,
        INTERNAL_IMAGER1;

    }
}

