/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscan;

import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.emdkservice.simulscan.ISvcSimulScanReaderStatusCallback;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanStatusData;
import com.symbol.emdk.simulscan.SimulScanReader;
import com.symbol.emdk.simulscan.SimulScanStatusData;

class SimulScanOnStatusCallbackInternal
extends ISvcSimulScanReaderStatusCallback.Stub {
    SimulScanReader ssdcReader = null;

    public SimulScanOnStatusCallbackInternal(SimulScanReader ssdcReader) {
        this.ssdcReader = ssdcReader;
    }

    @Override
    public void onSSDCStatus(SvcSimulScanStatusData statusData) throws RemoteException {
        new StatusCallbackThread(this.ssdcReader, statusData).start();
    }

    class StatusCallbackThread
    extends Thread {
        private static final String TAG = "Status_Callback_Thread";
        SvcSimulScanStatusData readerStatus = null;
        SimulScanReader reader = null;

        StatusCallbackThread(SimulScanReader reader, SvcSimulScanStatusData readerStatus) {
            if (reader == null || readerStatus == null) {
                return;
            }
            this.readerStatus = readerStatus;
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                if (null != this.reader.statusListenerCallbacks && this.readerStatus != null && !this.reader.statusListenerCallbacks.isEmpty()) {
                    SimulScanStatusData statusData = new SimulScanStatusData();
                    statusData.ssdcStatus = SimulScanStatusData.SimulScanStatus.values()[this.readerStatus.getState().ordinal()];
                    statusData.extendedStatus = SimulScanStatusData.ExtendedStatus.values()[this.readerStatus.extendedInfo.extendedStatus.ordinal()];
                    statusData.statusDescription = this.readerStatus.extendedInfo.extendedStatusDescription;
                    statusData.friendlyName = this.readerStatus.getFriendlyName();
                    for (SimulScanReader.StatusListerner callback : this.reader.statusListenerCallbacks) {
                        if (callback == null) continue;
                        callback.onStatus(statusData);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }
}

