/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscan;

import android.content.Context;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanConfig;
import com.symbol.emdk.simulscan.SimulScanConfig;
import com.symbol.emdk.simulscan.SimulScanData;
import com.symbol.emdk.simulscan.SimulScanException;
import com.symbol.emdk.simulscan.SimulScanOnDataCallbackInternal;
import com.symbol.emdk.simulscan.SimulScanOnStatusCallbackInternal;
import com.symbol.emdk.simulscan.SimulScanReaderInfo;
import com.symbol.emdk.simulscan.SimulScanResults;
import com.symbol.emdk.simulscan.SimulScanStatusData;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Deprecated
public class SimulScanReader {
    private static final String TAG = "SimulScan_Reader";
    private SimulScanReaderInfo readerInfo;
    private Context context;
    private EMDKServiceConnection emdkServiceConnection;
    private boolean isReleased = false;
    List<StatusListerner> statusListenerCallbacks = null;
    SimulScanOnStatusCallbackInternal ssdcOnStatusCallBackInternal = null;
    List<DataListerner> dataListenerCallbacks = null;
    SimulScanOnDataCallbackInternal ssdcOnDataCallBackInternal = null;

    protected SimulScanReader(SimulScanReaderInfo readerInfo, Context context, EMDKServiceConnection emdkServiceConnection) {
        this.readerInfo = readerInfo;
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
        this.ssdcOnDataCallBackInternal = new SimulScanOnDataCallbackInternal(this, emdkServiceConnection);
        this.ssdcOnStatusCallBackInternal = new SimulScanOnStatusCallbackInternal(this);
    }

    public SimulScanReaderInfo getReaderInfo() {
        return this.readerInfo;
    }

    public Boolean isReadPending() {
        if (this.isReleased) {
            return false;
        }
        Boolean retValue = false;
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcIsReadPending(this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"EMDK service is not connected");
        }
        return retValue;
    }

    public void enable() throws SimulScanException {
        if (this.isReleased) {
            throw new SimulScanException(SimulScanResults.INVALID_OBJECT);
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcEnableDevice(this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (SimulScanResults.SUCCESS.getValue() != retValue) {
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    public void disable() throws SimulScanException {
        if (this.isReleased) {
            throw new SimulScanException(SimulScanResults.INVALID_OBJECT);
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcDisable(this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (SimulScanResults.SUCCESS.getValue() != retValue) {
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    public boolean isEnabled() {
        if (this.isReleased) {
            return false;
        }
        Boolean retValue = false;
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcIsEnabled(this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return retValue;
    }

    public SimulScanConfig getConfig() throws SimulScanException {
        if (this.isReleased) {
            throw new SimulScanException(SimulScanResults.INVALID_OBJECT);
        }
        SvcSimulScanConfig svcConfig = null;
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                svcConfig = this.emdkServiceConnection.getService().ssdcGetConfig(this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (null == svcConfig) {
            Log.e((String)TAG, (String)"SimulScanReader get config Failed");
            throw new SimulScanException(SimulScanResults.FAILURE);
        }
        return new SimulScanConfig(svcConfig);
    }

    public void setConfig(SimulScanConfig config) throws SimulScanException {
        if (this.isReleased) {
            throw new SimulScanException(SimulScanResults.INVALID_OBJECT);
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcSetConfig(this.readerInfo.readerIndex, config.getServiceConfig());
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Caught exception : " + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (SimulScanResults.SUCCESS.getValue() != retValue) {
            Log.e((String)TAG, (String)"SimulScanReader set config Failed");
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    public void read() throws SimulScanException {
        if (this.isReleased) {
            throw new SimulScanException(SimulScanResults.INVALID_OBJECT);
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcReadDevice(this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Read() Caught exception : " + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (SimulScanResults.SUCCESS.getValue() != retValue) {
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    public void cancelRead() throws SimulScanException {
        if (this.isReleased) {
            throw new SimulScanException(SimulScanResults.INVALID_OBJECT);
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcCancelRead(this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (SimulScanResults.SUCCESS.getValue() != retValue) {
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    public void addDataListener(DataListerner dataListener) {
        if (!this.isReleased) {
            if (this.dataListenerCallbacks == null) {
                this.dataListenerCallbacks = new CopyOnWriteArrayList<DataListerner>();
                try {
                    this.registerDataNotification();
                }
                catch (SimulScanException e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            if (!this.dataListenerCallbacks.contains(dataListener)) {
                this.dataListenerCallbacks.add(dataListener);
            }
        }
    }

    public void removeDataListener(DataListerner dataListener) {
        if (!this.isReleased && this.dataListenerCallbacks != null) {
            this.dataListenerCallbacks.remove(dataListener);
            if (this.dataListenerCallbacks.size() == 0) {
                this.dataListenerCallbacks = null;
                this.unregisterDataNotification();
            }
        }
    }

    private void registerDataNotification() throws SimulScanException {
        if (this.dataListenerCallbacks == null) {
            return;
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcAddDataListener(this.readerInfo.readerIndex, this.ssdcOnDataCallBackInternal);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Caught exception : " + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (retValue != SimulScanResults.SUCCESS.getValue()) {
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    private void unregisterDataNotification() {
        try {
            if (this.emdkServiceConnection.isServiceConnected()) {
                this.emdkServiceConnection.getService().ssdcRemoveDataListener(this.readerInfo.readerIndex, this.ssdcOnDataCallBackInternal);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
    }

    public void addStatusListener(StatusListerner statusListener) {
        if (!this.isReleased) {
            if (this.statusListenerCallbacks == null) {
                this.statusListenerCallbacks = new CopyOnWriteArrayList<StatusListerner>();
                try {
                    this.registerStatusNotification();
                }
                catch (SimulScanException e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            if (!this.statusListenerCallbacks.contains(statusListener)) {
                this.statusListenerCallbacks.add(statusListener);
            }
        }
    }

    private void registerStatusNotification() throws SimulScanException {
        if (this.statusListenerCallbacks == null) {
            return;
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcAddStatusListener(this.readerInfo.readerIndex, this.ssdcOnStatusCallBackInternal);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Caught exception : " + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (retValue != SimulScanResults.SUCCESS.getValue()) {
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    private void unregisterStatusNotification() {
        try {
            if (this.emdkServiceConnection.isServiceConnected()) {
                this.emdkServiceConnection.getService().ssdcRemoveStatusListener(this.readerInfo.readerIndex, this.ssdcOnStatusCallBackInternal);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
    }

    public void removeStatusListener(StatusListerner statusListener) {
        if (!this.isReleased && this.statusListenerCallbacks != null) {
            this.statusListenerCallbacks.remove(statusListener);
            if (this.statusListenerCallbacks.size() == 0) {
                this.statusListenerCallbacks = null;
                this.unregisterStatusNotification();
            }
        }
    }

    protected void release() {
        if (!this.isReleased) {
            int retValue = SimulScanResults.FAILURE.getValue();
            if (this.emdkServiceConnection.isServiceConnected()) {
                try {
                    retValue = this.emdkServiceConnection.getService().ssdcRelease(this.readerInfo.readerIndex);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            this.isReleased = true;
            this.unregisterStatusNotification();
            if (this.statusListenerCallbacks != null) {
                this.statusListenerCallbacks.clear();
                this.statusListenerCallbacks = null;
            }
            this.unregisterDataNotification();
            if (this.dataListenerCallbacks != null) {
                this.dataListenerCallbacks.clear();
                this.dataListenerCallbacks = null;
            }
        }
    }

    public void fetchTemplate(String userName, String password) throws SimulScanException {
        if (this.isReleased) {
            throw new SimulScanException(SimulScanResults.INVALID_OBJECT);
        }
        int retValue = SimulScanResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().ssdcFetchTemplate(userName, password, this.readerInfo.readerIndex);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Caught exception : " + e.getMessage()));
                throw new SimulScanException(SimulScanResults.FAILURE);
            }
        } else {
            throw new SimulScanException(SimulScanResults.EMDK_NOT_OPENED, "EMDK is not opened");
        }
        if (SimulScanResults.SUCCESS.getValue() != retValue) {
            throw new SimulScanException(SimulScanResults.getSimulScanResult(retValue));
        }
    }

    @Deprecated
    public static interface StatusListerner {
        public void onStatus(SimulScanStatusData var1);
    }

    @Deprecated
    public static interface DataListerner {
        public void onData(SimulScanData var1);
    }
}

