/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;

public class Analytics {
    private static final Boolean enableLog = true;
    private static final String LOG_TAG = "Analytics";
    private static final String KEY_ANALYTICS_COMPONENT = "com.symbol.dataanalytics";
    private static final String VALUE_ANALYTICS_COMPONENT = "com.symbol.dataanalytics.intentreceiver.DataReceiverService";
    private static final String DA_PATH = "dataanalytics.intent.extra.PATH";
    private static final String DA_SENDER = "dataanalytics.intent.extra.SENDER";
    private static final String DA_SOURCE = "dataanalytics.intent.extra.SOURCE";
    private static final String DA_TIMESTAMP = "dataanalytics.intent.extra.TIMESTAMP";
    private static final String DA_TYPE = "dataanalytics.intent.extra.TYPE";
    private static final String DA_DATA = "dataanalytics.intent.extra.DATA";
    private static final String SENDER = "EMC";
    private static final String SOURCE = "com.symbol.emdk_api";
    private static final String PATH = "EMDK";
    private static final String CALLING_APP = "callingApp";
    private static String callingApp = null;
    private static String jarVersion = null;

    private static void sendAnalyticsData(Context context, long timestamp, String tableName, Bundle valuePairBundle, EMDKServiceConnection emdkServiceConnection) {
        try {
            if (enableLog.booleanValue()) {
                Log.d((String)LOG_TAG, (String)"Saving API stats...");
            }
            Intent intent = new Intent();
            intent.putExtra(DA_PATH, PATH);
            intent.putExtra(DA_SENDER, SENDER);
            intent.putExtra(DA_SOURCE, SOURCE);
            intent.putExtra(DA_TIMESTAMP, String.valueOf(timestamp));
            intent.putExtra(DA_DATA, valuePairBundle);
            intent.putExtra(DA_TYPE, tableName);
            intent.setComponent(new ComponentName(KEY_ANALYTICS_COMPONENT, VALUE_ANALYTICS_COMPONENT));
            if (emdkServiceConnection != null && emdkServiceConnection.isServiceConnected()) {
                emdkServiceConnection.getService().sendAnalytics(intent);
            }
            if (enableLog.booleanValue()) {
                Log.d((String)LOG_TAG, (String)"Saved API stats...");
            }
        }
        catch (Exception ex) {
            Log.d((String)LOG_TAG, (String)("Error in API stats... " + ex.getMessage()));
        }
    }

    private static void sendAnalyticsData(Context context, String tableName, Bundle valuePairBundle, EMDKServiceConnection emdkServiceConnection) {
        valuePairBundle.putString(CALLING_APP, context.getPackageName());
        Long timestamp = System.currentTimeMillis();
        Analytics.sendAnalyticsData(context, timestamp, tableName, valuePairBundle, emdkServiceConnection);
    }

    public static void sendEMDKStat(Context context, String apiName, String value, EMDKServiceConnection emdkServiceConnection) {
        Bundle bundle = new Bundle();
        bundle.putString(EMDK_APIS.API_NAME.getValue(), apiName);
        if (value != null) {
            bundle.putString(EMDK_APIS.VALUE.getValue(), value);
        }
        if (callingApp == null) {
            callingApp = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        }
        if (callingApp != null) {
            bundle.putString(EMDK_APIS.CALLING_APP.getValue(), callingApp);
        }
        if (jarVersion != null) {
            bundle.putString(EMDK_APIS.VERSION.getValue(), jarVersion);
        }
        Analytics.sendAnalyticsData(context, Tables.EMDK_STAT.getValue(), bundle, emdkServiceConnection);
    }

    public static enum EMDK_APIS {
        API_NAME("apiName"),
        VALUE("value"),
        CALLING_APP("callingApp"),
        VERSION("version");

        private final String id;

        private EMDK_APIS(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.id;
        }
    }

    public static enum Tables {
        EMDK_STAT("emdk_stat");

        private final String id;

        private Tables(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.id;
        }
    }
}

