/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.content.Context;
import android.nfc.NfcAdapter;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.Analytics;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKError;
import com.symbol.emdk.EMDKErrorCode;
import com.symbol.emdk.EMDKException;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.EMDKServiceConnectionException;
import com.symbol.emdk.EMDKSubErrorCode;
import com.symbol.emdk.ProfileManager;
import com.symbol.emdk.VersionManager;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.BarcodeManagerHelper;
import com.symbol.emdk.emdkservice.ISvcFeatureStatusCallback;
import com.symbol.emdk.emdkservice.SvcError;
import com.symbol.emdk.emdkservice.SvcResult;
import com.symbol.emdk.notification.NotificationManager;
import com.symbol.emdk.notification.NotificationManagerHelper;
import com.symbol.emdk.personalshopper.PersonalShopper;
import com.symbol.emdk.personalshopper.PersonalShopperHelper;
import com.symbol.emdk.sam.SAMManager;
import com.symbol.emdk.sam.SAMManagerHelper;
import com.symbol.emdk.scanandpair.ScanAndPairManager;
import com.symbol.emdk.scanandpair.ScannerAndPairManagerHelper;
import com.symbol.emdk.serialcomm.SerialComm;
import com.symbol.emdk.serialcomm.SerialCommHelper;
import com.symbol.emdk.serialcomm.SerialCommManager;
import com.symbol.emdk.simulscan.SimulScanManager;
import com.symbol.emdk.simulscan.SimulScanManagerHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class EMDKManager {
    private static final String TAG = "EMDK_Manager";
    private final Context context;
    private static String emdkConfigXml = "EMDKConfig.xml";
    private ProfileManager profileManager = null;
    private VersionManager versionManager = null;
    private BarcodeManager barcodeManager = null;
    private SimulScanManager ssdcManager = null;
    private ScanAndPairManager scanAndPairManager = null;
    private NotificationManager notificationManager = null;
    private SAMManager samManager = null;
    private EMDKServiceConnection emdkServiceConnection = null;
    private boolean isInitialized = false;
    Vector<EMDKListener> listeners = new Vector();
    private PersonalShopper personalShopper = null;
    private NfcAdapter mNfcAdapter;
    private SerialComm serialComm = null;
    private SerialCommManager serialCommManager = null;
    private boolean isReleased = false;
    private Map<FEATURE_TYPE, StatusListener> featureStatusMap = null;
    private FeatureStatusCallback featureStatusCallback = null;

    public static EMDKResults getEMDKManager(Context context, EMDKListener emdkListener) {
        EMDKResults.STATUS_CODE status = EMDKResults.STATUS_CODE.FAILURE;
        EMDKResults.EXTENDED_STATUS_CODE extendedStatusCode = EMDKResults.EXTENDED_STATUS_CODE.NONE;
        String exceptionMessage = "";
        if (context != null && emdkListener != null) {
            try {
                new EMDKManager(context, emdkListener);
                status = EMDKResults.STATUS_CODE.SUCCESS;
            }
            catch (EMDKServiceConnectionException ex) {
                extendedStatusCode = EMDKResults.EXTENDED_STATUS_CODE.DEPENDACY_COMPONENT_FAILURE;
                status = EMDKResults.STATUS_CODE.FAILURE;
            }
            catch (Exception ex) {
                extendedStatusCode = EMDKResults.EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED;
                status = EMDKResults.STATUS_CODE.FAILURE;
                exceptionMessage = ex.getMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = "Caught exception";
                }
            }
        } else {
            status = EMDKResults.STATUS_CODE.NULL_POINTER;
        }
        EMDKResults results = new EMDKResults(status, extendedStatusCode, exceptionMessage);
        return results;
    }

    EMDKManager(Context context, EMDKListener emdkListener) throws Exception {
        this.context = context;
        this.listeners.add(emdkListener);
        this.emdkServiceConnection = new EMDKServiceConnection(this.context, this);
    }

    public EMDKBase getInstance(FEATURE_TYPE featureType) {
        try {
            Analytics.sendEMDKStat(this.context, "EMDKManager.getInstance", featureType.toString(), this.emdkServiceConnection);
            switch (featureType) {
                case PROFILE: {
                    if (this.profileManager == null) {
                        this.initiliaze();
                        if (this.isInitialized) {
                            this.profileManager = new ProfileManager(this.context, this.emdkServiceConnection);
                        }
                    }
                    return this.profileManager;
                }
                case VERSION: {
                    if (this.versionManager == null) {
                        this.versionManager = new VersionManager(this.context, this.emdkServiceConnection);
                    }
                    return this.versionManager;
                }
                case BARCODE: {
                    if (this.barcodeManager == null) {
                        this.barcodeManager = BarcodeManagerHelper.getInstance(this.context, this.emdkServiceConnection);
                    }
                    return this.barcodeManager;
                }
                case SCANANDPAIR: {
                    if (this.scanAndPairManager == null) {
                        this.scanAndPairManager = ScannerAndPairManagerHelper.getInstance(this, this.context, this.emdkServiceConnection);
                    }
                    return this.scanAndPairManager;
                }
                case SIMULSCAN: {
                    if (this.ssdcManager == null) {
                        this.ssdcManager = SimulScanManagerHelper.getInstance(this.context, this.emdkServiceConnection);
                    }
                    return this.ssdcManager;
                }
                case PERSONALSHOPPER: {
                    if (this.personalShopper == null) {
                        this.personalShopper = PersonalShopperHelper.getInstance(this.context, this.emdkServiceConnection);
                    }
                    return this.personalShopper;
                }
                case SERIALCOMM: {
                    if (this.serialComm == null) {
                        this.serialComm = (SerialComm)SerialCommHelper.getInstance(this.context, this.emdkServiceConnection, true);
                    }
                    return this.serialComm;
                }
                case SERIALCOMM_EX: {
                    if (this.serialCommManager == null) {
                        this.serialCommManager = (SerialCommManager)SerialCommHelper.getInstance(this.context, this.emdkServiceConnection, false);
                    }
                    return this.serialCommManager;
                }
                case NOTIFICATION: {
                    if (this.notificationManager == null) {
                        this.notificationManager = NotificationManagerHelper.getInstance(this.context, this.emdkServiceConnection);
                    }
                    return this.notificationManager;
                }
                case SAM: {
                    if (this.samManager == null) {
                        this.samManager = SAMManagerHelper.getInstance(this.context, this.emdkServiceConnection);
                    }
                    return this.samManager;
                }
            }
            return null;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("#EMDK-API# " + ex.getMessage()));
            return null;
        }
    }

    public void getInstanceAsync(FEATURE_TYPE featureType, StatusListener statusListener) throws EMDKException {
        block6: {
            try {
                Analytics.sendEMDKStat(this.context, "EMDKManager.getInstanceAsync", featureType.toString(), this.emdkServiceConnection);
                if (featureType != null && statusListener != null) {
                    if (this.featureStatusCallback == null) {
                        this.featureStatusCallback = new FeatureStatusCallback();
                        this.featureStatusMap = new HashMap<FEATURE_TYPE, StatusListener>();
                    }
                    this.featureStatusMap.put(featureType, statusListener);
                    SvcResult result = this.emdkServiceConnection.service.registerFeatureReadyStatus(featureType.ordinal(), this.featureStatusCallback);
                    if (result.errorCode != 0) {
                        throw new EMDKException(EMDKResults.STATUS_CODE.values()[result.errorCode], result.errorDescription);
                    }
                    break block6;
                }
                throw new EMDKException(EMDKResults.STATUS_CODE.NULL_POINTER, "Null pointer is passed");
            }
            catch (Exception ex) {
                if (ex != null) {
                    Log.e((String)TAG, (String)("" + ex.getMessage()));
                    throw new EMDKException(EMDKResults.STATUS_CODE.FAILURE, "" + ex.getMessage());
                }
                throw new EMDKException(EMDKResults.STATUS_CODE.FAILURE, "");
            }
        }
    }

    public void release() {
        Analytics.sendEMDKStat(this.context, "EMDKManager.releaseEMDK", null, this.emdkServiceConnection);
        this.isReleased = true;
        for (FEATURE_TYPE featureType : FEATURE_TYPE.values()) {
            this.release(featureType);
        }
        if (this.emdkServiceConnection != null) {
            this.emdkServiceConnection.release();
            this.emdkServiceConnection = null;
        }
        this.listeners.clear();
        if (this.featureStatusMap != null) {
            this.featureStatusMap.clear();
            this.featureStatusMap = null;
        }
        if (this.featureStatusCallback != null) {
            this.featureStatusCallback = null;
        }
    }

    public void release(FEATURE_TYPE featureType) {
        boolean notifyAnalytics = false;
        switch (featureType) {
            case PROFILE: {
                if (this.profileManager == null) break;
                this.profileManager.release();
                this.profileManager = null;
                notifyAnalytics = true;
                break;
            }
            case VERSION: {
                if (this.versionManager == null) break;
                this.versionManager.release();
                this.versionManager = null;
                notifyAnalytics = true;
                break;
            }
            case BARCODE: {
                if (this.barcodeManager == null) break;
                BarcodeManagerHelper.release(this.barcodeManager);
                this.barcodeManager = null;
                notifyAnalytics = true;
                break;
            }
            case SCANANDPAIR: {
                if (this.scanAndPairManager == null) break;
                ScannerAndPairManagerHelper.release(this.scanAndPairManager);
                this.scanAndPairManager = null;
                notifyAnalytics = true;
                break;
            }
            case SIMULSCAN: {
                if (this.ssdcManager == null) break;
                SimulScanManagerHelper.release(this.ssdcManager);
                this.ssdcManager = null;
                notifyAnalytics = true;
                break;
            }
            case PERSONALSHOPPER: {
                if (this.personalShopper == null) break;
                PersonalShopperHelper.release(this.personalShopper);
                this.personalShopper = null;
                notifyAnalytics = true;
                break;
            }
            case SERIALCOMM: {
                if (this.serialComm != null) {
                    SerialCommHelper.release(this.serialComm);
                    this.serialComm = null;
                    notifyAnalytics = true;
                }
                if (this.featureStatusMap == null) break;
                this.featureStatusMap.remove((Object)featureType);
                break;
            }
            case SERIALCOMM_EX: {
                if (this.serialCommManager != null) {
                    SerialCommHelper.release(this.serialCommManager);
                    this.serialCommManager = null;
                    notifyAnalytics = true;
                }
                if (this.featureStatusMap == null) break;
                this.featureStatusMap.remove((Object)featureType);
                break;
            }
            case NOTIFICATION: {
                if (this.notificationManager == null) break;
                NotificationManagerHelper.release(this.notificationManager);
                this.notificationManager = null;
                notifyAnalytics = true;
                break;
            }
            case SAM: {
                if (this.samManager == null) break;
                SAMManagerHelper.release(this.samManager);
                this.samManager = null;
                notifyAnalytics = true;
            }
        }
        if (notifyAnalytics) {
            Analytics.sendEMDKStat(this.context, "EMDKManager.releaseFeature", featureType.toString(), this.emdkServiceConnection);
        }
        this.unInitialize();
    }

    public EMDKError getLastError() {
        EMDKError emdkError = null;
        SvcError svcError = null;
        try {
            if (this.emdkServiceConnection.isServiceConnected()) {
                svcError = this.emdkServiceConnection.getService().getLastError();
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        if (svcError != null) {
            ArrayList<EMDKSubErrorCode> emdkSubErrorCodes = new ArrayList<EMDKSubErrorCode>();
            if (svcError.subErrorCodes != null) {
                for (SvcError.EMDKSubErrorCode emdkSubErrorCode : svcError.subErrorCodes) {
                    emdkSubErrorCodes.add(EMDKSubErrorCode.values()[emdkSubErrorCode.ordinal()]);
                }
            }
            emdkError = new EMDKError(EMDKErrorCode.values()[svcError.errorCode.ordinal()], emdkSubErrorCodes);
        }
        return emdkError;
    }

    void initiliaze() {
        String profileXml;
        if (!this.isInitialized && (profileXml = this.readProfileXmlFile()).length() > 0) {
            try {
                if (this.emdkServiceConnection.isServiceConnected()) {
                    this.isInitialized = this.emdkServiceConnection.getService().initializeProfileService(profileXml);
                }
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    void unInitialize() {
        if (this.isInitialized && this.profileManager == null && this.versionManager == null) {
            if (this.emdkServiceConnection.service != null) {
                try {
                    this.emdkServiceConnection.service.unInitializeProfileService();
                }
                catch (RemoteException e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            this.isInitialized = false;
        }
    }

    private String readProfileXmlFile() {
        StringBuilder sb = new StringBuilder();
        try {
            InputStream is = this.context.getAssets().open(emdkConfigXml);
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(reader);
            String sCurrentLine = null;
            while ((sCurrentLine = br.readLine()) != null) {
                sb.append(sCurrentLine);
            }
        }
        catch (IOException e) {
            return "<?xml version=\"1.0\" encoding=\"utf-8\"?><wap-provisioningdoc></wap-provisioningdoc>";
        }
        return sb.toString();
    }

    public static interface EMDKListener {
        public void onOpened(EMDKManager var1);

        public void onClosed();
    }

    class FeatureStatusCallback
    extends ISvcFeatureStatusCallback.Stub {
        FeatureStatusCallback() {
        }

        @Override
        public void onStatus(int featureID, SvcResult result) throws RemoteException {
            EMDKBase featureMgrObj = null;
            FEATURE_TYPE featureType = null;
            EMDKResults.STATUS_CODE emdkResult = null;
            try {
                featureMgrObj = null;
                featureType = FEATURE_TYPE.values()[featureID];
                emdkResult = EMDKResults.STATUS_CODE.values()[result.errorCode];
                if (emdkResult == EMDKResults.STATUS_CODE.SUCCESS) {
                    featureMgrObj = EMDKManager.this.getInstance(featureType);
                }
            }
            catch (Exception ex) {
                Log.d((String)EMDKManager.TAG, (String)("" + ex.getMessage()));
                emdkResult = EMDKResults.STATUS_CODE.FAILURE;
            }
            try {
                StatusListener statusListener;
                if (!EMDKManager.this.isReleased && EMDKManager.this.featureStatusMap != null && (statusListener = (StatusListener)EMDKManager.this.featureStatusMap.get((Object)featureType)) != null) {
                    StatusData statusData = new StatusData(featureType, emdkResult);
                    statusListener.onStatus(statusData, featureMgrObj);
                }
            }
            catch (Exception ex) {
                Log.d((String)EMDKManager.TAG, (String)("" + ex.getMessage()));
            }
        }
    }

    public static enum FEATURE_TYPE {
        PROFILE,
        VERSION,
        BARCODE,
        SCANANDPAIR,
        SIMULSCAN,
        PERSONALSHOPPER,
        SERIALCOMM,
        NOTIFICATION,
        SERIALCOMM_EX,
        SAM;

    }

    public class StatusData {
        EMDKResults.STATUS_CODE result;
        FEATURE_TYPE type;

        StatusData(FEATURE_TYPE type, EMDKResults.STATUS_CODE result) {
            this.type = type;
            this.result = result;
        }

        public EMDKResults.STATUS_CODE getResult() {
            return this.result;
        }

        public FEATURE_TYPE getFeatureType() {
            return this.type;
        }
    }

    public static interface StatusListener {
        public void onStatus(StatusData var1, EMDKBase var2);
    }
}

